<?php

namespace Api\Wpl\models\core\Auth;

class AuthToken {

	/**
	 * @var string
	 */
	private $username;

	/**
	 * @var string
	 */
	private $password;

	/**
	 * @var string
	 */
	private $email;

	/**
	 * @param $request
	 */
	public function __construct($request) {

		$this->email    = $request->get_param('email');
		$this->username = $request->get_param('username');
		$this->password = $request->get_param('password');
	}

	/**
	 * @return array
	 */
	public function create() {

		$user = wp_authenticate(
			$this->username,
			$this->password
		);
		if ( is_wp_error( $user ) ) {
			wp_send_json_error(array(
				'message' => 'username or password is incorrect')
			);
		}
		(new Auth())->register($this->email);

		return array(
			'token' => get_option('wpl_api_token')
		);
	}

	/**
	 * @return bool
	 */
	public static function remove() {

		return (delete_option( 'wpl_api_token' ))
			? true
			: false;
	}

	/**
	 * @param $http_origin
	 */
	public static function checkToken($referer) {

		if ($referer) {
			(get_option('wpl_api_token'))
				? wp_send_json_success(get_option('wpl_api_token'))
				: wp_send_json_error();
		}
		wp_send_json_error(
			array('message' => 'Invalid host'),
			401
		);
	}
}