<?php

namespace Api\Wpl\models\core\Auth;

use \Firebase\JWT\JWT;

class Auth {

	/**
	 * Register json web token
	 *
	 * @param $email
	 *
	 * @return array
	 */
	public function register( $email ) {

		// Make an array for the JWT Payload
		$token = array(
			"iss"  => get_bloginfo( 'url' ),
			// The "iss" value is a case-sensitive string containing a StringOrURI value
			'data' => [ // Data related to the signer user
				'email' => $email
			]
		);

		// generate JSON web token and store as variable
		$jwt = JWT::encode(
			$token,
			SECRET_KEY_JWT
		);
		// save the token into the option table
		$this->saveToken( $jwt );

		$response = array(
			'token' => $jwt
		);

		return $response;
	}

	/**
	 * This method validates a given JSON web token
	 * @return bool
	 */
	public function auth() {

		// using a try and catch to verify
		try {

			$auth = isset( $_SERVER['HTTP_AUTHORIZATION'] )
				? $_SERVER['HTTP_AUTHORIZATION']
				: false;
			if ( ! $auth ) {
				$auth = isset( $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] )
					? $_SERVER['REDIRECT_HTTP_AUTHORIZATION']
					: false;
			}

			if ( $auth ) {
				list( $token ) = sscanf( $auth, 'Bearer %s' );
			} else {
				return false;
			}
			// decode the JWT using the key from config

			JWT::decode(
				$token,
				SECRET_KEY_JWT,
				array( 'HS256' )
			);

		} catch ( \Exception $e ) {
			return false; // Unauthorized
		}

		return true;
	}

	/**
	 * Get User ID by Token
	 * @return bool/User ID
	 */
	public function getUserIdByToken() {

		$auth = isset( $_SERVER['HTTP_AUTHORIZATION'] )
			? $_SERVER['HTTP_AUTHORIZATION']
			: false;

		if ( $auth ) {
			list( $token ) = sscanf( $auth, 'Bearer %s' );
		} else {
			return false;
		}

		$decode = JWT::decode(
			$token, SECRET_KEY_JWT, array( 'HS256' )
		);

		if ( email_exists( $decode->data->email ) ) {
			$user = get_user_by( 'email', $decode->data->email );

			return $user->ID;
		}

		return false;
	}

	/**
	 * Saves the token into the option table
	 *
	 * @param $jwt
	 */
	protected function saveToken( $jwt ) {

		update_option(
			'wpl_api_token',
			$jwt
		);
	}
}