<?php

namespace  Api\Wpl\models\business;

class i18n {

    private $domain;

    private $lang;

    /**
     * Load the plugin text domain for translation.
     *
     * @since    1.0.0
     */
    public function load_plugin_textdomain() {
        $locale = sprintf('%s_%s', $this->lang, strtoupper($this->lang));
        load_textdomain( 
            $this->domain, untrailingslashit( plugin_dir_path( __FILE__ ) ) . '/languages/' . $locale . '.mo' 
        );
    }

    public function set_domain( $domain ) {
        $this->domain = $domain;
    }

    public function set_lang( $lang ) {
        $this->lang = $lang;
    }
}