<?php

namespace Api\Wpl\models;

use Api\Wpl\models\core\Error\Error;

class AbstractModel extends Error {
	
	/** @var array */
	protected $listings = array();
	
	/**  @var int how much records should be in one page */
	protected $inPage = 20;
	
	/** @var int part of query */
	protected $limit = 500;
	
	/** @var int Contains the sort index value */
	protected $sortIndex = 99;

    /** @var \wpdb */
    protected $wpdb;
	
	/** @var array Location for overloaded data. */
    protected $data = array();

    public function __construct() {
        global $wpdb;
        $this->wpdb = $wpdb;
    }

    /**
     * Magic Get Method
     *
     * @param $key
     * @return mixed
     */
    public function __get($key) {
        if ($this->__isset($key)) {
            return $this->data[$key];
        }
        return false;
    }
    
	/**
	 * Magic Set Method
	 * @param $key
	 * @param $value
	 * @return bool
	 */
    public function __set($key, $value) {
        if (!is_array($value) && $value === null) {
            $this->__unset($key);
        } else {
            $this->data[$key] = $value;
        }
    }

    /**
     * Magic isSet Method
     *
     * @param $key
     * @return bool
     */
    public function __isset($key) {
        return isset($this->data[$key]);
    }

    /**
     * Magic Unset Method
     *
     * @param $key
     */
    public function __unset($key) {
        unset($this->data[$key]);
    }

    /**
     * This responds with list of errors. creates JSON in 'respond' format
     *
     * @param Error[] $errors list of Error instances with errorMessages filled
     * @return void
     */
    protected static function respondErrors(array $errors) {
        //so first, this array will hold list of actions
        $actions = array();
        //take errors one by one
        foreach ($errors as $error) {
            //and create the actions that will display errors
            $actions = array(
                "message" => $error->getMessage(),
                'reason'  => $error->getErrorReason()
            );
        }
        //now respond with those actions - meaning, print them out to screen
        self::respondActionsError($actions);
    }

    /**
     * This allows to respond just one error.
     *
     * @param string $error errorMessage
     * @param string $fieldName field name that error is associated with
     * @return void
     */
    public static function respondError($errorMessage, $reason = false) {
        //first we create the error. note that there is no field associated
        $error = new Error($errorMessage, $reason);
        //then we respond with it
        self::respondErrors(array($error));
    }

    /**
     * This makes json out of actions and prints them out to screen
     *
     * @param assoc[] $actions list of actions
     */
    protected static function respondActionsError($actions) {
        wp_send_json_error($actions);
    }
}