<?php

namespace Api\Wpl\managers;

use Api\Wpl\models\core\Format\Format;
use Api\Wpl\models\core\Database\Database;
use Api\Wpl\models\AbstractModel;

class SettingsManager extends AbstractModel {

    private $pricePeriodTitle = '';
	public function setFeature( $feature ) {
		$this->feature = $feature;
		return $this;
	}

	public function getFeature() {
		return $this->feature;
	}

	public function setNeighborhood( $neighborhood ) {
		$this->neighborhood = $neighborhood;
		return $this;
	}

	public function getNeighborhood() {
		return $this->neighborhood;
	}

	public function setTag( $tag ) {
		$this->tag = $tag;
		return $this;
	}

	public function getTag() {
		return $this->tag;
	}

	public function setId( $id ) {
		$this->id = $id;
		return $this;
	}

	public function getId() {
		return $this->id;
	}

	public function setPropertyTitle($title) {
		$this->title = $title;
		return $this;
	}

	public function getPropertyTitle() {
	    if ($this->title == false) {
			$this->title = "";
		}
		return $this->title;
	}

	public function setYearBuilt($year) {
		$this->year = $year;
		return $this;
	}

	public function getYearBuilt() {
		return $this->year;
	}

	public function setMLSNumber($mls_id) {
		$this->mls_id = $mls_id;
		return $this;
	}

	public function getMLSNumber() {
		return $this->mls_id;
	}

	public function setBathroom( $bathroom ) {
		$this->bathroom = $bathroom;
		return $this;
	}

	public function getBathroom() {
		return $this->bathroom;
	}

	public function setBedroom( $bedroom ) {
		$this->bedroom = $bedroom;
		return $this;
	}

	public function getBedroom() {
		return $this->bedroom;
	}

	public function setPrice( $price ) {
		$this->price = $price;
		return $this;
	}

	public function getPrice() {
		return Format::GetNumberFormat( 
			$this->price 
		);
	}

	public function setPriceUnit( $unit ) {
		$this->unit = $unit;
		return $this;
	}

	public function getPriceUnit() {
		return Format::GetUnit(
			$this->unit 
		);
	}
	
	public function getPriceUnitExtra() {
		return Format::GetUnit(
			$this->unit,
			'extra'
		);
	}

	public function setFullDescription( $desc ) {
		$this->desc = $desc;
		return $this;
	}

	public function setLocationText( $location_text ) {
		$this->location_text = $location_text;
		return $this;
	}

	public function getLocationText() {
		return $this->location_text;
	}

	public function getFullDescription() {
		if ($this->desc == false) {
			$this->desc = "";
		}
		$desc = preg_replace_callback('/&lt;([\s\S]*?)&gt;/s',
		        function ($matches) {
		            return '';
		        },
		        $this->desc
		    );
		return strip_tags($desc ?? '');
	}

	public function setDescription( $description ) {
		$this->description = $description;
		return $this;
	}

	public function getDescription() {
		return Format::GetDescription( 
			$this->description
		);
	}

	public function setImages( $images = false ) {
		$this->images = $images;
		return $this;
	}

	public function getImages() {
		return ( $this->images ) ? true : false;
	}

	public function setImageCount( $imgNum ) {
		$this->imgNum = $imgNum;
		return $this;
	}

	public function getImageCount() {
		return $this->imgNum;
	}

	public function setLatitude( $lat ) {
		$this->lat = $lat;
		return $this;
	}

	public function getLatitude() {
		if ($this->lat == false) {
			 $this->lat = "0";
		} 
		return $this->lat;
	}

	public function setLongitude( $lon ) {
		$this->lon = $lon;
		return $this;
	}

	public function getLongitude() {
		if ($this->lon == false) {
			 $this->lon = "0";
		} 
		return $this->lon;
	}

	public function setListingType( $type ) {
		$this->type = Database::getRow(
			"SELECT name as listing_type 
			    FROM {$this->properties->wpdb->base_prefix}wpl_listing_types 
			 WHERE id = ?", $type
		);
		return $this;
	}

	public function getListingType() {
		if  ($this->type != false) {
			return $this->type['listing_type'];
		}
		return;
	}

	public function setPropertyType( $ptype ) {
		$this->ptype = Database::getRow(
			"SELECT name as property_type 
			    FROM {$this->properties->wpdb->base_prefix}wpl_property_types 
			 WHERE id = ?", $ptype
		);
		return $this;
	}

	public function getPropertyType() {
		if ($this->ptype != false) {
			return $this->ptype['property_type'];
		}
		return;
	}


    public function getListingTypeParentId($listingTypeId) {
        $type = Database::getRow(
            "select parent
               from {$this->properties->wpdb->base_prefix}wpl_listing_types 
              where id = ?", $listingTypeId
        );
        if(!empty($type))
            return $type['parent'];
        return '';
    }

    public function setPricePeriod( $pricePeriodId ) {
        $flexInfo = Database::getRow("select options from {$this->properties->wpdb->base_prefix}wpl_dbst where table_column = 'price_period' and kind = 0");
        $options = json_decode($flexInfo['options'] ?? '', true);
        foreach ($options['params'] as $option) {
            if($option['key'] == $pricePeriodId) {
                $this->pricePeriodTitle = __($option['value'], 'wpl-api');
            }
        }
        return $this;
    }

    public function getPricePeriodTitle() {
        return $this->pricePeriodTitle;
    }

	public function setSqft( $sqft ) {
		$this->sqft = $sqft;
		return $this;
	}

	public function getSqft() {
		return $this->sqft;
	}

	public function setLotSize( $size ) {
		$this->size = $size;
		return $this;
	}

	public function getLotSize() {
		return $this->size;
	}

	public function setAlias( $alias ) {
		$this->alias = $alias;
		return $this;
	}

	public function getAlias() {
		$qs = Database::getRow(
			"SELECT setting_value 
			    FROM {$this->properties->wpdb->base_prefix}wpl_settings 
			 WHERE setting_name = ?", array(
			 	'main_permalink'
			 )
		);
		$post = get_post($qs['setting_value']);
		return get_site_url() .'/'. $post->post_name . '/'. $this->getId() . '-' . $this->alias;
	}

	public static function getPropertyTitlePattern() {
	    global $wpdb;
		$qs = Database::getRow(
			"SELECT setting_value 
			    FROM {$wpdb->base_prefix}wpl_settings 
			 WHERE setting_name = ?", array(
			 	'property_title_pattern'
			 )
		);
		return $qs['setting_value'];
	}

	public function setAreaUnit( $unit ) {
		$this->areaunit = $unit;
		return $this;
	}

	public function getAreaUnit() {
		return Format::GetUnit( $this->areaunit );
	}

	public function setAgentInfo( $userId ) {
		$this->agentInfo = Database::getRow(
			"SELECT * 
			    FROM {$this->properties->wpdb->base_prefix}wpl_users 
			 WHERE id = ?", $userId
		);
		return $this;
	}

	public function getAgentInfo() {

		$base_url = wp_upload_dir();
		$this->agentInfo = array(
		    'user_id' => $this->agentInfo['id'],
			'agent'   => $this->agentInfo['first_name'] . ' ' . $this->agentInfo['last_name'],
			'company' => $this->agentInfo['company_name'],
			'tel'     => $this->agentInfo['tel'],
			'email'   => $this->agentInfo['main_email'],
			'image'   => ( empty( $this->agentInfo['profile_picture'] )
					? get_avatar_url( $this->agentInfo['id'] )
					: $base_url['baseurl'] . '/WPL/users/' . $this->agentInfo['id'] . '/' . $this->agentInfo['profile_picture']
			)
		);
		return $this->agentInfo;
	}
}