<?php

namespace Api\Wpl\managers;

use Api\Wpl\models\core\Settings\SettingBuilder;
use Api\Wpl\models\core\Properties\Properties;
use Api\Wpl\models\core\Properties\Sort;
use Api\Wpl\models\core\Search\Builder;
use Api\Wpl\models\core\Properties\Coordinate;

class ListingManager extends SettingsManager
{

    /** @var this will contain Properties object, which gives access to get the Listing types, sort options and properties */
    protected $properties;

    /**
     * Init values when object is created
     */
    public function __construct(Properties $properties)
    {
        $this->properties = $properties;
    }

    /**
     * Using this method, you can get all the active listing types.
     * @since 1.0.0
     */
    public function getListingTypes()
    {
        $this->properties->getPropertiesTypes();
    }

    /**
     * Using this method, you can get all the active sort options.
     * @since 1.0.0
     */
    public function getSortOptions()
    {
        $this->properties->getSortOptions();
    }

    /**
     * Using this method, you can recieve properties information
     * @param bool $request
     * @param bool $search
     * @since 1.0.0
     */
    public function listings($request = false, $search = false)
    {
        if ($request) {
            $listings = $this->properties
                ->select(
                    false, $request,
                    $request->get_param('listing_type'), $request->get_param('points')
                );
            wp_send_json_success(
                $this->GetPropertyData($listings, false, $request->get_param('fav_user_id'))
            );
        }
        wp_send_json_success(
            $this->GetPropertyData($search)
        );
    }

    /**
     * Using this method, you can recieve list of properties
     * @param $request
     * @since 1.0.0
     */
    public function propertiesList($request)
    {
        $this->properties->getPropertiesList(
            $request
        );
    }

    /**
     * Using this method, you will receive information about the filtering fields,
     * based on which you can perform the search commands.
     */
    public function settings()
    {
        $search_settings = new SettingBuilder();
        // Settings Builder
        $search_settings->AddItems()->build();
    }


    /**
     * Using this method, you can retrieve information about the properties; keep in mind the following options are mandatory:
     * swlat, nelat, swlng, nelng. Using these 4 parameters, you will be able to load the property data. Also you can retrieve property
     * data with different kind of keys (POST Params) like: listing_type, property_type, minprice, maxprice, minsqft,
     * maxsqft, minbedroom, maxbedroom, minbathroom, maxbathroom
     * @param $request
     * @since 1.0.0
     */
    public function search($request)
    {
        $builder = (new Builder())->setSwlat($request->get_param('swlat'))->setSwlng($request->get_param('swlng'))
            ->setNelat($request->get_param('nelat'))->setNelng($request->get_param('nelng'))
            ->setMinsqft($request->get_param('minsqft'))->setMaxsqft($request->get_param('maxsqft'))
            ->setMinPrice($request->get_param('minprice'))->setMaxPrice($request->get_param('maxprice'))
            ->setMaxbedroom($request->get_param('maxbedroom'))->setMinbedroom($request->get_param('minbedroom'))
            ->setMinbathroom($request->get_param('minbathroom'))->setMaxbathroom($request->get_param('maxbathroom'))
            ->setMinroom($request->get_param('minroom'))->setMaxroom($request->get_param('maxroom'))
            ->setMinlivingarea($request->get_param('minlivingarea'))->setMaxlivingarea($request->get_param('maxlivingarea'))
            ->setMinbuildyear($request->get_param('minbuildyear'))->setMaxbuildyear($request->get_param('maxbuildyear'))
            ->setListingType($request->get_param('listing_type'))->setPropertyType($request->get_param('property_type'))
            ->setMinLotArea($request->get_param('min_area'))->setMaxLotArea($request->get_param('max_area')
            );
        $builder->whereTags(
            $request->get_param('tags')
        );
        $builder->whereNeighborhoods(
            $request->get_param('neighborhoods')
        );
        $builder->whereAppliances(
            $request->get_param('appliances')
        );
        $listings = $this->properties->select(
            $builder->build(),
            array(),
            false,
            $request->get_param('points')
        );
        $this->listings(
            false, $listings,
            $request->get_param('swlat'),
            $request->get_param('swlng'),
            $request->get_param('nelat'),
            $request->get_param('nelng')
        );
    }

    /**
     * Using this method, you can recieve properties information
     * @param array $properties
     * @param bool $images
     * @param int $userId
     * @return mixed
     */
    public function GetPropertyData(array $properties, $images = false, $userId = null)
    {
        global $wpdb;
        $response = [];
        $base = wp_upload_dir();
        foreach ($properties as $property) {
            $property['location_text'] = (!isset($property['location_text']) OR empty($property['location_text'])) ? '' : $property['location_text'];

            /*$imgs = ($this->setImages($images)->getImages()) 
                        ? $this->properties->getImagesByListingId($property['id'],
                        $this->setImageCount($property['pic_numb'])->getImageCount())
                        : $this->properties->getImageByListingId($property['id']);*/
            $imgs = [];
            $new_images = [];
            $imgs = $this->properties->getImagesByListingId($property['id']);
            /*$images1 = $wpdb->get_results("SELECT concat('".$base['baseurl']."','/WPL/',{$wpdb->base_prefix}wpl_items.parent_id,'/',{$wpdb->base_prefix}wpl_items.item_name) url FROM {$wpdb->base_prefix}wpl_items WHERE ((item_type = 'video' AND item_cat='video') OR (item_type = 'gallery' AND item_cat = 'image')) AND enabled = 1 AND parent_id = $property[id]",ARRAY_A);
            $images2 = $wpdb->get_results("SELECT item_extra3 url FROM {$wpdb->base_prefix}wpl_items WHERE ((item_type = 'video' AND item_cat='video_embed') OR (item_type = 'gallery' AND item_cat = 'external')) AND enabled = 1 AND parent_id = $property[id] AND ",ARRAY_A);
            foreach (array_merge($images1,$images2) as $im => $rec) {
                $imgs[] = $rec['url'];
            }*/
            foreach ($imgs as $k => $img) {
                if ($img === false or $img == '[]') unset($imgs[$k]);
            }
            foreach ($imgs as $k => $img) {
                $new_images[] = $img;
            }
            if ($images) {
                $res_images = $new_images;
            } else {
                $res_images = (isset($new_images) and is_array($new_images) and count($new_images)) ? $new_images[0] : "";
            }
            $bathrooms = $this->setBathroom($property['bathrooms'])->getBathroom();
            $bedrooms = $this->setBedroom($property['bedrooms'])->getBedroom();
            $all_data = array(
                'id' => $this->setId($property['id'])->getId(),
                'location_text' => $this->setLocationText($property['location_text'])->getLocationText(),
                'property_title' => $this->setPropertyTitle($property['field_313'])->getPropertyTitle(),
                'listing_type_title' => $this->setListingType($property['listing'])->getListingType(),
                'is_favorite' => $this->isFavorite($property['id'], $userId),
                'bathrooms' => (!isset($bathrooms) or empty($bathrooms)) ? 0 : (int)$bathrooms,
                'bedrooms' => (!isset($bedrooms) or empty($bedrooms)) ? 0 : (int)$bedrooms,
//                'price'          => $this->setPrice($property['price'])->getPrice() . $this->setPriceUnit($property['price_unit'])->getPriceUnit(),
                'price' => $this->setPriceUnit($property['price_unit'])->getPriceUnit() . number_format($property['price']),
                'price_numeric' => $property['price'],
                'area' => $this->setSqft($property['living_area'])->getSqft() . ' ' . $this->setAreaUnit($property['living_area_unit'])->getAreaUnit(),
                //'description' => strip_tags($property['field_308'] ?? ''),
                'image' => $res_images == null ? '' : $res_images,
                'image_count' => is_array($imgs) ? count($imgs) : 0,
                'longitude' => $this->setLatitude($property['googlemap_ln'])->getLatitude(),
                'latitude' => $this->setLongitude($property['googlemap_lt'])->getLongitude(),
                'user_id' => $property['user_id'],
            );

            $response['properties'][] = $all_data;
        }
        return $response;

    }

    public function isFavorite($propertyId, $userId)
    {
        if (empty($propertyId) or empty($userId)) {
            return false;
        }
        global $wpdb;
        $favorite = $wpdb->get_row("SELECT property_id FROM {$wpdb->base_prefix}wpl_addon_pro_favorites WHERE user_id = $userId and property_id = $propertyId", ARRAY_A);
        if (!empty($favorite)) {
            return true;
        }
        return false;
    }

    /**
     * Using this method, you will be able to get the listing details and agent information.
     * @param $property
     * @return array
     */
    public function GetDetailedData(array $property, $userId = null)
    {
        global $wpdb;
        //$agent_infs = $this->setAgentInfo($property['user_id'])->getAgentInfo();

        $agent_infs = $wpdb->get_row("SELECT id, concat(first_name,' ',last_name) agent, company_name as company, tel, mobile, main_email as email, profile_picture FROM {$wpdb->base_prefix}wpl_users WHERE id = $property[user_id]", ARRAY_A);
        $agent_infs['tel'] = (isset($agent_infs['tel']) and !empty($agent_infs['tel'])) ? $agent_infs['tel'] : $agent_infs['mobile'];
        if (isset($agent_infs['profile_picture']) and !empty($agent_infs['profile_picture'])) {
            $agent_infs['image'] = ($_SERVER['HTTP_HOST'] == 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/wp-content/uploads/WPL/users/' . $agent_infs['id'] . '/' . $agent_infs['profile_picture'];
            unset($agent_infs['profile_picture']);
        } else {
            $agent_infs['image'] = '';
        }
        unset($agent_infs['profile_picture']);
        unset($agent_infs['mobile']);

        $imgs = $this->properties->getImagesByListingId($property['id']);
        $new_images = [];
        foreach ($imgs as $k => $img) {
            if ($img === false or $img == '[]') unset($imgs[$k]);
        }
        $videos = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_items WHERE `item_type` = 'video' AND `item_cat` = 'video_embed' AND `enabled` = 1 AND parent_id = $property[id]", ARRAY_A);
        foreach ($videos as $k => $video) {
            $new_images[] = array('url' => $video['item_extra3'], 'type' => 'video');
        }
        foreach ($imgs as $k => $img) {
            $new_images[] = array('url' => $img, 'type' => 'image');
        }
        $sqft_unit = html_entity_decode($this->setAreaUnit($property['living_area_unit'])->getAreaUnit());
        $lot_unit = html_entity_decode($this->setAreaUnit($property['lot_area_unit'])->getAreaUnit());

        $old_appliances = $this->properties->getAppliances($property);
        $new_appliances = [];
        foreach ($old_appliances as $k1 => $old_appliance) {
            $new_appliances[] = array('id' => $old_appliance['id'], 'title' => $old_appliance['title']);
        }

        $visits = $wpdb->get_row("SELECT * FROM {$wpdb->base_prefix}wpl_properties2 WHERE id = $property[id]")->visit_time;
        if (empty($visits)) {
            $visits = '0';
        }
        $build_year = $this->setYearBuilt($property['build_year'])->getYearBuilt();

        $response = array(
            'id' => $this->setId($property['id'])->getId(),
            'property_title' => $this->setPropertyTitle($property['field_313'])->getPropertyTitle(),
            'is_favorite' => $this->isFavorite($property['id'], $userId),
            'year_built' => empty($build_year) ? 0 : $build_year,
            'mls_id' => $property['mls_id'],
            'bathrooms' => $this->setBathroom($property['bathrooms'])->getBathroom(),
            'half_bathrooms' => $property['half_bathrooms'],
            'bedrooms' => $this->setBedroom($property['bedrooms'])->getBedroom(),
//            'price'          => $this->setPrice($property['price'])->getPrice() . $this->setPriceUnit($property['price_unit'])->getPriceUnit(),
            'price' => $this->setPriceUnit($property['price_unit'])->getPriceUnit() . number_format($property['price']),
            'price_unit' => $this->setPriceUnit($property['price_unit'])->getPriceUnit(),
            'price_unit_id' => $property['price_unit'],
            'price_unit_extra' => $this->setPriceUnit($property['price_unit'])->getPriceUnitExtra(),
            'price_period_id' => $property['price_period'],
            'price_period_title' => $this->setPricePeriod($property['price_period'])->getPricePeriodTitle(),
            'price_numeric' => preg_replace("/[^0-9.]/", "", $this->setPrice($property['price'])->getPrice()),
            'description' => $this->setFullDescription($property['field_308'])->getFullDescription(),
            //'images_count'   => $this->setImageCount($property['pic_numb'])->getImageCount(),
            'sqft' => $this->setSqft($property['living_area'])->getSqft() . ' ' . html_entity_decode($this->setAreaUnit($property['living_area_unit'])->getAreaUnit()),
            'sqft_unit' => $sqft_unit,
            'sqft_unit_id' => $property['living_area_unit'],
            'sqft_numeric' => preg_replace("/[^0-9.]/", "", $this->setSqft($property['living_area'])->getSqft()),
            'lot_size' => $this->setLotSize($property['lot_area'])->getLotSize() . ' ' . $this->setAreaUnit($property['lot_area_unit'])->getAreaUnit(),
            'lot_unit' => $lot_unit,
            'lot_unit_id' => $property['lot_area_unit'],
            'lot_size_numeric' => preg_replace("/[^0-9.]/", "", $this->setLotSize($property['lot_area'])->getLotSize()),
            'images' => $new_images,
            'images_count' => is_array($imgs) ? count($imgs) : 0,
            'type' => __($this->setPropertyType($property['property_type'])->getPropertyType(), 'wpl-api') . ' ' . __($this->setListingType($property['listing'])->getListingType(), 'wpl-api'),
            'property_type_id' => $property['property_type'],
            'property_type' => __($this->setPropertyType($property['property_type'])->getPropertyType(), 'wpl-api'),
            'listing_type_parent_id' => $this->getListingTypeParentId($property['listing']),
            'listing_type_id' => $property['listing'],
            'listing_type' => __($this->setListingType($property['listing'])->getListingType(), 'wpl-api'),
            'location_text' => $this->setLocationText($property['location_text'])->getLocationText(),
            'longitude' => $this->setLatitude($property['googlemap_ln'])->getLatitude(),
            'latitude' => $this->setLongitude($property['googlemap_lt'])->getLongitude(),
            'neighborhoods' => $this->properties->getNeighborhood($property),
            'appliances' => $new_appliances,
            'features' => $this->properties->getFeatures($property),
            'share_link' => $this->setAlias($property['alias'])->getAlias(),
            'agent_info' => $agent_infs,
            'address' => $property['field_3002'],
            'user_id' => $property['user_id'],
            'add_date' => $property['add_date'],
            'visits' => $visits,
        );

        if ($response['location_text'] == false) {
            $response['location_text'] = \wpl_property::generate_location_text(NULL, $property['id']);
        }
        $response = array_map(function ($v) {
            //return $v ?: '';
            //return ($v and !is_array($v)) ? '' : $v;
            if (is_array($v) and empty($v)) return array();
            return !is_null($v) ? $v : '';
        }, $response);

        $response['images_count'] = is_array($imgs) ? count($imgs) : 0;
        $response['bathrooms'] = $response['bathrooms'] ? (int)$response['bathrooms'] : 0;
        $response['half_bathrooms'] = $response['half_bathrooms'] ? (int)$response['half_bathrooms'] : 0;
        $response['bedrooms'] = $response['bedrooms'] ? (int)$response['bedrooms'] : 0;
        $response['year_built'] = empty($response['year_built']) ? "0" : "$response[year_built]";
        return $response;
    }
}