<?php
use Firebase\JWT\JWT;


if ( ! function_exists('realtynaAuthInternalRequest')) {
    /**
     * You need to pass your $request(Pointer)
     * It will modify your request and add AUTH header for internal requests
     * UserID is optional and if you don't pass that parameter it will be set by current_user_id
     * @param WP_REST_Request $request
     * @param $userID
     *
     * @return WP_REST_Request
     */
    function realtynaAuthInternalRequest(WP_REST_Request &$request, $userID = null): WP_REST_Request
    {
        if ($userID == null) {
            $userID = get_current_user_id();
        }

        if($userID != 0){
            $token = [
                "iss" => get_bloginfo('url'),
                'data' => [
                    'user_id' => $userID,
                ]
            ];
            if(defined('SECRET_KEY_JWT')){
                $JWTSecret = SECRET_KEY_JWT;
            }else{
                $JWTSecret = NONCE_SALT;
            }
            $access_token = 'Bearer ' . JWT::encode($token, $JWTSecret);
            $request->add_header('X_REALTYNA_INTERNAL_TOKEN', $access_token);
        }

        return $request;
    }
}
