# REST API SDK for PHP

Working with Realtyna REST API. 
Realtyna APIs are HTTP-based RESTful APIs. API response bodies are formatted in JSON.

Requirements
============

This library requires `PHP >= 5.4.X` and `Wordpress with WPL PRO version`

Dependencies
============
The following PHP extensions are required for all the WPL REST API functions to work properly:

* ``` ext-pdo ```
* ``` ext-pdo_mysql```


Installation
============

The best way to Install dependencies is using `composer`. You'll need to open the WPL REST API folder and run the following command:

```php
composer install
```

Configure the secret key
==========================

* To add the **secret key**, edit your wp-config.php file and add a new constant called `SECRET_KEY_JWT`.

```php
define('SECRET_KEY_JWT', 'your secret key');
```

HTTP Autorization 
==================

* To enable HTTP AUTHORIZATION, you’ll need to edit your .htaccess file and add the following:

```php
RewriteEngine on
RewriteCond %{HTTP:Authorization} ^(.*)
RewriteRule ^(.*) - [E=HTTP_AUTHORIZATION:%1]
```

Unit Tests
==========

* Run the tests using phpunit:

```php
.....
Time: 2.61 seconds, Memory: 24.00MB
OK (10 tests, 21 assertions)

```

Common Problems
===============

[Common Problems](http://v2.wp-api.org/guide/problems/)



Release
===============

```bash
composer install

#copy these paths
index.php
wpl_api.php
vendor/
src/ exclude src/views/
src/views/frontend/build/
src/views/frontend/index.php


```
