<?php
/**
 * Plugin Name: BizPrint Print Manager for WooCommerce
 * Plugin URI: http://www.getbizprint.com
 * Description: Easily Add Support for Printing WooCommerce Orders with BizPrint Cloud Print Service and Print to Anywhere in the World!
 * Version: 4.3.31
 * Text Domain: Print-Google-Cloud-Print-GCP-WooCommerce
 * Domain Path: /lang
 * WC requires at least: 2.4.0
 * WC tested up to: 7.6.1
 * Author: BizSwoop a CPF Concepts, LLC Brand
 * Author URI: http://www.bizswoop.com
 */

namespace Zprint;

const ACTIVE = true;
const PLUGIN_ROOT = __DIR__;
const PLUGIN_ROOT_FILE = __FILE__;
const PLUGIN_VERSION = '4.3.31';
const ASPECT_PREFIX = 'zp';
defined('ABSPATH') or die('No script kiddies please!');
require_once __DIR__ . '/includes/functions.php';

spl_autoload_register(function ($name) {
	$raw_name = $name;
	$name = explode('\\', $name);
	$name[0] = 'includes';
	$name = array_filter($name);

	$path = __DIR__ . DIRECTORY_SEPARATOR . implode(DIRECTORY_SEPARATOR, $name) . '.php';

	$path = apply_filters('zprint_autoload_path', $path, $name, $raw_name, PLUGIN_VERSION);

	if (file_exists($path)) {
		require_once $path;
	}
}, version_compare(phpversion(), '8.0.0', '>='));

new Setup();
