jQuery(document).on("ready", function () {
  var $body = jQuery("body");

  // WP Core Thickbox has a bug: https://core.trac.wordpress.org/ticket/17249
  // So, we can improve the Thickbox layout for the Print dialog by our hack:
  jQuery(".zprint-print-btn").on("click", appendTBCSSFix);
  $body.on("tb_unload", "#TB_window", function () {
    jQuery("#zprint-thickbox-css-fix").remove();
  });

  function appendTBCSSFix() {
    $body.append(
      '<style id="zprint-thickbox-css-fix">' +
        "#TB_window {" +
        "position: fixed !important;" +
        "top: 50% !important;" +
        "left: 50% !important;" +
        "width: calc(100% - 30px) !important;" +
        "max-width: 460px !important;" +
        "height: auto !important;" +
        "max-height: calc(100% - 30px) !important;" +
        "margin-left: 0 !important;" +
        "margin-top: 0 !important;" +
        "-webkit-transform: translate(-50%, -50%) !important;" +
        "-ms-transform: translate(-50%, -50%) !important;" +
        "transform: translate(-50%, -50%) !important;" +
        "overflow: auto !important;" +
        "}" +
        "#TB_ajaxContent {" +
        "width: 100% !important;" +
        "height: auto !important;" +
        "padding: 0 !important;" +
        "}" +
        "</style>"
    );
  }

  // Bulk print dialog
  var $bulkDialog = jQuery("#zprint-dialog-bulk");
  if ($bulkDialog.length) {
    appendTBCSSFix();
    tb_show();

    var $TB_window = jQuery('#TB_window');

    $TB_window.css("visibility", "visible");
    $TB_window.append("<div id='TB_title'><div id='TB_ajaxWindowTitle'/><div id='TB_closeAjaxWindow'><button type='button' id='TB_closeWindowButton'><span class='screen-reader-text'>Close</span><span class='tb-close-icon'/></button></div></div>");
    $TB_window.append("<div id='TB_ajaxContent'></div>");
    jQuery('#TB_ajaxContent').append($bulkDialog.children());
  }
});
