<?php

namespace ZPOS;

use ZPOS\Admin\Setting\PostTab;
use ZPOS\Admin\Stations\Post;

class Station
{
	protected $id;
	public $post;

	public function __construct($id)
	{
		$this->id = $id;
		$this->post = get_post($id);

		if ($this->post->post_type !== Post::TYPE || $this->post === null) {
			throw new StationException('Not found station');
		}
	}

	public function getBaseURL($append = '')
	{
		$structure = get_option('permalink_structure');
		return str_replace(home_url(), '', get_the_permalink($this->post->ID)) .
			($structure ? '' : ($append ? '&rest=/' : '&rest=')) .
			$append;
	}

	public function getID()
	{
		return $this->post->ID;
	}

	public function getDebugURL()
	{
		return add_query_arg('debug', '1', $this->getBaseURL());
	}

	public function getData($key)
	{
		return PostTab::getValue($key, $this->post->id);
	}

	public static function getFromOrder($order)
	{
		if ($order instanceof \WC_Order) {
			$order = $order->get_id();
		}
		if ($order instanceof \WP_Post) {
			$order = $order->ID;
		}
		$station_id = get_post_meta($order, '_pos_by', true);
		if ($station_id === 'pos') {
			$station_id = self::getDefaultStationID();
		} elseif (empty($station_id)) {
			$station_id = self::getWCStationID();
		}
		return new self($station_id);
	}

	public static function getDefaultStationID()
	{
		return (int) get_option('pos_legacy_station_id', null);
	}

	public static function getWCStationID()
	{
		return (int) get_option('pos_wc_station_id', null);
	}

	public static function isWCStation($post)
	{
		return self::getWCStationID() === (int) $post;
	}

	public static function isDefaultStation($post)
	{
		return self::getDefaultStationID() === (int) $post;
	}
}
