<?php

namespace ZPOS\Model;

use ZPOS\API;

class Gateway
{
	protected static $instance;

	public function __construct()
	{
		add_action('woocommerce_payment_gateways', [$this, 'payment_gateways'], 10000);
		static::$instance = $this;
	}

	public static function get_instance()
	{
		$class = get_called_class();
		if (null === static::$instance) {
			static::$instance = new $class();
		}
		return static::$instance;
	}

	public function payment_gateways(array $gateways)
	{
		global $plugin_page;
		if ((is_admin() && $plugin_page == 'wc-settings') || (!is_admin() && !API::is_pos())) {
			return $gateways;
		}

		$pos_gateways = [
			\ZPOS\Gateway\Cash::class,
			\ZPOS\Gateway\Smart::class,
			\ZPOS\Gateway\EPD::class,
		];

		if (class_exists(\WC_Gateway_Stripe::class)) {
			$pos_gateways[] = \ZPOS\Gateway\Stripe::class;
		}

		$pos_support_gateways = apply_filters('zpos_support_gateways', $pos_gateways);

		$gateways = array_merge($gateways, $pos_gateways);

		if (API::is_pos()) {
			return array_filter($gateways, function ($gateway_class) use ($pos_support_gateways) {
				return in_array($gateway_class, $pos_support_gateways);
			});
		}

		return $gateways;
	}

	public static function is_gateway_enabled($id)
	{
		$gateways_data = get_option('pos_gateways');
		return isset($gateways_data[$id]) && isset($gateways_data[$id]['pos'])
			? (bool) $gateways_data[$id]['pos']
			: false;
	}
}
