<?php

namespace ZPOS\Gateway;

use WC_Order;
use ZPOS\API;

class Smart extends Base
{
	public $id = 'pos_card_smart';
	public $method_title = 'Smart Card';
	public $method_description = 'Card gateway for iOS and Android devices';
	public $has_fields = true;
	public $supports = array('products', 'pos', 'kiosk');

	public function __construct()
	{
		parent::__construct();

		$this->title = $this->get_option('title');
		$this->description = $this->get_option('description');

		// Actions
		add_action('woocommerce_pos_update_options_payment_gateways_' . $this->id, array(
			$this,
			'process_admin_options',
		));
	}

	public function process_payment($order_id)
	{
		// get order object
		$order = new WC_Order($order_id);

		// update pos_cash data
		$data = API::get_raw_data();
		$data = $data['order'];

		if (isset($data['payment_details']['paid']) && $data['payment_details']['paid']) {
			// payment complete
			$order->update_status('processing');
			return array(
				'result' => 'success',
			);
		} else {
			return array(
				'result' => 'failed',
			);
		}
	}
}
