<?php

namespace ZPOS\Admin\Tabs\Users;

use ZPOS\Admin\Setting\CoreBox;
use ZPOS\Admin\Setting\Input\Select;
use ZPOS\Admin\Tabs\Users;
use ZPOS\Deactivate;

class UserSettings extends CoreBox
{
	protected $label;

	public function __construct($parent)
	{
		$this->label = __('Individual Free User Accounts', 'point-of-sale-pos-woocommerce');

		parent::__construct(
			$parent,
			$this->label,
			null,
			new Select(
				__('Cashier', 'point-of-sale-pos-woocommerce'),
				'pos_user_free[cashier]',
				[$this, 'getCashier'],
				[$this, 'getValues']
			),
			new Select(
				__('Manager', 'point-of-sale-pos-woocommerce'),
				'pos_user_free[manager]',
				[$this, 'getManager'],
				[$this, 'getValues']
			)
		);
	}

	public function getCashier()
	{
		return get_option('pos_user_free')['cashier'];
	}

	public function getManager()
	{
		return get_option('pos_user_free')['manager'];
	}

	public static function init($path)
	{
		register_setting('pos' . $path, 'pos_user_free', [
			'default' => static::getFreeDefaultValue(),
		]);
	}

	public function getValues()
	{
		return array_map(function ($user) {
			return ["value" => $user->user_login, "label" => $user->user_login];
		}, Users::getAllowedUsers());
	}

	public static function getFreeDefaultValue()
	{
		return [
			'cashier' => '',
			'manager' => '',
		];
	}

	public static function reset()
	{
		if (!did_action(Deactivate::class . '::resetSettings')) {
			return _doing_it_wrong(
				__METHOD__,
				'Reset POS settings should called by ' . Deactivate::class . '::resetSettings',
				'2.0.3'
			);
		}

		delete_option('pos_user_free');
	}
}
