<?php

namespace ZPOS\API;

use WP_REST_Server;
use WC_REST_Taxes_Controller;
use ZPOS\Admin\Setting\PostTab;
use ZPOS\Admin\Stations\Tabs\Tax;
use const ZPOS\REST_NAMESPACE;
use ZPOS\Structure\EmptyEntity;

class Taxes extends WC_REST_Taxes_Controller
{
	protected $namespace = REST_NAMESPACE;

	public function __construct()
	{
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
	}

	public function register_routes()
	{
		parent::register_routes();
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		register_rest_route(
			$this->namespace,
			'/applications/(?P<id>[\d]+)/' . $this->rest_base . '/(?P<tax_class>[^/]+)',
			[
				[
					'methods' => WP_REST_Server::READABLE,
					'callback' => [$this, 'get_shop_items'],
					'permission_callback' => [$this, 'get_items_permissions_check'],
				],
			]
		);
	}

	public function get_shop_items($request)
	{
		$tax_class = $request['tax_class'] === 'standard' ? '' : $request['tax_class'];
		$pos = +$request['id'];
		$empty_entity = new EmptyEntity();
		$taxes = $this->get_current_taxes_rates($empty_entity, $tax_class, $pos);
		return $taxes ? array_values($taxes) : [];
	}

	public function get_items_permissions_check($request)
	{
		return parent::get_item_permissions_check($request) ||
			current_user_can('read_woocommerce_pos_setting');
	}

	/**
	 * @param $entity \WC_Order|\WC_Customer|EmptyEntity
	 * @param $tax_class
	 * @param $pos \WP_Post|int
	 * @return array
	 */
	public static function get_current_taxes_rates($entity, $tax_class, $pos)
	{
		$options = Tax::getValue('pos_tax_based_on_order', $pos);
		foreach ($options as $option) {
			switch ($option) {
				case "shipping":
					if (empty($entity->get_shipping_country())) {
						continue 2;
					}
					$args = [
						'country' => $entity->get_shipping_country(),
						'state' => $entity->get_shipping_state(),
						'city' => $entity->get_shipping_city(),
						'postcode' => $entity->get_shipping_postcode(),
					];
					break;
				case "billing":
					if (empty($entity->get_billing_country())) {
						continue 2;
					}
					$args = [
						'country' => $entity->get_billing_country(),
						'state' => $entity->get_billing_state(),
						'city' => $entity->get_billing_city(),
						'postcode' => $entity->get_billing_postcode(),
					];
					break;
				case "pos":
					if (empty(PostTab::getValue('pos_country', $pos))) {
						continue 2;
					}
					$args = [
						'country' => PostTab::getValue('pos_country', $pos),
						'state' => PostTab::getValue('pos_state', $pos),
						'city' => PostTab::getValue('pos_city', $pos),
						'postcode' => PostTab::getValue('pos_postcode', $pos),
					];
					break;
				default:
					return \WC_Tax::get_base_tax_rates($tax_class);
			}
			return \WC_Tax::find_rates(
				array_merge($args, [
					'tax_class' => $tax_class,
				])
			);
		}
	}
}
