/*!

 * Bootstrap v3.3.7 (http://getbootstrap.com)



 * Copyright 2011-2018 Twitter, Inc.



 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)



 */
/*!



 * Generated using the Bootstrap Customizer (<none>)



 * Config saved to config.json and <none>



 */
if (typeof jQuery === 'undefined') {
	throw new Error('Bootstrap\'s JavaScript requires jQuery')
}
+
function($) {
	'use strict';
	var version = $.fn.jquery.split(' ')[0].split('.')
	if ((version[0] < 2 && version[1] < 9) || (version[0] == 1 && version[1] == 9 && version[2] < 1) || (version[0] > 3)) {
		throw new Error('Bootstrap\'s JavaScript requires jQuery version 1.9.1 or higher, but lower than version 4')
	}
}(jQuery);



/* ========================================================================



 * Bootstrap: aromodal.js v3.3.7



 * http://getbootstrap.com/javascript/#aromodals



 * ========================================================================



 * Copyright 2011-2016 Twitter, Inc.



 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)



 * ======================================================================== */
+
function($) {
	'use strict';
	// MODAL CLASS DEFINITION
	// ======================
	var Modal = function(element, options) {
		this.options = options
		this.$body = $(document.body)
		this.$element = $(element)
		this.$dialog = this.$element.find('.aromodal-dialog')
		this.$backdrop = null
		this.isShown = null
		this.originalBodyPad = null
		this.scrollbarWidth = 0
		this.ignoreBackdropClick = false
		if (this.options.remote) {
			this.$element
				.find('.aromodal-content')
				.load(this.options.remote, $.proxy(function() {
					this.$element.trigger('loaded.bs.aromodal')
				}, this))
		}
	}
	Modal.VERSION = '3.3.7'
	Modal.TRANSITION_DURATION = 300
	Modal.BACKDROP_TRANSITION_DURATION = 150
	Modal.DEFAULTS = {
		backdrop: true,
		keyboard: true,
		show: true
	}
	Modal.prototype.toggle = function(_relatedTarget) {
		return this.isShown ? this.hide() : this.show(_relatedTarget)
	}
	Modal.prototype.show = function(_relatedTarget) {
		var that = this
		var e = $.Event('show.bs.aromodal', {
			relatedTarget: _relatedTarget
		})
		this.$element.trigger(e)
		if (this.isShown || e.isDefaultPrevented()) return
		this.isShown = true
		this.checkScrollbar()
		this.setScrollbar()
		this.$body.addClass('aromodal-open')
		this.escape()
		this.resize()
		this.$element.on('click.dismiss.bs.aromodal', '[data-dismiss="aromodal"]', $.proxy(this.hide, this))
		this.$dialog.on('mousedown.dismiss.bs.aromodal', function() {
			that.$element.one('mouseup.dismiss.bs.aromodal', function(e) {
				if ($(e.target).is(that.$element)) that.ignoreBackdropClick = true
			})
		})
		this.backdrop(function() {
			var transition = $.support.transition && that.$element.hasClass('fade')
			if (!that.$element.parent().length) {
				that.$element.appendTo(that.$body) // don't move aromodals dom position
			}
			that.$element
				.show()
				.scrollTop(0)
			that.adjustDialog()
			if (transition) {
				that.$element[0].offsetWidth // force reflow
			}
			that.$element.addClass('in')
			that.enforceFocus()
			var e = $.Event('shown.bs.aromodal', {
				relatedTarget: _relatedTarget
			})
			transition ?
				that.$dialog // wait for aromodal to slide in
				.one('bsTransitionEnd', function() {
					that.$element.trigger('focus').trigger(e)
				})
				.emulateTransitionEnd(Modal.TRANSITION_DURATION) :
				that.$element.trigger('focus').trigger(e)
		})
	}
	Modal.prototype.hide = function(e) {
		if (e) e.preventDefault()
		e = $.Event('hide.bs.aromodal')
		this.$element.trigger(e)
		if (!this.isShown || e.isDefaultPrevented()) return
		this.isShown = false
		this.escape()
		this.resize()
		$(document).off('focusin.bs.aromodal')
		this.$element
			.removeClass('in')
			.off('click.dismiss.bs.aromodal')
			.off('mouseup.dismiss.bs.aromodal')
		this.$dialog.off('mousedown.dismiss.bs.aromodal')
		$.support.transition && this.$element.hasClass('fade') ?
			this.$element
			.one('bsTransitionEnd', $.proxy(this.hideModal, this))
			.emulateTransitionEnd(Modal.TRANSITION_DURATION) :
			this.hideModal()
	}
	Modal.prototype.enforceFocus = function() {
		$(document)
			.off('focusin.bs.aromodal') // guard against infinite focus loop
			.on('focusin.bs.aromodal', $.proxy(function(e) {
				if (document !== e.target &&
					this.$element[0] !== e.target &&
					!this.$element.has(e.target).length) {
					this.$element.trigger('focus')
				}
			}, this))
	}
	Modal.prototype.escape = function() {
		if (this.isShown && this.options.keyboard) {
			this.$element.on('keydown.dismiss.bs.aromodal', $.proxy(function(e) {
				e.which == 27 && this.hide()
			}, this))
		} else if (!this.isShown) {
			this.$element.off('keydown.dismiss.bs.aromodal')
		}
	}
	Modal.prototype.resize = function() {
		if (this.isShown) {
			$(window).on('resize.bs.aromodal', $.proxy(this.handleUpdate, this))
		} else {
			$(window).off('resize.bs.aromodal')
		}
	}
	Modal.prototype.hideModal = function() {
		var that = this
		this.$element.hide()
		this.backdrop(function() {
			that.$body.removeClass('aromodal-open')
			that.resetAdjustments()
			that.resetScrollbar()
			that.$element.trigger('hidden.bs.aromodal')
		})
	}
	Modal.prototype.removeBackdrop = function() {
		this.$backdrop && this.$backdrop.remove()
		this.$backdrop = null
	}
	Modal.prototype.backdrop = function(callback) {
		var that = this
		var animate = this.$element.hasClass('fade') ? 'fade' : ''
		if (this.isShown && this.options.backdrop) {
			var doAnimate = $.support.transition && animate
			this.$backdrop = $(document.createElement('div'))
				.addClass('aromodal-backdrop ' + animate)
				.appendTo(this.$body)
			this.$element.on('click.dismiss.bs.aromodal', $.proxy(function(e) {
				if (this.ignoreBackdropClick) {
					this.ignoreBackdropClick = false
					return
				}
				if (e.target !== e.currentTarget) return
				this.options.backdrop == 'static'
					?
					this.$element[0].focus()
					:
					this.hide()
			}, this))
			if (doAnimate) this.$backdrop[0].offsetWidth // force reflow
			this.$backdrop.addClass('in')
			if (!callback) return
			doAnimate ?
				this.$backdrop
				.one('bsTransitionEnd', callback)
				.emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :
				callback()
		} else if (!this.isShown && this.$backdrop) {
			this.$backdrop.removeClass('in')
			var callbackRemove = function() {
				that.removeBackdrop()
				callback && callback()
			}
			$.support.transition && this.$element.hasClass('fade') ?
				this.$backdrop
				.one('bsTransitionEnd', callbackRemove)
				.emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION) :
				callbackRemove()
		} else if (callback) {
			callback()
		}
	}
	// these following methods are used to handle overflowing aromodals
	Modal.prototype.handleUpdate = function() {
		this.adjustDialog()
	}
	Modal.prototype.adjustDialog = function() {
		var aromodalIsOverflowing = this.$element[0].scrollHeight > document.documentElement.clientHeight
		this.$element.css({
			paddingLeft: !this.bodyIsOverflowing && aromodalIsOverflowing ? this.scrollbarWidth : '',
			paddingRight: this.bodyIsOverflowing && !aromodalIsOverflowing ? this.scrollbarWidth : ''
		})
	}
	Modal.prototype.resetAdjustments = function() {
		this.$element.css({
			paddingLeft: '',
			paddingRight: ''
		})
	}
	Modal.prototype.checkScrollbar = function() {
		var fullWindowWidth = window.innerWidth
		if (!fullWindowWidth) { // workaround for missing window.innerWidth in IE8
			var documentElementRect = document.documentElement.getBoundingClientRect()
			fullWindowWidth = documentElementRect.right - Math.abs(documentElementRect.left)
		}
		this.bodyIsOverflowing = document.body.clientWidth < fullWindowWidth
		this.scrollbarWidth = this.measureScrollbar()
	}
	Modal.prototype.setScrollbar = function() {
		var bodyPad = parseInt((this.$body.css('padding-right') || 0), 10)
		this.originalBodyPad = document.body.style.paddingRight || ''
		if (this.bodyIsOverflowing) this.$body.css('padding-right', bodyPad + this.scrollbarWidth)
	}
	Modal.prototype.resetScrollbar = function() {
		this.$body.css('padding-right', this.originalBodyPad)
	}
	Modal.prototype.measureScrollbar = function() { // thx walsh
		var scrollDiv = document.createElement('div')
		scrollDiv.className = 'aromodal-scrollbar-measure'
		this.$body.append(scrollDiv)
		var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth
		this.$body[0].removeChild(scrollDiv)
		return scrollbarWidth
	}
	// MODAL PLUGIN DEFINITION
	// =======================
	function Plugin(option, _relatedTarget) {
		return this.each(function() {
			var $this = $(this)
			var data = $this.data('bs.aromodal')
			var options = $.extend({}, Modal.DEFAULTS, $this.data(), typeof option == 'object' && option)
			if (!data) $this.data('bs.aromodal', (data = new Modal(this, options)))
			if (typeof option == 'string') data[option](_relatedTarget)
			else if (options.show) data.show(_relatedTarget)
		})
	}

	/* Adjustment by Arosoft. New function name to avoid library conflicts */
	// MODAL NO CONFLICT
	var old = $.fn.aromodal
	$.fn.aromodal = Plugin
	$.fn.aromodal.Constructor = Modal
	$.fn.aromodal.noConflict = function() {
		$.fn.aromodal = old
		return this
	}

	// MODAL DATA-API
	// ==============
	$(document).on('click.bs.aromodal.data-api', '[data-toggle="aromodal"]', function(e) {
		var $this = $(this)
		var href = $this.attr('href')
		var $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\s]+$)/, ''))) // strip for ie7
		var option = $target.data('bs.aromodal') ? 'toggle' : $.extend({
			remote: !/#/.test(href) && href
		}, $target.data(), $this.data())
		if ($this.is('a')) e.preventDefault()
		$target.one('show.bs.aromodal', function(showEvent) {
			if (showEvent.isDefaultPrevented()) return // only register focus restorer if aromodal will actually get shown
			$target.one('hidden.bs.aromodal', function() {
				$this.is(':visible') && $this.trigger('focus')
			})
		})
		Plugin.call($target, option, this)
	})
}(jQuery);
/* ========================================================================



 * Bootstrap: arotooltip.js v3.3.7



 * http://getbootstrap.com/javascript/#arotooltip



 * Inspired by the original jQuery.tipsy by Jason Frame



 * ========================================================================



 * Copyright 2011-2016 Twitter, Inc.



 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)



 * ======================================================================== */
+
function($) {
	'use strict';
	// TOOLTIP PUBLIC CLASS DEFINITION
	// ===============================
	var Tooltip = function(element, options) {
		this.type = null
		this.options = null
		this.enabled = null
		this.timeout = null
		this.hoverState = null
		this.$element = null
		this.inState = null
		this.init('arotooltip', element, options)
	}
	Tooltip.VERSION = '3.3.7'
	Tooltip.TRANSITION_DURATION = 150
	Tooltip.DEFAULTS = {
		animation: true,
		placement: 'top',
		selector: false,
		template: '<div class="arotooltip" role="arotooltip"><div class="arotooltip-arrow"></div><div class="arotooltip-inner"></div></div>',
		trigger: 'hover focus',
		title: '',
		delay: 0,
		html: false,
		container: false,
		viewport: {
			selector: 'body',
			padding: 0
		}
	}
	Tooltip.prototype.init = function(type, element, options) {
		this.enabled = true
		this.type = type
		this.$element = $(element)
		this.options = this.getOptions(options)
		this.$viewport = this.options.viewport && $($.isFunction(this.options.viewport) ? this.options.viewport.call(this, this.$element) : (this.options.viewport.selector || this.options.viewport))
		this.inState = {
			click: false,
			hover: false,
			focus: false
		}
		if (this.$element[0] instanceof document.constructor && !this.options.selector) {
			throw new Error('`selector` option must be specified when initializing ' + this.type + ' on the window.document object!')
		}
		var triggers = this.options.trigger.split(' ')
		for (var i = triggers.length; i--;) {
			var trigger = triggers[i]
			if (trigger == 'click') {
				this.$element.on('click.' + this.type, this.options.selector, $.proxy(this.toggle, this))
			} else if (trigger != 'manual') {
				var eventIn = trigger == 'hover' ? 'mouseenter' : 'focusin'
				var eventOut = trigger == 'hover' ? 'mouseleave' : 'focusout'
				this.$element.on(eventIn + '.' + this.type, this.options.selector, $.proxy(this.enter, this))
				this.$element.on(eventOut + '.' + this.type, this.options.selector, $.proxy(this.leave, this))
			}
		}
		this.options.selector ?
			(this._options = $.extend({}, this.options, {
				trigger: 'manual',
				selector: ''
			})) :
			this.fixTitle()
	}
	Tooltip.prototype.getDefaults = function() {
		return Tooltip.DEFAULTS
	}
	Tooltip.prototype.getOptions = function(options) {
		options = $.extend({}, this.getDefaults(), this.$element.data(), options)
		if (options.delay && typeof options.delay == 'number') {
			options.delay = {
				show: options.delay,
				hide: options.delay
			}
		}
		return options
	}
	Tooltip.prototype.getDelegateOptions = function() {
		var options = {}
		var defaults = this.getDefaults()
		this._options && $.each(this._options, function(key, value) {
			if (defaults[key] != value) options[key] = value
		})
		return options
	}
	Tooltip.prototype.enter = function(obj) {
		var self = obj instanceof this.constructor ?
			obj : $(obj.currentTarget).data('bs.' + this.type)
		if (!self) {
			self = new this.constructor(obj.currentTarget, this.getDelegateOptions())
			$(obj.currentTarget).data('bs.' + this.type, self)
		}
		if (obj instanceof $.Event) {
			self.inState[obj.type == 'focusin' ? 'focus' : 'hover'] = true
		}
		if (self.tip().hasClass('in') || self.hoverState == 'in') {
			self.hoverState = 'in'
			return
		}
		clearTimeout(self.timeout)
		self.hoverState = 'in'
		if (!self.options.delay || !self.options.delay.show) return self.show()
		self.timeout = setTimeout(function() {
			if (self.hoverState == 'in') self.show()
		}, self.options.delay.show)
	}
	Tooltip.prototype.isInStateTrue = function() {
		for (var key in this.inState) {
			if (this.inState[key]) return true
		}
		return false
	}
	Tooltip.prototype.leave = function(obj) {
		var self = obj instanceof this.constructor ?
			obj : $(obj.currentTarget).data('bs.' + this.type)
		if (!self) {
			self = new this.constructor(obj.currentTarget, this.getDelegateOptions())
			$(obj.currentTarget).data('bs.' + this.type, self)
		}
		if (obj instanceof $.Event) {
			self.inState[obj.type == 'focusout' ? 'focus' : 'hover'] = false
		}
		if (self.isInStateTrue()) return
		clearTimeout(self.timeout)
		self.hoverState = 'out'
		if (!self.options.delay || !self.options.delay.hide) return self.hide()
		self.timeout = setTimeout(function() {
			if (self.hoverState == 'out') self.hide()
		}, self.options.delay.hide)
	}
	Tooltip.prototype.show = function() {
		var e = $.Event('show.bs.' + this.type)
		if (this.hasContent() && this.enabled) {
			this.$element.trigger(e)
			var inDom = $.contains(this.$element[0].ownerDocument.documentElement, this.$element[0])
			if (e.isDefaultPrevented() || !inDom) return
			var that = this
			var $tip = this.tip()
			var tipId = this.getUID(this.type)
			this.setContent()
			$tip.attr('id', tipId)
			this.$element.attr('aria-describedby', tipId)
			if (this.options.animation) $tip.addClass('fade')
			var placement = typeof this.options.placement == 'function' ?
				this.options.placement.call(this, $tip[0], this.$element[0]) :
				this.options.placement
			var autoToken = /\s?auto?\s?/i
			var autoPlace = autoToken.test(placement)
			if (autoPlace) placement = placement.replace(autoToken, '') || 'top'
			$tip
				.detach()
				.css({
					top: 0,
					left: 0,
					display: 'block'
				})
				.addClass(placement)
				.data('bs.' + this.type, this)
			this.options.container ? $tip.appendTo(this.options.container) : $tip.insertAfter(this.$element)
			this.$element.trigger('inserted.bs.' + this.type)
			var pos = this.getPosition()
			var actualWidth = $tip[0].offsetWidth
			var actualHeight = $tip[0].offsetHeight
			if (autoPlace) {
				var orgPlacement = placement
				var viewportDim = this.getPosition(this.$viewport)
				placement = placement == 'bottom' && pos.bottom + actualHeight > viewportDim.bottom ? 'top' :
					placement == 'top' && pos.top - actualHeight < viewportDim.top ? 'bottom' :
					placement == 'right' && pos.right + actualWidth > viewportDim.width ? 'left' :
					placement == 'left' && pos.left - actualWidth < viewportDim.left ? 'right' :
					placement
				$tip
					.removeClass(orgPlacement)
					.addClass(placement)
			}
			var calculatedOffset = this.getCalculatedOffset(placement, pos, actualWidth, actualHeight)
			this.applyPlacement(calculatedOffset, placement)
			var complete = function() {
				var prevHoverState = that.hoverState
				that.$element.trigger('shown.bs.' + that.type)
				that.hoverState = null
				if (prevHoverState == 'out') that.leave(that)
			}
			$.support.transition && this.$tip.hasClass('fade') ?
				$tip
				.one('bsTransitionEnd', complete)
				.emulateTransitionEnd(Tooltip.TRANSITION_DURATION) :
				complete()
		}
	}
	Tooltip.prototype.applyPlacement = function(offset, placement) {
		var $tip = this.tip()
		var width = $tip[0].offsetWidth
		var height = $tip[0].offsetHeight
		// manually read margins because getBoundingClientRect includes difference
		var marginTop = parseInt($tip.css('margin-top'), 10)
		var marginLeft = parseInt($tip.css('margin-left'), 10)
		// we must check for NaN for ie 8/9
		if (isNaN(marginTop)) marginTop = 0
		if (isNaN(marginLeft)) marginLeft = 0
		offset.top += marginTop
		offset.left += marginLeft
		// $.fn.offset doesn't round pixel values
		// so we use setOffset directly with our own function B-0
		$.offset.setOffset($tip[0], $.extend({
			using: function(props) {
				$tip.css({
					top: Math.round(props.top),
					left: Math.round(props.left)
				})
			}
		}, offset), 0)
		$tip.addClass('in')
		// check to see if placing tip in new offset caused the tip to resize itself
		var actualWidth = $tip[0].offsetWidth
		var actualHeight = $tip[0].offsetHeight
		if (placement == 'top' && actualHeight != height) {
			offset.top = offset.top + height - actualHeight
		}
		var delta = this.getViewportAdjustedDelta(placement, offset, actualWidth, actualHeight)
		if (delta.left) offset.left += delta.left
		else offset.top += delta.top
		var isVertical = /top|bottom/.test(placement)
		var arrowDelta = isVertical ? delta.left * 2 - width + actualWidth : delta.top * 2 - height + actualHeight
		var arrowOffsetPosition = isVertical ? 'offsetWidth' : 'offsetHeight'
		$tip.offset(offset)
		this.replaceArrow(arrowDelta, $tip[0][arrowOffsetPosition], isVertical)
	}
	Tooltip.prototype.replaceArrow = function(delta, dimension, isVertical) {
		this.arrow()
			.css(isVertical ? 'left' : 'top', 50 * (1 - delta / dimension) + '%')
			.css(isVertical ? 'top' : 'left', '')
	}
	Tooltip.prototype.setContent = function() {
		var $tip = this.tip()
		var title = this.getTitle()
		$tip.find('.arotooltip-inner')[this.options.html ? 'html' : 'text'](title)
		$tip.removeClass('fade in top bottom left right')
	}
	Tooltip.prototype.hide = function(callback) {
		var that = this
		var $tip = $(this.$tip)
		var e = $.Event('hide.bs.' + this.type)

		function complete() {
			if (that.hoverState != 'in') $tip.detach()
			if (that.$element) { // TODO: Check whether guarding this code with this `if` is really necessary.
				that.$element
					.removeAttr('aria-describedby')
					.trigger('hidden.bs.' + that.type)
			}
			callback && callback()
		}
		this.$element.trigger(e)
		if (e.isDefaultPrevented()) return
		$tip.removeClass('in')
		$.support.transition && $tip.hasClass('fade') ?
			$tip
			.one('bsTransitionEnd', complete)
			.emulateTransitionEnd(Tooltip.TRANSITION_DURATION) :
			complete()
		this.hoverState = null
		return this
	}
	Tooltip.prototype.fixTitle = function() {
		var $e = this.$element
		if ($e.attr('title') || typeof $e.attr('data-original-title') != 'string') {
			$e.attr('data-original-title', $e.attr('title') || '').attr('title', '')
		}
	}
	Tooltip.prototype.hasContent = function() {
		return this.getTitle()
	}
	Tooltip.prototype.getPosition = function($element) {
		$element = $element || this.$element
		var el = $element[0]
		var isBody = el.tagName == 'BODY'
		var elRect = el.getBoundingClientRect()
		if (elRect.width == null) {
			// width and height are missing in IE8, so compute them manually; see https://github.com/twbs/bootstrap/issues/14093
			elRect = $.extend({}, elRect, {
				width: elRect.right - elRect.left,
				height: elRect.bottom - elRect.top
			})
		}
		var isSvg = window.SVGElement && el instanceof window.SVGElement
		// Avoid using $.offset() on SVGs since it gives incorrect results in jQuery 3.
		// See https://github.com/twbs/bootstrap/issues/20280
		var elOffset = isBody ? {
			top: 0,
			left: 0
		} : (isSvg ? null : $element.offset())
		var scroll = {
			scroll: isBody ? document.documentElement.scrollTop || document.body.scrollTop : $element.scrollTop()
		}
		var outerDims = isBody ? {
			width: $(window).width(),
			height: $(window).height()
		} : null
		return $.extend({}, elRect, scroll, outerDims, elOffset)
	}
	Tooltip.prototype.getCalculatedOffset = function(placement, pos, actualWidth, actualHeight) {
		return placement == 'bottom' ? {
				top: pos.top + pos.height,
				left: pos.left + pos.width / 2 - actualWidth / 2
			} :
			placement == 'top' ? {
				top: pos.top - actualHeight,
				left: pos.left + pos.width / 2 - actualWidth / 2
			} :
			placement == 'left' ? {
				top: pos.top + pos.height / 2 - actualHeight / 2,
				left: pos.left - actualWidth
			} :
			/* placement == 'right' */
			{
				top: pos.top + pos.height / 2 - actualHeight / 2,
				left: pos.left + pos.width
			}
	}
	Tooltip.prototype.getViewportAdjustedDelta = function(placement, pos, actualWidth, actualHeight) {
		var delta = {
			top: 0,
			left: 0
		}
		if (!this.$viewport) return delta
		var viewportPadding = this.options.viewport && this.options.viewport.padding || 0
		var viewportDimensions = this.getPosition(this.$viewport)
		if (/right|left/.test(placement)) {
			var topEdgeOffset = pos.top - viewportPadding - viewportDimensions.scroll
			var bottomEdgeOffset = pos.top + viewportPadding - viewportDimensions.scroll + actualHeight
			if (topEdgeOffset < viewportDimensions.top) { // top overflow
				delta.top = viewportDimensions.top - topEdgeOffset
			} else if (bottomEdgeOffset > viewportDimensions.top + viewportDimensions.height) { // bottom overflow
				delta.top = viewportDimensions.top + viewportDimensions.height - bottomEdgeOffset
			}
		} else {
			var leftEdgeOffset = pos.left - viewportPadding
			var rightEdgeOffset = pos.left + viewportPadding + actualWidth
			if (leftEdgeOffset < viewportDimensions.left) { // left overflow
				delta.left = viewportDimensions.left - leftEdgeOffset
			} else if (rightEdgeOffset > viewportDimensions.right) { // right overflow
				delta.left = viewportDimensions.left + viewportDimensions.width - rightEdgeOffset
			}
		}
		return delta
	}
	Tooltip.prototype.getTitle = function() {
		var title
		var $e = this.$element
		var o = this.options
		title = $e.attr('data-original-title')
			||
			(typeof o.title == 'function' ? o.title.call($e[0]) : o.title)
		return title
	}
	Tooltip.prototype.getUID = function(prefix) {
		do prefix += ~~(Math.random() * 1000000)
		while (document.getElementById(prefix))
		return prefix
	}
	Tooltip.prototype.tip = function() {
		if (!this.$tip) {
			this.$tip = $(this.options.template)
			if (this.$tip.length != 1) {
				throw new Error(this.type + ' `template` option must consist of exactly 1 top-level element!')
			}
		}
		return this.$tip
	}
	Tooltip.prototype.arrow = function() {
		return (this.$arrow = this.$arrow || this.tip().find('.arotooltip-arrow'))
	}
	Tooltip.prototype.enable = function() {
		this.enabled = true
	}
	Tooltip.prototype.disable = function() {
		this.enabled = false
	}
	Tooltip.prototype.toggleEnabled = function() {
		this.enabled = !this.enabled
	}
	Tooltip.prototype.toggle = function(e) {
		var self = this
		if (e) {
			self = $(e.currentTarget).data('bs.' + this.type)
			if (!self) {
				self = new this.constructor(e.currentTarget, this.getDelegateOptions())
				$(e.currentTarget).data('bs.' + this.type, self)
			}
		}
		if (e) {
			self.inState.click = !self.inState.click
			if (self.isInStateTrue()) self.enter(self)
			else self.leave(self)
		} else {
			self.tip().hasClass('in') ? self.leave(self) : self.enter(self)
		}
	}
	Tooltip.prototype.destroy = function() {
		var that = this
		clearTimeout(this.timeout)
		this.hide(function() {
			that.$element.off('.' + that.type).removeData('bs.' + that.type)
			if (that.$tip) {
				that.$tip.detach()
			}
			that.$tip = null
			that.$arrow = null
			that.$viewport = null
			that.$element = null
		})
	}
	// TOOLTIP PLUGIN DEFINITION
	// =========================
	function Plugin(option) {
		return this.each(function() {
			var $this = $(this)
			var data = $this.data('bs.arotooltip')
			var options = typeof option == 'object' && option
			if (!data && /destroy|hide/.test(option)) return
			if (!data) $this.data('bs.arotooltip', (data = new Tooltip(this, options)))
			if (typeof option == 'string') data[option]()
		})
	}
	var old = $.fn.arotooltip
	$.fn.arotooltip = Plugin
	$.fn.arotooltip.Constructor = Tooltip
	// TOOLTIP NO CONFLICT
	// ===================
	$.fn.arotooltip.noConflict = function() {
		$.fn.arotooltip = old
		return this
	}
}(jQuery);
/* ========================================================================



 * Bootstrap: aropopover.js v3.3.7



 * http://getbootstrap.com/javascript/#aropopovers



 * ========================================================================



 * Copyright 2011-2016 Twitter, Inc.



 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)



 * ======================================================================== */
+
function($) {
	'use strict';
	// POPOVER PUBLIC CLASS DEFINITION
	// ===============================
	var Popover = function(element, options) {
		this.init('aropopover', element, options)
	}
	if (!$.fn.arotooltip) throw new Error('Popover requires arotooltip.js')
	Popover.VERSION = '3.3.7'
	Popover.DEFAULTS = $.extend({}, $.fn.arotooltip.Constructor.DEFAULTS, {
		placement: 'right',
		trigger: 'click',
		content: '',
		template: '<div class="aropopover" role="arotooltip"><div class="arrow"></div><h3 class="aropopover-title"></h3><div class="aropopover-content"></div></div>'
	})
	// NOTE: POPOVER EXTENDS arotooltip.js
	// ================================
	Popover.prototype = $.extend({}, $.fn.arotooltip.Constructor.prototype)
	Popover.prototype.constructor = Popover
	Popover.prototype.getDefaults = function() {
		return Popover.DEFAULTS
	}
	Popover.prototype.setContent = function() {
		var $tip = this.tip()
		var title = this.getTitle()
		var content = this.getContent()
		$tip.find('.aropopover-title')[this.options.html ? 'html' : 'text'](title)
		$tip.find('.aropopover-content').children().detach().end()[ // we use append for html objects to maintain js events
			this.options.html ? (typeof content == 'string' ? 'html' : 'append') : 'text'
		](content)
		$tip.removeClass('fade top bottom left right in')
		// IE8 doesn't accept hiding via the `:empty` pseudo selector, we have to do
		// this manually by checking the contents.
		if (!$tip.find('.aropopover-title').html()) $tip.find('.aropopover-title').hide()
	}
	Popover.prototype.hasContent = function() {
		return this.getTitle() || this.getContent()
	}
	Popover.prototype.getContent = function() {
		var $e = this.$element
		var o = this.options
		return $e.attr('data-content')
			||
			(typeof o.content == 'function' ?
				o.content.call($e[0]) :
				o.content)
	}
	Popover.prototype.arrow = function() {
		return (this.$arrow = this.$arrow || this.tip().find('.arrow'))
	}
	// POPOVER PLUGIN DEFINITION
	// =========================
	function Plugin(option) {
		return this.each(function() {
			var $this = $(this)
			var data = $this.data('bs.aropopover')
			var options = typeof option == 'object' && option
			if (!data && /destroy|hide/.test(option)) return
			if (!data) $this.data('bs.aropopover', (data = new Popover(this, options)))
			if (typeof option == 'string') data[option]()
		})
	}
	var old = $.fn.aropopover
	$.fn.aropopover = Plugin
	$.fn.aropopover.Constructor = Popover
	// POPOVER NO CONFLICT
	// ===================
	$.fn.aropopover.noConflict = function() {
		$.fn.aropopover = old
		return this
	}
}(jQuery);



/* ========================================================================



 * Bootstrap: aroaffix.js v3.3.7



 * http://getbootstrap.com/javascript/#aroaffix



 * ========================================================================



 * Copyright 2011-2016 Twitter, Inc.



 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)



 * ======================================================================== */
+
function($) {
	'use strict';
	// AFFIX CLASS DEFINITION
	// ======================
	var Affix = function(element, options) {
		this.options = $.extend({}, Affix.DEFAULTS, options)
		this.$target = $(this.options.target)
			.on('scroll.bs.aroaffix.data-api', $.proxy(this.checkPosition, this))
			.on('click.bs.aroaffix.data-api', $.proxy(this.checkPositionWithEventLoop, this))
		this.$element = $(element)
		this.aroaffixed = null
		this.unpin = null
		this.pinnedOffset = null
		this.checkPosition()
	}
	Affix.VERSION = '3.3.7'
	Affix.RESET = 'aroaffix aroaffix-top aroaffix-bottom'
	Affix.DEFAULTS = {
		offset: 0,
		target: window
	}
	Affix.prototype.getState = function(scrollHeight, height, offsetTop, offsetBottom) {
		var scrollTop = this.$target.scrollTop()
		var position = this.$element.offset()
		var targetHeight = this.$target.height()
		if (offsetTop != null && this.aroaffixed == 'top') return scrollTop < offsetTop ? 'top' : false
		if (this.aroaffixed == 'bottom') {
			if (offsetTop != null) return (scrollTop + this.unpin <= position.top) ? false : 'bottom'
			return (scrollTop + targetHeight <= scrollHeight - offsetBottom) ? false : 'bottom'
		}
		var initializing = this.aroaffixed == null
		var colliderTop = initializing ? scrollTop : position.top
		var colliderHeight = initializing ? targetHeight : height
		if (offsetTop != null && scrollTop <= offsetTop) return 'top'
		if (offsetBottom != null && (colliderTop + colliderHeight >= scrollHeight - offsetBottom)) return 'bottom'
		return false
	}
	Affix.prototype.getPinnedOffset = function() {
		if (this.pinnedOffset) return this.pinnedOffset
		this.$element.removeClass(Affix.RESET).addClass('aroaffix')
		var scrollTop = this.$target.scrollTop()
		var position = this.$element.offset()
		return (this.pinnedOffset = position.top - scrollTop)
	}
	Affix.prototype.checkPositionWithEventLoop = function() {
		setTimeout($.proxy(this.checkPosition, this), 1)
	}
	Affix.prototype.checkPosition = function() {
		if (!this.$element.is(':visible')) return
		var height = this.$element.height()
		var offset = this.options.offset
		var offsetTop = offset.top
		var offsetBottom = offset.bottom
		var scrollHeight = Math.max($(document).height(), $(document.body).height())
		if (typeof offset != 'object') offsetBottom = offsetTop = offset
		if (typeof offsetTop == 'function') offsetTop = offset.top(this.$element)
		if (typeof offsetBottom == 'function') offsetBottom = offset.bottom(this.$element)
		var aroaffix = this.getState(scrollHeight, height, offsetTop, offsetBottom)
		if (this.aroaffixed != aroaffix) {
			if (this.unpin != null) this.$element.css('top', '')
			var aroaffixType = 'aroaffix' + (aroaffix ? '-' + aroaffix : '')
			var e = $.Event(aroaffixType + '.bs.aroaffix')
			this.$element.trigger(e)
			if (e.isDefaultPrevented()) return
			this.aroaffixed = aroaffix
			this.unpin = aroaffix == 'bottom' ? this.getPinnedOffset() : null
			this.$element
				.removeClass(Affix.RESET)
				.addClass(aroaffixType)
				.trigger(aroaffixType.replace('aroaffix', 'aroaffixed') + '.bs.aroaffix')
		}
		if (aroaffix == 'bottom') {
			this.$element.offset({
				top: scrollHeight - height - offsetBottom
			})
		}
	}
	// AFFIX PLUGIN DEFINITION
	// =======================
	function Plugin(option) {
		return this.each(function() {
			var $this = $(this)
			var data = $this.data('bs.aroaffix')
			var options = typeof option == 'object' && option
			if (!data) $this.data('bs.aroaffix', (data = new Affix(this, options)))
			if (typeof option == 'string') data[option]()
		})
	}
	var old = $.fn.aroaffix
	$.fn.aroaffix = Plugin
	$.fn.aroaffix.Constructor = Affix
	// AFFIX NO CONFLICT
	// =================
	$.fn.aroaffix.noConflict = function() {
		$.fn.aroaffix = old
		return this
	}
	// AFFIX DATA-API
	// ==============
	$(window).on('load', function() {
		$('[data-spy="aroaffix"]').each(function() {
			var $spy = $(this)
			var data = $spy.data()
			data.offset = data.offset || {}
			if (data.offsetBottom != null) data.offset.bottom = data.offsetBottom
			if (data.offsetTop != null) data.offset.top = data.offsetTop
			Plugin.call($spy, data)
		})
	})
}(jQuery);
/* ========================================================================
 * Bootstrap: transition.js v3.3.7
 * http://getbootstrap.com/javascript/#transitions
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // CSS TRANSITION SUPPORT (Shoutout: http://www.modernizr.com/)
  // ============================================================

  function transitionEnd() {
    var el = document.createElement('bootstrap')

    var transEndEventNames = {
      WebkitTransition : 'webkitTransitionEnd',
      MozTransition    : 'transitionend',
      OTransition      : 'oTransitionEnd otransitionend',
      transition       : 'transitionend'
    }

    for (var name in transEndEventNames) {
      if (el.style[name] !== undefined) {
        return { end: transEndEventNames[name] }
      }
    }

    return false // explicit for ie8 (  ._.)
  }

  // http://blog.alexmaccaw.com/css-transitions
  $.fn.emulateTransitionEnd = function (duration) {
    var called = false
    var $el = this
    $(this).one('bsTransitionEnd', function () { called = true })
    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }
    setTimeout(callback, duration)
    return this
  }

  $(function () {
    $.support.transition = transitionEnd()

    if (!$.support.transition) return

    $.event.special.bsTransitionEnd = {
      bindType: $.support.transition.end,
      delegateType: $.support.transition.end,
      handle: function (e) {
        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments)
      }
    }
  })

}(jQuery);

/* ========================================================================

 * Bootstrap: collapse.js v3.3.7

 * http://getbootstrap.com/javascript/#collapse

 * ========================================================================

 * Copyright 2011-2016 Twitter, Inc.

 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)

 * ======================================================================== */
/* jshint latedef: false */
+
function($) {
	'use strict';
	// COLLAPSE PUBLIC CLASS DEFINITION
	// ================================
	var Collapse = function(element, options) {
		this.$element = $(element)
		this.options = $.extend({}, Collapse.DEFAULTS, options)
		this.$trigger = $('[data-toggle="collapse"][href="#' + element.id + '"],' +
			'[data-toggle="collapse"][data-target="#' + element.id + '"]')
		this.transitioning = null
		if (this.options.parent) {
			this.$parent = this.getParent()
		} else {
			this.addAriaAndCollapsedClass(this.$element, this.$trigger)
		}
		if (this.options.toggle) this.toggle()
	}
	Collapse.VERSION = '3.3.7'
	Collapse.TRANSITION_DURATION = 350
	Collapse.DEFAULTS = {
		toggle: true
	}
	Collapse.prototype.dimension = function() {
		var hasWidth = this.$element.hasClass('width')
		return hasWidth ? 'width' : 'height'
	}
	Collapse.prototype.show = function() {
		if (this.transitioning || this.$element.hasClass('in')) return
		var activesData
		var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing')
		if (actives && actives.length) {
			activesData = actives.data('bs.arocollapse')
			if (activesData && activesData.transitioning) return
		}
		var startEvent = $.Event('show.bs.arocollapse')
		this.$element.trigger(startEvent)
		if (startEvent.isDefaultPrevented()) return
		if (actives && actives.length) {
			Plugin.call(actives, 'hide')
			activesData || actives.data('bs.arocollapse', null)
		}
		var dimension = this.dimension()
		this.$element
			.removeClass('collapse')
			.addClass('collapsing')[dimension](0)
			.attr('aria-expanded', true)
		this.$trigger
			.removeClass('collapsed')
			.attr('aria-expanded', true)
		this.transitioning = 1
		var complete = function() {
			this.$element
				.removeClass('collapsing')
				.addClass('collapse in')[dimension]('')
			this.transitioning = 0
			this.$element
				.trigger('shown.bs.arocollapse')
		}
		if (!$.support.transition) return complete.call(this)
		var scrollSize = $.camelCase(['scroll', dimension].join('-'))
		this.$element
			.one('bsTransitionEnd', $.proxy(complete, this))
			.emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])
	}
	Collapse.prototype.hide = function() {
		if (this.transitioning || !this.$element.hasClass('in')) return
		var startEvent = $.Event('hide.bs.arocollapse')
		this.$element.trigger(startEvent)
		if (startEvent.isDefaultPrevented()) return
		var dimension = this.dimension()
		this.$element[dimension](this.$element[dimension]())[0].offsetHeight
		this.$element
			.addClass('collapsing')
			.removeClass('collapse in')
			.attr('aria-expanded', false)
		this.$trigger
			.addClass('collapsed')
			.attr('aria-expanded', false)
		this.transitioning = 1
		var complete = function() {
			this.transitioning = 0
			this.$element
				.removeClass('collapsing')
				.addClass('collapse')
				.trigger('hidden.bs.arocollapse')
		}
		if (!$.support.transition) return complete.call(this)
		this.$element
		[dimension](0)
		.one('bsTransitionEnd', $.proxy(complete, this))
			.emulateTransitionEnd(Collapse.TRANSITION_DURATION)
	}
	Collapse.prototype.toggle = function() {
		this[this.$element.hasClass('in') ? 'hide' : 'show']()
	}
	Collapse.prototype.getParent = function() {
		return $(this.options.parent)
			.find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]')
			.each($.proxy(function(i, element) {
				var $element = $(element)
				this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element)
			}, this))
			.end()
	}
	Collapse.prototype.addAriaAndCollapsedClass = function($element, $trigger) {
		var isOpen = $element.hasClass('in')
		$element.attr('aria-expanded', isOpen)
		$trigger
			.toggleClass('collapsed', !isOpen)
			.attr('aria-expanded', isOpen)
	}

	function getTargetFromTrigger($trigger) {
		var href
		var target = $trigger.attr('data-target')
			||
			(href = $trigger.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, '') // strip for ie7
		return $(target)
	}
	// COLLAPSE PLUGIN DEFINITION
	// ==========================
	function Plugin(option) {
		return this.each(function() {
			var $this = $(this)
			var data = $this.data('bs.arocollapse')
			var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)
			if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false
			if (!data) $this.data('bs.arocollapse', (data = new Collapse(this, options)))
			if (typeof option == 'string') data[option]()
		})
	}
	var old = $.fn.arocollapse
	$.fn.arocollapse = Plugin
	$.fn.arocollapse.Constructor = Collapse
	// COLLAPSE NO CONFLICT
	// ====================
	$.fn.arocollapse.noConflict = function() {
		$.fn.arocollapse = old
		return this
	}
	// COLLAPSE DATA-API
	// =================
	$(document).on('click.bs.arocollapse.data-api', '[data-toggle="collapse"]', function(e) {
		var $this = $(this)
		if (!$this.attr('data-target')) e.preventDefault()
		var $target = getTargetFromTrigger($this)
		var data = $target.data('bs.arocollapse')
		var option = data ? 'toggle' : $this.data()
		Plugin.call($target, option)
	})
}(jQuery);
