<?php
/*
Plugin Name: VarkTech Minimum Purchase for WooCommerce
Plugin URI: http://varktech.com
Description: An e-commerce add-on for WooCommerce, supplying minimum purchase functionality. php 8.1+ compatible.
Version: 2.0.0.1
Author: Vark
Author URI: http://varktech.com
WC requires at least: 6.8
WC tested up to: 7.0
*/


/*
** define Globals 
*/
   $vtmin_info;  //initialized in VTMIN_Parent_Definitions
   $vtmin_rules_set;
   $vtmin_rule;
   $vtmin_cart;
   $vtmin_cart_item;
   $vtmin_setup_options;
//   $vtmin_error_msg;


   $vtmin_license_options; //v1.09.90 
  
 //initial setup only, overriden later in function vtprd_debug_options
 // display only the listed types
 //test test
   error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR); //v1.09.2
         
class VTMIN_Controller{
	
	public function __construct(){    
   
	define('VTMIN_VERSION',                               '2.0.0.1');  //v2.0.0
    define('VTMIN_MINIMUM_PRO_VERSION',                   '2.0.0.1');  //v2.0.0
    define('VTMIN_LAST_UPDATE_DATE',                      '2022-10-06'); //v2.0.0
    define('VTMIN_DIRNAME',                               ( dirname( __FILE__ ) ));
    define('VTMIN_URL',                                   plugins_url( '', __FILE__ ) );
    define('VTMIN_EARLIEST_ALLOWED_WP_VERSION',           '3.3');   //To pick up wp_get_object_terms fix, which is required for vtmin-parent-functions.php
    define('VTMIN_EARLIEST_ALLOWED_PHP_VERSION',          '7.0');  //v2.0.0   now using the "null coalescing operator" ("??"), first introduced in PHP7 
    define('VTMIN_PLUGIN_SLUG',                           plugin_basename(__FILE__));
    define('VTMIN_PRO_PLUGIN_NAME',                      'VarkTech Minimum Purchase Pro for WooCommerce');
    define('VTMIN_PRO_PLUGIN_FOLDER',                    'minimum-purchase-pro-for-woocommerce');    //v2.0.0
    define('VTMIN_PRO_PLUGIN_FILE',                      'vt-minimum-purchase-pro.php');    //v2.0.0
    define('VTMIN_ADMIN_CSS_FILE_VERSION',               'v003');    //v2.0.0  
       
    
    require_once ( VTMIN_DIRNAME . '/woo-integration/vtmin-parent-definitions.php');  //v2.0.0 CHANGE ALL require TO require_once 
   
    /*  =============+++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    //  these control the rules ui, add/save/trash/modify/delete
    /*  =============+++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    add_action('init',          array( &$this, 'vtmin_controller_init' )); 
    add_action('admin_init',    array( &$this, 'vtmin_admin_init' ));
   
    //v1.08 begin
    add_action( 'draft_to_publish',       array( &$this, 'vtmin_admin_update_rule' )); 
    add_action( 'auto-draft_to_publish',  array( &$this, 'vtmin_admin_update_rule' ));
    add_action( 'new_to_publish',         array( &$this, 'vtmin_admin_update_rule' )); 			
    add_action( 'pending_to_publish',     array( &$this, 'vtmin_admin_update_rule' ));    
    //v1.08 end
                                    
    //standard mod/del/trash/untrash    
    add_action('save_post',     array( &$this, 'vtmin_admin_update_rule' ));
    add_action('delete_post',   array( &$this, 'vtmin_admin_delete_rule' ));    
    add_action('trash_post',    array( &$this, 'vtmin_admin_trash_rule' ));
    add_action('untrash_post',  array( &$this, 'vtmin_admin_untrash_rule' ));

    add_action( 'admin_notices', array( &$this, 'vtmin_maybe_system_requirements') );  //v1.09.90 

    add_action( 'admin_notices', array( &$this, 'vtmin_check_for_data_updates') );  //v2.0.0 - added for data conversion 

    //add_action( 'load-post.php',     array( &$this, 'vtmin_admin_process' ) );      //v2.0.0a   added and removed      - function vtmin_admin_process also removed
    //add_action( 'load-post-new.php', array( &$this, 'vtmin_admin_process' ) );  ////v2.0.0a    added and removed       - function vtmin_admin_process also removed
    /*  =============+++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    
    //get rid of bulk actions on the edit list screen, which aren't compatible with this plugin's actions...
    add_action('bulk_actions-edit-vtmin-rule', array($this, 'vtmin_custom_bulk_actions') ); 

	}   //end constructor

  	                                                             
 /* ************************************************
 **   Overhead and Init
 *************************************************** */
	public function vtmin_controller_init(){   
    global $vtmin_setup_options;

  
    load_plugin_textdomain( 'vtmin', null, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 

    require_once ( VTMIN_DIRNAME . '/core/vtmin-backbone.php' );      //v2.0.0 - all 'require' files changed to 'require_once'
    require_once ( VTMIN_DIRNAME . '/core/vtmin-rules-classes.php');
    require_once ( VTMIN_DIRNAME . '/woo-integration/vtmin-parent-functions.php');
    // require_once ( VTMIN_DIRNAME . '/woo-integration/vtmin-parent-cart-validation.php'); //v1.09.91.1 shifted below


    //moved here v1.07
    if (get_option( 'vtmin_setup_options' ) ) {
      $vtmin_setup_options = get_option( 'vtmin_setup_options' );  //put the setup_options into the global namespace
    }        
    vtmin_debug_options();  //v1.07

    //***************
    //v2.0.0 begin
    // Licensing and Phone Home ONLY occurs when the purchased PRO version is installed
    //***************
    require_once ( VTMIN_DIRNAME . '/admin/vtmin-license-options.php');   
    global $vtmin_license_options; 
    $vtmin_license_options = get_option('vtmin_license_options'); 
    
    $this->vtmin_init_update_license();
    //v2.0.0 end
            
    //v1.09.90 begin
    //***************
    // Licensing and Phone Home ONLY occurs when the purchased PRO version is installed
    //***************
    //require_once ( VTMIN_DIRNAME . '/admin/vtmin-license-options.php');   //v2.0.0 
    //global $vtmin_license_options; //v2.0.0 
    //$vtmin_license_options = get_option('vtmin_license_options'); //v2.0.0 

    if ( $vtmin_setup_options['debugging_mode_on'] == 'yes' ){   
       error_log( print_r(  'Begin FREE plugin, vtmin_license_options= ', true ) );  
       error_log( var_export($vtmin_license_options, true ) ); 
    }      
    //v1.09.90 end

    $pageURL = sanitize_url($_SERVER["REQUEST_URI"]); //v2.0.0
    if (strpos($pageURL,'wp-admin') !== false) {            //v2.0.0      
    //if (is_admin()){  //v2.0.0 
        require_once ( VTMIN_DIRNAME . '/admin/vtmin-setup-options.php');
        
        define('VTMIN_ADMIN_URL', get_admin_url() ); //v1.09.90     
           
        if(defined('VTMIN_PRO_DIRNAME')) {
          require_once ( VTMIN_PRO_DIRNAME . '/admin/vtmin-rules-ui.php' );
          require_once ( VTMIN_PRO_DIRNAME . '/admin/vtmin-rules-update.php');
        } else {
          require_once ( VTMIN_DIRNAME .     '/admin/vtmin-rules-ui.php' );
          require_once ( VTMIN_DIRNAME .     '/admin/vtmin-rules-update.php');
        }
        
        require_once ( VTMIN_DIRNAME . '/admin/vtmin-checkbox-classes.php');
        require_once ( VTMIN_DIRNAME . '/admin/vtmin-rules-delete.php');
        
        //v1.09.2 begin
        if ( (defined('VTMIN_PRO_DIRNAME')) &&
             (version_compare(VTMIN_PRO_VERSION, VTMIN_MINIMUM_PRO_VERSION) < 0) ) {    //'<0' = 1st value is lower  
          add_action( 'admin_notices',array(&$this, 'vtmin_admin_notice_version_mismatch') );            
        }
        //v1.09.2 end 
                
    } else { //v1.09.91.1 begin-  added 'else' branch to Prevent some resources from loading in wp-admin which were causing woo api issues.
      //is_admin test doesn't alway work - test this way!!!!!!
       if ( (strpos($_SERVER["REQUEST_URI"],'wp-admin') !== false) ||
            (defined( 'DOING_CRON' )) ) {          
            //if is_admin, DO NOTHING
          $do_nothing = true;          
       } else {
          require_once ( VTMIN_DIRNAME . '/woo-integration/vtmin-parent-cart-validation.php');
       }
    } //v1.09.91.1 end
    
    //unconditional branch for these resources needed for WOOCommerce, at "place order" button time
    require_once ( VTMIN_DIRNAME . '/core/vtmin-cart-classes.php');
    
    /* v2.0.0a moved below is_admin
    if(defined('VTMIN_PRO_DIRNAME')) {
      require_once ( VTMIN_PRO_DIRNAME . '/core/vtmin-apply-rules.php' );
    } else {
      require_once ( VTMIN_DIRNAME .     '/core/vtmin-apply-rules.php' );
    }
    */
    
    wp_enqueue_script('jquery'); 
    
    
    //*****************
    //v1.09.8 begin
    //*****************
     /*
     wc_clear_notices
     doesn't clear old notices in all cases
     this takes care of it.
     
     CAN'T use is_cart() as it's not yet available.
     */
    
    //EXIT FUNCTION if is_admin
    $pageURL = sanitize_url($_SERVER["REQUEST_URI"]); //v2.0.0
    if (strpos($pageURL,'wp-admin') !== false) {    
      return;
    }
    
    //v2.0.0a begin moved here from above
    if(defined('VTMIN_PRO_DIRNAME')) {
      require_once ( VTMIN_PRO_DIRNAME . '/core/vtmin-apply-rules.php' );
      
      //v2.0.0a cronjobs check license twice a day
      require_once ( VTMIN_DIRNAME . '/core/vtmin-cron-class.php' );  //v2.0.0a
      add_action( 'vtmin_twice_daily_scheduled_events', 'vtmin_recheck_license_activation' );   //v2.0.0a       
    } else {
      require_once ( VTMIN_DIRNAME .     '/core/vtmin-apply-rules.php' );
    }
    //v2.0.0a end
    
    global $vtmin_info;
    $vtmin_info['woo_cart_url']      =  vtmin_woo_get_url('cart'); 
    $vtmin_info['woo_checkout_url']  =  vtmin_woo_get_url('checkout');
    $vtmin_info['currPageURL']       =  vtmin_currPageURL(); 
    
    
    //v1.09.83 begin  - recoded  
    $use_clear_cart_msgs = apply_filters('vtmin_use_clear_cart_msgs',TRUE );
    if ($use_clear_cart_msgs) {
      
      $currPageURL      = $vtmin_info['currPageURL'];
      $woo_cart_url     = $vtmin_info['woo_cart_url'];
  
      //enqueue not doing it's thing on this one...  - NEED wp_head to allow for is_product, is_shop etc TEST in function...   
      //add_action( "wp_enqueue_scripts", array(&$this, 'vtmin_enqueue_page_reload_on_ajax') );
      add_action( "wp_head", array(&$this, 'vtmin_enqueue_page_reload_on_ajax') );            
      add_action( "wp_enqueue_scripts", array(&$this, 'vtmin_enqueue_cart_resources') );       
    }
    //v1.09.83 end
    
    return;
    //*****************
    //v1.09.8 end
    //*****************

  }
  
  //*****************
  //v1.09.8 New Function
  //*****************
  function vtmin_enqueue_cart_resources() {
    wp_register_script('vtmin-clear-cart-msgs', VTMIN_URL.'/woo-integration/js/vtmin-clear-cart-msgs.js' ); 
    wp_enqueue_script ('vtmin-clear-cart-msgs', array('jquery'), false, true);
    //error_log( print_r(  'vtmin-clear-cart-msgs', true ) ); 
    
    //*************************
    //v2.0.0a begin
    //*************************
    // the registered style is ending up at the bottom of the list, doesn't get activated until a screen refresh...
    // using inline style and the 'fake' registratiion puts it at the TOP in the 'embbeded' file
    	
	//wp_register_style( 'vtmin-error-style', VTMIN_URL.'/core/css/vtmin-error-style.css' );  
    //wp_enqueue_style('vtmin-error-style');
    
    $vtmin_inline_css =  "
		/*CSS for Mimimum Error Msg Display*/
            table.shop_table {clear:left} /*woo-only override, for table following msgs on cart page, but css also hits the same table on checkout page(no effect)*/
            div.vtmin-error {
              margin: 30px 0 0 0%;  /* v1.09.8 */
              /* v1.09.8 */
              /* margin: 30px 0 0 -15%; */
              /* width: 120%; */                
              width: 100%;   /* v1.09.8 */
              background-color: #FFEBE8;
              border-color: #CC0000;
              padding: 5px 0.6em;
              border-radius: 3px 3px 3px 3px;
              border-style: solid;
              border-width: 1px;
              line-height: 12px;
              font-size:10px;
              height:auto;
              float:left;
            }
            /* TEST TEST TEST TEST*********************************/
            /*div.vtmin-error p {  color:red; } */
            
            div.vtmin-error p {font-size:14px;line-height: 18px;}
            div.vtmin-error .error-title {
              color: red;
              font-size: 12px;
              letter-spacing: 0.1em;
              line-height: 2.6em;
              padding-bottom: 2px;
              text-decoration: underline;
              text-transform: uppercase;
            }
            div.vtmin-error .black-font {color:black;}
            div.vtmin-error .errmsg-begin {color:black;margin-left:20px;}
            div.vtmin-error .black-font-italic {color:black; font-style:italic;}
            div.vtmin-error .red-font-italic {color:red; font-style:italic;}
            div.vtmin-error .errmsg-text {color:blue;}
            div.vtmin-error .errmsg-amt-current,
            div.vtmin-error .errmsg-amt-required {  
              font-style:italic;
              }
             
             
             /* ***************************************************************** */
             /* TABLE FORMAT ERROR MSG AREA  */
             /* ***************************************************************** */
            div.vtmin-error #table-error-messages {float:left; color:black; width:100%;}
            div.vtmin-error .table-titles {float:left; width:100%; margin-top:15px;}
            div.vtmin-error .product-column {float:left; width:42%; }
            div.vtmin-error .quantity-column {float:left; width:18%; }
            div.vtmin-error .price-column {float:left; width:15%; } 
            div.vtmin-error .total-column {float:left; /*width:25%; */}
            div.vtmin-error .product-column-title, 
            div.vtmin-error .quantity-column-title, 
            div.vtmin-error .price-column-title, 
            div.vtmin-error .total-column-title {
              text-decoration:underline; 
              } 
            div.vtmin-error .quantity-column-total, 
            div.vtmin-error .total-column-total {
              text-decoration:overline; font-weight:bold; font-style:italic; width:auto;
              }
            div.vtmin-error .table-error-msg {color:blue; float:left; margin:3px 0 3px 20px; font-size:16px;} 
            div.vtmin-error .bold-this {font-weight:bold}
             
            div.vtmin-error .table-msg-line {float:left; width:100%;}
            div.vtmin-error .table-totals-line {float:left; width:100%;}
            div.vtmin-error .table-text-line {float:left; width:100%;}
            
            div.vtmin-error .rule-id {font-size:10px;margin-left:5px;color:black;}
             
            /*2.0.0a begin*/           
                                        
            div#line-cnt1,
            div#line-cnt2,
            div#line-cnt3,
            div#line-cnt4,
            div#line-cnt5,
            div#line-cnt6,
            div#line-cnt7,
            div#line-cnt8,
            div#line-cnt9,
            div#line-cnt10,
            div#line-cnt11,
            div#line-cnt12,
            div#line-cnt13,
            div#line-cnt14,
            div#line-cnt15,
            div#line-cnt16,
            div#line-cnt17,
            div#line-cnt18,
            div#line-cnt19,
            div#line-cnt20 {height:auto;}             
            /*2.0.0a end*/ 
             
            /*alternating colors for rule groups*/
            
            div.vtmin-error .color-grp0 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp1 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp2 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp3 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp4 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp5 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp6 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp7 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp8 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp9 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp10 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp11 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp12 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp13 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp14 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp15 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp16 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp17 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp18 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp19 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-grp20 {color:RGB(197, 3, 3);}  /*dark red*/
            div.vtmin-error .color-xgrp1 {color:RGB(0, 255, 5);}  /*neon green*/            
            div.vtmin-error .color-xgrp2 {color:RGB(255, 93, 0);}  /*orange*/
            div.vtmin-error .color-xgrp3 {color:RGB(0, 115, 2);}  /*dark green*/
            div.vtmin-error .color-xgrp4 {color:RGB(244, 56, 56);}  /*light red*/
            div.vtmin-error .color-xgrp5 {color:RGB(255, 200, 0);}  /*ochre*/ 
            div.vtmin-error .color-xgrp6 {color:RGB(74, 178, 255);}  /*light blue*/
            div.vtmin-error .color-xgrp7 {color:RGB(37, 163, 162);}  /*dark teal*/                        
            div.vtmin-error .color-xgrp8 {color:RGB(47, 255, 253);}  /*light teal*/
            div.vtmin-error .color-xgrp9 {color:RGB(72, 157, 74);}  /*med green*/
            div.vtmin-error .color-xgrp10 {color:RGB(142, 146, 144);}  /*med grey*/            
            div.vtmin-error .color-xgrp11 {color:RGB(5, 71, 119);}  /*dark blue*/           
            div.vtmin-error .color-xgrp12 {color:RGB(0,0,0);}  /*black*/
           ";
    
      wp_register_style( 'vtmin-inline-css', false );
	  wp_enqueue_style ( 'vtmin-inline-css' );
	  wp_add_inline_style( 'vtmin-inline-css', $vtmin_inline_css );
    
    //v2.0.0a end
    //*************************
    return;	
	
  } 

   
  //*****************
  //v1.09.83 New Function
  //*****************
  function vtmin_enqueue_page_reload_on_ajax() {
 //error_log( print_r(  'BEGIN vtmin_enqueue_page_reload_on_ajax', true ) ); 
  
    global $vtmin_setup_options;

    if ( (isset( $vtmin_setup_options['show_errors_on_more_pages'] ))  &&
         ($vtmin_setup_options['show_errors_on_more_pages'] == 'all' ) &&
         (is_shop() || is_product_category() ) )  { //earliest this works is at add_action( 'wp', 'init' );
            //reload on ajax completion needed to run this plugin, possibly creating another error warning for min/max issue

               //error_log( print_r(  'LOAD JS', true ) ); 
                  ?>
                    <script type="text/javascript">
                        jQuery(document).ready(function($) {
                           $( document ).ajaxComplete(function() { 
                              //alert ('about to reload');
                              location.reload(true);
                            });
                        });   
                    </script>
                  <?php
     }  
    
  } 
         
  /* ************************************************
  **   Admin - Remove bulk actions on edit list screen, actions don't work the same way as onesies...
  ***************************************************/ 
  function vtmin_custom_bulk_actions($actions){
    
    ?> 
    <style type="text/css"> #delete_all {display:none;} /*kill the 'empty trash' buttons, for the same reason*/ </style>
    <?php
    
    unset( $actions['edit'] );
    unset( $actions['trash'] );
    unset( $actions['untrash'] );
    unset( $actions['delete'] );
    return $actions;
  }
    
  /* ************************************************
  **   Admin - Show Rule UI Screen
  *************************************************** 
  *  This function is executed whenever the add/modify screen is presented
  *  WP also executes it ++right after the update function, prior to the screen being sent back to the user.   
  */  
	public function vtmin_admin_init(){
     
      //************************
      //v2.0.0.1 begin 
      //************************
      $pageURL = sanitize_url($_SERVER["REQUEST_URI"]); //v2.0.0a    //v2.0.0.1  for ManageWP and InfiniteWP conflicts. for ManageWP and InfiniteWP 'admin' is not currently in $_SERVER["REQUEST_URI"], so don't run
      if (strpos($pageURL,'wp-admin') === false) {   //v2.0.0a  ) {   must be wp-admin to access this function
        return;
      } 
      //v2.0.0.1 end 
      //************************ 
      
     //v2.0.0.1 moved below to wrap the ui
     /*
     if ( !current_user_can( 'edit_posts', 'vtmin-rule' ) )
          return;
     */ 
     
     //v2.0.0.1 begin
     if (!class_exists('VTMIN_Rules_UI')) {  //v2.0.0.1  for ManageWP and InfiniteWP conflicts. for ManageWP and InfiniteWP 'admin' is not currently in $_SERVER["REQUEST_URI"], so this class doesn't yet exist.
          return;
     } 
     //v2.0.0.1 end
     
     global $vtmin_license_options, $vtmin_setup_options; //v2.0.0a

     if ( current_user_can( 'edit_posts', 'vtmin-rule' ) ) {   //v2.0.0.1 moved to wrap around the UI display
        $vtmin_rules_ui = new VTMIN_Rules_UI;  //v2.0.0a moved to its own function, in response to page actions      
     }
     
      require_once  ( VTMIN_DIRNAME . '/core/vtmin-backbone.php' ); 
       
     
     if (!$vtmin_license_options) {
        $vtmin_license_options = get_option( 'vtmin_license_options' ); 
     }     

  
  
    //v2.0.0a Licensing - begin
    //error_log( print_r(  'BEGIN vtmin_admin_init_overhead, current_pro_version= ' .$vtmin_setup_options['current_pro_version'] , true ) ); 
    
    $this->vtmin_maybe_update_version_num(); //v1.1.6.3
  
          //error_log( print_r(  'AFTER vtmin_maybe_update_version_num, current_pro_version= ' .$vtmin_setup_options['current_pro_version'] , true ) ); 
  
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active
    if (defined('VTMIN_PRO_VERSION')) { //v1.1.6.1

      $this->vtmin_maybe_pro_deactivate_action(); //pro only
      $this->vtmin_license_count_check(); //pro only
      //***************
      //v1.1.8.2 begin
      // require_once added here as the 2 functions below are in that file, and will not be there at admin_init time using the standard init path!
      //***************
      require_once ( VTMIN_DIRNAME . '/admin/vtmin-license-options.php');   //v2.0.0a moved here  
      //v1.1.8.2 end 

      if ( function_exists('vtmin_maybe_delete_pro_plugin_action') ) { //v1.1.8.2 weird occasional fatal on not finding this function...
        vtmin_maybe_delete_pro_plugin_action(); //pro only
      }
      
      //vtmin_maybe_admin_recheck_license_activation(); //v1.1.6  fallback to cron job //pro only
      if ( function_exists('vtmin_recheck_license_activation') ) { //v1.1.8.2 weird occasional fatal on not finding this function...      
        vtmin_recheck_license_activation(); //v1.1.6.3  fallback to cron job //pro only
      }
    } 
    
    $this->vtmin_maybe_version_mismatch_action(); 
    //v2.0.0a Licensing - end 
    
    return;  
  }
  
 
  /* ************************************************
  **   Admin - Update Rule 
  *************************************************** */
	public function vtmin_admin_update_rule(){
    /* *****************************************************************
         The delete/trash/untrash actions *will sometimes fire save_post*
         and there is a case structure in the save_post function to handle this.
    
          the delete/trash actions are sometimes fired twice, 
               so this can be handled by checking 'did_action'
     ***************************************************************** */
       /* ******************************************
       The 'SAVE_POST' action is fired at odd times during updating.
       When it's fired early, there's no post data available.
       So checking for a blank post id is an effective solution.
      *************************************************** */    
     
      global $post, $vtmin_rules_set;
	    if( !isset( $post ) ) {  //v1.09.3  
        return;
      } 

      
      //v2.0.0.1 begin
      /* ******************************************
       The 'SAVE_POST' action is fired at odd times during updating.
       When it's fired early, there's no post data available.
       So checking for a blank post id is an effective solution.
      *************************************************** */      

      if ( !( $post->ID > ' ' ) ) { //a blank post id means no data to proces....
        return;
      } 
      //v2.0.0.1 end      
      
      if ( !( 'vtmin-rule' == $post->post_type )) {
        return;
      }  
      if (( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) ) {
            return; 
      }
     if (isset($_REQUEST['vtmin_nonce']) ) {     //nonce created in vtmin-rules-ui.php  
          $nonce = $_REQUEST['vtmin_nonce'];
          if(!wp_verify_nonce($nonce, 'vtmin-rule-nonce')) { 
            return;
          }
      } 
      if ( !current_user_can( 'edit_posts', 'vtmin-rule' ) ) {
          return;
      }

      
      /* ******************************************
       The 'SAVE_POST' action is fired at odd times during updating.
       When it's fired early, there's no post data available.
       So checking for a blank post id is an effective solution.
      *************************************************** */      
      if ( !( $post->ID > ' ' ) ) { //a blank post id means no data to proces....
        return;
      } 
      //AND if we're here via an action other than a true save, do the action and exit stage left
      $action_type = $_REQUEST['action'];
      if ( in_array($action_type, array('trash', 'untrash', 'delete') ) ) {
        switch( $action_type ) {
            case 'trash':
                $this->vtmin_admin_trash_rule();  
              break;
            case 'untrash':
                $this->vtmin_admin_untrash_rule();
              break;
            case 'delete':
                $this->vtmin_admin_delete_rule();  
              break;
        }
        return;
      }
                 
      $vtmin_rule_update = new VTMIN_Rule_update;
  }
   
  
 /* ************************************************
 **   Admin - Delete Rule
 *************************************************** */
	public function vtmin_admin_delete_rule(){
     global $post, $vtmin_rules_set; 

      //v2.0.0.1 begin 
      if( !isset( $post ) ) {
        return;
      } 
      //v2.0.0.1 end  
       
      if ( !( 'vtmin-rule' == $post->post_type )) {
        return;
      }         

     if ( !current_user_can( 'delete_posts', 'vtmin-rule' ) )  {
          return;
     }
    
    $vtmin_rule_delete = new VTMIN_Rule_delete;            
    $vtmin_rule_delete->vtmin_delete_rule();
  }
  
  
  /* ************************************************
  **   Admin - Trash Rule
  *************************************************** */   
	public function vtmin_admin_trash_rule(){
     global $post, $vtmin_rules_set; 

      //v2.0.0.1 begin 
      if( !isset( $post ) ) {
        return;
      } 
      //v2.0.0.1 end  
         
      if ( !( 'vtmin-rule' == $post->post_type )) {
        return;
      }          
  
     if ( !current_user_can( 'delete_posts', 'vtmin-rule' ) )  {
          return;
     }  
     
     if(did_action('trash_post')) {    
         return;
    }
    
    $vtmin_rule_delete = new VTMIN_Rule_delete;            
    $vtmin_rule_delete->vtmin_trash_rule();

  }
  
  
 /* ************************************************
 **   Admin - Untrash Rule
 *************************************************** */   
	public function vtmin_admin_untrash_rule(){
     global $post, $vtmin_rules_set; 

      //v2.0.0.1 begin 
      if( !isset( $post ) ) {
        return;
      } 
      //v2.0.0.1 end  
        
      if ( !( 'vtmin-rule' == $post->post_type )) {
        return;
      }          

     if ( !current_user_can( 'delete_posts', 'vtmin-rule' ) )  {
          return;
     }       
    $vtmin_rule_delete = new VTMIN_Rule_delete;            
    $vtmin_rule_delete->vtmin_untrash_rule();
  }


  /* ************************************************
  **   Admin - Activation Hook
  *************************************************** */  
  function vtmin_activation_hook() {
     //the options are added at admin_init time by the setup_options.php as soon as plugin is activated!!!
    
    //error_log( print_r(  'function vtmin_activation_hook', true ) );
    
      //verify the requirements for Vtmin.
      global $wp_version;
  		if((float)$wp_version < 3.3){
  			// delete_option('vtmin_setup_options');
  			 wp_die( __('<strong>Looks like you\'re running an older version of WordPress, you need to be running at least WordPress 3.3 to use the Varktech Minimum Purchase plugin.</strong>', 'vtmin'), __('VT Minimum Purchase not compatible - WP', 'vtmin'), array('back_link' => true));
  			return;
  		}
      
      //fix 2-13-2013 - changed php version_compare, altered error msg   
     if (version_compare(PHP_VERSION, VTMIN_EARLIEST_ALLOWED_PHP_VERSION) < 0) {    //'<0' = 1st value is lower 
  			wp_die( __('<strong><em>PLUGIN CANNOT ACTIVATE &nbsp;&nbsp;-&nbsp;&nbsp;     Varktech Minimum Purchase </em>
        <br><br>&nbsp;&nbsp;&nbsp;&nbsp;   Your installation is running on an older version of PHP 
        <br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   - your PHP version = ', 'vtmin') .PHP_VERSION. __(' . 
        <br><br>&nbsp;&nbsp;&nbsp;&nbsp;   You need to be running **at least PHP version 7** to use this plugin.  
        <br><br>&nbsp;&nbsp;&nbsp;&nbsp;   Please contact your host and request an upgrade to PHP 7+ . 
        <br><br>&nbsp;&nbsp;&nbsp;&nbsp;   Then activate this plugin following the upgrade.</strong>', 'vtmin'), __('VT Min and Max Purchase not compatible - PHP', 'vtmin'), array('back_link' => true));
  			return; 
  		}
  
      if(defined('WOOCOMMERCE_VERSION') && (VTMIN_PARENT_PLUGIN_NAME == 'WooCommerce')) { 
        $new_version =      VTMIN_EARLIEST_ALLOWED_PARENT_VERSION;
        $current_version =  WOOCOMMERCE_VERSION;
        if( (version_compare(strval($new_version), strval($current_version), '>') == 1) ) {   //'==1' = 2nd value is lower 
    			// delete_option('vtmin_setup_options');
    			 wp_die( __('<strong>Looks like you\'re running an older version of WooCommerce. <br>You need to be running at least ** WooCommerce 1.0 **, to use the Varktech Minimum Purchase plugin.</strong>', 'vtmin'), __('VT Minimum Purchase not compatible - WooCommerce', 'vtmin'), array('back_link' => true));
    			return;
    		}
      }   else 
      if (VTMIN_PARENT_PLUGIN_NAME == 'WooCommerce') {
          wp_die( __('<strong>Varktech Minimum Purchase for WooCommerce requires that WooCommerce be installed and activated.</strong>', 'vtmin'), __('WooCommerce not installed or activated', 'vtmin'), array('back_link' => true));
    			return;
      }
    
      //*********************
      //v2.0.0 begin
      //*********************
      // run this to serialize the  'vtmin_rules_set' option as required in php8, if plugin was previously installed...
      //MUST be done IMMEDIATELY
      
      require_once  ( VTMIN_DIRNAME . '/woo-integration/vtmin-parent-functions.php');   
      require_once  ( VTMIN_DIRNAME . '/woo-integration/vtmin-parent-definitions.php');
      	  
      $this->vtmin_check_for_data_updates();
    
      //v2.0.0 end
      //*********************

    return;
   }
    

   //v1.09.2 begin                          
   function vtmin_admin_notice_version_mismatch() {
      /* V2.0.0.1
      $message  =  '<strong>' . __('Please also update plugin: ' , 'vtmin') . ' &nbsp;&nbsp;'  .VTMIN_PRO_PLUGIN_NAME . '</strong>' ;
      $message .=  '<br>&nbsp;&nbsp;&bull;&nbsp;&nbsp;' . __('Your Pro Version = ' , 'vtmin') .VTMIN_PRO_VERSION. ' &nbsp;&nbsp;' . __(' The Minimum Required Pro Version = ' , 'vtmin') .VTMIN_MINIMUM_PRO_VERSION ;      
      $message .=  '<br>&nbsp;&nbsp;&bull;&nbsp;&nbsp;' . __('Please delete the old Pro plugin from your installation via ftp.'  , 'vtmin');
      $message .=  '<br>&nbsp;&nbsp;&bull;&nbsp;&nbsp;' . __('Go to ', 'vtmin');
      $message .=  '<a target="_blank" href="http://www.varktech.com/download-pro-plugins/">Varktech Downloads</a>';
      $message .=   __(', download and install the newest <strong>'  , 'vtmin') .VTMIN_PRO_PLUGIN_NAME. '</strong>' ;
      
      $admin_notices = '<div id="message" class="error fade" style="background-color: #FFEBE8 !important;"><p>' . $message . ' </p></div>';
      echo $admin_notices;
      */
      //v1.09.2 added
      $plugin = VTMIN_PRO_PLUGIN_SLUG;
	  if( is_plugin_active($plugin) ) {
			   deactivate_plugins( $plugin );
      }      
      
      return; 
    
  }   
   //v1.09.2 end    
 
  
  //***************************
  //v2.0.0  new function    
  // Message for ALL future updates
  //***************************
  
  public function vtmin_check_for_data_updates(){
        global $vtmin_info;

        //v2.0.0 begin

        $vtmin_data_update_options = get_option('vtmin_data_update_options');
        
        if (!$vtmin_data_update_options) {
          $vtmin_data_update_options = array();
        }
                
        $dataUpd = '2.0.0 Ruleset conversion';
 
        if ( (isset ($vtmin_data_update_options['required_updates'][$dataUpd])) &&
             ($vtmin_data_update_options['required_updates'][$dataUpd] === true) ) {
          //error_log( print_r(  'Done with Engines', true ) );
          $done_with_engines = true;
        } else {
                          
          //SERIALIZE the rules_set array - ALREADY DONE ABOVE
          $vtmin_rules_set = vtmin_get_rules_set();   //v2.0.0
          //v2.0.3 
          $sizeof_rules_set = is_array($vtmin_rules_set) ? sizeof($vtmin_rules_set) : 0; //v2.1.0  
          if ($sizeof_rules_set > 0) { 
            //++++++++++++++++
            //BACKUP - so this can be rolled back....
            $todaysDate = date("Y.m.d");                      
            $option_key = 'vtmin_rules_set_v2.0.0_bkup_' .$todaysDate;
            $flat_rules_set = serialize($vtmin_rules_set);
            update_option( $option_key,$flat_rules_set ); 
 
            vtmin_set_rules_set($vtmin_rules_set);  //v2.0.0  serialize the array and update the option.
          }
          
          $vtmin_data_update_options['required_updates'][$dataUpd] = true; 
          update_option('vtmin_data_update_options',$vtmin_data_update_options); 

        }          
        //v2.0.0 end
        //*************************                
       
    return;
        
  }



   //**************************** 
   //v1.09.90 new function PRO ONLY
   //**************************** 
   public function vtmin_maybe_system_requirements() {
     global $vtmin_license_options;
    if (!defined('VTMIN_PRO_VERSION')) {
      return;    
    }

    
    //v2.0.0 begin 
    global $vtmin_license_options;
    if (!$vtmin_license_options) {
      $vtmin_license_options = get_option('vtmin_license_options');
    }
    
    if ($vtmin_license_options['state'] == 'suspended-by-vendor') {
      return;    
    }
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active
    if (!defined('VTMIN_PRO_VERSION')) {
      return;
    }
   
    //if fatal counts exceed limit, never allow pro plugin to be activated
    if ($vtmin_license_count >= 10 ) { //v1.1.6.7 upgraded from 5 to 10!
      vtmin_deactivate_pro_plugin();
      $vtmin_license_options['state'] = 'suspended-by-vendor';
      $vtmin_license_options['status'] = 'invalid';
      $vtmin_license_options['diagnostic_msg'] = 'suspended until contact with vendor';
      update_option('vtmin_license_options', $vtmin_license_options);
                    
    }    
      
    //display any system-level licensing issues
    $this->vtmin_maybe_pro_license_error();
         
    //v2.0.0 end
    
    return; 
  }

  
  /* ************************************************
  **   v2.0.0 new function, run at plugin init
  * ONLY RUN IF PRO VERSION IS installed
  * However, the PRO version may have been deactivated
  * when this runs, so no test is applied directly     
  *************************************************** */ 
	public function vtmin_init_update_license() {
    global $vtmin_license_options;
    
    //don't run if license_options.php has NEVER RUN!
    if( get_option( 'vtmin_license_options' ) !== FALSE ) {
      $carry_on = true;  
    } else {
      return;
    }
    
       //error_log( print_r(  'BEGIN vtmin_init_update_license, global $vtmin_license_options=' , true ) );   

    /* vtmin_license_suspended / vtmin_license_checked
    is only created during the plugin updater execution

    However, you can't update the options table consistently, so this is done instead. 
    If the call to the home server produces a status change, it's updated here.
      ( Can't update vtmin_license_options in the plugin updater, things explode!! )
    */
    if (get_option('vtmin_license_suspended')) {
      $vtmin_license_options2 = get_option('vtmin_license_suspended');
      $vtmin_license_options['status']  = $vtmin_license_options2['status'];
      $vtmin_license_options['state']   = $vtmin_license_options2['state'];
      $vtmin_license_options['strikes'] = $vtmin_license_options2['strikes'];
      $vtmin_license_options['diagnostic_msg'] = $vtmin_license_options2['diagnostic_msg'];
      $vtmin_license_options['last_failed_rego_ts']        = $vtmin_license_options2['last_failed_rego_ts']; 
      $vtmin_license_options['last_failed_rego_date_time'] = $vtmin_license_options2['last_failed_rego_date_time']; 
      $vtmin_license_options['last_response_from_host'] = $vtmin_license_options2['last_response_from_host']; //v1.1.6
      $vtmin_license_options['msg'] = $vtmin_license_options2['msg']; //v1.1.6
      //v1.1.6 begin
      //moved here from PHONE HOME, as the cron job timing can't check is_installed!
      if ($license_data->state == 'suspended-by-vendor') {   
        vtmin_deactivate_pro_plugin();
      }
      //v1.1.6 end
      //update status change
      update_option('vtmin_license_options', $vtmin_license_options);
       //error_log( print_r(  'UPDATED FROM  vtmin_license_suspended', true ) );  
      //cleanup
      delete_option('vtmin_license_suspended'); 
      return;   //if suspneded, no further processing.        
    }
     
    if (get_option('vtmin_license_checked')) {
      $vtmin_license_options2 = get_option('vtmin_license_checked');
      $vtmin_license_options['last_successful_rego_ts']        = $vtmin_license_options2['last_successful_rego_ts']; 
      $vtmin_license_options['last_successful_rego_date_time'] = $vtmin_license_options2['last_successful_rego_date_time'];  
      //update ts change
      update_option('vtmin_license_options', $vtmin_license_options);
          
      //cleanup
      delete_option('vtmin_license_checked');            
    }  

    
    
    //check for PRO VERSION MISMATCH, comparing from Either side
    //$vtmin_license_options['pro_version'] only has a value if pro version has ever been installed.
    //on Pro uninstall clear out these values, so that if plugin uninstalled, values and accompanying error messages don't display!
    

    $pageURL = sanitize_url($_SERVER["REQUEST_URI"]); //v2.0.3
    if (strpos($pageURL,'wp-admin') !== false) {   //v2.0.3       
      /* vtmin_pro_plugin_deleted 
      is only created if the pro plugin is deleted by the admin.
      However, you can't update the options table consistently, so this is done instead. 
      If the call to the home server produces a status change, it's updated here.
        ( Can't update vtmin_license_options in the plugin updater, things explode!! )
      */     
      if (get_option('vtmin_pro_plugin_deleted')) {
        $vtmin_license_options['pro_version'] = null;      
        $vtmin_license_options['pro_plugin_version_status'] = null;
        $vtmin_license_options['pro_minimum_free_version'] = null; 
        update_option('vtmin_license_options', $vtmin_license_options);
  
        //cleanup
        delete_option('vtmin_pro_plugin_deleted');            
      }   
              
      $this->vtmin_pro_version_verify(); //v1.1.6.3 refactored into new function

      //v1.1.6.1 begin
      //conversion to storing home_url, used in anchors ...
      if ( (!isset($vtmin_license_options['home_url'])) ||
           ($vtmin_license_options['home_url'] == null) ) {
         $vtmin_license_options['home_url'] = sanitize_url( home_url() );
         update_option('vtmin_license_options', $vtmin_license_options);   
      }
      //v1.1.6.1 end
      
    }  
        
    return;   
  }


  /* ************************************************
  **   v2.0.0 new function, run at admin init  
  *************************************************** */ 
	public function vtmin_pro_version_verify() {
    global $vtmin_license_options;               
    
      //EDIT only if PRO plugin installed or active
      if (defined('VTMIN_PRO_VERSION')) {
        $carry_on = true;
      } else {
        $pro_plugin_is_installed = vtmin_check_pro_plugin_installed();
        if ($pro_plugin_is_installed !== false) {
           $vtmin_license_options['pro_version'] = $pro_plugin_is_installed;
        } else {
 
          //PRO is not installed, however there may be cleanup to do if pro mismatch status left over
          if ($vtmin_license_options['pro_plugin_version_status'] == 'Pro Version Error' ) {
            $vtmin_license_options['pro_version'] = FALSE;
            $vtmin_license_options['pro_plugin_version_status'] = 'valid'; 
            update_option('vtmin_license_options', $vtmin_license_options);
          } 

          return;
        }    
      }
    
          //error_log( print_r(  'vtmin_pro_version_verify 001' , true ) ); 
      //PICK up any defined values from active PRO.  If inactive, the license_options value will have previously-loaded values
      //if ((defined('vtmin_PRO_DIRNAME')) )   { //changed to PRO_VERSION because PRO_DIRNAME is now controlled in THIS file 
      if (defined('VTMIN_PRO_VERSION')) {
      
          //error_log( print_r(  'vtmin_pro_version_verify 002' , true ) ); 
        if ( ($vtmin_license_options['pro_version'] == VTMIN_PRO_VERSION) &&
             ($vtmin_license_options['pro_minimum_free_version'] == VTMIN_PRO_MINIMUM_REQUIRED_FREE_VERSION) ) {
      
          //error_log( print_r(  'vtmin_pro_version_verify 003' , true ) );             
            $carry_on = true;   //v1.1.6.6
        } else {
       
          //error_log( print_r(  'vtmin_pro_version_verify 005' , true ) );        
          $vtmin_license_options['pro_version'] = VTMIN_PRO_VERSION;
          $vtmin_license_options['pro_minimum_free_version'] = VTMIN_PRO_MINIMUM_REQUIRED_FREE_VERSION;
          //update_option('vtmin_license_options', $vtmin_license_options);
        }

      } 

      if ($vtmin_license_options['pro_version'] > '') {
       
          //error_log( print_r(  'vtmin_pro_version_verify 006' , true ) );      
        if (version_compare($vtmin_license_options['pro_version'], VTMIN_MINIMUM_PRO_VERSION) < 0) {    //'<0' = 1st value is lower 
          
          //error_log( print_r(  'vtmin_pro_version_verify 007' , true ) );            
          $vtmin_license_options['pro_plugin_version_status'] = 'Pro Version Error'; 
        } else {
       
          //v1.1.6.7 begin
          // if previously pro version error, this would have been set, to allow a PLUGIN UPDATE.  Update has been completed, so no longer necessary!
          if ($vtmin_license_options['pro_plugin_version_status'] == 'Pro Version Error') {
            delete_option('vtmin_do_pro_plugin_update');  
          }
          //v1.1.6.7 begin
            
          //error_log( print_r(  'vtmin_pro_version_verify 008' , true ) );      
          $vtmin_license_options['pro_plugin_version_status'] = 'valid'; 
        }
        
        if ($vtmin_license_options['pro_plugin_version_status'] == 'valid') { 
         
          //error_log( print_r(  'vtmin_pro_version_verify 009' , true ) );     
          if  (version_compare(VTMIN_VERSION, $vtmin_license_options['pro_minimum_free_version']) < 0) {    //'<0' = 1st value is lower   
          
          //error_log( print_r(  'vtmin_pro_version_verify 010' , true ) );             
            $vtmin_license_options['pro_plugin_version_status'] = 'Free Version Error';
            //$vtmin_license_options['state']  = 'pending';  //v1.1.6.3 changed from PRO deactivation to status change
            //$vtmin_license_options['status'] = 'invalid';  //v1.1.6.3 changed from PRO deactivation to status change            
          } else {
       
          //error_log( print_r(  'vtmin_pro_version_verify 011' , true ) );          
            $vtmin_license_options['pro_plugin_version_status'] = 'valid'; 
          }
        } 
      //error_log( print_r(  'vtmin_pro_version_verify 012' , true ) );                         
        update_option('vtmin_license_options', $vtmin_license_options);
                         
      } 
        //error_log( print_r(  'vtmin_pro_version_verify 013' , true ) );     
      return;   
  }


  /* ************************************************
  **   v2.0.0 new function, run at admin init  
  *************************************************** */ 
	public function vtmin_maybe_version_mismatch_action() {

    //if PRO **not active** but installed, and VERSION ERROR, still do the messaging
    //can only do this AFTER or as part of admin_init
    global $vtmin_license_options;
    if (!$vtmin_license_options) {
      $vtmin_license_options = get_option('vtmin_license_options');
    }
    
    if (( isset($vtmin_license_options['status']) ) &&            //v2.0.3
        (!$vtmin_license_options['pro_version']) ) {  //'pro_version' only has data when pro plugin INSTALLED
      return;
    } 

   
    if ($vtmin_license_options['pro_plugin_version_status'] == 'Pro Version Error') {
      //*******************
      //v1.1.6.7 refactored
      //ONLY show if the plugin is actually INSTALLED!!
      if (defined('VTMIN_PRO_VERSION')) {
        $pro_plugin_is_installed = TRUE;
      } else {
        $pro_plugin_is_installed = $this->vtmin_maybe_pro_plugin_installed(); // function pro_plugin_installed must be in the class!!
      }     
      if ($pro_plugin_is_installed !== false) {
         //v1.1.8.2 - ONLY SEND if previously registered - REGISTRATION SUPERCEDES MISMATCH
        if ( ($vtmin_license_options['status'] == 'valid') &&  //v1.1.8.2
             ($vtmin_license_options['state']  == 'active') ) { //v1.1.8.2 
          add_action( 'admin_notices',    array(&$this, 'vtmin_admin_notice_version_mismatch_pro') ); 
          add_action( 'after_plugin_row', array(&$this, 'vtmin_plugin_notice_version_mismatch_pro' ), 10, 3  );  //v1.1.6.7
           //v1.1.6.7 - plugin updater now runs *only* when a plugin mismatch is detected in the free version - so there must always be paired updates!! 
          update_option('vtmin_do_pro_plugin_update', TRUE);  //v1.1.6.7 ==>> allows pro_plugin_update action!
        }  //v1.1.8.2 
      //v1.1.6.7 end 
      //******************* 
      }  
    }
    
    if ($vtmin_license_options['pro_plugin_version_status'] == 'Free Version Error') {
      //v1.1.6.3 begin
      //ONLY show if the plugin is actually INSTALLED!!
      $pro_plugin_is_installed = $this->vtmin_maybe_pro_plugin_installed(); // function pro_plugin_installed must be in the class!!
      if ($pro_plugin_is_installed !== false) {      
        add_action( 'admin_notices',array(&$this, 'vtmin_admin_notice_version_mismatch_free') ); 
      }
      //v1.1.6.3 end                 
    } 
         
    return;    
  }  
 


   //**************************** 
   //  v2.0.0 new function, run at admin init  
   //****************************                       
   public function vtmin_admin_notice_version_mismatch_pro() {
  
      //error_log( print_r(  'Function begin - vtmin_admin_notice_version_mismatch_pro', true ) );

      global $vtmin_license_options;
   
      //$pageURL = $_SERVER["REQUEST_URI"];  //v2.0.3
      $pageURL =  sanitize_url($_SERVER["REQUEST_URI"]); //v2.0.3      

      switch( true ) { 
        case (strpos($pageURL,'delete-selected') !== false ):         
                return; //annoying to have warnings on the delete page!
             break;
          
        case (strpos($pageURL,'vtmin_license_options_page') !== false ):         
                //v1.1.6.7  NOW handled in vtmin-license-options as a direct message, as admin-notices are sometimes blocked by a conflicting plugin!! 
                return;
             break;
         case (strpos($pageURL,'plugin-install') !== false ):         
                //v2.0.3 annoying to have message on plugin install page
                return;
             break; 
         case (strpos($pageURL,'upload-plugin') !== false ):         
                //v2.0.3 annoying to have message on plugin install/upload page
                return;
             break;
         //v2.0.0.1 begin
         case (strpos($pageURL,'plugins.php') !== false ):         
                $admin_notices = vtmin_full_pro_upd_msg(); //V2.0.0.1 MSG move to functions.php        
                $allowed_html = vtmin_get_allowed_html(); //v2.0.3
                echo wp_kses($admin_notices ,$allowed_html ); //v2.0.3

                return;
             break;
         //v2.0.0.1 end                                
        default:          
            
            $message  =  '<strong>' . __('Update Required for: ' , 'vtmin') . ' &nbsp;&nbsp;'  .VTMIN_PRO_PLUGIN_NAME . '</strong>' ;
            $message .=  "<span style='color:red !important;font-size:16px;'><strong><em>&nbsp;&nbsp;&nbsp; (pro plugin will **not discount** until updated)</em></strong></span>" ;  //v1.1.7 change color, wording
            
            $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . __('Your Pro Version = ' , 'vtmin') .$vtmin_license_options['pro_version'] .'&nbsp;&nbsp;&nbsp;&nbsp;<strong>' . __(' <em>Required</em> Pro Version = ' , 'vtmin') .VTMIN_MINIMUM_PRO_VERSION .'</strong>'; 
                         
            //ALL UPDATES MUST NOW BE MANUAL.
               
              $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&bull;&nbsp;&nbsp;<span style="font-size:16px;font-weight:bold;">' . __('Go to the '  , 'vtmin') .'&nbsp;&nbsp;';
              $homeURL = VTMIN_ADMIN_URL.'plugins.php?plugin_status=all&paged=1&s';            //v2.0.0.a updated
              $message .=  '<a href="'.esc_url($homeURL).'">Plugins Page</a> For Instructions</span>' ;              //v2.0.0.a updated
           
            //v2.1.0 END              
          break;      
      }
      
      
      $admin_notices = '<div id="message" class="error fade" style="background-color: #FFEBE8 !important;"><p style="font-size: 18px !important;">' . $message . ' </p></div>';
      
      //echo $admin_notices; //v2.0.3
      $allowed_html = vtmin_get_allowed_html(); //v2.0.3
      echo wp_kses($admin_notices ,$allowed_html ); //v2.0.3
      
      return;    
  }       

   //**************************** 
   //  v2.0.0 new function, run at admin init 
   //****************************       
    function vtmin_plugin_notice_version_mismatch_pro( $plugin_file, $plugin_data, $status ) {
       global $vtmin_license_options;
       if (!$vtmin_license_options) {
          $vtmin_license_options = get_option( 'vtmin_license_options' ); 
       } 

       if ( ($vtmin_license_options['pro_plugin_version_status'] == 'Pro Version Error') &&  
          //  (strpos( $plugin_file, 'pricing-deals-for-woocommerce' ) !== false )  ) {
            (strpos( $plugin_file, VTMIN_PRO_PLUGIN_FOLDER ) !== false )  ) {
   
            if ( (isset($plugin_data['url'])) && 
                 (isset($plugin_data['package'])) &&
                 ($plugin_data['url'] !== false) &&
                 ($plugin_data['package'] !== false) ) {              
              //**************************************************************************
              //if update nag data is found, message unneccessary, 
              //   and actually gums up the works, so don't send!
              //**************************************************************************
              return;                    
            }
         
            $message  =  '<td colspan="5" class="update-msg" style="line-height:1.2em; font-size:12px; padding:1px;">';
            $message .=  '<div style="color:#000; font-weight:bold; margin:4px 4px 4px 5%; width:80%; padding:6px 5px; background-color:#fffbe4; border-color:#dfdfdf; border-width:1px; border-style:solid; -moz-border-radius:5px; -khtml-border-radius:5px; -webkit-border-radius:5px; border-radius:5px;">';
            $message .=  '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . __('Get the New version ', 'vtmin') .'&nbsp; - &nbsp;&nbsp;<em>'. VTMIN_MINIMUM_PRO_VERSION .'</em>&nbsp;&nbsp; - &nbsp;'. __(' *required* &nbsp;&nbsp; for ', 'vtmin')  .'&nbsp;&nbsp;' . VTMIN_PRO_PLUGIN_NAME  ;
            $message .=  "<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style='color:red !important;font-size:16px;'><em>&nbsp;&nbsp;&nbsp; (pro plugin will **not discount** until updated)</em></span>" ; //v1.1.7 change color, wording
            //$message .=  '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' .VTMIN_PRO_PLUGIN_NAME  .'&nbsp;&nbsp;&nbsp;&nbsp;' . __('New version ', 'vtmin') .'&nbsp;&nbsp;<em>'. VTMIN_MINIMUM_PRO_VERSION .'</em>&nbsp;&nbsp;'. __(' *required* ! ', 'vtmin')   ;
            
            //***************** 
            //v2.1.0 begin
            //*****************
            /*
            
            WITH THE UPDATE TO THE INMOTION SERVER, AUTO UPDATES FOR PRICING DEALS NO LONGER FUNCTION
            
            ALL UPDATES MUST NOW BE MANUAL.
            */ 
            
              $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&bull;&nbsp;&nbsp;' . __('See Plugin update instructions above'  , 'vtmin') .'&nbsp;&nbsp;';           

            //v2.1.0 END
                       
            $message .=  '</div	></td>';  
                      
          //echo $message; //v2.0.3
          $allowed_html = vtmin_get_allowed_html(); //v2.0.3
          echo wp_kses($message ,$allowed_html ); //v2.0.3
      }
      
      return;
    }
  
   //**************************** 
   //   v2.0.0 new function, run at admin init 
   //****************************                       
   public function vtmin_admin_notice_version_mismatch_free() {
  
      //error_log( print_r(  'Function begin - vtmin_admin_notice_version_mismatch_free', true ) );
      global $vtmin_license_options;
      $message  =  '<strong>' . __('Please update the FREE plugin: ' , 'vtmin') . ' &nbsp;&nbsp;'  .VTMIN_PLUGIN_NAME . '</strong>' ;
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active
      if (defined('VTMIN_PRO_VERSION')) {
        $message .=  '<br>&nbsp;&nbsp;&bull;&nbsp;&nbsp;' . __('Required FREE version  = ' , 'vtmin') .$vtmin_license_options['pro_minimum_free_version']. ' &nbsp;&nbsp;<strong>' . 
              __(' Current Free Version = ' , 'vtmin') .VTMIN_VERSION .'</strong>';
      }  else {
        $message .=  '<br>&nbsp;&nbsp;&bull;&nbsp;&nbsp;<strong>' . __('FREE Plugin update required!! ' , 'vtmin').'</strong>';
      }          
            
      $message .=  '<br><br><strong>' . 'The PRO Plugin:' . ' &nbsp;&nbsp;</strong><em>'  .VTMIN_PRO_PLUGIN_NAME . '</em>&nbsp;&nbsp;<strong>' . '  ** will not give discounts ** until this is resolved.' .'</strong>' ;              
                   
      $message .=  '<br><br>&nbsp;&nbsp; 1. &nbsp;&nbsp;<strong>' . __('You should see an update prompt on your '  , 'vtmin');
      $homeURL = VTMIN_ADMIN_URL.'plugins.php?plugin_status=all&paged=1&s'; 
      $message .=     '<a class="ab-item" href="'.esc_url($homeURL).'">' . __('Plugins Page', 'vtmin') . '</a>'; //v1.1.8.2 
      $message .=     __(' for a FREE Plugin automated update'  , 'vtmin') .'</strong>';
      $message .=  '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&bull;&nbsp;&nbsp;' . __('If no FREE Plugin update nag is visible, you can request Wordpress to check for an update: '  , 'vtmin');
      $homeURL = VTMIN_ADMIN_URL.'edit.php?post_type=vtmin-rule&page=vtmin_license_options_page&action=force_plugin_updates_check';
      $message .=  '<a href="'.esc_url($homeURL).'">' . __('Check for Plugin Updates', 'vtmin'). '</a>'; //v1.1.8.2 - bounces to license page, which then sets the transient and goes on to the plugins page.      

      $message .=  '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&bull;&nbsp;&nbsp;' . __('Be sure to  <em> re-Activate the PRO Plugin </em>, once the FREE plugin update has been completed. ', 'vtmin');
      $message .=  '</strong>';
      
      $message .=  "<span style='color:grey !important;'><br><br><em>&nbsp;&nbsp;&nbsp; (This message displays when the Pro version is installed, regardless of whether it's active)</em></span>" ;

      $admin_notices = '<div id="message" class="error fade" style="background-color: #FFEBE8 !important;"><p>' . $message . ' </p></div>';
      //echo $admin_notices; //v2.0.3
      $allowed_html = vtmin_get_allowed_html(); //v2.0.3
      echo wp_kses($admin_notices ,$allowed_html ); //v2.0.3
      return;    
  } 
        
  /* ************************************************
  **   v2.0.0 new function, run at admin init
  *************************************************** */ 
	public function vtmin_maybe_pro_plugin_installed() {
     
    // Check if get_plugins() function exists. This is required on the front end of the
    // site, since it is in a file that is normally only loaded in the admin.
    if ( ! function_exists( 'get_plugins' ) ) {
    	require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    
    $all_plugins = get_plugins();

    foreach ($all_plugins as $key => $data) { 
      if ($key == VTMIN_PRO_PLUGIN_FOLDER.'/'.VTMIN_PRO_PLUGIN_FILE) {    
        return true;      
      } 
    } 
    
    return false;  
 
  }
 
   //*************************
   //v2.0.0 licensing -  new function       //v2.0.0a
   //*************************   
   /*
   If plugin activated
    unregistered - Yellow box rego msg on all pages - mention that PRO will not work until registered - handles 1st time through
    suspended - fatal msg everywhere
    other stuff  - msg on plugins page and plugin pages - mention that PRO will not work until registered
   If plugin deactivated
    unregistered - none
    suspended - fatal msg everywhere
    other stuff  - none  
   */
   
	public function vtmin_maybe_pro_license_error() {
     //if PRO is ACTIVE or even INSTALLED, do messaging.
    //error_log( print_r(  'Begin vtmin_maybe_pro_license_error', true ) );
    
    global $vtmin_license_options;
    
    $pageURL = sanitize_url($_SERVER["REQUEST_URI"]); 
    switch( true ) { 
        case (strpos($pageURL,'delete-selected') !== false ):         
        case (strpos($pageURL,'vtmin_license_options_page') !== false ):         
        case (strpos($pageURL,'plugin-install') !== false ):         
        case (strpos($pageURL,'upload-plugin') !== false ):         
                //v2.0.3 annoying to have message on plugin install/upload page
                return;
             break;                   
        default:          
            
      
              //if deactivated, warn that PRO will NOT function!!
                //VTMIN_PRO_VERSION only exists if PRO version is installed and active
              if ( (defined('VTMIN_PRO_VERSION')) &&
                   ($vtmin_license_options['status'] == 'valid') &&
                   ($vtmin_license_options['state']  == 'deactivated') ) {
                $message = '<span style="color:black !important;">
                             &nbsp;&nbsp;&nbsp;<strong> ' . VTMIN_ITEM_NAME .   ' </strong> &nbsp;&nbsp; License is not registered</span>';
                $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . '** the PRO Plugin will not function until Registered** ' ; 
                $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . '* Please go the the ' ;  
                $homeURL = VTMIN_ADMIN_URL.'edit.php?post_type=vtmin-rule&page=vtmin_license_options_page';
                $message .=  '&nbsp; <a href="'.esc_url($homeURL).'">License Page</a> &nbsp;' ; //v1.1.8.2       
                $message .=  ' and REGISTER the PRO License. </strong>' ;  
                $admin_notices = '<div class="error fade is-dismissible" 
                  style="
                        line-height: 19px;
                        padding: 0px 15px 11px 15px;
                        font-size: 14px;
                        text-align: left;
                        margin: 25px 20px 15px 2px;
                        background-color: #fff;
                        border-left: 4px solid #ffba00;
                        -webkit-box-shadow: 0 1px 1px 0 rgba(0,0,0,.1);
                        box-shadow: 0 1px 1px 0 rgba(0,0,0,.1); " > <p>' . $message . ' </p></div>';  //send yellow box
                //echo $admin_notices; //v2.0.3
                $allowed_html = vtmin_get_allowed_html(); //v2.0.3
                echo wp_kses($admin_notices ,$allowed_html ); //v2.0.3 
                return;  
              }
             break; 
    }    
    
    if (( isset($vtmin_license_options['status']) ) &&            //v2.0.3
         ($vtmin_license_options['status'] == 'valid') ) {
        return;
    }  
        
    //$pageURL = $_SERVER["REQUEST_URI"];  //v2.0.3
    $pageURL = sanitize_url($_SERVER["REQUEST_URI"]); //v2.0.3

    //***************************************************************** //v1.1.8.2
    //License page messaging handled in license-options.php, so EXIT!
    //***************************************************************** //v1.1.8.2
    if (strpos($pageURL,'vtmin_license_options_page') !== false ) {    
      return;
    }
    
    $pro_plugin_installed = false;
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active
    if (defined('VTMIN_PRO_VERSION')) { 
      
      //PRO IS INSTALLED and ACTIVE, show these msgs on ALL PAGES       
      if ($vtmin_license_options['state'] == 'suspended-by-vendor') { 
        $this->vtmin_pro_suspended_msg();            
        return;   
      }    
      if ($vtmin_license_options['status'] != 'valid')  { //v1.1.8.2 
        $this->vtmin_pro_unregistered_msg();            
        return;
      }   
                   
      $pro_plugin_installed = true; //show other error msgs
    }
    
    
    if (!$pro_plugin_installed) {       
      $pro_plugin_installed = vtmin_check_pro_plugin_installed();
    }
     
    //if pro not in system, no further msgs
    if (!$pro_plugin_installed) {   
      return;
    }
    
    //IF PRO at least installed, show this on ALL pages (except license page)
    if ($vtmin_license_options['state'] == 'suspended-by-vendor') { 
      $this->vtmin_pro_suspended_msg(); 
      return;     
    } 
    
    //show other msgs for Plugins Page and vtmin pages 
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active
    if ( (defined('VTMIN_PRO_VERSION')) 
          &&
         ($vtmin_license_options['state'] == 'pending') ) {
      //ACTIVE PRO Plugin and we are on the plugins page or a vtmin page

        //OTHER MESSAGES, showing on vtmin Pages and PLUGINS.PHP
        $message = '<span style="color:black !important;">
                     &nbsp;&nbsp;&nbsp;<strong> ' . VTMIN_ITEM_NAME .   ' </strong> has NOT been successfully REGISTERED, and **will not function until registered**. </span><br><br>';
        $message .= '&nbsp;&nbsp;&nbsp; Licensing Error Message: <em>' . $vtmin_license_options['msg'] . '</em>';
        $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . '* Please go the the ' ;  
        $homeURL = VTMIN_ADMIN_URL.'edit.php?post_type=vtmin-rule&page=vtmin_license_options_page';
        $message .=  '&nbsp; <a href="'.esc_url($homeURL).'">License Page</a> &nbsp;' ;  //v1.1.8.2        
        $message .=  ' for more information. </strong>' ;  
        $admin_notices = '<div class="error fade is-dismissible" 
          style="
                line-height: 19px;
                padding: 0px 15px 11px 15px;
                font-size: 14px;
                text-align: left;
                margin: 25px 20px 15px 2px;
                background-color: #fff;
                border-left: 4px solid #ffba00;
                -webkit-box-shadow: 0 1px 1px 0 rgba(0,0,0,.1);
                box-shadow: 0 1px 1px 0 rgba(0,0,0,.1); " > <p>' . $message . ' </p></div>';  //send yellow box
        //echo $admin_notices; //v2.0.3
        $allowed_html = vtmin_get_allowed_html(); //v2.0.3
        echo wp_kses($admin_notices ,$allowed_html ); //v2.0.3       
        return;      
      // } //v1.1.8.2
    }        
      
    //show other msgs for Plugins Page and vtmin pages 
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active
    if ( (defined('VTMIN_PRO_VERSION')) 
          &&
       ( (strpos($pageURL,'plugins.php') !== false ) || 
         (strpos($pageURL,'vtmin')       !== false ) ) ) {
      //ACTIVE PRO Plugin and we are on the plugins page or a vtmin page

        //OTHER MESSAGES, showing on vtmin Pages and PLUGINS.PHP
        $message = '<span style="color:black !important;">
                     &nbsp;&nbsp;&nbsp;<strong> ' . VTMIN_ITEM_NAME .   ' </strong> has NOT been successfully REGISTERED, and **will not function until registered**. </span><br><br>';
        $message .= '&nbsp;&nbsp;&nbsp; Licensing Error Message: <em>' . $vtmin_license_options['msg'] . '</em>';
        $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . '* Please go the the ' ;  
        $homeURL = VTMIN_ADMIN_URL.'edit.php?post_type=vtmin-rule&page=vtmin_license_options_page';
        $message .=  '&nbsp; <a href="'.esc_url($homeURL).'">License Page</a> &nbsp;' ; //v1.1.8.2 
        $message .=  ' for more information. </strong>' ;  
        $admin_notices = '<div class="error fade is-dismissible" style="background-color: #FFEBE8 !important;"><p>' . $message . ' </p></div>';
        //echo $admin_notices; //v2.0.3
        $allowed_html = vtmin_get_allowed_html(); //v2.0.3
        echo wp_kses($admin_notices ,$allowed_html ); //v2.0.3
      // } //v1.1.8.2
    }        
    
  return;  
  }
  
  //********************************
  //v2.0.0 licensing - new function     //v2.0.0a
  //********************************
	public function vtmin_pro_unregistered_msg() { 
    //plugin version mismatch takes precedence over registration message.
    global $vtmin_license_options;
/* v1.1.8.2 removed
    if ( ($vtmin_license_options['pro_plugin_version_status'] == 'valid') ||
         ($vtmin_license_options['pro_plugin_version_status'] == null)) { //null = default
      $carry_on = true;
    } else { 
      return;
    }
*/
    
    
    $message  = '<h2>' .VTMIN_PRO_PLUGIN_NAME . '</h2>';
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active    
    $homeURL = VTMIN_ADMIN_URL.'edit.php?post_type=vtmin-rule&page=vtmin_license_options_page';
    if (VTMIN_PRO_VERSION == VTMIN_PRO_LAST_PRELICENSE_VERSION) {
      $message .=   '<strong>' . __(' - We have introduced Plugin Registration,' , 'vtmin')  ; 
      $message .=  '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . __('Please take a moment to ', 'vtmin')  ;
      $message .=  '<a href="'.esc_url($homeURL).'">register</a>' ; //v1.1.8.2 
      $message .=   __(' your plugin.', 'vtmin')  ;
      $message .=  '<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . __('You may use your original purchase <em>SessionID</em> as your registration key.', 'vtmin')  ;
      
      $message .=  '<h3 style="color:grey !important;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<em>' . __(' Your PRO plugin will not function until registered', 'vtmin')  . '</em>' . '</h3>' ;    
    } else {
     // $message .= '<span style="background-color: RGB(255, 255, 180) !important;"> ';
      $message .=   '<strong>' . __(' - Requires valid ' , 'vtmin')  ; //v1.1.8.2
      $message .=  '<a href="'.esc_url($homeURL).'">Registration</a>' ; //v1.1.8.2 
      $message .=  '<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<em>' . __(' and will not function until registered -', 'vtmin')  . '</em><br><br>' ; //. '</span>' ;        
    }
                             
    $message .=  '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a href="'.esc_url($homeURL).'">Register Pro License</a></strong> ' ; //v1.1.8.2 
             
     
     //yellow line box override      
    $admin_notices = '<div class="error fade is-dismissible" 
      style="
            line-height: 19px;
            padding: 0px 15px 11px 15px;
            font-size: 14px;
            text-align: left;
            margin: 25px 20px 15px 2px;
            background-color: #fff;
            border-left: 4px solid #ffba00;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0,0,0,.1);
            box-shadow: 0 1px 1px 0 rgba(0,0,0,.1); " > <p>' . $message . ' </p></div>';
    //echo $admin_notices; //v2.0.3
    $allowed_html = vtmin_get_allowed_html(); //v2.0.3
    echo wp_kses($admin_notices ,$allowed_html ); //v2.0.3  
    return;
  } 
 
        
  /* ************************************************
  **  //v2.0.0a licensing -  new function   
  *************************************************** */ 
	public function vtmin_maybe_update_version_num() { 
    global $vtmin_license_options, $vtmin_setup_options;

      //error_log( print_r(  'BEGIN vtmin_maybe_update_version_num ', true ) );
    
/*  CURRENTLY, this function has to run all the time, to pick up the new 
    //vtmin_new_version_in_progress ONLY created if plugin_updater has found one.
    //this function updates the current version ONLY after an UPDATED install is complete.
    if (get_option('vtmin_new_version_in_progress') !== false) {
           //error_log( print_r(  'vtmin_new_version OPTION = ' .get_option('vtmin_new_version'), true ) );  
       $carry_on = true;  
    } else {
      return;
    }
 */   
    
    if (defined('VTMIN_PRO_VERSION')) { 
      if( (isset($vtmin_setup_options['current_pro_version'])) &&
          ($vtmin_setup_options['current_pro_version'] == VTMIN_PRO_VERSION) ) {
         //error_log( print_r(  'vtmin_maybe_update_version_num, current_pro_version001 = ' .$vtmin_setup_options['current_pro_version'], true ) );
        $carry_on = true;
      } else {
        $vtmin_setup_options['current_pro_version'] = VTMIN_PRO_VERSION; 
        update_option( 'vtmin_setup_options',$vtmin_setup_options ); 
         //error_log( print_r(  'vtmin_maybe_update_version_num, current_pro_version002 = ' .$vtmin_setup_options['current_pro_version'], true ) );
   
        delete_option('vtmin_new_version_in_progress');    
      }
    } else {

      $pro_plugin_installed = vtmin_check_pro_plugin_installed();
      
      //verify if version number, from http://stackoverflow.com/questions/28903203/test-if-string-given-is-a-version-number
      if( version_compare( $pro_plugin_installed, '0.0.1', '>=' ) >= 0 ) {
        if ( (isset($vtmin_setup_options['current_pro_version'])) &&
            ($vtmin_setup_options['current_pro_version'] == $pro_plugin_installed) ) {
         //error_log( print_r(  'vtmin_maybe_update_version_num, current_pro_version003 = ' .$vtmin_setup_options['current_pro_version'], true ) );            
          $carry_on = true;
        } else {
          $vtmin_setup_options['current_pro_version'] = $pro_plugin_installed; 
         //error_log( print_r(  'vtmin_maybe_update_version_num, current_pro_version004 = ' .$vtmin_setup_options['current_pro_version'], true ) );           
          update_option( 'vtmin_setup_options',$vtmin_setup_options );
          delete_option('vtmin_new_version_in_progress');  
        }  
       }   
    }
 
           //error_log( print_r(  'vtmin_maybe_update_version_num, $vtmin_setup_options =', true ) );
              //error_log( var_export($vtmin_setup_options, true ) ); 
            //error_log( print_r(  '$pro_plugin_installed = ' .$pro_plugin_installed, true ) );   
    return;
  }  


          
  /* ************************************************
  **  //v2.0.0a licensing -  new function
  * //only runs if PRO version is installed and active    
  *************************************************** */ 
	public function vtmin_maybe_pro_deactivate_action() {
    global $vtmin_license_options;             

    if ($vtmin_license_options['state'] == 'suspended-by-vendor') {                                  
      //set up deactivate during admin_init - it's not available yet! done out of vtmin_maybe_pro_deactivate_action
      $vtmin_license_options['pro_deactivate'] = 'yes';
      update_option('vtmin_license_options', $vtmin_license_options); 
    }

    if ($vtmin_license_options['pro_deactivate'] != 'yes') {
      return;
    }
    
    
    vtmin_deactivate_pro_plugin();
    vtmin_increment_license_count(); 
    $vtmin_license_options['pro_deactivate'] = null;
    update_option('vtmin_license_options', $vtmin_license_options); 
                        
    if ( $vtmin_setup_options['debugging_mode_on'] == 'yes' ){   
           //error_log( print_r(  'PRO deactivated, VTMIN_PRO_DIRNAME not defined ', true ) );
    }
  
    
    return; 
  } 
 
  
  /* ************************************************
  ** //v2.0.0a licensing -  new function, run at admin init 
  * //only runs if PRO version is installed and active     
  *************************************************** */ 
	public function vtmin_license_count_check() {

    $vtmin_license_count = get_option( 'vtmin_license_count');
    if (!$vtmin_license_count) {
      return;
    }
    //if PRO **not active** but installed, and VERSION ERROR, still do the messaging
    //can only do this AFTER or as part of admin_init
    global $vtmin_license_options;
    if (!$vtmin_license_options) {
      $vtmin_license_options = get_option('vtmin_license_options');
    }
    
    if ($vtmin_license_options['state'] == 'suspended-by-vendor') {
      return;    
    }
      //VTMIN_PRO_VERSION only exists if PRO version is installed and active
    if (!defined('VTMIN_PRO_VERSION')) {
      return;
    }
   
    //if fatal counts exceed limit, never allow pro plugin to be activated
    if ($vtmin_license_count >= 10 ) { //v1.1.6.7 upgraded from 5 to 10!
      vtmin_deactivate_pro_plugin();
      $vtmin_license_options['state'] = 'suspended-by-vendor';
      $vtmin_license_options['status'] = 'invalid';
      $vtmin_license_options['diagnostic_msg'] = 'suspended until contact with vendor';
      update_option('vtmin_license_options', $vtmin_license_options);
                    
    }
    
    return;    
  } 
   

  /* ************************************************
  **   Admin - **Uninstall** Hook and cleanup
  *************************************************** */ 
  function vtmin_uninstall_hook() {
      
      if ( !defined( 'WP_UNINSTALL_PLUGIN' ) ) {
      	return;
        //exit ();
      }
  
      delete_option('vtmin_setup_options');
      $vtmin_nuke = new VTMIN_Rule_delete;            
      $vtmin_nuke->vtmin_nuke_all_rules();
      $vtmin_nuke->vtmin_nuke_all_rule_cats();
      wp_clear_scheduled_hook( 'vtmin_twice_daily_scheduled_events' ); //v2.0.0a
  }
  
} //end class
$vtmin_controller = new VTMIN_Controller;

  //***************************************************************************************
  //fix 2-13-2013  -  problems with activation hook and class, solved herewith...
  //   FROM http://website-in-a-weekend.net/tag/register_activation_hook/
  //***************************************************************************************
  $pageURL = sanitize_url($_SERVER["REQUEST_URI"]); //v2.0.0
  if (strpos($pageURL,'wp-admin') !== false)  {       //v2.0.0        
  //if (is_admin()){  //v2.0.0 
        register_activation_hook(__FILE__, array($vtmin_controller, 'vtmin_activation_hook'));
        register_activation_hook(__FILE__, array($vtmin_controller, 'vtmin_uninstall_hook'));                                   
  }
