<?php
if ( !defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'grfwpExportCSV' ) ) {
/**
 * Handle CSV exports
 *
 * PHP's fputcsv() function is used to stream a
 * CSV file to the browser.
 *
 * @since 2.1.0
 */
class grfwpExportCSV {

	/**
	 * Insantiate the CSV export
	 *
	 * @since 2.1.0
	 */
	public function __construct() {

		$this->reviews = get_posts( array( 'post_type' => GRFWP_REVIEW_POST_TYPE, 'numberposts' => -1 ) );
	}

	/**
	 * Compile an array for the CSV file
	 *
	 * @since 2.1.0
	 */
	public function export() {
		global $grfwp_controller;

		$date_format = $grfwp_controller->settings->get_setting( 'grfwp-date-format' );

		// Compile reviews array headers
		$arr = apply_filters( 'grfwp_export_csv_review_headers', array(
			array( 
				'ID' => __( 'Review ID', 'good-reviews-wp'),
				'date' => __( 'Date', 'good-reviews-wp' ),
				'reviewer' => __( 'Reviewer', 'good-reviews-wp' ),
				'review' => __( 'Review', 'good-reviews-wp' ),
				'rating' => __( 'Rating', 'good-reviews-wp' ),
			)
		) );

		// Compile reviews array
		foreach( $this->reviews as $review ) {
			$post_metadata = get_post_meta( $review->ID, 'grfwp', true );

			$arr[] = apply_filters( 'grfwp_export_csv_review', array(
				'ID' => $review->ID,
				'date' => date_i18n( $date_format, strtotime( $review->post_date ) ),
				'reviewer' => $review->post_title,
				'review' => $review->post_content,
				'rating' => isset( $post_metadata['rating'] ) ? $post_metadata['rating'] : '',
			), $review );
		}

		$this->export = apply_filters( 'grfwp_export_csv_reviews', $arr );

		return $this->export;
	}

	/**
	 * Deliver the CSV file to the browser
	 *
	 * @since 0.1
	 */
	public function deliver() {

		// Generate the export if it's not been done yet
		if ( empty( $this->export ) ) {
			$this->export();
		}

		$filename = apply_filters( 'grfwp_export_csv_filename', 'Reviews.csv' );
		$delimiter = apply_filters( 'grfwp_export_csv_delimiter', ',' );

		header( 'Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0' );
		header( 'Content-Description: File Transfer' );
		header( 'Content-type: text/csv' );
		header( 'Content-Disposition: attachment; filename=' . $filename );
		header( 'Expires: 0' );
		header( 'Pragma: no-cache' );

		$output = @fopen( 'php://output', 'w' );

		foreach( $this->export as $review ) {
			fputcsv( $output, $review, $delimiter );
		}

		fclose( $output );

		exit();
	}
}
} // endif
