<?php
if (!defined('ABSPATH'))
{
    exit;
}
class Food_Online_Shortcode_Address
{
    protected static $_instance = null;
    protected $is_active = false;
    public static $shortcode_order;
    public static $categories_raw;
    public function __construct()
    {
        add_shortcode('foodonline_address_validator', array(
            $this,
            'address_validator'
        ));
        add_shortcode('foodonline_postcode_validator', array(
            $this,
            'postcode_validator'
        ));
        add_shortcode('foodonline_delivery', array(
            $this,
            'top_bar'
        ));
        add_shortcode('foodonline_minicart', array(
            $this,
            'minicart'
        ));
        add_shortcode('foodonline_menu', array(
            $this,
            'menu'
        ));
        add_shortcode('foodonline_side_category_menu', array(
            $this,
            'side_cat_menu'
        ));
        add_shortcode('foodonline_top_category_menu', array(
            $this,
            'top_cat_menu'
        ));
        add_shortcode('foodonline_timepicker', array(
            $this,
            'timepicker'
        ));
        add_shortcode('foodonline_topbar', array(
            $this,
            'top_bar'
        ));
    }
    public static function instance()
    {
        if (is_null(self::$_instance))
        {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
    public function timepicker($atts)
    {
        if (is_admin())
        {
            return;
        }
        if (is_wc_endpoint_url('order-pay') || is_wc_endpoint_url('order-received') || !isset(WC()->cart) || (isset(WC()
            ->cart) && WC()
            ->cart
            ->needs_shipping() === false))
        {
            return;
        }
        if (Food_Online_Timepick::do_timepicker())
        {
            wp_enqueue_style('fdoe-prem-timepicker-style', FDOE_PREM_PLUGINDIRURL . 'prem/assets/jonthornton-jquery-timepicker/jquery.timepicker.min.css', array() , FOOD_ONLINE_PREM_VERSION);
            wp_enqueue_script('fdoe-prem-timepicker-script', FDOE_PREM_PLUGINDIRURL . 'prem/assets/jonthornton-jquery-timepicker/jquery.timepicker.min.js', array(
                'jquery'
            ) , FOOD_ONLINE_PREM_VERSION, true);
            wp_enqueue_script('fdoe-prem-checkout-script', FDOE_PREM_PLUGINDIRURL . 'prem/assets/js/fdoe-timepicker.min.js', array(
                'jquery',
                'fdoe-prem-timepicker-script'
            ) , FOOD_ONLINE_PREM_VERSION, true);
            do_action('fdoe_before_get_picktime_args');
            $args = Food_Online_Timepick::get_picktime_args(Food_Online_Timepick::do_timepicker('do_pickup_time') , Food_Online_Timepick::do_timepicker('do_delivery_time'));
            wp_localize_script('fdoe-prem-checkout-script', 'fdoecheckout', $args);
        }
        if (Food_Online_Timepick::do_timepicker())
        {
            $title = Food_Online_Timepick::do_timepicker('do_pickup_time') ? __('Select Pickup Time?', 'fdoep') : __('Select Delivery Time?', 'fdoep');
            $is_before_details = get_option('fdoe_time_picker_placement', 'before_details') == 'before_details';
            ob_start();
            if ($is_before_details)
            {
                echo '<div id="fdoe-time_checkout_field" class="shop_table">';
            }
            echo '<h3 class="fdoe-checkoutfield-title">' . $title . '</h3>';
            $datetime_today = current_datetime();
            $today = $datetime_today->format('Y-m-d');
            // Make date array
            $date_array = array(
                $today => __('Today', 'fdoep') ,
            );
            $max = get_option('fdoe_timepick_days_qty', 2) <= 1 ? 0 : get_option('fdoe_timepick_days_qty', 2) - 1;
            for ($i = 0;$i < $max;$i++)
            {
                $temp_day = $datetime_today->modify('+' . ($i + 1) . ' days');
                $date_format = get_option('fdoe_timepicker_dateformat', 'default') == 'default' ? get_option('date_format') : get_option('fdoe_timepicker_dateformat_custom', get_option('date_format'));
                $wp_date = wp_date($date_format, $temp_day->getTimestamp());
                if ($wp_date == false)
                {
                    continue;
                }
                $date_array[$temp_day->format('Y-m-d') ] = $wp_date;
            }
            if ($is_before_details)
            {
                echo '<div  class="form-row form-row-first validate-required">';
            }
            woocommerce_form_field('fdoe-date', array(
                'type' => 'select',
                'options' => $date_array,
                'class' => array(
                    ''
                ) ,
                'required' => true,
                'default' => $today,
                'label' => __('Date?', 'fdoep') ,
            ));
            if ($is_before_details)
            {
                echo '</div>';
                echo '<div  class="form-row form-row-last validate-required">';
            }
            woocommerce_form_field('fdoe-time', array(
                'type' => 'text',
                'class' => array(
                    'time',
                    'ui-timepicker-input'
                ) ,
                'required' => true,
                'label' => __('Time?', 'fdoep') ,
                'placeholder' => __('Select time...', 'fdoep') ,
            ));
            if ($is_before_details)
            {
                echo '</div></div>';
            }
        }
        return ob_get_clean();
    }
    public function postcode_validator($atts)
    {
        if (is_admin())
        {
            return;
        }
        $options = shortcode_atts(array(
            'show' => null,
            'placement' => null
        ) , $atts);
        $show = empty($options['show']) ? '' : sanitize_text_field($options['show']);
        $placement = empty($options['placement']) ? 'shortcode' : sanitize_text_field($options['placement']);
        return fdoe_get_zip_form($show, $placement);
    }
    public function address_validator($atts)
    {
        if (is_admin())
        {
            return;
        }
        $options = shortcode_atts(array(
            'show' => null,
            'placement' => null
        ) , $atts);
        $show = empty($options['show']) ? '' : sanitize_text_field($options['show']);
        $placement = empty(sanitize_text_field($options['placement'])) ? 'shortcode' : sanitize_text_field($options['placement']);
        ob_start();
        echo fdoe_get_address_form($show, $placement);
        echo fdoe_get_address_form_fractions();
        return ob_get_clean();
    }
    public function top_cat_menu()
    {
        if (is_admin())
        {
            return;
        }
        ob_start();
        echo fdoe_get_top_menu_pre();
        echo '<div id="fdoe_products_id" class="fdoe_menu_header fdoe-top-sticky fdoe-element">

								<ul class="nav nav-tabs fdoe-menu-2  " id="menu_headings" >

								</ul></div>';
        return ob_get_clean();
    }
    public function side_cat_menu()
    {
        if (is_admin())
        {
            return;
        }
        ob_start();
        echo '	<div class="fdoe-element" id="fdoe-left-left-container"><div   id="menu_headings_2" ><h4 class="Category_heading">';
        echo __('Menu', 'fdoep');
        echo '</h4></div></div>';
        return ob_get_clean();
    }
    public function top_bar($atts)
    {
        if (is_admin() || (is_user_logged_in() && !isset(WC()->session)))
        {
            return;
        }
        $this->is_active = true;
        $options = shortcode_atts(array(
            'delivery_mode' => null,
            'selection_mandatory' => null,
            'default_delivery_mode' => null,
            'validation' => null
        ) , $atts);
        $delivery_mode = empty($options['delivery_mode']) ? 'no' : sanitize_text_field($options['delivery_mode']);
        $default_delivery_mode = empty($options['default_delivery_mode']) ? 'delivery' : sanitize_text_field($options['default_delivery_mode']);
        $selection_mandatory = empty($options['selection_mandatory']) ? 'no' : sanitize_text_field($options['selection_mandatory']);
        $validation = empty($options['validation']) ? 'address' : sanitize_text_field($options['validation']);
        $is_start_page = get_option('fdoe_start_page', 'no') == 'yes' ? 'fdoe-is-start-page' : '';
        $locs = array(
            'selector_is_3way' => $selection_mandatory == 'no' ? 0 : 1,
            'delivery_mode' => $delivery_mode,
            'selection_state' => $selection_mandatory != 'no' ? 1 : 0,
            'fdoe_skip_address_validation' => $validation,
            'top_bar' => 1
        );
        wp_localize_script('fdoe-prem-script', 'fdoe_short_switch', $locs);
        ob_start();
        echo '<div class="fdoe-element fdoe-shortcode-wrapper ' . $is_start_page . '">';
        echo '<div id="fdoe-top-element" class="fdoe-top-element">';
        echo fdoe_output_top_bar(false, $delivery_mode, $default_delivery_mode, $selection_mandatory, $validation);
        echo '</div></div>';
        return ob_get_clean();
    }
    public function minicart($atts)
    {
        if (is_admin())
        {
            return;
        }
        $this->is_active = true;
        ob_start();
          echo '<div class="fdoe-shortcode-wrapper">';
         if (get_option('fdoe_loading_overlay', 'no') == 'yes') {
                echo fdoe_output_rightbar_pre();
             }
             echo '<div class="fdoe-shortcode-element">';
        echo fdoe_output_minicart();
      echo '</div></div>';
       
     return ob_get_clean();
    }
    public function menu($atts)
    {
        if (is_admin())
        {
            return;
        }
        $this->is_active = true;
        $options = shortcode_atts(array(
            'categories' => null,
            'tags' => null,
            'orderby' => null,
            'order' => null,
            'ids' => null,
        ) , $atts);
         $pp = 999;
        $l = 'limit=' . $pp;
        $args = array(
            'status' => 'publish',
            'limit' => $pp,
        );
        $args += empty($options['ids']) ? [] : ['include' => explode(",", $options['ids']) ];
        $args += empty($options['order']) ? ['order' => 'ASC'] : ['order' => $options['order']];
        $args += empty($options['tags']) ? [] : ['tag' => explode(",", $options['ids']) ];
        if (wc_clean($options['orderby']) == 'price')
        {
            $args += ['orderby' => 'meta_value_num'];
            $args += ['meta_key' => '_price'];
        }
        else
        {
            $args += empty($options['orderby']) ? ['orderby' => 'menu_order'] : ['orderby' => $options['orderby']];
        }
        $cats = empty($options['categories']) ? false : true;
        $cats_array = [];
        $cats_array_slug = [];
        if (class_exists('Food_Online_Del') && get_option('fdoe_menu_by_mode', 'no') == 'yes') {
            $cats_array = Food_Online_Del::get_cats_by_mode();
            if (!empty($cats_array)) {
                self::set_category_objects($cats_array);
                $cats2 = self::get_category_objects();
                $cats_array_slug = array_column($cats2, 'slug');
                $args += empty($cats_array) ? [] : ['category' => $cats_array_slug];
            }
            else {
                self::set_category_objects();
                $args += ['limit' => 1];
            }
        }
        else if ($cats) {
            $pieces = explode(",", $options['categories']);
            foreach ($pieces as $piece) {
                $category = get_term_by('name', $piece, 'product_cat');
                if ($category !== false) {
                    $cat_id = $category->term_id;
                    $cats_array[] = $cat_id;
                    
                }
                else {
                    $piece = str_replace(' ', '', $piece);
                    $category = get_term_by('slug', $piece, 'product_cat');
                    if ($category !== false) {
                    $cat_id = $category->term_id;
                    $cats_array[] = $cat_id;
                      }
                }
            }
           
        self::set_category_objects($cats_array);
           
        }
        else {
            self::set_category_objects();
        }
         $cats_order = self::get_category_objects();
        $locs = array(
            'cats' => $cats_order ,
        );
        wp_localize_script('fdoe-order', 'fdoe_short', $locs);
        $products = wc_get_products($args);
       
        
        ob_start();
        $fdoe_color_back = get_option('fdoe_color_back', 'inherit');
        $menu_color_back = $fdoe_color_back == '' ? 'inherit' : $fdoe_color_back;
        $fdoe_border_color = get_option('fdoe_border_color', '#ddd');
        $menu_border_color = $fdoe_border_color == '' ? '#ddd' : $fdoe_border_color;
?>



<style>





#the_menu, #menu_headings, div.fdoe-item:hover  {background-color: <?php echo $menu_color_back; ?>;

}

#the_menu .fdoe-item{

	border-right-color: <?php echo $menu_border_color; ?>;

	border-bottom-color: <?php echo $menu_border_color; ?>;



}



#the_main_container  h5{

    margin-top: 1rem;

	margin-bottom: 1rem;

	margin-left: .2rem;

	margin-right: .2rem;

}





</style>





<?php
       
			echo '<div class="container-fluid fdoe_main_container fdoe-shortcode-extern" id="the_main_container">
				<div class=" fdoe-less-gut" id="fdoe-left-container">';
                 if (get_option('fdoe_loading_overlay', 'no') == 'yes') {
            echo fdoe_get_menu_pre();
        }
                
			echo '<div class="fdoe">
						<div class="fdoe-products flex-container-column" id="the_menu"> </div>
					</div>
				</div>
			</div>';
        $content = ob_get_clean();
         $the_products = array();
       do_action('fdoe_before_foodonline2_loop');
        $cats_array_slug = [];
        foreach($cats_order as $cat){
             $cats_array_slug[] = $cat->slug;
         
        }
          $args['category'] = $cats_array_slug;
        
            $products_ = wc_get_products($args);
              foreach ($products_ as $i) {
            $the_products[] = Food_Online_Product2::the_product($i);
        }
?>

<script>



	// Collect the products into a javascript array



	var Food_Online_Items = <?php echo json_encode(array(
            'products' => $the_products,
        ),JSON_HEX_QUOT | JSON_HEX_TAG) ?>;


</script>


<?php
        return ($content);
    }
    public static function save_shortcode_order($cats_array)
    {
        if (!isset(self::$shortcode_order))
        {
            self::$shortcode_order = $cats_array;
        }
    }
    public static function get_shortcode_order()
    {
        return self::$shortcode_order;
    }
    public static function set_category_objects($cats_array=array())
    {
        if (!isset(self::$categories_raw))
        {
            $taxonomy = 'product_cat';
            $orderby = 'include'; //'name';
            $show_count = 0; // 1 for yes, 0 for no
            $pad_counts = 0; // 1 for yes, 0 for no
            $hierarchical = 1; // 1 for yes, 0 for no
            $title = '';
            $empty = 0;
            $fields = 'all';
            $includes = $cats_array;
            $args = array(
                'taxonomy' => $taxonomy,
                
                'show_count' => $show_count,
                'pad_counts' => $pad_counts,
                'hierarchical' => $hierarchical,
                'title_li' => $title,
                'hide_empty' => $empty,
                'fields' => $fields,
               
            );
            if(empty( $cats_array )){
               $args['menu_order'] = 'asc';
            }else{
                $args['orderby'] = $orderby;
                 $args['include'] = $includes;
            }
            self::$categories_raw = get_categories($args);
            $do_image = ( get_option('fdoe_cat_image', 'no') == 'yes') ? true : false;
            $i = 0;
            foreach (self::$categories_raw as $fdoe_cat)
            {
                 $fdoe_cat->sortIndex = $i;
                $i++;
                $fdoe_cat->id = $fdoe_cat->cat_ID;
                $term_children = get_term_children(filter_var($fdoe_cat->term_id, FILTER_VALIDATE_INT) , filter_var('product_cat', FILTER_SANITIZE_STRING));
                $parent_count = 0;
                $fdoe_cat->image = false;
                $has_sub = true;
                if (empty($term_children) || is_wp_error($term_children))
                {
                    $has_sub = false;
                }
                else
                {
                    foreach ($term_children as $child_cat)
                    {
                        $child = get_term($child_cat, 'product_cat');
                        $parent_count = $parent_count + $child->count;
                    }
                }
                $fdoe_cat->category_count_not_children = $fdoe_cat->category_count - $parent_count;
                $fdoe_cat->has_sub = $has_sub;
                if ($do_image)
                {
                    $thumbnail_id = get_term_meta($fdoe_cat->term_id, 'thumbnail_id', true);
                    $image = wp_get_attachment_url($thumbnail_id);
                    $fdoe_cat->image = $image;
                }
            }
        }
        return;
    }
    // Return product categories
    public static function get_category_objects()
    {
        return self::$categories_raw;
    }
}

