<?php
  /**
  * @wordpress-plugin
  * Plugin Name: EZRentOut Online Webstore
  * Author URI: https://www.ezrentout.com
  * Description: This plugin enables you to allow your customers to add items to cart, view availability calendar, and create web orders right from your online store. This and more can be done by connecting your Wordpress site to the EZRentOut Online WebStore. Bookings are seamlessly created in the EZRentOut rental app.
  * Author: EZRentOut
  * Version: 1.0
  * Copyright: 2019 EZRentOut
  */

if ( ! defined( 'WPINC' ) ) {
  die;
}

function ezr_include_javascripts() {
  $store_url = get_option( 'ezr_company_url' );
  wp_enqueue_script('ezrentout_cart', $store_url.'/javascripts/webstore_cart_widget.js', array(), false, true);
  wp_enqueue_script('ezrentout_details', $store_url.'/javascripts/webstore_show_details_widget.js', array(), false, true);
}

if( !function_exists("update_ezr_company_url") ) {
  function update_ezr_company_url() {
    register_setting( 'ezr-company-url-settings', 'ezr_company_url' );
  }
}

function ezr_admin_notice(){
  global $pagenow;
  $store_url = get_option( 'ezr_company_url' );
  if ( $pagenow == 'plugins.php' && empty($store_url) ) {
       echo '<div class="notice notice-error is-dismissible">
       <h2>EZRentalStore Setup Required</h2>
           <p>To continue, you first need to set up your <b>EZRentOut Online Webstore</b>. To do that, follow the link to the <a href="options-general.php?page=EZRentOut">Plugin Settings</a> page.</p>
       </div>';
  }
}

function ezr_admin_stylesheet($hook) {
  if($hook != 'settings_page_EZRentOut') {
    return;
  }
  wp_enqueue_style( 'ezr_widget_admin', plugins_url('stylesheets/ezr_widget_admin.css', __FILE__) );
}

function ezr_admin_functionality() {
  include('ezr_admin/ezr_admin_for_widget.php');
}

function ezr_admin_actions_for_widget() {
  add_options_page("EZRentOut", "EZRentOut", 'administrator', "EZRentOut", "ezr_admin_functionality");
}

function ezr_link_for_settings_page($settings_link) {
    $ezr_settings_location = '<a href="options-general.php?page=EZRentOut">' . __( 'Settings' ) . '</a>';
    array_unshift( $settings_link, $ezr_settings_location );
    return $settings_link;
}

function ezr_include_div_tag() { 
  $store_url = get_option( 'ezr_company_url' );
  ?>
    <div id='ezr-store-url' style='display:none;' data-store-url="<?php echo $store_url; ?>"></div>
  <?php

}

$ezr_plugin = plugin_basename( __FILE__ );
add_filter("plugin_action_links_$ezr_plugin", 'ezr_link_for_settings_page' );
add_action('admin_notices', 'ezr_admin_notice');
add_action('admin_menu', 'ezr_admin_actions_for_widget');
add_action('admin_enqueue_scripts', 'ezr_admin_stylesheet');
add_action( 'admin_init', 'update_ezr_company_url' );
add_action('wp_footer', 'ezr_include_div_tag');
add_action('wp_enqueue_scripts', 'ezr_include_javascripts');

?>