(function( $ ) {
	'use strict';
    window.moo_RestUrl = moo_params.moo_RestUrl;
    swal.setDefaults({ customClass: 'moo-custom-dialog-class' });
    jQuery( document ).ready(function($) {
        jQuery('#moo_OnlineStoreContainer').removeClass('moo_loading');
        if(document.getElementById("moo_OnlineStoreContainer") !== null && document.getElementById("moo-checkout")  === null && document.getElementById("moo-my-account")  === null) {
           if(moo_params.custom_sa_title !== "") {
               swal({
                   title:moo_params.custom_sa_title,
                   html:moo_params.custom_sa_content
               });
           }
        } else {
            if(document.getElementById("moo-checkout") !== null){
                if(moo_params.custom_sa_title !== "" && moo_params.custom_sa_onCheckoutPage === "on") {
                    swal({
                        title:moo_params.custom_sa_title,
                        html:moo_params.custom_sa_content
                    });
                }
            }
        }
    });

    setTimeout(function () {
        jQuery(".Moo_Copyright").show();
    }, 3000);

    const queryVars = getUrlVars();
    if(queryVars.soocoupon){
        localStorage.setItem("soo-coupon",queryVars.soocoupon);
    }

    if (typeof mooObjectL10n === "undefined") {
        console.log("We can't get the localized messages, English is used by default");
        window.mooObjectL10n = mooGetDefaultStrings();
    }


})(jQuery);

function mooformatPrice (p) {
    return p.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,")
}
function mooformatCentPrice (p) {
    p = p/100;
    return p.toFixed(2).toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,")
}


function moo_btn_addToCartFIWM(event,item_uuid,qty) {

    if (event) {
        event.preventDefault();
    }

    //Change button content to loading
    var target = event.target;
    jQuery(target).text('Loading options...');

    jQuery.get(moo_RestUrl+"moo-clover/v1/items/"+item_uuid, function (data) {
        //Change button text
        jQuery(target).text("ADD TO CART");

        if(data != null) {
                mooBuildModifiersPanel(data.modifier_groups,item_uuid,qty);
        } else {
            //Change butn text
            jQuery(target).text("ADD TO CART");
            swal({ title: "Error", text: 'We cannot Load the options for this item, please refresh the page or contact us',   type: "error",   confirmButtonText: "ok" });
        }
    }).fail(function (data) {
        //Change butn text
        jQuery(target).text("ADD TO CART");
        swal({ title: "Error", text: 'We cannot Load the options for this item, please refresh the page or contact us',   type: "error",   confirmButtonText: "ok" });
    });
}
function moo_btn_addToCart(event,item_uuid,qty)
{
    if (event) {
        event.preventDefault();
    }

    var body = {
        item_uuid:item_uuid,
        item_qty:qty,
        item_modifiers:{}
    };
    swal({
        html:
        '<div class="moo-msgPopup">Adding the item to your cart</div>' +
        '<img src="'+ moo_params['plugin_img']+'/loading.gif" class="moo-imgPopup"/>',
        showConfirmButton: false
    });

    /* Add to cart the item */
    jQuery.post(moo_RestUrl+"moo-clover/v1/cart", body,function (data) {
        if(data != null) {
            swal({
                title:"Item added",
                showCancelButton: true,
                cancelButtonText: 'Close',
                confirmButtonText: 'Cart page',
                type:"success"
            }).then(function (data) {
                if(data.value){
                    window.location.replace(moo_params.cartPage)
                }
            });
        } else {
            swal({
                title:"Item not added, try again",
                type:"error"
            });
        }
    }).fail(function ( data ) {
        swal({
            title:"Item not added, try again",
            text:"Check your internet connection or contact us",
            type:"error"
        });
    }).done(function ( data ) {
       // console.log(data);
    });
}

function moo_openQty_Window(event,item_uuid,callback)
{
    event.preventDefault();
    var inputOptions = new Promise(function (resolve) {
        resolve({
        "1":"1","2":"2","3":"3","4":"4","5":"5","6":"6","7":"7","8":"8","9":"9","10":"10","custom":"Custom Quantity"
        });
    });

    swal({
        title: 'Select the quantity',
        showLoaderOnConfirm: true,
        confirmButtonText: "Add",
        input: 'select',
        inputClass: 'moo-form-control',
        inputOptions: inputOptions,
        showCancelButton: true,
        preConfirm: function (value) {
            return new Promise(function (resolve, reject) {
                if(value=="custom") {
                    moo_OpenCustomQtyWindow(event,item_uuid,callback);
                } else {
                    callback(event,item_uuid,value);
                    swal.close();
                }

            });
        }
    }).then(function () {},function (dismiss) {});
}

function moo_OpenCustomQtyWindow(event,item_id,callback)
{
    swal({
        title: 'Enter the quantity',
        input: 'text',
        showCancelButton: true,
        showLoaderOnConfirm: true,
        inputValidator: function (value) {
            return new Promise(function (resolve, reject) {
                if (value != "" && parseInt(value)>0) {
                    callback(event,item_id,parseInt(value));
                    swal.close();
                } else {
                    reject('You need to write a number')
                }
            })
        }
    }).then(function () {},function () {})
}
function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
        vars[key] = value;
    });
    return vars;
}

function mooGetDefaultStrings() {
    return {"loading":"Loading, please wait ...","loadingOptions":"Loading Options","loadingCart":"Loading Your cart","chooseACategory":"Choose a Category","addToCart":"Add to cart","chooseOptionsAndQty":"Choose Options & Qty","chooseOptions":"Choose Options","outOfStock":"Out Of Stock","notAvailableYet":"Not Available Yet","viewCart":"View Cart","cartEmpty":"Your cart is empty","close":"Close","ok":"Ok","checkout":"Checkout","item":"Item","qty":"Qty","subtotal":"Sub-Total","tax":"Tax","total":"Total","edit":"Edit","addedToCart":"Added to cart","notAddedToCart":"Item not added, try again","cancel":"Cancel","quantityCanBeUpdated":"Quantity can be updated during checkout","addingTheItems":"Adding the items to your cart","showMore":"Show More","items":"Items","noCategory":"There is no category available right now please try again later","noItemsInCategory":"There is no items available right now in this category please try again later","customQuantity":"Custom Quantity","selectTheQuantity":"Select the quantity","enterTheQuantity":"Enter the quantity","writeNumber":"You need to write a number","checkInternetConnection":"Check your internet connection or contact us","cannotLoadItemOptions":"We cannot Load the options for this item, please refresh the page or contact us","cannotLoadCart":"Error in loading your cart, please refresh the page","confirmItemDeletion":"Are you sure you want to delete this item","yesDelete":"Yes, delete it!","noThanks":"No Thanks","noCancel":"No Cancel","deleted":"Deleted!","canceled":"Canceled!","cannotDeleteItem":"Item not deleted, try again","tryAgain":"Try again","add":"Add","added":"Added","notAdded":"Not Added","update":"Update","updated":"Updated","notUpdated":"Not Updated","addSpecialInstructions":"Add Special Instructions","updateSpecialInstructions":"Update Your Special Instructions","specialInstructionsNotAdded":"Special instructions not submitted try again","textTooLongMax250":"Text too long, You cannot add more than 250 chars","enterYourName":"Please enter your name","enterYourPassword":"Please enter your password","enterYourEmail":"Please enter a valid email","enterYourEmailReason":"We need a valid email to contact you and send to you the receipt","enterYourPhone":"Please enter your phone","enterYourPhoneReason":"We need your phone to contact you if we have any question about your order","chooseOrderingMethod":"Please choose the ordering method","chooseOrderingMethodReason":"How you want your order to be served ?","YouDidNotMeetMinimum":"You did not meet the minimum purchase requirement","orderingMethodSubtotalGreaterThan":"this ordering method requires a subtotal greater than $","orderingMethodSubtotalLessThan":"this ordering method requires a subtotal less than $","continueShopping":"Continue shopping","updateCart":"Update Cart","reachedMaximumPurchaseAmount":"You reached the maximum purchase amount","verifyYourAddress":"Please verify your address","addressNotFound":"We can't found this address on the map, please choose an other address","addDeliveryAddress":"Please add the delivery address","addDeliveryAddressReason":"You have chosen a delivery method, we need your address","chooseTime":"Please choose a time","choosePaymentMethod":"Please choose your payment method","verifyYourPhone":"Please verify your phone","verifyYourPhoneReason":"When you choose the cash payment you must verify your phone","verifyYourCreditCard":"Please verify your card information","SpecialInstructionsRequired":"Special instructions are required","minimumForDeliveryZone":"The minimum order total for this selected zone is $","spend":"Spend $","toGetFreeDelivery":"to get free delivery","deliveryZoneNotSupported":"Sorry, zone not supported. We do not deliver to this address at this time","deliveryAmount":"Delivery amount","deliveryTo":"Delivery to","editAddress":"Edit address","addEditAddress":"Add/Edit address","CardNumberRequired":"Card Number is required","CardDateRequired":"Card Date is required","CardCVVRequired":"Card CVV is required","CardStreetAddressRequired":"Street Address is required","CardZipRequired":"Zip Code is required","receivedDiscountUSD":"Success! You have received a discount of $","receivedDiscountPercent":"Success! You have received a discount of","thereIsACoupon":"There is a coupon that can be applied to this order","verifyConnection":"Verify your connection and try again","error":"Error","payUponDelivery":"Pay upon Delivery","payAtlocation":"Pay at location","sendingVerificationCode":"Sending the verification code please wait ..","anErrorOccurred":"An error has occurred please try again or contact us","codeInvalid":"Code invalid","codeInvalidDetails":"this code is invalid please try again","phoneVerified":"Phone verified","phoneVerifiedDetails":"Please have your payment ready when picking up from the store and don't forget to finalize your order below","thanksForOrder":"Thank you for your order","orderBeingPrepared":"Your order is being prepared","seeReceipt":"You can see your receipt","here":"here","ourAddress":"Our Address","cannotSendEntireOrder":"We weren't able to send the entire order to the store, please try again or contact us","loadingAddresses":"Loading your addresses","useAddress":"USE THIS ADDRESS","sessionExpired":"Your session is expired","login":"Log In","register":"Register","reset":"Reset","invalidEmailOrPassword":"Invalid Email or Password","invalidEmail":"Invalid Email","useForgetPassword":"Please click on forgot password or Please register as new user.","facebookEmailNotFound":"You don't have an email on your Facebook account","cannotResetPassword":"Could not reset your password","resetPasswordEmailSent":"If the e-mail you specified exists in our system, then you will receive an e-mail shortly to reset your password.","enterYourAddress":"Please enter your address","enterYourCity":"Please enter your city","addressMissing":"Address missing","cityMissing":"City missing","cannotLocateAddress":"We weren't able to locate this address,try again","confirmAddressOnMap":"Please confirm your address on the map","confirmAddressOnMapDetails":"By confirming  your address on the map you will help the driver to deliver your order faster, and you will help us to calculate your delivery fee better","confirm":"Confirm","confirmAndAddAddress":"Confirm and add address","addressNotAdded":"Address not added to your account","AreYouSure":"Are you sure?","cannotRecoverAddress":"You will not be able to recover this address","enterCouponCode":"Please enter your coupon code","checkingCouponCode":"Checking your coupon...","couponApplied":"Coupon applied","removingCoupon":"Removing your coupon....","success":"Success","optionRequired":" (required) ","mustChoose":"Must choose","options":"options","mustChooseBetween":"Must choose between","mustChooseAtLeastOneOption":"Must choose at least 1 option","mustChooseAtLeast":"Must choose at least","selectUpTo":"Select up to","selectOneOption":"Select one option","and":" & ","chooseItemOptions":"Choose Item Options","youDidNotSelectedRequiredOptions":"You did not select all of the required options","checkAgain":"Please check again"}
}