<?php
 namespace tk\GuzzleHttp\Psr7; use tk\Psr\Http\Message\RequestInterface; use tk\Psr\Http\Message\ServerRequestInterface; use tk\Psr\Http\Message\StreamInterface; use tk\Psr\Http\Message\UriInterface; final class Utils { public static function caselessRemove($keys, array $data) { $result = []; foreach ($keys as &$key) { $key = \strtolower($key); } foreach ($data as $k => $v) { if (!\in_array(\strtolower($k), $keys)) { $result[$k] = $v; } } return $result; } public static function copyToStream(\tk\Psr\Http\Message\StreamInterface $source, \tk\Psr\Http\Message\StreamInterface $dest, $maxLen = -1) { $bufferSize = 8192; if ($maxLen === -1) { while (!$source->eof()) { if (!$dest->write($source->read($bufferSize))) { break; } } } else { $remaining = $maxLen; while ($remaining > 0 && !$source->eof()) { $buf = $source->read(\min($bufferSize, $remaining)); $len = \strlen($buf); if (!$len) { break; } $remaining -= $len; $dest->write($buf); } } } public static function copyToString(\tk\Psr\Http\Message\StreamInterface $stream, $maxLen = -1) { $buffer = ''; if ($maxLen === -1) { while (!$stream->eof()) { $buf = $stream->read(1048576); if ($buf == null) { break; } $buffer .= $buf; } return $buffer; } $len = 0; while (!$stream->eof() && $len < $maxLen) { $buf = $stream->read($maxLen - $len); if ($buf == null) { break; } $buffer .= $buf; $len = \strlen($buffer); } return $buffer; } public static function hash(\tk\Psr\Http\Message\StreamInterface $stream, $algo, $rawOutput = \false) { $pos = $stream->tell(); if ($pos > 0) { $stream->rewind(); } $ctx = \hash_init($algo); while (!$stream->eof()) { \hash_update($ctx, $stream->read(1048576)); } $out = \hash_final($ctx, (bool) $rawOutput); $stream->seek($pos); return $out; } public static function modifyRequest(\tk\Psr\Http\Message\RequestInterface $request, array $changes) { if (!$changes) { return $request; } $headers = $request->getHeaders(); if (!isset($changes['uri'])) { $uri = $request->getUri(); } else { if ($host = $changes['uri']->getHost()) { $changes['set_headers']['Host'] = $host; if ($port = $changes['uri']->getPort()) { $standardPorts = ['http' => 80, 'https' => 443]; $scheme = $changes['uri']->getScheme(); if (isset($standardPorts[$scheme]) && $port != $standardPorts[$scheme]) { $changes['set_headers']['Host'] .= ':' . $port; } } } $uri = $changes['uri']; } if (!empty($changes['remove_headers'])) { $headers = self::caselessRemove($changes['remove_headers'], $headers); } if (!empty($changes['set_headers'])) { $headers = self::caselessRemove(\array_keys($changes['set_headers']), $headers); $headers = $changes['set_headers'] + $headers; } if (isset($changes['query'])) { $uri = $uri->withQuery($changes['query']); } if ($request instanceof \tk\Psr\Http\Message\ServerRequestInterface) { return (new \tk\GuzzleHttp\Psr7\ServerRequest(isset($changes['method']) ? $changes['method'] : $request->getMethod(), $uri, $headers, isset($changes['body']) ? $changes['body'] : $request->getBody(), isset($changes['version']) ? $changes['version'] : $request->getProtocolVersion(), $request->getServerParams()))->withParsedBody($request->getParsedBody())->withQueryParams($request->getQueryParams())->withCookieParams($request->getCookieParams())->withUploadedFiles($request->getUploadedFiles()); } return new \tk\GuzzleHttp\Psr7\Request(isset($changes['method']) ? $changes['method'] : $request->getMethod(), $uri, $headers, isset($changes['body']) ? $changes['body'] : $request->getBody(), isset($changes['version']) ? $changes['version'] : $request->getProtocolVersion()); } public static function readLine(\tk\Psr\Http\Message\StreamInterface $stream, $maxLength = null) { $buffer = ''; $size = 0; while (!$stream->eof()) { if (null == ($byte = $stream->read(1))) { return $buffer; } $buffer .= $byte; if ($byte === "\n" || ++$size === $maxLength - 1) { break; } } return $buffer; } public static function streamFor($resource = '', array $options = []) { if (\is_scalar($resource)) { $stream = \fopen('php://temp', 'r+'); if ($resource !== '') { \fwrite($stream, $resource); \fseek($stream, 0); } return new \tk\GuzzleHttp\Psr7\Stream($stream, $options); } switch (\gettype($resource)) { case 'resource': return new \tk\GuzzleHttp\Psr7\Stream($resource, $options); case 'object': if ($resource instanceof \tk\Psr\Http\Message\StreamInterface) { return $resource; } elseif ($resource instanceof \Iterator) { return new \tk\GuzzleHttp\Psr7\PumpStream(function () use($resource) { if (!$resource->valid()) { return \false; } $result = $resource->current(); $resource->next(); return $result; }, $options); } elseif (\method_exists($resource, '__toString')) { return \tk\GuzzleHttp\Psr7\Utils::streamFor((string) $resource, $options); } break; case 'NULL': return new \tk\GuzzleHttp\Psr7\Stream(\fopen('php://temp', 'r+'), $options); } if (\is_callable($resource)) { return new \tk\GuzzleHttp\Psr7\PumpStream($resource, $options); } throw new \InvalidArgumentException('Invalid resource type: ' . \gettype($resource)); } public static function tryFopen($filename, $mode) { $ex = null; \set_error_handler(function () use($filename, $mode, &$ex) { $ex = new \RuntimeException(\sprintf('Unable to open %s using mode %s: %s', $filename, $mode, \func_get_args()[1])); }); $handle = \fopen($filename, $mode); \restore_error_handler(); if ($ex) { throw $ex; } return $handle; } public static function uriFor($uri) { if ($uri instanceof \tk\Psr\Http\Message\UriInterface) { return $uri; } if (\is_string($uri)) { return new \tk\GuzzleHttp\Psr7\Uri($uri); } throw new \InvalidArgumentException('URI must be a string or UriInterface'); } } 