<?php
 namespace tk\GuzzleHttp; use tk\GuzzleHttp\Exception\BadResponseException; use tk\GuzzleHttp\Exception\TooManyRedirectsException; use tk\GuzzleHttp\Promise\PromiseInterface; use tk\Psr\Http\Message\RequestInterface; use tk\Psr\Http\Message\ResponseInterface; use tk\Psr\Http\Message\UriInterface; class RedirectMiddleware { public const HISTORY_HEADER = 'X-Guzzle-Redirect-History'; public const STATUS_HISTORY_HEADER = 'X-Guzzle-Redirect-Status-History'; public static $defaultSettings = ['max' => 5, 'protocols' => ['http', 'https'], 'strict' => \false, 'referer' => \false, 'track_redirects' => \false]; private $nextHandler; public function __construct(callable $nextHandler) { $this->nextHandler = $nextHandler; } public function __invoke(\tk\Psr\Http\Message\RequestInterface $request, array $options) : \tk\GuzzleHttp\Promise\PromiseInterface { $fn = $this->nextHandler; if (empty($options['allow_redirects'])) { return $fn($request, $options); } if ($options['allow_redirects'] === \true) { $options['allow_redirects'] = self::$defaultSettings; } elseif (!\is_array($options['allow_redirects'])) { throw new \InvalidArgumentException('allow_redirects must be true, false, or array'); } else { $options['allow_redirects'] += self::$defaultSettings; } if (empty($options['allow_redirects']['max'])) { return $fn($request, $options); } return $fn($request, $options)->then(function (\tk\Psr\Http\Message\ResponseInterface $response) use($request, $options) { return $this->checkRedirect($request, $options, $response); }); } public function checkRedirect(\tk\Psr\Http\Message\RequestInterface $request, array $options, \tk\Psr\Http\Message\ResponseInterface $response) { if (\strpos((string) $response->getStatusCode(), '3') !== 0 || !$response->hasHeader('Location')) { return $response; } $this->guardMax($request, $response, $options); $nextRequest = $this->modifyRequest($request, $options, $response); if (isset($options['allow_redirects']['on_redirect'])) { $options['allow_redirects']['on_redirect']($request, $response, $nextRequest->getUri()); } $promise = $this($nextRequest, $options); if (!empty($options['allow_redirects']['track_redirects'])) { return $this->withTracking($promise, (string) $nextRequest->getUri(), $response->getStatusCode()); } return $promise; } private function withTracking(\tk\GuzzleHttp\Promise\PromiseInterface $promise, string $uri, int $statusCode) : \tk\GuzzleHttp\Promise\PromiseInterface { return $promise->then(static function (\tk\Psr\Http\Message\ResponseInterface $response) use($uri, $statusCode) { $historyHeader = $response->getHeader(self::HISTORY_HEADER); $statusHeader = $response->getHeader(self::STATUS_HISTORY_HEADER); \array_unshift($historyHeader, $uri); \array_unshift($statusHeader, (string) $statusCode); return $response->withHeader(self::HISTORY_HEADER, $historyHeader)->withHeader(self::STATUS_HISTORY_HEADER, $statusHeader); }); } private function guardMax(\tk\Psr\Http\Message\RequestInterface $request, \tk\Psr\Http\Message\ResponseInterface $response, array &$options) : void { $current = $options['__redirect_count'] ?? 0; $options['__redirect_count'] = $current + 1; $max = $options['allow_redirects']['max']; if ($options['__redirect_count'] > $max) { throw new \tk\GuzzleHttp\Exception\TooManyRedirectsException("Will not follow more than {$max} redirects", $request, $response); } } public function modifyRequest(\tk\Psr\Http\Message\RequestInterface $request, array $options, \tk\Psr\Http\Message\ResponseInterface $response) : \tk\Psr\Http\Message\RequestInterface { $modify = []; $protocols = $options['allow_redirects']['protocols']; $statusCode = $response->getStatusCode(); if ($statusCode == 303 || $statusCode <= 302 && !$options['allow_redirects']['strict']) { $safeMethods = ['GET', 'HEAD', 'OPTIONS']; $requestMethod = $request->getMethod(); $modify['method'] = \in_array($requestMethod, $safeMethods) ? $requestMethod : 'GET'; $modify['body'] = ''; } $uri = $this->redirectUri($request, $response, $protocols); if (isset($options['idn_conversion']) && $options['idn_conversion'] !== \false) { $idnOptions = $options['idn_conversion'] === \true ? \IDNA_DEFAULT : $options['idn_conversion']; $uri = \tk\GuzzleHttp\Utils::idnUriConvert($uri, $idnOptions); } $modify['uri'] = $uri; \tk\GuzzleHttp\Psr7\Message::rewindBody($request); if ($options['allow_redirects']['referer'] && $modify['uri']->getScheme() === $request->getUri()->getScheme()) { $uri = $request->getUri()->withUserInfo(''); $modify['set_headers']['Referer'] = (string) $uri; } else { $modify['remove_headers'][] = 'Referer'; } if ($request->getUri()->getHost() !== $modify['uri']->getHost()) { $modify['remove_headers'][] = 'Authorization'; } return \tk\GuzzleHttp\Psr7\Utils::modifyRequest($request, $modify); } private function redirectUri(\tk\Psr\Http\Message\RequestInterface $request, \tk\Psr\Http\Message\ResponseInterface $response, array $protocols) : \tk\Psr\Http\Message\UriInterface { $location = \tk\GuzzleHttp\Psr7\UriResolver::resolve($request->getUri(), new \tk\GuzzleHttp\Psr7\Uri($response->getHeaderLine('Location'))); if (!\in_array($location->getScheme(), $protocols)) { throw new \tk\GuzzleHttp\Exception\BadResponseException(\sprintf('Redirect URI, %s, does not use one of the allowed redirect protocols: %s', $location, \implode(', ', $protocols)), $request, $response); } return $location; } } 