<?php
 namespace tk\GuzzleHttp\Exception; use tk\GuzzleHttp\BodySummarizer; use tk\GuzzleHttp\BodySummarizerInterface; use tk\Psr\Http\Client\RequestExceptionInterface; use tk\Psr\Http\Message\RequestInterface; use tk\Psr\Http\Message\ResponseInterface; use tk\Psr\Http\Message\UriInterface; class RequestException extends \tk\GuzzleHttp\Exception\TransferException implements \tk\Psr\Http\Client\RequestExceptionInterface { private $request; private $response; private $handlerContext; public function __construct(string $message, \tk\Psr\Http\Message\RequestInterface $request, \tk\Psr\Http\Message\ResponseInterface $response = null, \Throwable $previous = null, array $handlerContext = []) { $code = $response ? $response->getStatusCode() : 0; parent::__construct($message, $code, $previous); $this->request = $request; $this->response = $response; $this->handlerContext = $handlerContext; } public static function wrapException(\tk\Psr\Http\Message\RequestInterface $request, \Throwable $e) : \tk\GuzzleHttp\Exception\RequestException { return $e instanceof \tk\GuzzleHttp\Exception\RequestException ? $e : new \tk\GuzzleHttp\Exception\RequestException($e->getMessage(), $request, null, $e); } public static function create(\tk\Psr\Http\Message\RequestInterface $request, \tk\Psr\Http\Message\ResponseInterface $response = null, \Throwable $previous = null, array $handlerContext = [], \tk\GuzzleHttp\BodySummarizerInterface $bodySummarizer = null) : self { if (!$response) { return new self('Error completing request', $request, null, $previous, $handlerContext); } $level = (int) \floor($response->getStatusCode() / 100); if ($level === 4) { $label = 'Client error'; $className = \tk\GuzzleHttp\Exception\ClientException::class; } elseif ($level === 5) { $label = 'Server error'; $className = \tk\GuzzleHttp\Exception\ServerException::class; } else { $label = 'Unsuccessful request'; $className = __CLASS__; } $uri = $request->getUri(); $uri = static::obfuscateUri($uri); $message = \sprintf('%s: `%s %s` resulted in a `%s %s` response', $label, $request->getMethod(), $uri, $response->getStatusCode(), $response->getReasonPhrase()); $summary = ($bodySummarizer ?? new \tk\GuzzleHttp\BodySummarizer())->summarize($response); if ($summary !== null) { $message .= ":\n{$summary}\n"; } return new $className($message, $request, $response, $previous, $handlerContext); } private static function obfuscateUri(\tk\Psr\Http\Message\UriInterface $uri) : \tk\Psr\Http\Message\UriInterface { $userInfo = $uri->getUserInfo(); if (\false !== ($pos = \strpos($userInfo, ':'))) { return $uri->withUserInfo(\substr($userInfo, 0, $pos), '***'); } return $uri; } public function getRequest() : \tk\Psr\Http\Message\RequestInterface { return $this->request; } public function getResponse() : ?\tk\Psr\Http\Message\ResponseInterface { return $this->response; } public function hasResponse() : bool { return $this->response !== null; } public function getHandlerContext() : array { return $this->handlerContext; } } 