<?php
 namespace tk\ReCaptcha; class Response { private $success = \false; private $errorCodes = array(); private $hostname; private $challengeTs; private $apkPackageName; private $score; private $action; public static function fromJson($json) { $responseData = \json_decode($json, \true); if (!$responseData) { return new \tk\ReCaptcha\Response(\false, array(\tk\ReCaptcha\ReCaptcha::E_INVALID_JSON)); } $hostname = isset($responseData['hostname']) ? $responseData['hostname'] : null; $challengeTs = isset($responseData['challenge_ts']) ? $responseData['challenge_ts'] : null; $apkPackageName = isset($responseData['apk_package_name']) ? $responseData['apk_package_name'] : null; $score = isset($responseData['score']) ? \floatval($responseData['score']) : null; $action = isset($responseData['action']) ? $responseData['action'] : null; if (isset($responseData['success']) && $responseData['success'] == \true) { return new \tk\ReCaptcha\Response(\true, array(), $hostname, $challengeTs, $apkPackageName, $score, $action); } if (isset($responseData['error-codes']) && \is_array($responseData['error-codes'])) { return new \tk\ReCaptcha\Response(\false, $responseData['error-codes'], $hostname, $challengeTs, $apkPackageName, $score, $action); } return new \tk\ReCaptcha\Response(\false, array(\tk\ReCaptcha\ReCaptcha::E_UNKNOWN_ERROR), $hostname, $challengeTs, $apkPackageName, $score, $action); } public function __construct($success, array $errorCodes = array(), $hostname = null, $challengeTs = null, $apkPackageName = null, $score = null, $action = null) { $this->success = $success; $this->hostname = $hostname; $this->challengeTs = $challengeTs; $this->apkPackageName = $apkPackageName; $this->score = $score; $this->action = $action; $this->errorCodes = $errorCodes; } public function isSuccess() { return $this->success; } public function getErrorCodes() { return $this->errorCodes; } public function getHostname() { return $this->hostname; } public function getChallengeTs() { return $this->challengeTs; } public function getApkPackageName() { return $this->apkPackageName; } public function getScore() { return $this->score; } public function getAction() { return $this->action; } public function toArray() { return array('success' => $this->isSuccess(), 'hostname' => $this->getHostname(), 'challenge_ts' => $this->getChallengeTs(), 'apk_package_name' => $this->getApkPackageName(), 'score' => $this->getScore(), 'action' => $this->getAction(), 'error-codes' => $this->getErrorCodes()); } } 