<?php

if ( ! defined( 'ABSPATH' ) ) { exit; }

 if ( ! defined( 'ABSPATH' ) ) { exit; } require_once dirname( __FILE__ ) . '/FreemiusBase.php'; if ( ! defined( 'FS_SDK__USER_AGENT' ) ) { define( 'FS_SDK__USER_AGENT', 'fs-php-' . Freemius_Api_Base::VERSION ); } if ( ! defined( 'FS_SDK__SIMULATE_NO_CURL' ) ) { define( 'FS_SDK__SIMULATE_NO_CURL', false ); } if ( ! defined( 'FS_SDK__SIMULATE_NO_API_CONNECTIVITY_CLOUDFLARE' ) ) { define( 'FS_SDK__SIMULATE_NO_API_CONNECTIVITY_CLOUDFLARE', false ); } if ( ! defined( 'FS_SDK__SIMULATE_NO_API_CONNECTIVITY_SQUID_ACL' ) ) { define( 'FS_SDK__SIMULATE_NO_API_CONNECTIVITY_SQUID_ACL', false ); } if ( ! defined( 'FS_SDK__HAS_CURL' ) ) { if ( FS_SDK__SIMULATE_NO_CURL ) { define( 'FS_SDK__HAS_CURL', false ); } else { $curl_required_methods = array( 'curl_version', 'curl_exec', 'curl_init', 'curl_close', 'curl_setopt', 'curl_setopt_array', 'curl_error', ); $has_curl = true; foreach ( $curl_required_methods as $m ) { if ( ! function_exists( $m ) ) { $has_curl = false; break; } } define( 'FS_SDK__HAS_CURL', $has_curl ); } } if ( ! defined( 'FS_SDK__SSLVERIFY' ) ) { define( 'FS_SDK__SSLVERIFY', false ); } $curl_version = FS_SDK__HAS_CURL ? curl_version() : array( 'version' => '7.37' ); if ( ! defined( 'FS_API__PROTOCOL' ) ) { define( 'FS_API__PROTOCOL', version_compare( $curl_version['version'], '7.37', '>=' ) ? 'https' : 'http' ); } if ( ! defined( 'FS_API__LOGGER_ON' ) ) { define( 'FS_API__LOGGER_ON', false ); } if ( ! defined( 'FS_API__ADDRESS' ) ) { define( 'FS_API__ADDRESS', '://api.freemius.com' ); } if ( ! defined( 'FS_API__SANDBOX_ADDRESS' ) ) { define( 'FS_API__SANDBOX_ADDRESS', '://sandbox-api.freemius.com' ); } if ( ! class_exists( 'Freemius_Api_WordPress' ) ) { class Freemius_Api_WordPress extends Freemius_Api_Base { private static $_logger = array(); public function __construct( $pScope, $pID, $pPublic, $pSecret = false, $pSandbox = false ) { if ( is_bool( $pSecret ) ) { $pSecret = $pPublic; } parent::Init( $pScope, $pID, $pPublic, $pSecret, $pSandbox ); } public static function GetUrl( $pCanonizedPath = '', $pIsSandbox = false ) { $address = ( $pIsSandbox ? FS_API__SANDBOX_ADDRESS : FS_API__ADDRESS ); if ( ':' === $address[0] ) { $address = self::$_protocol . $address; } return $address . $pCanonizedPath; } private static $_clock_diff = 0; public static function SetClockDiff( $pSeconds ) { self::$_clock_diff = $pSeconds; } public static function FindClockDiff() { $time = time(); $pong = self::Ping(); return ( $time - strtotime( $pong->timestamp ) ); } private static $_protocol = FS_API__PROTOCOL; public static function SetHttp() { self::$_protocol = 'http'; } public static function SetHttps() { self::$_protocol = 'https'; } public static function IsHttps() { return ( 'https' === self::$_protocol ); } function SignRequest( $pResourceUrl, $pWPRemoteArgs ) { $auth = $this->GenerateAuthorizationParams( $pResourceUrl, $pWPRemoteArgs['method'], ! empty( $pWPRemoteArgs['body'] ) ? $pWPRemoteArgs['body'] : '' ); $pWPRemoteArgs['headers']['Date'] = $auth['date']; $pWPRemoteArgs['headers']['Authorization'] = $auth['authorization']; if ( ! empty( $auth['content_md5'] ) ) { $pWPRemoteArgs['headers']['Content-MD5'] = $auth['content_md5']; } return $pWPRemoteArgs; } function GenerateAuthorizationParams( $pResourceUrl, $pMethod = 'GET', $pPostParams = '' ) { $pMethod = strtoupper( $pMethod ); $eol = "\n"; $content_md5 = ''; $content_type = ''; $now = ( time() - self::$_clock_diff ); $date = date( 'r', $now ); if ( in_array( $pMethod, array( 'POST', 'PUT' ) ) ) { $content_type = 'application/json'; if ( ! empty( $pPostParams ) ) { $content_md5 = md5( $pPostParams ); } } $string_to_sign = implode( $eol, array( $pMethod, $content_md5, $content_type, $date, $pResourceUrl ) ); $auth_type = ( $this->_secret !== $this->_public ) ? 'FS' : 'FSP'; $auth = array( 'date' => $date, 'authorization' => $auth_type . ' ' . $this->_id . ':' . $this->_public . ':' . self::Base64UrlEncode( hash_hmac( 'sha256', $string_to_sign, $this->_secret ) ) ); if ( ! empty( $content_md5 ) ) { $auth['content_md5'] = $content_md5; } return $auth; } function GetSignedUrl( $pPath ) { $resource = explode( '?', $this->CanonizePath( $pPath ) ); $pResourceUrl = $resource[0]; $auth = $this->GenerateAuthorizationParams( $pResourceUrl ); return Freemius_Api_WordPress::GetUrl( $pResourceUrl . '?' . ( 1 < count( $resource ) && ! empty( $resource[1] ) ? $resource[1] . '&' : '' ) . 'authorization=' . urlencode( $auth['authorization'] ) . '&auth_date=' . urlencode( $auth['date'] ) , $this->_isSandbox ); } private static function ExecuteRequest( $pUrl, &$pWPRemoteArgs ) { $bt = debug_backtrace(); $start = microtime( true ); $response = self::RemoteRequest( $pUrl, $pWPRemoteArgs ); if ( FS_API__LOGGER_ON ) { $end = microtime( true ); $has_body = ( isset( $pWPRemoteArgs['body'] ) && ! empty( $pWPRemoteArgs['body'] ) ); $is_http_error = is_wp_error( $response ); self::$_logger[] = array( 'id' => count( self::$_logger ), 'start' => $start, 'end' => $end, 'total' => ( $end - $start ), 'method' => $pWPRemoteArgs['method'], 'path' => $pUrl, 'body' => $has_body ? $pWPRemoteArgs['body'] : null, 'result' => ! $is_http_error ? $response['body'] : json_encode( $response->get_error_messages() ), 'code' => ! $is_http_error ? $response['response']['code'] : null, 'backtrace' => $bt, ); } return $response; } static function RemoteRequest( $pUrl, $pWPRemoteArgs ) { $response = wp_remote_request( $pUrl, $pWPRemoteArgs ); if ( is_array( $response ) && ( empty( $response['headers'] ) || empty( $response['headers']['x-api-server'] ) ) ) { $response = new WP_Error( 'api_blocked', htmlentities( $response['body'] ) ); } return $response; } static function GetLogger() { return self::$_logger; } private static function MakeStaticRequest( $pCanonizedPath, $pMethod = 'GET', $pParams = array(), $pWPRemoteArgs = null, $pIsSandbox = false, $pBeforeExecutionFunction = null ) { if ( FS_SDK__SIMULATE_NO_API_CONNECTIVITY_CLOUDFLARE ) { self::ThrowCloudFlareDDoSException(); } else if ( FS_SDK__SIMULATE_NO_API_CONNECTIVITY_SQUID_ACL ) { self::ThrowSquidAclException(); } if ( empty( $pWPRemoteArgs ) ) { $user_agent = 'Freemius/WordPress-SDK/' . Freemius_Api_Base::VERSION . '; ' . home_url(); $pWPRemoteArgs = array( 'method' => strtoupper( $pMethod ), 'connect_timeout' => 10, 'timeout' => 60, 'follow_redirects' => true, 'redirection' => 5, 'user-agent' => $user_agent, 'blocking' => true, ); } if ( ! isset( $pWPRemoteArgs['headers'] ) || ! is_array( $pWPRemoteArgs['headers'] ) ) { $pWPRemoteArgs['headers'] = array(); } if ( in_array( $pMethod, array( 'POST', 'PUT' ) ) ) { $pWPRemoteArgs['headers']['Content-type'] = 'application/json'; if ( is_array( $pParams ) && 0 < count( $pParams ) ) { $pWPRemoteArgs['body'] = json_encode( $pParams ); } } $request_url = self::GetUrl( $pCanonizedPath, $pIsSandbox ); $resource = explode( '?', $pCanonizedPath ); if ( FS_SDK__HAS_CURL ) { $pWPRemoteArgs['headers']['Expect'] = ''; } if ( 'https' === substr( strtolower( $request_url ), 0, 5 ) ) { $pWPRemoteArgs['sslverify'] = FS_SDK__SSLVERIFY; } if ( false !== $pBeforeExecutionFunction && is_callable( $pBeforeExecutionFunction ) ) { $pWPRemoteArgs = call_user_func( $pBeforeExecutionFunction, $resource[0], $pWPRemoteArgs ); } $result = self::ExecuteRequest( $request_url, $pWPRemoteArgs ); if ( is_wp_error( $result ) ) { if ( self::IsCurlError( $result ) ) { $matches = array(); $regex = '/Failed to connect to ([^:].*): Network is unreachable/'; if ( preg_match( $regex, $result->get_error_message( 'http_request_failed' ), $matches ) ) { if ( filter_var( $matches[1], FILTER_VALIDATE_IP ) ) { if ( strlen( inet_pton( $matches[1] ) ) === 16 ) { add_action( 'http_api_curl', 'Freemius_Api_WordPress::CurlResolveToIPv4', 10, 1 ); $result = self::ExecuteRequest( $request_url, $pWPRemoteArgs ); } } } } if ( is_wp_error( $result ) ) { self::ThrowWPRemoteException( $result ); } } $response_body = $result['body']; if ( empty( $response_body ) ) { return null; } $decoded = json_decode( $response_body ); if ( is_null( $decoded ) ) { if ( preg_match( '/Please turn JavaScript on/i', $response_body ) && preg_match( '/text\/javascript/', $response_body ) ) { self::ThrowCloudFlareDDoSException( $response_body ); } else if ( preg_match( '/Access control configuration prevents your request from being allowed at this time. Please contact your service provider if you feel this is incorrect./', $response_body ) && preg_match( '/squid/', $response_body ) ) { self::ThrowSquidAclException( $response_body ); } else { $decoded = (object) array( 'error' => (object) array( 'type' => 'Unknown', 'message' => $response_body, 'code' => 'unknown', 'http' => 402 ) ); } } return $decoded; } public function MakeRequest( $pCanonizedPath, $pMethod = 'GET', $pParams = array(), $pWPRemoteArgs = null ) { $resource = explode( '?', $pCanonizedPath ); $sign_request = ( '/v1/ping.json' !== strtolower( substr( $resource[0], - strlen( '/v1/ping.json' ) ) ) ); return self::MakeStaticRequest( $pCanonizedPath, $pMethod, $pParams, $pWPRemoteArgs, $this->_isSandbox, $sign_request ? array( &$this, 'SignRequest' ) : null ); } static function CurlResolveToIPv4( $handle ) { curl_setopt( $handle, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 ); return $handle; } public static function Test( $pPong = null ) { return ( is_object( $pPong ) && isset( $pPong->api ) && 'pong' === $pPong->api ); } public static function Ping() { try { $result = self::MakeStaticRequest( '/v' . FS_API__VERSION . '/ping.json' ); } catch ( Freemius_Exception $e ) { $result = (object) $e->getResult(); } catch ( Exception $e ) { $result = (object) array( 'error' => (object) array( 'type' => 'Unknown', 'message' => $e->getMessage() . ' (' . $e->getFile() . ': ' . $e->getLine() . ')', 'code' => 'unknown', 'http' => 402 ) ); } return $result; } private static function IsCurlError( WP_Error $pError ) { $message = $pError->get_error_message( 'http_request_failed' ); return ( 0 === strpos( $message, 'cURL' ) ); } private static function ThrowWPRemoteException( WP_Error $pError ) { if ( self::IsCurlError( $pError ) ) { $message = $pError->get_error_message( 'http_request_failed' ); $curl_required_methods = array( 'curl_version', 'curl_exec', 'curl_init', 'curl_close', 'curl_setopt', 'curl_setopt_array', 'curl_error', ); $missing_methods = array(); foreach ( $curl_required_methods as $m ) { if ( ! function_exists( $m ) ) { $missing_methods[] = $m; } } if ( ! empty( $missing_methods ) ) { throw new Freemius_Exception( array( 'error' => (object) array( 'type' => 'cUrlMissing', 'message' => $message, 'code' => 'curl_missing', 'http' => 402 ), 'missing_methods' => $missing_methods, ) ); } $parts = explode( ':', substr( $message, strlen( 'cURL error ' ) ), 2 ); $code = ( 0 < count( $parts ) ) ? $parts[0] : 'http_request_failed'; $message = ( 1 < count( $parts ) ) ? $parts[1] : $message; $e = new Freemius_Exception( array( 'error' => (object) array( 'code' => $code, 'message' => $message, 'type' => 'CurlException', ), ) ); } else { $e = new Freemius_Exception( array( 'error' => (object) array( 'code' => $pError->get_error_code(), 'message' => $pError->get_error_message(), 'type' => 'WPRemoteException', ), ) ); } throw $e; } private static function ThrowCloudFlareDDoSException( $pResult = '' ) { throw new Freemius_Exception( array( 'error' => (object) array( 'type' => 'CloudFlareDDoSProtection', 'message' => $pResult, 'code' => 'cloudflare_ddos_protection', 'http' => 402 ) ) ); } private static function ThrowSquidAclException( $pResult = '' ) { throw new Freemius_Exception( array( 'error' => (object) array( 'type' => 'SquidCacheBlock', 'message' => $pResult, 'code' => 'squid_cache_block', 'http' => 402 ) ) ); } } } 