<?php

if ( ! defined( 'ABSPATH' ) ) { exit; }

 if ( ! defined( 'ABSPATH' ) ) { exit; } class FS_Storage { private static $_instances = array(); private $_storage; private $_network_storage; private $_module_type; private $_module_slug; private $_blog_id = 0; private $_is_multisite; private $_is_network_active = false; private $_is_delegated_connection = false; private static $_NETWORK_OPTIONS_MAP; const OPTION_LEVEL_UNDEFINED = -1; const OPTION_LEVEL_NETWORK = 0; const OPTION_LEVEL_NETWORK_ACTIVATED = 1; const OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED = 2; const OPTION_LEVEL_SITE = 3; static function instance( $module_type, $slug ) { $key = $module_type . ':' . $slug; if ( ! isset( self::$_instances[ $key ] ) ) { self::$_instances[ $key ] = new FS_Storage( $module_type, $slug ); } return self::$_instances[ $key ]; } private function __construct( $module_type, $slug ) { $this->_module_type = $module_type; $this->_module_slug = $slug; $this->_is_multisite = is_multisite(); if ( $this->_is_multisite ) { $this->_blog_id = get_current_blog_id(); $this->_network_storage = FS_Key_Value_Storage::instance( $module_type . '_data', $slug, true ); } $this->_storage = FS_Key_Value_Storage::instance( $module_type . '_data', $slug, $this->_blog_id ); } function set_network_active( $is_network_active = true, $is_delegated_connection = false ) { $this->_is_network_active = $is_network_active; $this->_is_delegated_connection = $is_delegated_connection; } function set_site_blog_context( $blog_id ) { $this->_storage = $this->get_site_storage( $blog_id ); $this->_blog_id = $blog_id; } function store( $key, $value, $network_level_or_blog_id = null, $option_level = self::OPTION_LEVEL_UNDEFINED, $flush = true ) { if ( $this->should_use_network_storage( $key, $network_level_or_blog_id, $option_level ) ) { $this->_network_storage->store( $key, $value, $flush ); } else { $storage = $this->get_site_storage( $network_level_or_blog_id ); $storage->store( $key, $value, $flush ); } } function clear_all( $store = true, $exceptions = array(), $network_level_or_blog_id = null ) { if ( ! $this->_is_multisite || false === $network_level_or_blog_id || is_null( $network_level_or_blog_id ) || is_numeric( $network_level_or_blog_id ) ) { $storage = $this->get_site_storage( $network_level_or_blog_id ); $storage->clear_all( $store, $exceptions ); } if ( $this->_is_multisite && ( true === $network_level_or_blog_id || is_null( $network_level_or_blog_id ) ) ) { $this->_network_storage->clear_all( $store, $exceptions ); } } function remove( $key, $store = true, $network_level_or_blog_id = null ) { if ( $this->should_use_network_storage( $key, $network_level_or_blog_id ) ) { $this->_network_storage->remove( $key, $store ); } else { $storage = $this->get_site_storage( $network_level_or_blog_id ); $storage->remove( $key, $store ); } } function get( $key, $default = false, $network_level_or_blog_id = null, $option_level = self::OPTION_LEVEL_UNDEFINED ) { if ( $this->should_use_network_storage( $key, $network_level_or_blog_id, $option_level ) ) { return $this->_network_storage->get( $key, $default ); } else { $storage = $this->get_site_storage( $network_level_or_blog_id ); return $storage->get( $key, $default ); } } function save( $network_level_or_blog_id = null ) { if ( $this->_is_network_active && ( true === $network_level_or_blog_id || is_null( $network_level_or_blog_id ) ) ) { $this->_network_storage->save(); } if ( ! $this->_is_network_active || true !== $network_level_or_blog_id ) { $storage = $this->get_site_storage( $network_level_or_blog_id ); $storage->save(); } } function get_module_slug() { return $this->_module_slug; } function get_module_type() { return $this->_module_type; } function migrate_to_network() { if ( ! $this->_is_multisite ) { return; } $updated = false; if ( ! isset( self::$_NETWORK_OPTIONS_MAP ) ) { self::load_network_options_map(); } foreach ( self::$_NETWORK_OPTIONS_MAP as $option => $storage_level ) { if ( ! $this->is_multisite_option( $option ) ) { continue; } if ( isset( $this->_storage->{$option} ) && ! isset( $this->_network_storage->{$option} ) ) { $this->_network_storage->store( $option, $this->_storage->{$option}, false ); $updated = true; } } if ( ! $updated ) { return; } $this->_network_storage->save(); } private static function load_network_options_map() { self::$_NETWORK_OPTIONS_MAP = array( 'affiliate_application_data' => self::OPTION_LEVEL_NETWORK, 'beta_data' => self::OPTION_LEVEL_NETWORK, 'connectivity_test' => self::OPTION_LEVEL_NETWORK, 'handle_gdpr_admin_notice' => self::OPTION_LEVEL_NETWORK, 'has_trial_plan' => self::OPTION_LEVEL_NETWORK, 'install_sync_timestamp' => self::OPTION_LEVEL_NETWORK, 'install_sync_cron' => self::OPTION_LEVEL_NETWORK, 'is_anonymous_ms' => self::OPTION_LEVEL_NETWORK, 'is_network_activated' => self::OPTION_LEVEL_NETWORK, 'is_on' => self::OPTION_LEVEL_NETWORK, 'is_plugin_new_install' => self::OPTION_LEVEL_NETWORK, 'network_install_blog_id' => self::OPTION_LEVEL_NETWORK, 'pending_sites_info' => self::OPTION_LEVEL_NETWORK, 'plugin_last_version' => self::OPTION_LEVEL_NETWORK, 'plugin_main_file' => self::OPTION_LEVEL_NETWORK, 'plugin_version' => self::OPTION_LEVEL_NETWORK, 'sdk_downgrade_mode' => self::OPTION_LEVEL_NETWORK, 'sdk_last_version' => self::OPTION_LEVEL_NETWORK, 'sdk_upgrade_mode' => self::OPTION_LEVEL_NETWORK, 'sdk_version' => self::OPTION_LEVEL_NETWORK, 'sticky_optin_added_ms' => self::OPTION_LEVEL_NETWORK, 'subscriptions' => self::OPTION_LEVEL_NETWORK, 'sync_timestamp' => self::OPTION_LEVEL_NETWORK, 'sync_cron' => self::OPTION_LEVEL_NETWORK, 'was_plugin_loaded' => self::OPTION_LEVEL_NETWORK, 'network_user_id' => self::OPTION_LEVEL_NETWORK, 'plugin_upgrade_mode' => self::OPTION_LEVEL_NETWORK, 'plugin_downgrade_mode' => self::OPTION_LEVEL_NETWORK, 'is_network_connected' => self::OPTION_LEVEL_NETWORK, 'is_network_activation' => self::OPTION_LEVEL_NETWORK, 'license_migration' => self::OPTION_LEVEL_NETWORK, 'install_timestamp' => self::OPTION_LEVEL_NETWORK_ACTIVATED, 'prev_is_premium' => self::OPTION_LEVEL_NETWORK_ACTIVATED, 'require_license_activation' => self::OPTION_LEVEL_NETWORK_ACTIVATED, 'activation_timestamp' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'expired_license_notice_shown' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'is_whitelabeled' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'last_license_key' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'last_license_user_id' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'prev_user_id' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'sticky_optin_added' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'uninstall_reason' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'is_pending_activation' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'pending_license_key' => self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED, 'is_anonymous' => self::OPTION_LEVEL_SITE, 'clone_id' => self::OPTION_LEVEL_SITE, ); } private function is_multisite_option( $key, $option_level = self::OPTION_LEVEL_UNDEFINED ) { if ( ! isset( self::$_NETWORK_OPTIONS_MAP ) ) { self::load_network_options_map(); } if ( self::OPTION_LEVEL_UNDEFINED === $option_level && isset( self::$_NETWORK_OPTIONS_MAP[ $key ] ) ) { $option_level = self::$_NETWORK_OPTIONS_MAP[ $key ]; } if ( self::OPTION_LEVEL_UNDEFINED === $option_level ) { return false; } if ( self::OPTION_LEVEL_NETWORK === $option_level ) { return true; } if ( self::OPTION_LEVEL_SITE === $option_level ) { return false; } if ( ! $this->_is_network_active ) { return false; } if ( self::OPTION_LEVEL_NETWORK_ACTIVATED === $option_level ) { return true; } if ( self::OPTION_LEVEL_NETWORK_ACTIVATED_NOT_DELEGATED === $option_level && ! $this->_is_delegated_connection ) { return true; } return false; } private function should_use_network_storage( $key, $network_level_or_blog_id = null, $option_level = self::OPTION_LEVEL_UNDEFINED ) { if ( ! $this->_is_multisite ) { return false; } if ( is_numeric( $network_level_or_blog_id ) ) { return false; } if ( is_bool( $network_level_or_blog_id ) ) { return $network_level_or_blog_id; } return $this->is_multisite_option( $key, $option_level ); } private function get_site_storage( $blog_id = 0 ) { if ( ! is_numeric( $blog_id ) || $blog_id == $this->_blog_id || 0 == $blog_id ) { return $this->_storage; } return FS_Key_Value_Storage::instance( $this->_module_type . '_data', $this->_storage->get_secondary_id(), $blog_id ); } function __set( $k, $v ) { if ( $this->should_use_network_storage( $k ) ) { $this->_network_storage->{$k} = $v; } else { $this->_storage->{$k} = $v; } } function __isset( $k ) { return $this->should_use_network_storage( $k ) ? isset( $this->_network_storage->{$k} ) : isset( $this->_storage->{$k} ); } function __unset( $k ) { if ( $this->should_use_network_storage( $k ) ) { unset( $this->_network_storage->{$k} ); } else { unset( $this->_storage->{$k} ); } } function __get( $k ) { return $this->should_use_network_storage( $k ) ? $this->_network_storage->{$k} : $this->_storage->{$k}; } } 