<?php
/**
 * ProductPost
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class ProductPost extends ProductBase implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ProductPost';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'name' => 'string',
        'type' => 'string',
        'sku' => 'string',
        'description' => 'string',
        'weight' => 'double',
        'width' => 'double',
        'depth' => 'double',
        'height' => 'double',
        'price' => 'double',
        'cost_price' => 'double',
        'retail_price' => 'double',
        'sale_price' => 'double',
        'tax_class_id' => 'int',
        'product_tax_code' => 'string',
        'categories' => 'int[]',
        'brand_id' => 'int',
        'inventory_level' => 'int',
        'inventory_warning_level' => 'int',
        'inventory_tracking' => 'string',
        'fixed_cost_shipping_price' => 'double',
        'is_free_shipping' => 'bool',
        'is_visible' => 'bool',
        'is_featured' => 'bool',
        'related_products' => 'int[]',
        'warranty' => 'string',
        'bin_picking_number' => 'string',
        'layout_file' => 'string',
        'upc' => 'string',
        'search_keywords' => 'string',
        'availability' => 'string',
        'availability_description' => 'string',
        'gift_wrapping_options_type' => 'string',
        'gift_wrapping_options_list' => 'int[]',
        'sort_order' => 'int',
        'condition' => 'string',
        'is_condition_shown' => 'bool',
        'order_quantity_minimum' => 'int',
        'order_quantity_maximum' => 'int',
        'page_title' => 'string',
        'meta_keywords' => 'string[]',
        'meta_description' => 'string',
        'view_count' => 'int',
        'preorder_release_date' => '\DateTime',
        'preorder_message' => 'string',
        'is_preorder_only' => 'bool',
        'is_price_hidden' => 'bool',
        'price_hidden_label' => 'string',
        'custom_url' => '\BigCommerce\Api\v3\Model\CustomUrlProduct',
        'open_graph_type' => 'string',
        'open_graph_title' => 'string',
        'open_graph_description' => 'string',
        'open_graph_use_meta_description' => 'bool',
        'open_graph_use_product_name' => 'bool',
        'open_graph_use_image' => 'bool',
        'custom_fields' => '\BigCommerce\Api\v3\Model\CustomFieldPost[]',
        'bulk_pricing_rules' => '\BigCommerce\Api\v3\Model\BulkPricingRulePost[]',
        'variants' => '\BigCommerce\Api\v3\Model\VariantProductPost[]'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'type' => 'type',
        'sku' => 'sku',
        'description' => 'description',
        'weight' => 'weight',
        'width' => 'width',
        'depth' => 'depth',
        'height' => 'height',
        'price' => 'price',
        'cost_price' => 'cost_price',
        'retail_price' => 'retail_price',
        'sale_price' => 'sale_price',
        'tax_class_id' => 'tax_class_id',
        'product_tax_code' => 'product_tax_code',
        'categories' => 'categories',
        'brand_id' => 'brand_id',
        'inventory_level' => 'inventory_level',
        'inventory_warning_level' => 'inventory_warning_level',
        'inventory_tracking' => 'inventory_tracking',
        'fixed_cost_shipping_price' => 'fixed_cost_shipping_price',
        'is_free_shipping' => 'is_free_shipping',
        'is_visible' => 'is_visible',
        'is_featured' => 'is_featured',
        'related_products' => 'related_products',
        'warranty' => 'warranty',
        'bin_picking_number' => 'bin_picking_number',
        'layout_file' => 'layout_file',
        'upc' => 'upc',
        'search_keywords' => 'search_keywords',
        'availability' => 'availability',
        'availability_description' => 'availability_description',
        'gift_wrapping_options_type' => 'gift_wrapping_options_type',
        'gift_wrapping_options_list' => 'gift_wrapping_options_list',
        'sort_order' => 'sort_order',
        'condition' => 'condition',
        'is_condition_shown' => 'is_condition_shown',
        'order_quantity_minimum' => 'order_quantity_minimum',
        'order_quantity_maximum' => 'order_quantity_maximum',
        'page_title' => 'page_title',
        'meta_keywords' => 'meta_keywords',
        'meta_description' => 'meta_description',
        'view_count' => 'view_count',
        'preorder_release_date' => 'preorder_release_date',
        'preorder_message' => 'preorder_message',
        'is_preorder_only' => 'is_preorder_only',
        'is_price_hidden' => 'is_price_hidden',
        'price_hidden_label' => 'price_hidden_label',
        'custom_url' => 'custom_url',
        'open_graph_type' => 'open_graph_type',
        'open_graph_title' => 'open_graph_title',
        'open_graph_description' => 'open_graph_description',
        'open_graph_use_meta_description' => 'open_graph_use_meta_description',
        'open_graph_use_product_name' => 'open_graph_use_product_name',
        'open_graph_use_image' => 'open_graph_use_image',
        'custom_fields' => 'custom_fields',
        'bulk_pricing_rules' => 'bulk_pricing_rules',
        'variants' => 'variants'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'type' => 'setType',
        'sku' => 'setSku',
        'description' => 'setDescription',
        'weight' => 'setWeight',
        'width' => 'setWidth',
        'depth' => 'setDepth',
        'height' => 'setHeight',
        'price' => 'setPrice',
        'cost_price' => 'setCostPrice',
        'retail_price' => 'setRetailPrice',
        'sale_price' => 'setSalePrice',
        'tax_class_id' => 'setTaxClassId',
        'product_tax_code' => 'setProductTaxCode',
        'categories' => 'setCategories',
        'brand_id' => 'setBrandId',
        'inventory_level' => 'setInventoryLevel',
        'inventory_warning_level' => 'setInventoryWarningLevel',
        'inventory_tracking' => 'setInventoryTracking',
        'fixed_cost_shipping_price' => 'setFixedCostShippingPrice',
        'is_free_shipping' => 'setIsFreeShipping',
        'is_visible' => 'setIsVisible',
        'is_featured' => 'setIsFeatured',
        'related_products' => 'setRelatedProducts',
        'warranty' => 'setWarranty',
        'bin_picking_number' => 'setBinPickingNumber',
        'layout_file' => 'setLayoutFile',
        'upc' => 'setUpc',
        'search_keywords' => 'setSearchKeywords',
        'availability' => 'setAvailability',
        'availability_description' => 'setAvailabilityDescription',
        'gift_wrapping_options_type' => 'setGiftWrappingOptionsType',
        'gift_wrapping_options_list' => 'setGiftWrappingOptionsList',
        'sort_order' => 'setSortOrder',
        'condition' => 'setCondition',
        'is_condition_shown' => 'setIsConditionShown',
        'order_quantity_minimum' => 'setOrderQuantityMinimum',
        'order_quantity_maximum' => 'setOrderQuantityMaximum',
        'page_title' => 'setPageTitle',
        'meta_keywords' => 'setMetaKeywords',
        'meta_description' => 'setMetaDescription',
        'view_count' => 'setViewCount',
        'preorder_release_date' => 'setPreorderReleaseDate',
        'preorder_message' => 'setPreorderMessage',
        'is_preorder_only' => 'setIsPreorderOnly',
        'is_price_hidden' => 'setIsPriceHidden',
        'price_hidden_label' => 'setPriceHiddenLabel',
        'custom_url' => 'setCustomUrl',
        'open_graph_type' => 'setOpenGraphType',
        'open_graph_title' => 'setOpenGraphTitle',
        'open_graph_description' => 'setOpenGraphDescription',
        'open_graph_use_meta_description' => 'setOpenGraphUseMetaDescription',
        'open_graph_use_product_name' => 'setOpenGraphUseProductName',
        'open_graph_use_image' => 'setOpenGraphUseImage',
        'custom_fields' => 'setCustomFields',
        'bulk_pricing_rules' => 'setBulkPricingRules',
        'variants' => 'setVariants'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'type' => 'getType',
        'sku' => 'getSku',
        'description' => 'getDescription',
        'weight' => 'getWeight',
        'width' => 'getWidth',
        'depth' => 'getDepth',
        'height' => 'getHeight',
        'price' => 'getPrice',
        'cost_price' => 'getCostPrice',
        'retail_price' => 'getRetailPrice',
        'sale_price' => 'getSalePrice',
        'tax_class_id' => 'getTaxClassId',
        'product_tax_code' => 'getProductTaxCode',
        'categories' => 'getCategories',
        'brand_id' => 'getBrandId',
        'inventory_level' => 'getInventoryLevel',
        'inventory_warning_level' => 'getInventoryWarningLevel',
        'inventory_tracking' => 'getInventoryTracking',
        'fixed_cost_shipping_price' => 'getFixedCostShippingPrice',
        'is_free_shipping' => 'getIsFreeShipping',
        'is_visible' => 'getIsVisible',
        'is_featured' => 'getIsFeatured',
        'related_products' => 'getRelatedProducts',
        'warranty' => 'getWarranty',
        'bin_picking_number' => 'getBinPickingNumber',
        'layout_file' => 'getLayoutFile',
        'upc' => 'getUpc',
        'search_keywords' => 'getSearchKeywords',
        'availability' => 'getAvailability',
        'availability_description' => 'getAvailabilityDescription',
        'gift_wrapping_options_type' => 'getGiftWrappingOptionsType',
        'gift_wrapping_options_list' => 'getGiftWrappingOptionsList',
        'sort_order' => 'getSortOrder',
        'condition' => 'getCondition',
        'is_condition_shown' => 'getIsConditionShown',
        'order_quantity_minimum' => 'getOrderQuantityMinimum',
        'order_quantity_maximum' => 'getOrderQuantityMaximum',
        'page_title' => 'getPageTitle',
        'meta_keywords' => 'getMetaKeywords',
        'meta_description' => 'getMetaDescription',
        'view_count' => 'getViewCount',
        'preorder_release_date' => 'getPreorderReleaseDate',
        'preorder_message' => 'getPreorderMessage',
        'is_preorder_only' => 'getIsPreorderOnly',
        'is_price_hidden' => 'getIsPriceHidden',
        'price_hidden_label' => 'getPriceHiddenLabel',
        'custom_url' => 'getCustomUrl',
        'open_graph_type' => 'getOpenGraphType',
        'open_graph_title' => 'getOpenGraphTitle',
        'open_graph_description' => 'getOpenGraphDescription',
        'open_graph_use_meta_description' => 'getOpenGraphUseMetaDescription',
        'open_graph_use_product_name' => 'getOpenGraphUseProductName',
        'open_graph_use_image' => 'getOpenGraphUseImage',
        'custom_fields' => 'getCustomFields',
        'bulk_pricing_rules' => 'getBulkPricingRules',
        'variants' => 'getVariants'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_PHYSICAL = 'physical';
    const TYPE_DIGITAL = 'digital';
    const INVENTORY_TRACKING_NONE = 'none';
    const INVENTORY_TRACKING_PRODUCT = 'product';
    const INVENTORY_TRACKING_VARIANT = 'variant';
    const AVAILABILITY_AVAILABLE = 'available';
    const AVAILABILITY_DISABLED = 'disabled';
    const AVAILABILITY_PREORDER = 'preorder';
    const GIFT_WRAPPING_OPTIONS_TYPE_ANY = 'any';
    const GIFT_WRAPPING_OPTIONS_TYPE_NONE = 'none';
    const GIFT_WRAPPING_OPTIONS_TYPE_LIST = 'list';
    const CONDITION_NEW = 'New';
    const CONDITION_USED = 'Used';
    const CONDITION_REFURBISHED = 'Refurbished';
    const OPEN_GRAPH_TYPE_PRODUCT = 'product';
    const OPEN_GRAPH_TYPE_ALBUM = 'album';
    const OPEN_GRAPH_TYPE_BOOK = 'book';
    const OPEN_GRAPH_TYPE_DRINK = 'drink';
    const OPEN_GRAPH_TYPE_FOOD = 'food';
    const OPEN_GRAPH_TYPE_GAME = 'game';
    const OPEN_GRAPH_TYPE_MOVIE = 'movie';
    const OPEN_GRAPH_TYPE_SONG = 'song';
    const OPEN_GRAPH_TYPE_TV_SHOW = 'tv_show';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_PHYSICAL,
            self::TYPE_DIGITAL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getInventoryTrackingAllowableValues()
    {
        return [
            self::INVENTORY_TRACKING_NONE,
            self::INVENTORY_TRACKING_PRODUCT,
            self::INVENTORY_TRACKING_VARIANT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAvailabilityAllowableValues()
    {
        return [
            self::AVAILABILITY_AVAILABLE,
            self::AVAILABILITY_DISABLED,
            self::AVAILABILITY_PREORDER,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGiftWrappingOptionsTypeAllowableValues()
    {
        return [
            self::GIFT_WRAPPING_OPTIONS_TYPE_ANY,
            self::GIFT_WRAPPING_OPTIONS_TYPE_NONE,
            self::GIFT_WRAPPING_OPTIONS_TYPE_LIST,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getConditionAllowableValues()
    {
        return [
            self::CONDITION_NEW,
            self::CONDITION_USED,
            self::CONDITION_REFURBISHED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOpenGraphTypeAllowableValues()
    {
        return [
            self::OPEN_GRAPH_TYPE_PRODUCT,
            self::OPEN_GRAPH_TYPE_ALBUM,
            self::OPEN_GRAPH_TYPE_BOOK,
            self::OPEN_GRAPH_TYPE_DRINK,
            self::OPEN_GRAPH_TYPE_FOOD,
            self::OPEN_GRAPH_TYPE_GAME,
            self::OPEN_GRAPH_TYPE_MOVIE,
            self::OPEN_GRAPH_TYPE_SONG,
            self::OPEN_GRAPH_TYPE_TV_SHOW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['name'] = array_key_exists('name', $data) ? $data['name'] : null;
        $this->container['type'] = array_key_exists('type', $data) ? $data['type'] : null;
        $this->container['sku'] = array_key_exists('sku', $data) ? $data['sku'] : null;
        $this->container['description'] = array_key_exists('description', $data) ? $data['description'] : null;
        $this->container['weight'] = array_key_exists('weight', $data) ? $data['weight'] : null;
        $this->container['width'] = array_key_exists('width', $data) ? $data['width'] : null;
        $this->container['depth'] = array_key_exists('depth', $data) ? $data['depth'] : null;
        $this->container['height'] = array_key_exists('height', $data) ? $data['height'] : null;
        $this->container['price'] = array_key_exists('price', $data) ? $data['price'] : null;
        $this->container['cost_price'] = array_key_exists('cost_price', $data) ? $data['cost_price'] : null;
        $this->container['retail_price'] = array_key_exists('retail_price', $data) ? $data['retail_price'] : null;
        $this->container['sale_price'] = array_key_exists('sale_price', $data) ? $data['sale_price'] : null;
        $this->container['tax_class_id'] = array_key_exists('tax_class_id', $data) ? $data['tax_class_id'] : null;
        $this->container['product_tax_code'] = array_key_exists('product_tax_code', $data) ? $data['product_tax_code'] : null;
        $this->container['categories'] = array_key_exists('categories', $data) ? $data['categories'] : null;
        $this->container['brand_id'] = array_key_exists('brand_id', $data) ? $data['brand_id'] : null;
        $this->container['inventory_level'] = array_key_exists('inventory_level', $data) ? $data['inventory_level'] : null;
        $this->container['inventory_warning_level'] = array_key_exists('inventory_warning_level', $data) ? $data['inventory_warning_level'] : null;
        $this->container['inventory_tracking'] = array_key_exists('inventory_tracking', $data) ? $data['inventory_tracking'] : null;
        $this->container['fixed_cost_shipping_price'] = array_key_exists('fixed_cost_shipping_price', $data) ? $data['fixed_cost_shipping_price'] : null;
        $this->container['is_free_shipping'] = array_key_exists('is_free_shipping', $data) ? $data['is_free_shipping'] : null;
        $this->container['is_visible'] = array_key_exists('is_visible', $data) ? $data['is_visible'] : null;
        $this->container['is_featured'] = array_key_exists('is_featured', $data) ? $data['is_featured'] : null;
        $this->container['related_products'] = array_key_exists('related_products', $data) ? $data['related_products'] : null;
        $this->container['warranty'] = array_key_exists('warranty', $data) ? $data['warranty'] : null;
        $this->container['bin_picking_number'] = array_key_exists('bin_picking_number', $data) ? $data['bin_picking_number'] : null;
        $this->container['layout_file'] = array_key_exists('layout_file', $data) ? $data['layout_file'] : null;
        $this->container['upc'] = array_key_exists('upc', $data) ? $data['upc'] : null;
        $this->container['search_keywords'] = array_key_exists('search_keywords', $data) ? $data['search_keywords'] : null;
        $this->container['availability'] = array_key_exists('availability', $data) ? $data['availability'] : null;
        $this->container['availability_description'] = array_key_exists('availability_description', $data) ? $data['availability_description'] : null;
        $this->container['gift_wrapping_options_type'] = array_key_exists('gift_wrapping_options_type', $data) ? $data['gift_wrapping_options_type'] : null;
        $this->container['gift_wrapping_options_list'] = array_key_exists('gift_wrapping_options_list', $data) ? $data['gift_wrapping_options_list'] : null;
        $this->container['sort_order'] = array_key_exists('sort_order', $data) ? $data['sort_order'] : null;
        $this->container['condition'] = array_key_exists('condition', $data) ? $data['condition'] : null;
        $this->container['is_condition_shown'] = array_key_exists('is_condition_shown', $data) ? $data['is_condition_shown'] : null;
        $this->container['order_quantity_minimum'] = array_key_exists('order_quantity_minimum', $data) ? $data['order_quantity_minimum'] : null;
        $this->container['order_quantity_maximum'] = array_key_exists('order_quantity_maximum', $data) ? $data['order_quantity_maximum'] : null;
        $this->container['page_title'] = array_key_exists('page_title', $data) ? $data['page_title'] : null;
        $this->container['meta_keywords'] = array_key_exists('meta_keywords', $data) ? $data['meta_keywords'] : null;
        $this->container['meta_description'] = array_key_exists('meta_description', $data) ? $data['meta_description'] : null;
        $this->container['view_count'] = array_key_exists('view_count', $data) ? $data['view_count'] : null;
        $this->container['preorder_release_date'] = array_key_exists('preorder_release_date', $data) ? $data['preorder_release_date'] : null;
        $this->container['preorder_message'] = array_key_exists('preorder_message', $data) ? $data['preorder_message'] : null;
        $this->container['is_preorder_only'] = array_key_exists('is_preorder_only', $data) ? $data['is_preorder_only'] : null;
        $this->container['is_price_hidden'] = array_key_exists('is_price_hidden', $data) ? $data['is_price_hidden'] : null;
        $this->container['price_hidden_label'] = array_key_exists('price_hidden_label', $data) ? $data['price_hidden_label'] : null;
        $this->container['custom_url'] = array_key_exists('custom_url', $data) ? $data['custom_url'] : null;
        $this->container['open_graph_type'] = array_key_exists('open_graph_type', $data) ? $data['open_graph_type'] : null;
        $this->container['open_graph_title'] = array_key_exists('open_graph_title', $data) ? $data['open_graph_title'] : null;
        $this->container['open_graph_description'] = array_key_exists('open_graph_description', $data) ? $data['open_graph_description'] : null;
        $this->container['open_graph_use_meta_description'] = array_key_exists('open_graph_use_meta_description', $data) ? $data['open_graph_use_meta_description'] : null;
        $this->container['open_graph_use_product_name'] = array_key_exists('open_graph_use_product_name', $data) ? $data['open_graph_use_product_name'] : null;
        $this->container['open_graph_use_image'] = array_key_exists('open_graph_use_image', $data) ? $data['open_graph_use_image'] : null;
        $this->container['custom_fields'] = array_key_exists('custom_fields', $data) ? $data['custom_fields'] : null;
        $this->container['bulk_pricing_rules'] = array_key_exists('bulk_pricing_rules', $data) ? $data['bulk_pricing_rules'] : null;
        $this->container['variants'] = array_key_exists('variants', $data) ? $data['variants'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        if (strlen($this->container['name']) > 255) {
            $invalid_properties[] = "invalid value for 'name', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['name']) < 1) {
            $invalid_properties[] = "invalid value for 'name', the character length must be bigger than or equal to 1.";
        }
        $allowed_values = ["physical", "digital"];
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }
        if (strlen($this->container['sku']) > 255) {
            $invalid_properties[] = "invalid value for 'sku', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['sku']) < 0) {
            $invalid_properties[] = "invalid value for 'sku', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['weight'] > 9999999999) {
            $invalid_properties[] = "invalid value for 'weight', must be smaller than or equal to 9999999999.";
        }
        if ($this->container['weight'] < 0) {
            $invalid_properties[] = "invalid value for 'weight', must be bigger than or equal to 0.";
        }
        if ($this->container['width'] > 9999999999) {
            $invalid_properties[] = "invalid value for 'width', must be smaller than or equal to 9999999999.";
        }
        if ($this->container['width'] < 0) {
            $invalid_properties[] = "invalid value for 'width', must be bigger than or equal to 0.";
        }
        if ($this->container['depth'] > 9999999999) {
            $invalid_properties[] = "invalid value for 'depth', must be smaller than or equal to 9999999999.";
        }
        if ($this->container['depth'] < 0) {
            $invalid_properties[] = "invalid value for 'depth', must be bigger than or equal to 0.";
        }
        if ($this->container['height'] > 9999999999) {
            $invalid_properties[] = "invalid value for 'height', must be smaller than or equal to 9999999999.";
        }
        if ($this->container['height'] < 0) {
            $invalid_properties[] = "invalid value for 'height', must be bigger than or equal to 0.";
        }
        if ($this->container['price'] < 0) {
            $invalid_properties[] = "invalid value for 'price', must be bigger than or equal to 0.";
        }
        if ($this->container['cost_price'] < 0) {
            $invalid_properties[] = "invalid value for 'cost_price', must be bigger than or equal to 0.";
        }
        if ($this->container['retail_price'] < 0) {
            $invalid_properties[] = "invalid value for 'retail_price', must be bigger than or equal to 0.";
        }
        if ($this->container['sale_price'] < 0) {
            $invalid_properties[] = "invalid value for 'sale_price', must be bigger than or equal to 0.";
        }
        if ($this->container['tax_class_id'] > 1000000000) {
            $invalid_properties[] = "invalid value for 'tax_class_id', must be smaller than or equal to 1000000000.";
        }
        if ($this->container['tax_class_id'] < 0) {
            $invalid_properties[] = "invalid value for 'tax_class_id', must be bigger than or equal to 0.";
        }
        if (strlen($this->container['product_tax_code']) > 255) {
            $invalid_properties[] = "invalid value for 'product_tax_code', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['product_tax_code']) < 0) {
            $invalid_properties[] = "invalid value for 'product_tax_code', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['brand_id'] > 1000000000) {
            $invalid_properties[] = "invalid value for 'brand_id', must be smaller than or equal to 1000000000.";
        }
        if ($this->container['brand_id'] < 0) {
            $invalid_properties[] = "invalid value for 'brand_id', must be bigger than or equal to 0.";
        }
        if ($this->container['inventory_level'] > 1000000000) {
            $invalid_properties[] = "invalid value for 'inventory_level', must be smaller than or equal to 1000000000.";
        }
        if ($this->container['inventory_level'] < 0) {
            $invalid_properties[] = "invalid value for 'inventory_level', must be bigger than or equal to 0.";
        }
        if ($this->container['inventory_warning_level'] > 1000000000) {
            $invalid_properties[] = "invalid value for 'inventory_warning_level', must be smaller than or equal to 1000000000.";
        }
        if ($this->container['inventory_warning_level'] < 0) {
            $invalid_properties[] = "invalid value for 'inventory_warning_level', must be bigger than or equal to 0.";
        }
        $allowed_values = ["none", "product", "variant"];
        if (!in_array($this->container['inventory_tracking'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'inventory_tracking', must be one of #{allowed_values}.";
        }
        if ($this->container['fixed_cost_shipping_price'] < 0) {
            $invalid_properties[] = "invalid value for 'fixed_cost_shipping_price', must be bigger than or equal to 0.";
        }
        if (strlen($this->container['warranty']) > 65535) {
            $invalid_properties[] = "invalid value for 'warranty', the character length must be smaller than or equal to 65535.";
        }
        if (strlen($this->container['warranty']) < 0) {
            $invalid_properties[] = "invalid value for 'warranty', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['bin_picking_number']) > 255) {
            $invalid_properties[] = "invalid value for 'bin_picking_number', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['bin_picking_number']) < 0) {
            $invalid_properties[] = "invalid value for 'bin_picking_number', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['layout_file']) > 500) {
            $invalid_properties[] = "invalid value for 'layout_file', the character length must be smaller than or equal to 500.";
        }
        if (strlen($this->container['layout_file']) < 0) {
            $invalid_properties[] = "invalid value for 'layout_file', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['upc']) > 255) {
            $invalid_properties[] = "invalid value for 'upc', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['upc']) < 0) {
            $invalid_properties[] = "invalid value for 'upc', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['search_keywords']) > 65535) {
            $invalid_properties[] = "invalid value for 'search_keywords', the character length must be smaller than or equal to 65535.";
        }
        if (strlen($this->container['search_keywords']) < 0) {
            $invalid_properties[] = "invalid value for 'search_keywords', the character length must be bigger than or equal to 0.";
        }
        $allowed_values = ["available", "disabled", "preorder"];
        if (!in_array($this->container['availability'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'availability', must be one of #{allowed_values}.";
        }
        if (strlen($this->container['availability_description']) > 255) {
            $invalid_properties[] = "invalid value for 'availability_description', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['availability_description']) < 0) {
            $invalid_properties[] = "invalid value for 'availability_description', the character length must be bigger than or equal to 0.";
        }
        $allowed_values = ["any", "none", "list"];
        if (!in_array($this->container['gift_wrapping_options_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'gift_wrapping_options_type', must be one of #{allowed_values}.";
        }
        if ($this->container['sort_order'] > 2147483647) {
            $invalid_properties[] = "invalid value for 'sort_order', must be smaller than or equal to 2147483647.";
        }
        if ($this->container['sort_order'] < -2147483648) {
            $invalid_properties[] = "invalid value for 'sort_order', must be bigger than or equal to -2147483648.";
        }
        $allowed_values = ["New", "Used", "Refurbished"];
        if (!in_array($this->container['condition'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'condition', must be one of #{allowed_values}.";
        }
        if ($this->container['order_quantity_minimum'] > 1000000000) {
            $invalid_properties[] = "invalid value for 'order_quantity_minimum', must be smaller than or equal to 1000000000.";
        }
        if ($this->container['order_quantity_minimum'] < 0) {
            $invalid_properties[] = "invalid value for 'order_quantity_minimum', must be bigger than or equal to 0.";
        }
        if ($this->container['order_quantity_maximum'] > 1000000000) {
            $invalid_properties[] = "invalid value for 'order_quantity_maximum', must be smaller than or equal to 1000000000.";
        }
        if ($this->container['order_quantity_maximum'] < 0) {
            $invalid_properties[] = "invalid value for 'order_quantity_maximum', must be bigger than or equal to 0.";
        }
        if (strlen($this->container['page_title']) > 255) {
            $invalid_properties[] = "invalid value for 'page_title', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['page_title']) < 0) {
            $invalid_properties[] = "invalid value for 'page_title', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['meta_description']) > 65535) {
            $invalid_properties[] = "invalid value for 'meta_description', the character length must be smaller than or equal to 65535.";
        }
        if (strlen($this->container['meta_description']) < 0) {
            $invalid_properties[] = "invalid value for 'meta_description', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['view_count'] > 1000000000) {
            $invalid_properties[] = "invalid value for 'view_count', must be smaller than or equal to 1000000000.";
        }
        if ($this->container['view_count'] < 0) {
            $invalid_properties[] = "invalid value for 'view_count', must be bigger than or equal to 0.";
        }
        if (strlen($this->container['preorder_message']) > 255) {
            $invalid_properties[] = "invalid value for 'preorder_message', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['preorder_message']) < 0) {
            $invalid_properties[] = "invalid value for 'preorder_message', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['price_hidden_label']) > 200) {
            $invalid_properties[] = "invalid value for 'price_hidden_label', the character length must be smaller than or equal to 200.";
        }
        if (strlen($this->container['price_hidden_label']) < 0) {
            $invalid_properties[] = "invalid value for 'price_hidden_label', the character length must be bigger than or equal to 0.";
        }
        $allowed_values = ["product", "album", "book", "drink", "food", "game", "movie", "song", "tv_show"];
        if (!in_array($this->container['open_graph_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'open_graph_type', must be one of #{allowed_values}.";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if (strlen($this->container['name']) > 255) {
            return false;
        }
        if (strlen($this->container['name']) < 1) {
            return false;
        }
        $allowed_values = ["physical", "digital"];
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if (strlen($this->container['sku']) > 255) {
            return false;
        }
        if (strlen($this->container['sku']) < 0) {
            return false;
        }
        if ($this->container['weight'] > 9999999999) {
            return false;
        }
        if ($this->container['weight'] < 0) {
            return false;
        }
        if ($this->container['width'] > 9999999999) {
            return false;
        }
        if ($this->container['width'] < 0) {
            return false;
        }
        if ($this->container['depth'] > 9999999999) {
            return false;
        }
        if ($this->container['depth'] < 0) {
            return false;
        }
        if ($this->container['height'] > 9999999999) {
            return false;
        }
        if ($this->container['height'] < 0) {
            return false;
        }
        if ($this->container['price'] < 0) {
            return false;
        }
        if ($this->container['cost_price'] < 0) {
            return false;
        }
        if ($this->container['retail_price'] < 0) {
            return false;
        }
        if ($this->container['sale_price'] < 0) {
            return false;
        }
        if ($this->container['tax_class_id'] > 1000000000) {
            return false;
        }
        if ($this->container['tax_class_id'] < 0) {
            return false;
        }
        if (strlen($this->container['product_tax_code']) > 255) {
            return false;
        }
        if (strlen($this->container['product_tax_code']) < 0) {
            return false;
        }
        if ($this->container['brand_id'] > 1000000000) {
            return false;
        }
        if ($this->container['brand_id'] < 0) {
            return false;
        }
        if ($this->container['inventory_level'] > 1000000000) {
            return false;
        }
        if ($this->container['inventory_level'] < 0) {
            return false;
        }
        if ($this->container['inventory_warning_level'] > 1000000000) {
            return false;
        }
        if ($this->container['inventory_warning_level'] < 0) {
            return false;
        }
        $allowed_values = ["none", "product", "variant"];
        if (!in_array($this->container['inventory_tracking'], $allowed_values)) {
            return false;
        }
        if ($this->container['fixed_cost_shipping_price'] < 0) {
            return false;
        }
        if (strlen($this->container['warranty']) > 65535) {
            return false;
        }
        if (strlen($this->container['warranty']) < 0) {
            return false;
        }
        if (strlen($this->container['bin_picking_number']) > 255) {
            return false;
        }
        if (strlen($this->container['bin_picking_number']) < 0) {
            return false;
        }
        if (strlen($this->container['layout_file']) > 500) {
            return false;
        }
        if (strlen($this->container['layout_file']) < 0) {
            return false;
        }
        if (strlen($this->container['upc']) > 255) {
            return false;
        }
        if (strlen($this->container['upc']) < 0) {
            return false;
        }
        if (strlen($this->container['search_keywords']) > 65535) {
            return false;
        }
        if (strlen($this->container['search_keywords']) < 0) {
            return false;
        }
        $allowed_values = ["available", "disabled", "preorder"];
        if (!in_array($this->container['availability'], $allowed_values)) {
            return false;
        }
        if (strlen($this->container['availability_description']) > 255) {
            return false;
        }
        if (strlen($this->container['availability_description']) < 0) {
            return false;
        }
        $allowed_values = ["any", "none", "list"];
        if (!in_array($this->container['gift_wrapping_options_type'], $allowed_values)) {
            return false;
        }
        if ($this->container['sort_order'] > 2147483647) {
            return false;
        }
        if ($this->container['sort_order'] < -2147483648) {
            return false;
        }
        $allowed_values = ["New", "Used", "Refurbished"];
        if (!in_array($this->container['condition'], $allowed_values)) {
            return false;
        }
        if ($this->container['order_quantity_minimum'] > 1000000000) {
            return false;
        }
        if ($this->container['order_quantity_minimum'] < 0) {
            return false;
        }
        if ($this->container['order_quantity_maximum'] > 1000000000) {
            return false;
        }
        if ($this->container['order_quantity_maximum'] < 0) {
            return false;
        }
        if (strlen($this->container['page_title']) > 255) {
            return false;
        }
        if (strlen($this->container['page_title']) < 0) {
            return false;
        }
        if (strlen($this->container['meta_description']) > 65535) {
            return false;
        }
        if (strlen($this->container['meta_description']) < 0) {
            return false;
        }
        if ($this->container['view_count'] > 1000000000) {
            return false;
        }
        if ($this->container['view_count'] < 0) {
            return false;
        }
        if (strlen($this->container['preorder_message']) > 255) {
            return false;
        }
        if (strlen($this->container['preorder_message']) < 0) {
            return false;
        }
        if (strlen($this->container['price_hidden_label']) > 200) {
            return false;
        }
        if (strlen($this->container['price_hidden_label']) < 0) {
            return false;
        }
        $allowed_values = ["product", "album", "book", "drink", "food", "game", "movie", "song", "tv_show"];
        if (!in_array($this->container['open_graph_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The product name.
     * @return $this
     */
    public function setName($name)
    {
        if (strlen($name) > 255) {
            throw new \InvalidArgumentException('invalid length for $name when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($name) < 1) {
            throw new \InvalidArgumentException('invalid length for $name when calling ProductPost., must be bigger than or equal to 1.');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The product type. One of: `physical` - a physical stock unit, `digital` - a digital download.
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = ['physical', 'digital'];
        if (!is_null($type) && (!in_array($type, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'physical', 'digital'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets sku
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     * @param string $sku User defined product code/stock keeping unit (SKU).
     * @return $this
     */
    public function setSku($sku)
    {
        if (strlen($sku) > 255) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($sku) < 0) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The product description, which can include HTML formatting.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets weight
     * @return double
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     * @param double $weight Weight of the product, which can be used when calculating shipping costs.
     * @return $this
     */
    public function setWeight($weight)
    {

        if ($weight > 9999999999) {
            throw new \InvalidArgumentException('invalid value for $weight when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if ($weight < 0) {
            throw new \InvalidArgumentException('invalid value for $weight when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets width
     * @return double
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     * @param double $width Width of the product, which can be used when calculating shipping costs.
     * @return $this
     */
    public function setWidth($width)
    {

        if ($width > 9999999999) {
            throw new \InvalidArgumentException('invalid value for $width when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if ($width < 0) {
            throw new \InvalidArgumentException('invalid value for $width when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets depth
     * @return double
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     * @param double $depth Depth of the product, which can be used when calculating shipping costs.
     * @return $this
     */
    public function setDepth($depth)
    {

        if ($depth > 9999999999) {
            throw new \InvalidArgumentException('invalid value for $depth when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if ($depth < 0) {
            throw new \InvalidArgumentException('invalid value for $depth when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets height
     * @return double
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     * @param double $height Height of the product, which can be used when calculating shipping costs.
     * @return $this
     */
    public function setHeight($height)
    {

        if ($height > 9999999999) {
            throw new \InvalidArgumentException('invalid value for $height when calling ProductPost., must be smaller than or equal to 9999999999.');
        }
        if ($height < 0) {
            throw new \InvalidArgumentException('invalid value for $height when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets price
     * @return double
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     * @param double $price The price of the product. The price should include or exclude tax, based on the store settings.
     * @return $this
     */
    public function setPrice($price)
    {

        if ($price < 0) {
            throw new \InvalidArgumentException('invalid value for $price when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets cost_price
     * @return double
     */
    public function getCostPrice()
    {
        return $this->container['cost_price'];
    }

    /**
     * Sets cost_price
     * @param double $cost_price The cost price of the product. Stored for reference only; it is not used or displayed anywhere on the store.
     * @return $this
     */
    public function setCostPrice($cost_price)
    {

        if ($cost_price < 0) {
            throw new \InvalidArgumentException('invalid value for $cost_price when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['cost_price'] = $cost_price;

        return $this;
    }

    /**
     * Gets retail_price
     * @return double
     */
    public function getRetailPrice()
    {
        return $this->container['retail_price'];
    }

    /**
     * Sets retail_price
     * @param double $retail_price The retail cost of the product. If entered, the retail cost price will be shown on the product page.
     * @return $this
     */
    public function setRetailPrice($retail_price)
    {

        if ($retail_price < 0) {
            throw new \InvalidArgumentException('invalid value for $retail_price when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['retail_price'] = $retail_price;

        return $this;
    }

    /**
     * Gets sale_price
     * @return double
     */
    public function getSalePrice()
    {
        return $this->container['sale_price'];
    }

    /**
     * Sets sale_price
     * @param double $sale_price If entered, the sale price will be used instead of value in the price field when calculating the product's cost.
     * @return $this
     */
    public function setSalePrice($sale_price)
    {

        if ($sale_price < 0) {
            throw new \InvalidArgumentException('invalid value for $sale_price when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['sale_price'] = $sale_price;

        return $this;
    }

    /**
     * Gets tax_class_id
     * @return int
     */
    public function getTaxClassId()
    {
        return $this->container['tax_class_id'];
    }

    /**
     * Sets tax_class_id
     * @param int $tax_class_id The ID of the tax class applied to the product. (NOTE: Value ignored if automatic tax is enabled.)
     * @return $this
     */
    public function setTaxClassId($tax_class_id)
    {

        if ($tax_class_id > 1000000000) {
            throw new \InvalidArgumentException('invalid value for $tax_class_id when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if ($tax_class_id < 0) {
            throw new \InvalidArgumentException('invalid value for $tax_class_id when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['tax_class_id'] = $tax_class_id;

        return $this;
    }

    /**
     * Gets product_tax_code
     * @return string
     */
    public function getProductTaxCode()
    {
        return $this->container['product_tax_code'];
    }

    /**
     * Sets product_tax_code
     * @param string $product_tax_code Accepts AvaTax System Tax Codes, which identify products and services that fall into special sales-tax categories. By using these codes, merchants who subscribe to BigCommerce's Avalara Premium integration can calculate sales taxes more accurately. Stores without Avalara Premium will ignore the code when calculating sales tax. Do not pass more than one code. The codes are case-sensitive. For details, please see Avalara's documentation.
     * @return $this
     */
    public function setProductTaxCode($product_tax_code)
    {
        if (strlen($product_tax_code) > 255) {
            throw new \InvalidArgumentException('invalid length for $product_tax_code when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($product_tax_code) < 0) {
            throw new \InvalidArgumentException('invalid length for $product_tax_code when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['product_tax_code'] = $product_tax_code;

        return $this;
    }

    /**
     * Gets categories
     * @return int[]
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     * @param int[] $categories An array of IDs for the categories to which this product belongs. When updating a product, if an array of categories is supplied, all product categories will be overwritten. Does not accept more than 1,000 ID values.
     * @return $this
     */
    public function setCategories($categories)
    {
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets brand_id
     * @return int
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     * @param int $brand_id The ID associated with the product's brand.
     * @return $this
     */
    public function setBrandId($brand_id)
    {

        if ($brand_id > 1000000000) {
            throw new \InvalidArgumentException('invalid value for $brand_id when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if ($brand_id < 0) {
            throw new \InvalidArgumentException('invalid value for $brand_id when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets inventory_level
     * @return int
     */
    public function getInventoryLevel()
    {
        return $this->container['inventory_level'];
    }

    /**
     * Sets inventory_level
     * @param int $inventory_level Current inventory level of the product. Simple inventory tracking must be enabled (See the `inventory_tracking` field) for this to take any effect.
     * @return $this
     */
    public function setInventoryLevel($inventory_level)
    {

        if ($inventory_level > 1000000000) {
            throw new \InvalidArgumentException('invalid value for $inventory_level when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if ($inventory_level < 0) {
            throw new \InvalidArgumentException('invalid value for $inventory_level when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['inventory_level'] = $inventory_level;

        return $this;
    }

    /**
     * Gets inventory_warning_level
     * @return int
     */
    public function getInventoryWarningLevel()
    {
        return $this->container['inventory_warning_level'];
    }

    /**
     * Sets inventory_warning_level
     * @param int $inventory_warning_level Inventory warning level for the product. When the product's inventory level drops below the warning level, the store owner will be informed. Simple inventory tracking must be enabled (see the `inventory_tracking` field) for this to take any effect.
     * @return $this
     */
    public function setInventoryWarningLevel($inventory_warning_level)
    {

        if ($inventory_warning_level > 1000000000) {
            throw new \InvalidArgumentException('invalid value for $inventory_warning_level when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if ($inventory_warning_level < 0) {
            throw new \InvalidArgumentException('invalid value for $inventory_warning_level when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['inventory_warning_level'] = $inventory_warning_level;

        return $this;
    }

    /**
     * Gets inventory_tracking
     * @return string
     */
    public function getInventoryTracking()
    {
        return $this->container['inventory_tracking'];
    }

    /**
     * Sets inventory_tracking
     * @param string $inventory_tracking The type of inventory tracking for the product. Values are: `none` - inventory levels will not be tracked; `product` - inventory levels will be tracked using the `inventory_level` and `inventory_warning_level` fields; `variant` - inventory levels will be tracked based on variants, which maintain their own warning levels and inventory levels.
     * @return $this
     */
    public function setInventoryTracking($inventory_tracking)
    {
        $allowed_values = ['none', 'product', 'variant'];
        if (!is_null($inventory_tracking) && (!in_array($inventory_tracking, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'inventory_tracking', must be one of 'none', 'product', 'variant'");
        }
        $this->container['inventory_tracking'] = $inventory_tracking;

        return $this;
    }

    /**
     * Gets fixed_cost_shipping_price
     * @return double
     */
    public function getFixedCostShippingPrice()
    {
        return $this->container['fixed_cost_shipping_price'];
    }

    /**
     * Sets fixed_cost_shipping_price
     * @param double $fixed_cost_shipping_price A fixed shipping cost for the product. If defined, this value will be used during checkout instead of normal shipping-cost calculation.
     * @return $this
     */
    public function setFixedCostShippingPrice($fixed_cost_shipping_price)
    {

        if ($fixed_cost_shipping_price < 0) {
            throw new \InvalidArgumentException('invalid value for $fixed_cost_shipping_price when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['fixed_cost_shipping_price'] = $fixed_cost_shipping_price;

        return $this;
    }

    /**
     * Gets is_free_shipping
     * @return bool
     */
    public function getIsFreeShipping()
    {
        return $this->container['is_free_shipping'];
    }

    /**
     * Sets is_free_shipping
     * @param bool $is_free_shipping Flag used to indicate whether the product has free shipping. If `true`, the shipping cost for the product will be zero.
     * @return $this
     */
    public function setIsFreeShipping($is_free_shipping)
    {
        $this->container['is_free_shipping'] = $is_free_shipping;

        return $this;
    }

    /**
     * Gets is_visible
     * @return bool
     */
    public function getIsVisible()
    {
        return $this->container['is_visible'];
    }

    /**
     * Sets is_visible
     * @param bool $is_visible Flag to determine whether the product should be displayed to customers browsing the store. If `true`, the product will be displayed. If `false`, the product will be hidden from view.
     * @return $this
     */
    public function setIsVisible($is_visible)
    {
        $this->container['is_visible'] = $is_visible;

        return $this;
    }

    /**
     * Gets is_featured
     * @return bool
     */
    public function getIsFeatured()
    {
        return $this->container['is_featured'];
    }

    /**
     * Sets is_featured
     * @param bool $is_featured Flag to determine whether the product should be included in the `featured products` panel when viewing the store.
     * @return $this
     */
    public function setIsFeatured($is_featured)
    {
        $this->container['is_featured'] = $is_featured;

        return $this;
    }

    /**
     * Gets related_products
     * @return int[]
     */
    public function getRelatedProducts()
    {
        return $this->container['related_products'];
    }

    /**
     * Sets related_products
     * @param int[] $related_products An array of IDs for the related products.
     * @return $this
     */
    public function setRelatedProducts($related_products)
    {
        $this->container['related_products'] = $related_products;

        return $this;
    }

    /**
     * Gets warranty
     * @return string
     */
    public function getWarranty()
    {
        return $this->container['warranty'];
    }

    /**
     * Sets warranty
     * @param string $warranty Warranty information displayed on the product page. Can include HTML formatting.
     * @return $this
     */
    public function setWarranty($warranty)
    {
        if (strlen($warranty) > 65535) {
            throw new \InvalidArgumentException('invalid length for $warranty when calling ProductPost., must be smaller than or equal to 65535.');
        }
        if (strlen($warranty) < 0) {
            throw new \InvalidArgumentException('invalid length for $warranty when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['warranty'] = $warranty;

        return $this;
    }

    /**
     * Gets bin_picking_number
     * @return string
     */
    public function getBinPickingNumber()
    {
        return $this->container['bin_picking_number'];
    }

    /**
     * Sets bin_picking_number
     * @param string $bin_picking_number The BIN picking number for the product.
     * @return $this
     */
    public function setBinPickingNumber($bin_picking_number)
    {
        if (strlen($bin_picking_number) > 255) {
            throw new \InvalidArgumentException('invalid length for $bin_picking_number when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($bin_picking_number) < 0) {
            throw new \InvalidArgumentException('invalid length for $bin_picking_number when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['bin_picking_number'] = $bin_picking_number;

        return $this;
    }

    /**
     * Gets layout_file
     * @return string
     */
    public function getLayoutFile()
    {
        return $this->container['layout_file'];
    }

    /**
     * Sets layout_file
     * @param string $layout_file The layout template file used to render this product.
     * @return $this
     */
    public function setLayoutFile($layout_file)
    {
        if (strlen($layout_file) > 500) {
            throw new \InvalidArgumentException('invalid length for $layout_file when calling ProductPost., must be smaller than or equal to 500.');
        }
        if (strlen($layout_file) < 0) {
            throw new \InvalidArgumentException('invalid length for $layout_file when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['layout_file'] = $layout_file;

        return $this;
    }

    /**
     * Gets upc
     * @return string
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     * @param string $upc The product UPC code, which is used in feeds for shopping comparison sites and external channel integrations.
     * @return $this
     */
    public function setUpc($upc)
    {
        if (strlen($upc) > 255) {
            throw new \InvalidArgumentException('invalid length for $upc when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($upc) < 0) {
            throw new \InvalidArgumentException('invalid length for $upc when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets search_keywords
     * @return string
     */
    public function getSearchKeywords()
    {
        return $this->container['search_keywords'];
    }

    /**
     * Sets search_keywords
     * @param string $search_keywords A comma-separated list of keywords that can be used to locate the product when searching the store.
     * @return $this
     */
    public function setSearchKeywords($search_keywords)
    {
        if (strlen($search_keywords) > 65535) {
            throw new \InvalidArgumentException('invalid length for $search_keywords when calling ProductPost., must be smaller than or equal to 65535.');
        }
        if (strlen($search_keywords) < 0) {
            throw new \InvalidArgumentException('invalid length for $search_keywords when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['search_keywords'] = $search_keywords;

        return $this;
    }

    /**
     * Gets availability
     * @return string
     */
    public function getAvailability()
    {
        return $this->container['availability'];
    }

    /**
     * Sets availability
     * @param string $availability Availability of the product. Availability options are: `available` - the product can be purchased on the storefront; `disabled` - the product is listed in the storefront, but cannot be purchased; `preorder` - the product is listed for pre-orders.
     * @return $this
     */
    public function setAvailability($availability)
    {
        $allowed_values = ['available', 'disabled', 'preorder'];
        if (!is_null($availability) && (!in_array($availability, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'availability', must be one of 'available', 'disabled', 'preorder'");
        }
        $this->container['availability'] = $availability;

        return $this;
    }

    /**
     * Gets availability_description
     * @return string
     */
    public function getAvailabilityDescription()
    {
        return $this->container['availability_description'];
    }

    /**
     * Sets availability_description
     * @param string $availability_description Availability text displayed on the checkout page, under the product title. Tells the customer how long it will normally take to ship this product, such as: 'Usually ships in 24 hours.'
     * @return $this
     */
    public function setAvailabilityDescription($availability_description)
    {
        if (strlen($availability_description) > 255) {
            throw new \InvalidArgumentException('invalid length for $availability_description when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($availability_description) < 0) {
            throw new \InvalidArgumentException('invalid length for $availability_description when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['availability_description'] = $availability_description;

        return $this;
    }

    /**
     * Gets gift_wrapping_options_type
     * @return string
     */
    public function getGiftWrappingOptionsType()
    {
        return $this->container['gift_wrapping_options_type'];
    }

    /**
     * Sets gift_wrapping_options_type
     * @param string $gift_wrapping_options_type Type of gift-wrapping options. Values: `any` - allow any gift-wrapping options in the store; `none` - disallow gift-wrapping on the product; `list` – provide a list of IDs in the `gift_wrapping_options_list` field.
     * @return $this
     */
    public function setGiftWrappingOptionsType($gift_wrapping_options_type)
    {
        $allowed_values = ['any', 'none', 'list'];
        if (!is_null($gift_wrapping_options_type) && (!in_array($gift_wrapping_options_type, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'gift_wrapping_options_type', must be one of 'any', 'none', 'list'");
        }
        $this->container['gift_wrapping_options_type'] = $gift_wrapping_options_type;

        return $this;
    }

    /**
     * Gets gift_wrapping_options_list
     * @return int[]
     */
    public function getGiftWrappingOptionsList()
    {
        return $this->container['gift_wrapping_options_list'];
    }

    /**
     * Sets gift_wrapping_options_list
     * @param int[] $gift_wrapping_options_list A list of gift-wrapping option IDs.
     * @return $this
     */
    public function setGiftWrappingOptionsList($gift_wrapping_options_list)
    {
        $this->container['gift_wrapping_options_list'] = $gift_wrapping_options_list;

        return $this;
    }

    /**
     * Gets sort_order
     * @return int
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     * @param int $sort_order Priority to give this product when included in product lists on category pages and in search results. Lower integers will place the product closer to the top of the results.
     * @return $this
     */
    public function setSortOrder($sort_order)
    {

        if ($sort_order > 2147483647) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ProductPost., must be smaller than or equal to 2147483647.');
        }
        if ($sort_order < -2147483648) {
            throw new \InvalidArgumentException('invalid value for $sort_order when calling ProductPost., must be bigger than or equal to -2147483648.');
        }
        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets condition
     * @return string
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     * @param string $condition The product condition. Will be shown on the product page if the `is_condition_shown` field's value is `true`. Possible values: `New`, `Used`, `Refurbished`.
     * @return $this
     */
    public function setCondition($condition)
    {
        $allowed_values = ['New', 'Used', 'Refurbished'];
        if (!is_null($condition) && (!in_array($condition, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'condition', must be one of 'New', 'Used', 'Refurbished'");
        }
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets is_condition_shown
     * @return bool
     */
    public function getIsConditionShown()
    {
        return $this->container['is_condition_shown'];
    }

    /**
     * Sets is_condition_shown
     * @param bool $is_condition_shown Flag used to determine whether the product condition is shown to the customer on the product page.
     * @return $this
     */
    public function setIsConditionShown($is_condition_shown)
    {
        $this->container['is_condition_shown'] = $is_condition_shown;

        return $this;
    }

    /**
     * Gets order_quantity_minimum
     * @return int
     */
    public function getOrderQuantityMinimum()
    {
        return $this->container['order_quantity_minimum'];
    }

    /**
     * Sets order_quantity_minimum
     * @param int $order_quantity_minimum The minimum quantity an order must contain, to be eligible to purchase this product.
     * @return $this
     */
    public function setOrderQuantityMinimum($order_quantity_minimum)
    {

        if ($order_quantity_minimum > 1000000000) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_minimum when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if ($order_quantity_minimum < 0) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_minimum when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['order_quantity_minimum'] = $order_quantity_minimum;

        return $this;
    }

    /**
     * Gets order_quantity_maximum
     * @return int
     */
    public function getOrderQuantityMaximum()
    {
        return $this->container['order_quantity_maximum'];
    }

    /**
     * Sets order_quantity_maximum
     * @param int $order_quantity_maximum The maximum quantity an order can contain when purchasing the product.
     * @return $this
     */
    public function setOrderQuantityMaximum($order_quantity_maximum)
    {

        if ($order_quantity_maximum > 1000000000) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_maximum when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if ($order_quantity_maximum < 0) {
            throw new \InvalidArgumentException('invalid value for $order_quantity_maximum when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['order_quantity_maximum'] = $order_quantity_maximum;

        return $this;
    }

    /**
     * Gets page_title
     * @return string
     */
    public function getPageTitle()
    {
        return $this->container['page_title'];
    }

    /**
     * Sets page_title
     * @param string $page_title Custom title for the product page. If not defined, the product name will be used as the meta title.
     * @return $this
     */
    public function setPageTitle($page_title)
    {
        if (strlen($page_title) > 255) {
            throw new \InvalidArgumentException('invalid length for $page_title when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($page_title) < 0) {
            throw new \InvalidArgumentException('invalid length for $page_title when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['page_title'] = $page_title;

        return $this;
    }

    /**
     * Gets meta_keywords
     * @return string[]
     */
    public function getMetaKeywords()
    {
        return $this->container['meta_keywords'];
    }

    /**
     * Sets meta_keywords
     * @param string[] $meta_keywords Custom meta keywords for the product page. If not defined, the store's default keywords will be used.
     * @return $this
     */
    public function setMetaKeywords($meta_keywords)
    {
        $this->container['meta_keywords'] = $meta_keywords;

        return $this;
    }

    /**
     * Gets meta_description
     * @return string
     */
    public function getMetaDescription()
    {
        return $this->container['meta_description'];
    }

    /**
     * Sets meta_description
     * @param string $meta_description Custom meta description for the product page. If not defined, the store's default meta description will be used.
     * @return $this
     */
    public function setMetaDescription($meta_description)
    {
        if (strlen($meta_description) > 65535) {
            throw new \InvalidArgumentException('invalid length for $meta_description when calling ProductPost., must be smaller than or equal to 65535.');
        }
        if (strlen($meta_description) < 0) {
            throw new \InvalidArgumentException('invalid length for $meta_description when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['meta_description'] = $meta_description;

        return $this;
    }

    /**
     * Gets view_count
     * @return int
     */
    public function getViewCount()
    {
        return $this->container['view_count'];
    }

    /**
     * Sets view_count
     * @param int $view_count The number of times the product has been viewed.
     * @return $this
     */
    public function setViewCount($view_count)
    {

        if ($view_count > 1000000000) {
            throw new \InvalidArgumentException('invalid value for $view_count when calling ProductPost., must be smaller than or equal to 1000000000.');
        }
        if ($view_count < 0) {
            throw new \InvalidArgumentException('invalid value for $view_count when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['view_count'] = $view_count;

        return $this;
    }

    /**
     * Gets preorder_release_date
     * @return \DateTime
     */
    public function getPreorderReleaseDate()
    {
        return $this->container['preorder_release_date'];
    }

    /**
     * Sets preorder_release_date
     * @param \DateTime $preorder_release_date Pre-order release date. See the `availability` field for details on setting a product's availability to accept pre-orders.
     * @return $this
     */
    public function setPreorderReleaseDate($preorder_release_date)
    {
        $this->container['preorder_release_date'] = $preorder_release_date;

        return $this;
    }

    /**
     * Gets preorder_message
     * @return string
     */
    public function getPreorderMessage()
    {
        return $this->container['preorder_message'];
    }

    /**
     * Sets preorder_message
     * @param string $preorder_message Custom expected-date message to display on the product page. If undefined, the message defaults to the storewide setting. Can contain the `%%DATE%%` placeholder, which will be substituted for the release date.
     * @return $this
     */
    public function setPreorderMessage($preorder_message)
    {
        if (strlen($preorder_message) > 255) {
            throw new \InvalidArgumentException('invalid length for $preorder_message when calling ProductPost., must be smaller than or equal to 255.');
        }
        if (strlen($preorder_message) < 0) {
            throw new \InvalidArgumentException('invalid length for $preorder_message when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['preorder_message'] = $preorder_message;

        return $this;
    }

    /**
     * Gets is_preorder_only
     * @return bool
     */
    public function getIsPreorderOnly()
    {
        return $this->container['is_preorder_only'];
    }

    /**
     * Sets is_preorder_only
     * @param bool $is_preorder_only If set to `false`, the product will not change its availability from `preorder` to `available` on the release date. Otherwise, on the release date the product's availability/status will change to `available`.
     * @return $this
     */
    public function setIsPreorderOnly($is_preorder_only)
    {
        $this->container['is_preorder_only'] = $is_preorder_only;

        return $this;
    }

    /**
     * Gets is_price_hidden
     * @return bool
     */
    public function getIsPriceHidden()
    {
        return $this->container['is_price_hidden'];
    }

    /**
     * Sets is_price_hidden
     * @param bool $is_price_hidden False by default, indicating that this product's price should be shown on the product page. If set to `true`, the price is hidden. (NOTE: To successfully set `is_price_hidden` to `true`, the `availability` value must be `disabled`.)
     * @return $this
     */
    public function setIsPriceHidden($is_price_hidden)
    {
        $this->container['is_price_hidden'] = $is_price_hidden;

        return $this;
    }

    /**
     * Gets price_hidden_label
     * @return string
     */
    public function getPriceHiddenLabel()
    {
        return $this->container['price_hidden_label'];
    }

    /**
     * Sets price_hidden_label
     * @param string $price_hidden_label By default, an empty string. If `is_price_hidden` is `true`, the value of `price_hidden_label` is displayed instead of the price. (NOTE: To successfully set a non-empty string value with `is_price_hidden` set to `true`, the `availability` value must be `disabled`.)
     * @return $this
     */
    public function setPriceHiddenLabel($price_hidden_label)
    {
        if (strlen($price_hidden_label) > 200) {
            throw new \InvalidArgumentException('invalid length for $price_hidden_label when calling ProductPost., must be smaller than or equal to 200.');
        }
        if (strlen($price_hidden_label) < 0) {
            throw new \InvalidArgumentException('invalid length for $price_hidden_label when calling ProductPost., must be bigger than or equal to 0.');
        }
        $this->container['price_hidden_label'] = $price_hidden_label;

        return $this;
    }

    /**
     * Gets custom_url
     * @return \BigCommerce\Api\v3\Model\CustomUrlProduct
     */
    public function getCustomUrl()
    {
        return $this->container['custom_url'];
    }

    /**
     * Sets custom_url
     * @param \BigCommerce\Api\v3\Model\CustomUrlProduct $custom_url
     * @return $this
     */
    public function setCustomUrl($custom_url)
    {
        $this->container['custom_url'] = $custom_url;

        return $this;
    }

    /**
     * Gets open_graph_type
     * @return string
     */
    public function getOpenGraphType()
    {
        return $this->container['open_graph_type'];
    }

    /**
     * Sets open_graph_type
     * @param string $open_graph_type Type of product, defaults to `product`.
     * @return $this
     */
    public function setOpenGraphType($open_graph_type)
    {
        $allowed_values = ['product', 'album', 'book', 'drink', 'food', 'game', 'movie', 'song', 'tv_show'];
        if (!is_null($open_graph_type) && (!in_array($open_graph_type, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'open_graph_type', must be one of 'product', 'album', 'book', 'drink', 'food', 'game', 'movie', 'song', 'tv_show'");
        }
        $this->container['open_graph_type'] = $open_graph_type;

        return $this;
    }

    /**
     * Gets open_graph_title
     * @return string
     */
    public function getOpenGraphTitle()
    {
        return $this->container['open_graph_title'];
    }

    /**
     * Sets open_graph_title
     * @param string $open_graph_title Title of the product, if not specified the product name will be used instead.
     * @return $this
     */
    public function setOpenGraphTitle($open_graph_title)
    {
        $this->container['open_graph_title'] = $open_graph_title;

        return $this;
    }

    /**
     * Gets open_graph_description
     * @return string
     */
    public function getOpenGraphDescription()
    {
        return $this->container['open_graph_description'];
    }

    /**
     * Sets open_graph_description
     * @param string $open_graph_description Description to use for the product, if not specified then the meta_description will be used instead.
     * @return $this
     */
    public function setOpenGraphDescription($open_graph_description)
    {
        $this->container['open_graph_description'] = $open_graph_description;

        return $this;
    }

    /**
     * Gets open_graph_use_meta_description
     * @return bool
     */
    public function getOpenGraphUseMetaDescription()
    {
        return $this->container['open_graph_use_meta_description'];
    }

    /**
     * Sets open_graph_use_meta_description
     * @param bool $open_graph_use_meta_description Flag to determine if product description or open graph description is used.
     * @return $this
     */
    public function setOpenGraphUseMetaDescription($open_graph_use_meta_description)
    {
        $this->container['open_graph_use_meta_description'] = $open_graph_use_meta_description;

        return $this;
    }

    /**
     * Gets open_graph_use_product_name
     * @return bool
     */
    public function getOpenGraphUseProductName()
    {
        return $this->container['open_graph_use_product_name'];
    }

    /**
     * Sets open_graph_use_product_name
     * @param bool $open_graph_use_product_name Flag to determine if product name or open graph name is used.
     * @return $this
     */
    public function setOpenGraphUseProductName($open_graph_use_product_name)
    {
        $this->container['open_graph_use_product_name'] = $open_graph_use_product_name;

        return $this;
    }

    /**
     * Gets open_graph_use_image
     * @return bool
     */
    public function getOpenGraphUseImage()
    {
        return $this->container['open_graph_use_image'];
    }

    /**
     * Sets open_graph_use_image
     * @param bool $open_graph_use_image Flag to determine if product image or open graph image is used.
     * @return $this
     */
    public function setOpenGraphUseImage($open_graph_use_image)
    {
        $this->container['open_graph_use_image'] = $open_graph_use_image;

        return $this;
    }

    /**
     * Gets custom_fields
     * @return \BigCommerce\Api\v3\Model\CustomFieldPost[]
     */
    public function getCustomFields()
    {
        return $this->container['custom_fields'];
    }

    /**
     * Sets custom_fields
     * @param \BigCommerce\Api\v3\Model\CustomFieldPost[] $custom_fields
     * @return $this
     */
    public function setCustomFields($custom_fields)
    {
        $this->container['custom_fields'] = $custom_fields;

        return $this;
    }

    /**
     * Gets bulk_pricing_rules
     * @return \BigCommerce\Api\v3\Model\BulkPricingRulePost[]
     */
    public function getBulkPricingRules()
    {
        return $this->container['bulk_pricing_rules'];
    }

    /**
     * Sets bulk_pricing_rules
     * @param \BigCommerce\Api\v3\Model\BulkPricingRulePost[] $bulk_pricing_rules
     * @return $this
     */
    public function setBulkPricingRules($bulk_pricing_rules)
    {
        $this->container['bulk_pricing_rules'] = $bulk_pricing_rules;

        return $this;
    }

    /**
     * Gets variants
     * @return \BigCommerce\Api\v3\Model\VariantProductPost[]
     */
    public function getVariants()
    {
        return $this->container['variants'];
    }

    /**
     * Sets variants
     * @param \BigCommerce\Api\v3\Model\VariantProductPost[] $variants
     * @return $this
     */
    public function setVariants($variants)
    {
        $this->container['variants'] = $variants;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


