<?php
/**
 * PlacementRequest
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce Widgets API
 *
 * Widgets API allows developers to inject content into a BigCommerce theme.
 *
 * OpenAPI spec version: 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class PlacementRequest implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PlacementRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'widget_uuid' => 'string',
        'entity_id' => 'string',
        'sort_order' => 'int',
        'region' => 'string',
        'template_file' => 'string',
        'status' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'widget_uuid' => 'widget_uuid',
        'entity_id' => 'entity_id',
        'sort_order' => 'sort_order',
        'region' => 'region',
        'template_file' => 'template_file',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'widget_uuid' => 'setWidgetUuid',
        'entity_id' => 'setEntityId',
        'sort_order' => 'setSortOrder',
        'region' => 'setRegion',
        'template_file' => 'setTemplateFile',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'widget_uuid' => 'getWidgetUuid',
        'entity_id' => 'getEntityId',
        'sort_order' => 'getSortOrder',
        'region' => 'getRegion',
        'template_file' => 'getTemplateFile',
        'status' => 'getStatus'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_INACTIVE = 'inactive';
    const STATUS_ACTIVE = 'active';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_INACTIVE,
            self::STATUS_ACTIVE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['widget_uuid'] = array_key_exists('widget_uuid', $data) ? $data['widget_uuid'] : null;
        $this->container['entity_id'] = array_key_exists('entity_id', $data) ? $data['entity_id'] : null;
        $this->container['sort_order'] = array_key_exists('sort_order', $data) ? $data['sort_order'] : null;
        $this->container['region'] = array_key_exists('region', $data) ? $data['region'] : null;
        $this->container['template_file'] = array_key_exists('template_file', $data) ? $data['template_file'] : null;
        $this->container['status'] = array_key_exists('status', $data) ? $data['status'] : 'inactive';
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        if ($this->container['widget_uuid'] === null) {
            $invalid_properties[] = "'widget_uuid' can't be null";
        }
        if ($this->container['template_file'] === null) {
            $invalid_properties[] = "'template_file' can't be null";
        }
        $allowed_values = ["inactive", "active"];
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['widget_uuid'] === null) {
            return false;
        }
        if ($this->container['template_file'] === null) {
            return false;
        }
        $allowed_values = ["inactive", "active"];
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets widget_uuid
     * @return string
     */
    public function getWidgetUuid()
    {
        return $this->container['widget_uuid'];
    }

    /**
     * Sets widget_uuid
     * @param string $widget_uuid A widget identifier.
     * @return $this
     */
    public function setWidgetUuid($widget_uuid)
    {
        $this->container['widget_uuid'] = $widget_uuid;

        return $this;
    }

    /**
     * Gets entity_id
     * @return string
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     * @param string $entity_id The specific instance of a page that you would like to target.
     * @return $this
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets sort_order
     * @return int
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     * @param int $sort_order The sort order to control the position of a content widget in a region.
     * @return $this
     */
    public function setSortOrder($sort_order)
    {
        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets region
     * @return string
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     * @param string $region The name of the region in which to insert content widgets.
     * @return $this
     */
    public function setRegion($region)
    {
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets template_file
     * @return string
     */
    public function getTemplateFile()
    {
        return $this->container['template_file'];
    }

    /**
     * Sets template_file
     * @param string $template_file The template file that you would like to target.
     * @return $this
     */
    public function setTemplateFile($template_file)
    {
        $this->container['template_file'] = $template_file;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status Sets the placement as either inactive or active.
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = ['inactive', 'active'];
        if (!is_null($status) && (!in_array($status, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'inactive', 'active'");
        }
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


