<?php
/**
 * GiftCertificate
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class GiftCertificate implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'GiftCertificate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'code' => 'string',
        'original_balance' => 'float',
        'starting_balance' => 'float',
        'remaining_balance' => 'float',
        'status' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'code' => 'code',
        'original_balance' => 'original_balance',
        'starting_balance' => 'starting_balance',
        'remaining_balance' => 'remaining_balance',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'code' => 'setCode',
        'original_balance' => 'setOriginalBalance',
        'starting_balance' => 'setStartingBalance',
        'remaining_balance' => 'setRemainingBalance',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'code' => 'getCode',
        'original_balance' => 'getOriginalBalance',
        'starting_balance' => 'getStartingBalance',
        'remaining_balance' => 'getRemainingBalance',
        'status' => 'getStatus'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_ACTIVE = 'active';
    const STATUS_PENDING = 'pending';
    const STATUS_DISABLED = 'disabled';
    const STATUS_EXPIRED = 'expired';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_ACTIVE,
            self::STATUS_PENDING,
            self::STATUS_DISABLED,
            self::STATUS_EXPIRED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['code'] = array_key_exists('code', $data) ? $data['code'] : null;
        $this->container['original_balance'] = array_key_exists('original_balance', $data) ? $data['original_balance'] : null;
        $this->container['starting_balance'] = array_key_exists('starting_balance', $data) ? $data['starting_balance'] : null;
        $this->container['remaining_balance'] = array_key_exists('remaining_balance', $data) ? $data['remaining_balance'] : null;
        $this->container['status'] = array_key_exists('status', $data) ? $data['status'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        $allowed_values = ["active", "pending", "disabled", "expired"];
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = ["active", "pending", "disabled", "expired"];
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets code
     * @return string
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     * @param string $code The gift-certificate code.
     * @return $this
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets original_balance
     * @return float
     */
    public function getOriginalBalance()
    {
        return $this->container['original_balance'];
    }

    /**
     * Sets original_balance
     * @param float $original_balance The balance on a gift certificate when it was purchased.
     * @return $this
     */
    public function setOriginalBalance($original_balance)
    {
        $this->container['original_balance'] = $original_balance;

        return $this;
    }

    /**
     * Gets starting_balance
     * @return float
     */
    public function getStartingBalance()
    {
        return $this->container['starting_balance'];
    }

    /**
     * Sets starting_balance
     * @param float $starting_balance The balance on a gift certificate at the time of this purchase.
     * @return $this
     */
    public function setStartingBalance($starting_balance)
    {
        $this->container['starting_balance'] = $starting_balance;

        return $this;
    }

    /**
     * Gets remaining_balance
     * @return float
     */
    public function getRemainingBalance()
    {
        return $this->container['remaining_balance'];
    }

    /**
     * Sets remaining_balance
     * @param float $remaining_balance The remaining balance on a gift certificate.
     * @return $this
     */
    public function setRemainingBalance($remaining_balance)
    {
        $this->container['remaining_balance'] = $remaining_balance;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of a gift certificate: `active` - gift certificate is active; `pending` - gift certificate purchase is pending; `disabled` - gift certificate is disabled; `expired` - gift certificate is expired.
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = ['active', 'pending', 'disabled', 'expired'];
        if (!is_null($status) && (!in_array($status, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'active', 'pending', 'disabled', 'expired'");
        }
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


