<?php
/**
 * CustomerAttributeValueForCustomer
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class CustomerAttributeValueForCustomer implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Customer Attribute Value For Customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'attribute_id' => 'int',
        'attribute_value' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'attribute_id' => 'attribute_id',
        'attribute_value' => 'attribute_value'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'attribute_id' => 'setAttributeId',
        'attribute_value' => 'setAttributeValue'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'attribute_id' => 'getAttributeId',
        'attribute_value' => 'getAttributeValue'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['attribute_id'] = array_key_exists('attribute_id', $data) ? $data['attribute_id'] : null;
        $this->container['attribute_value'] = array_key_exists('attribute_value', $data) ? $data['attribute_value'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        if ($this->container['attribute_id'] === null) {
            $invalid_properties[] = "'attribute_id' can't be null";
        }
        if ($this->container['attribute_value'] === null) {
            $invalid_properties[] = "'attribute_value' can't be null";
        }
        if (strlen($this->container['attribute_value']) > 255) {
            $invalid_properties[] = "invalid value for 'attribute_value', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['attribute_value']) < 0) {
            $invalid_properties[] = "invalid value for 'attribute_value', the character length must be bigger than or equal to 0.";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['attribute_id'] === null) {
            return false;
        }
        if ($this->container['attribute_value'] === null) {
            return false;
        }
        if (strlen($this->container['attribute_value']) > 255) {
            return false;
        }
        if (strlen($this->container['attribute_value']) < 0) {
            return false;
        }
        return true;
    }


    /**
     * Gets attribute_id
     * @return int
     */
    public function getAttributeId()
    {
        return $this->container['attribute_id'];
    }

    /**
     * Sets attribute_id
     * @param int $attribute_id Attribute ID.
     * @return $this
     */
    public function setAttributeId($attribute_id)
    {
        $this->container['attribute_id'] = $attribute_id;

        return $this;
    }

    /**
     * Gets attribute_value
     * @return string
     */
    public function getAttributeValue()
    {
        return $this->container['attribute_value'];
    }

    /**
     * Sets attribute_value
     * @param string $attribute_value Attribute value. This will always be a string, regardless of the attributes type.
     * @return $this
     */
    public function setAttributeValue($attribute_value)
    {
        if (strlen($attribute_value) > 255) {
            throw new \InvalidArgumentException('invalid length for $attribute_value when calling CustomerAttributeValueForCustomer., must be smaller than or equal to 255.');
        }
        if (strlen($attribute_value) < 0) {
            throw new \InvalidArgumentException('invalid length for $attribute_value when calling CustomerAttributeValueForCustomer., must be bigger than or equal to 0.');
        }
        $this->container['attribute_value'] = $attribute_value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


