<?php
/**
 * Consignment
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * Checkouts
 *
 * Create checkouts from existing carts using BigCommerce checkout logic.
 *
 * OpenAPI spec version: 3.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class Consignment implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Consignment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'string',
        'shipping_address' => 'object',
        'available_shipping_options' => '\BigCommerce\Api\v3\Model\SelectedShippingOption[]',
        'selected_shipping_option' => '\BigCommerce\Api\v3\Model\SelectedShippingOption',
        'coupon_discounts' => '\BigCommerce\Api\v3\Model\ConsignmentCouponDiscount[]',
        'discounts' => '\BigCommerce\Api\v3\Model\ConsignmentDiscount[]',
        'shipping_cost_inc_tax' => 'double',
        'shipping_cost_ex_tax' => 'double',
        'handling_cost_inc_tax' => 'double',
        'handling_cost_ex_tax' => 'double',
        'line_item_ids' => 'string[]'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'shipping_address' => 'shipping_address',
        'available_shipping_options' => 'available_shipping_options',
        'selected_shipping_option' => 'selected_shipping_option',
        'coupon_discounts' => 'coupon_discounts',
        'discounts' => 'discounts',
        'shipping_cost_inc_tax' => 'shipping_cost_inc_tax',
        'shipping_cost_ex_tax' => 'shipping_cost_ex_tax',
        'handling_cost_inc_tax' => 'handling_cost_inc_tax',
        'handling_cost_ex_tax' => 'handling_cost_ex_tax',
        'line_item_ids' => 'line_item_ids'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'shipping_address' => 'setShippingAddress',
        'available_shipping_options' => 'setAvailableShippingOptions',
        'selected_shipping_option' => 'setSelectedShippingOption',
        'coupon_discounts' => 'setCouponDiscounts',
        'discounts' => 'setDiscounts',
        'shipping_cost_inc_tax' => 'setShippingCostIncTax',
        'shipping_cost_ex_tax' => 'setShippingCostExTax',
        'handling_cost_inc_tax' => 'setHandlingCostIncTax',
        'handling_cost_ex_tax' => 'setHandlingCostExTax',
        'line_item_ids' => 'setLineItemIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'shipping_address' => 'getShippingAddress',
        'available_shipping_options' => 'getAvailableShippingOptions',
        'selected_shipping_option' => 'getSelectedShippingOption',
        'coupon_discounts' => 'getCouponDiscounts',
        'discounts' => 'getDiscounts',
        'shipping_cost_inc_tax' => 'getShippingCostIncTax',
        'shipping_cost_ex_tax' => 'getShippingCostExTax',
        'handling_cost_inc_tax' => 'getHandlingCostIncTax',
        'handling_cost_ex_tax' => 'getHandlingCostExTax',
        'line_item_ids' => 'getLineItemIds'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['id'] = array_key_exists('id', $data) ? $data['id'] : null;
        $this->container['shipping_address'] = array_key_exists('shipping_address', $data) ? $data['shipping_address'] : null;
        $this->container['available_shipping_options'] = array_key_exists('available_shipping_options', $data) ? $data['available_shipping_options'] : null;
        $this->container['selected_shipping_option'] = array_key_exists('selected_shipping_option', $data) ? $data['selected_shipping_option'] : null;
        $this->container['coupon_discounts'] = array_key_exists('coupon_discounts', $data) ? $data['coupon_discounts'] : null;
        $this->container['discounts'] = array_key_exists('discounts', $data) ? $data['discounts'] : null;
        $this->container['shipping_cost_inc_tax'] = array_key_exists('shipping_cost_inc_tax', $data) ? $data['shipping_cost_inc_tax'] : null;
        $this->container['shipping_cost_ex_tax'] = array_key_exists('shipping_cost_ex_tax', $data) ? $data['shipping_cost_ex_tax'] : null;
        $this->container['handling_cost_inc_tax'] = array_key_exists('handling_cost_inc_tax', $data) ? $data['handling_cost_inc_tax'] : null;
        $this->container['handling_cost_ex_tax'] = array_key_exists('handling_cost_ex_tax', $data) ? $data['handling_cost_ex_tax'] : null;
        $this->container['line_item_ids'] = array_key_exists('line_item_ids', $data) ? $data['line_item_ids'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id 
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets shipping_address
     * @return object
     */
    public function getShippingAddress()
    {
        return $this->container['shipping_address'];
    }

    /**
     * Sets shipping_address
     * @param object $shipping_address
     * @return $this
     */
    public function setShippingAddress($shipping_address)
    {
        $this->container['shipping_address'] = $shipping_address;

        return $this;
    }

    /**
     * Gets available_shipping_options
     * @return \BigCommerce\Api\v3\Model\SelectedShippingOption[]
     */
    public function getAvailableShippingOptions()
    {
        return $this->container['available_shipping_options'];
    }

    /**
     * Sets available_shipping_options
     * @param \BigCommerce\Api\v3\Model\SelectedShippingOption[] $available_shipping_options This is available only when \"include=available_shipping_options\" is presented in the URL.
     * @return $this
     */
    public function setAvailableShippingOptions($available_shipping_options)
    {
        $this->container['available_shipping_options'] = $available_shipping_options;

        return $this;
    }

    /**
     * Gets selected_shipping_option
     * @return \BigCommerce\Api\v3\Model\SelectedShippingOption
     */
    public function getSelectedShippingOption()
    {
        return $this->container['selected_shipping_option'];
    }

    /**
     * Sets selected_shipping_option
     * @param \BigCommerce\Api\v3\Model\SelectedShippingOption $selected_shipping_option
     * @return $this
     */
    public function setSelectedShippingOption($selected_shipping_option)
    {
        $this->container['selected_shipping_option'] = $selected_shipping_option;

        return $this;
    }

    /**
     * Gets coupon_discounts
     * @return \BigCommerce\Api\v3\Model\ConsignmentCouponDiscount[]
     */
    public function getCouponDiscounts()
    {
        return $this->container['coupon_discounts'];
    }

    /**
     * Sets coupon_discounts
     * @param \BigCommerce\Api\v3\Model\ConsignmentCouponDiscount[] $coupon_discounts List of consignment discounts applied through coupons
     * @return $this
     */
    public function setCouponDiscounts($coupon_discounts)
    {
        $this->container['coupon_discounts'] = $coupon_discounts;

        return $this;
    }

    /**
     * Gets discounts
     * @return \BigCommerce\Api\v3\Model\ConsignmentDiscount[]
     */
    public function getDiscounts()
    {
        return $this->container['discounts'];
    }

    /**
     * Sets discounts
     * @param \BigCommerce\Api\v3\Model\ConsignmentDiscount[] $discounts List of consignment discounts applied through cart level discounts
     * @return $this
     */
    public function setDiscounts($discounts)
    {
        $this->container['discounts'] = $discounts;

        return $this;
    }

    /**
     * Gets shipping_cost_inc_tax
     * @return double
     */
    public function getShippingCostIncTax()
    {
        return $this->container['shipping_cost_inc_tax'];
    }

    /**
     * Sets shipping_cost_inc_tax
     * @param double $shipping_cost_inc_tax The shipping cost for this consignment including tax.
     * @return $this
     */
    public function setShippingCostIncTax($shipping_cost_inc_tax)
    {
        $this->container['shipping_cost_inc_tax'] = $shipping_cost_inc_tax;

        return $this;
    }

    /**
     * Gets shipping_cost_ex_tax
     * @return double
     */
    public function getShippingCostExTax()
    {
        return $this->container['shipping_cost_ex_tax'];
    }

    /**
     * Sets shipping_cost_ex_tax
     * @param double $shipping_cost_ex_tax The shipping cost for this consignment excluding tax.
     * @return $this
     */
    public function setShippingCostExTax($shipping_cost_ex_tax)
    {
        $this->container['shipping_cost_ex_tax'] = $shipping_cost_ex_tax;

        return $this;
    }

    /**
     * Gets handling_cost_inc_tax
     * @return double
     */
    public function getHandlingCostIncTax()
    {
        return $this->container['handling_cost_inc_tax'];
    }

    /**
     * Sets handling_cost_inc_tax
     * @param double $handling_cost_inc_tax The handling cost of shipping for this consignment including tax.
     * @return $this
     */
    public function setHandlingCostIncTax($handling_cost_inc_tax)
    {
        $this->container['handling_cost_inc_tax'] = $handling_cost_inc_tax;

        return $this;
    }

    /**
     * Gets handling_cost_ex_tax
     * @return double
     */
    public function getHandlingCostExTax()
    {
        return $this->container['handling_cost_ex_tax'];
    }

    /**
     * Sets handling_cost_ex_tax
     * @param double $handling_cost_ex_tax The handling cost of shipping for this consignment excluding tax.
     * @return $this
     */
    public function setHandlingCostExTax($handling_cost_ex_tax)
    {
        $this->container['handling_cost_ex_tax'] = $handling_cost_ex_tax;

        return $this;
    }

    /**
     * Gets line_item_ids
     * @return string[]
     */
    public function getLineItemIds()
    {
        return $this->container['line_item_ids'];
    }

    /**
     * Sets line_item_ids
     * @param string[] $line_item_ids 
     * @return $this
     */
    public function setLineItemIds($line_item_ids)
    {
        $this->container['line_item_ids'] = $line_item_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


