<?php
/**
 * CatalogSummary
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class CatalogSummary implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CatalogSummary';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'inventory_count' => 'int',
        'inventory_value' => 'double',
        'primary_category_id' => 'int',
        'primary_category_name' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'inventory_count' => 'inventory_count',
        'inventory_value' => 'inventory_value',
        'primary_category_id' => 'primary_category_id',
        'primary_category_name' => 'primary_category_name'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'inventory_count' => 'setInventoryCount',
        'inventory_value' => 'setInventoryValue',
        'primary_category_id' => 'setPrimaryCategoryId',
        'primary_category_name' => 'setPrimaryCategoryName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'inventory_count' => 'getInventoryCount',
        'inventory_value' => 'getInventoryValue',
        'primary_category_id' => 'getPrimaryCategoryId',
        'primary_category_name' => 'getPrimaryCategoryName'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['inventory_count'] = array_key_exists('inventory_count', $data) ? $data['inventory_count'] : null;
        $this->container['inventory_value'] = array_key_exists('inventory_value', $data) ? $data['inventory_value'] : null;
        $this->container['primary_category_id'] = array_key_exists('primary_category_id', $data) ? $data['primary_category_id'] : null;
        $this->container['primary_category_name'] = array_key_exists('primary_category_name', $data) ? $data['primary_category_name'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets inventory_count
     * @return int
     */
    public function getInventoryCount()
    {
        return $this->container['inventory_count'];
    }

    /**
     * Sets inventory_count
     * @param int $inventory_count A count of all inventory items in the catalog.
     * @return $this
     */
    public function setInventoryCount($inventory_count)
    {
        $this->container['inventory_count'] = $inventory_count;

        return $this;
    }

    /**
     * Gets inventory_value
     * @return double
     */
    public function getInventoryValue()
    {
        return $this->container['inventory_value'];
    }

    /**
     * Sets inventory_value
     * @param double $inventory_value Total value of store's inventory.
     * @return $this
     */
    public function setInventoryValue($inventory_value)
    {
        $this->container['inventory_value'] = $inventory_value;

        return $this;
    }

    /**
     * Gets primary_category_id
     * @return int
     */
    public function getPrimaryCategoryId()
    {
        return $this->container['primary_category_id'];
    }

    /**
     * Sets primary_category_id
     * @param int $primary_category_id ID of the category containing the most products.
     * @return $this
     */
    public function setPrimaryCategoryId($primary_category_id)
    {
        $this->container['primary_category_id'] = $primary_category_id;

        return $this;
    }

    /**
     * Gets primary_category_name
     * @return string
     */
    public function getPrimaryCategoryName()
    {
        return $this->container['primary_category_name'];
    }

    /**
     * Sets primary_category_name
     * @param string $primary_category_name Name of the category containing the most products.
     * @return $this
     */
    public function setPrimaryCategoryName($primary_category_name)
    {
        $this->container['primary_category_name'] = $primary_category_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


