<?php
/**
 * CatalogApi
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Api;

use \BigCommerce\Api\v3\Configuration;
use \BigCommerce\Api\v3\ApiClient;
use \BigCommerce\Api\v3\ApiException;
use \BigCommerce\Api\v3\ObjectSerializer;

class CatalogApi
{

    /**
     * API Client
     *
     * @var \BigCommerce\Api\v3\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \BigCommerce\Api\v3\ApiClient $apiClient The api client to use
     */
    public function __construct(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
    * Get API client
    *
    * @return \BigCommerce\Api\v3\ApiClient get the API client
    */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
    * Set the API client
    *
    * @param \BigCommerce\Api\v3\ApiClient $apiClient set the API client
    *
    * @return CatalogApi
    */
    public function setApiClient(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation catalogSummaryGet
     *
     *
     *
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\CatalogSummaryResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function catalogSummaryGet(array $params = [])
    {
        list($response) = $this->catalogSummaryGetWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation catalogSummaryGetWithHttpInfo
     *
     * @see self::catalogSummaryGet()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CatalogSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogSummaryGetWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/summary";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CatalogSummaryResponse',
                '/catalog/summary'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CatalogSummaryResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CatalogSummaryResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createBrand
     *
     *
     *
     * @param \BigCommerce\Api\v3\Model\BrandPost $brand A &#x60;Brand&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\BrandResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createBrand($brand, array $params = [])
    {
        list($response) = $this->createBrandWithHttpInfo( $brand, $params);
        return $response;
    }


    /**
     * Operation createBrandWithHttpInfo
     *
     * @see self::createBrand()
     * @param \BigCommerce\Api\v3\Model\BrandPost $brand A &#x60;Brand&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BrandResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandWithHttpInfo( $brand, array $params = [])
    {

        // verify the required parameter 'brand' is set
        if (!isset($brand)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand when calling createBrand');
        }


        // parse inputs
        $resourcePath = "/catalog/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($brand)) {
        $_tempBody = $brand;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BrandResponse',
                '/catalog/brands'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BrandResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BrandResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createBrandImage
     *
     *
     *
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - image_file \SplFileObject An image file. Supported MIME types include GIF, JPEG, and PNG. (required)
     * @return \BigCommerce\Api\v3\Model\ImageResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createBrandImage($brand_id, array $params = [])
    {
        list($response) = $this->createBrandImageWithHttpInfo($brand_id, $params);
        return $response;
    }


    /**
     * Operation createBrandImageWithHttpInfo
     *
     * @see self::createBrandImage()
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ImageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandImageWithHttpInfo($brand_id, array $params = [])
    {

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling createBrandImage');
        }

        // verify the required parameter 'image_file' is set
        if (!isset($params[ 'image_file' ])) {
            throw new \InvalidArgumentException('Missing the required parameter $params[ "image_file" ] when calling createBrandImage');
        }
        $image_file = array_key_exists( 'image_file', $params ) ? $params[ 'image_file' ] : null;


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}/image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['multipart/form-data']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // form params
        if ($image_file !== null) {
        // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
        // See: https://wiki.php.net/rfc/curl-file-upload
        if (function_exists('curl_file_create')) {
            $formParams['image_file'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($image_file));
        } else {
            $formParams['image_file'] = '@' . $this->apiClient->getSerializer()->toFormValue($image_file);
        }
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ImageResponse',
                '/catalog/brands/{brand_id}/image'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ImageResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ImageResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createBrandMetafield
     *
     *
     *
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createBrandMetafield($brand_id, $metafield, array $params = [])
    {
        list($response) = $this->createBrandMetafieldWithHttpInfo($brand_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation createBrandMetafieldWithHttpInfo
     *
     * @see self::createBrandMetafield()
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandMetafieldWithHttpInfo($brand_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling createBrandMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling createBrandMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/brands/{brand_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createBulkPricingRule
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\BulkPricingRulePost $bulk_pricing_rule &#x60;BulkPricingRule&#x60; object. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @return \BigCommerce\Api\v3\Model\BulkPricingRuleResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createBulkPricingRule($product_id, $bulk_pricing_rule, array $params = [])
    {
        list($response) = $this->createBulkPricingRuleWithHttpInfo($product_id,  $bulk_pricing_rule, $params);
        return $response;
    }


    /**
     * Operation createBulkPricingRuleWithHttpInfo
     *
     * @see self::createBulkPricingRule()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\BulkPricingRulePost $bulk_pricing_rule &#x60;BulkPricingRule&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BulkPricingRuleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBulkPricingRuleWithHttpInfo($product_id,  $bulk_pricing_rule, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createBulkPricingRule');
        }

        // verify the required parameter 'bulk_pricing_rule' is set
        if (!isset($bulk_pricing_rule)) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_pricing_rule when calling createBulkPricingRule');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/bulk-pricing-rules";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($bulk_pricing_rule)) {
        $_tempBody = $bulk_pricing_rule;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse',
                '/catalog/products/{product_id}/bulk-pricing-rules'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createCategory
     *
     *
     *
     * @param \BigCommerce\Api\v3\Model\CategoryPost $category A BigCommerce &#x60;Category&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\CategoryResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createCategory($category, array $params = [])
    {
        list($response) = $this->createCategoryWithHttpInfo( $category, $params);
        return $response;
    }


    /**
     * Operation createCategoryWithHttpInfo
     *
     * @see self::createCategory()
     * @param \BigCommerce\Api\v3\Model\CategoryPost $category A BigCommerce &#x60;Category&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CategoryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCategoryWithHttpInfo( $category, array $params = [])
    {

        // verify the required parameter 'category' is set
        if (!isset($category)) {
            throw new \InvalidArgumentException('Missing the required parameter $category when calling createCategory');
        }


        // parse inputs
        $resourcePath = "/catalog/categories";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($category)) {
        $_tempBody = $category;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CategoryResponse',
                '/catalog/categories'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CategoryResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CategoryResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createCategoryImage
     *
     *
     *
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - image_file \SplFileObject An image file. Supported MIME types include GIF, JPEG, and PNG. (required)
     * @return \BigCommerce\Api\v3\Model\ImageResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createCategoryImage($category_id, array $params = [])
    {
        list($response) = $this->createCategoryImageWithHttpInfo($category_id, $params);
        return $response;
    }


    /**
     * Operation createCategoryImageWithHttpInfo
     *
     * @see self::createCategoryImage()
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ImageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCategoryImageWithHttpInfo($category_id, array $params = [])
    {

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling createCategoryImage');
        }

        // verify the required parameter 'image_file' is set
        if (!isset($params[ 'image_file' ])) {
            throw new \InvalidArgumentException('Missing the required parameter $params[ "image_file" ] when calling createCategoryImage');
        }
        $image_file = array_key_exists( 'image_file', $params ) ? $params[ 'image_file' ] : null;


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}/image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['multipart/form-data']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // form params
        if ($image_file !== null) {
        // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
        // See: https://wiki.php.net/rfc/curl-file-upload
        if (function_exists('curl_file_create')) {
            $formParams['image_file'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($image_file));
        } else {
            $formParams['image_file'] = '@' . $this->apiClient->getSerializer()->toFormValue($image_file);
        }
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ImageResponse',
                '/catalog/categories/{category_id}/image'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ImageResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ImageResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createCategoryMetafield
     *
     *
     *
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createCategoryMetafield($category_id, $metafield, array $params = [])
    {
        list($response) = $this->createCategoryMetafieldWithHttpInfo($category_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation createCategoryMetafieldWithHttpInfo
     *
     * @see self::createCategoryMetafield()
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCategoryMetafieldWithHttpInfo($category_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling createCategoryMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling createCategoryMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/categories/{category_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createComplexRule
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ComplexRulePost $complex_rule &#x60;ComplexRule&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ComplexRuleResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createComplexRule($product_id, $complex_rule, array $params = [])
    {
        list($response) = $this->createComplexRuleWithHttpInfo($product_id,  $complex_rule, $params);
        return $response;
    }


    /**
     * Operation createComplexRuleWithHttpInfo
     *
     * @see self::createComplexRule()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ComplexRulePost $complex_rule &#x60;ComplexRule&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ComplexRuleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createComplexRuleWithHttpInfo($product_id,  $complex_rule, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createComplexRule');
        }

        // verify the required parameter 'complex_rule' is set
        if (!isset($complex_rule)) {
            throw new \InvalidArgumentException('Missing the required parameter $complex_rule when calling createComplexRule');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/complex-rules";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($complex_rule)) {
        $_tempBody = $complex_rule;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ComplexRuleResponse',
                '/catalog/products/{product_id}/complex-rules'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ComplexRuleResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ComplexRuleResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createConfigurableField
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ConfigurableFieldPost $configurable_field &#x60;ConfigurableField&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ConfigurableFieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createConfigurableField($product_id, $configurable_field, array $params = [])
    {
        list($response) = $this->createConfigurableFieldWithHttpInfo($product_id,  $configurable_field, $params);
        return $response;
    }


    /**
     * Operation createConfigurableFieldWithHttpInfo
     *
     * @see self::createConfigurableField()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ConfigurableFieldPost $configurable_field &#x60;ConfigurableField&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ConfigurableFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConfigurableFieldWithHttpInfo($product_id,  $configurable_field, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createConfigurableField');
        }

        // verify the required parameter 'configurable_field' is set
        if (!isset($configurable_field)) {
            throw new \InvalidArgumentException('Missing the required parameter $configurable_field when calling createConfigurableField');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/configurable-fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($configurable_field)) {
        $_tempBody = $configurable_field;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse',
                '/catalog/products/{product_id}/configurable-fields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createCustomField
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\CustomFieldPost $custom_field &#x60;CustomField&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\CustomFieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createCustomField($product_id, $custom_field, array $params = [])
    {
        list($response) = $this->createCustomFieldWithHttpInfo($product_id,  $custom_field, $params);
        return $response;
    }


    /**
     * Operation createCustomFieldWithHttpInfo
     *
     * @see self::createCustomField()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\CustomFieldPost $custom_field &#x60;CustomField&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CustomFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomFieldWithHttpInfo($product_id,  $custom_field, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createCustomField');
        }

        // verify the required parameter 'custom_field' is set
        if (!isset($custom_field)) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field when calling createCustomField');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/custom-fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($custom_field)) {
        $_tempBody = $custom_field;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CustomFieldResponse',
                '/catalog/products/{product_id}/custom-fields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CustomFieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CustomFieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createModifier
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierPost $modifier A &#x60;Modifier&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ModifierResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createModifier($product_id, $modifier, array $params = [])
    {
        list($response) = $this->createModifierWithHttpInfo($product_id,  $modifier, $params);
        return $response;
    }


    /**
     * Operation createModifierWithHttpInfo
     *
     * @see self::createModifier()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierPost $modifier A &#x60;Modifier&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createModifierWithHttpInfo($product_id,  $modifier, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createModifier');
        }

        // verify the required parameter 'modifier' is set
        if (!isset($modifier)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier when calling createModifier');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($modifier)) {
        $_tempBody = $modifier;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierResponse',
                '/catalog/products/{product_id}/modifiers'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createModifierImage
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     *     - image_file \SplFileObject An image file. Supported MIME types include GIF, JPEG, and PNG. (required)
     * @return \BigCommerce\Api\v3\Model\ImageResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createModifierImage($product_id, $modifier_id, $value_id, array $params = [])
    {
        list($response) = $this->createModifierImageWithHttpInfo($product_id, $modifier_id, $value_id, $params);
        return $response;
    }


    /**
     * Operation createModifierImageWithHttpInfo
     *
     * @see self::createModifierImage()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ImageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createModifierImageWithHttpInfo($product_id, $modifier_id, $value_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createModifierImage');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling createModifierImage');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling createModifierImage');
        }

        // verify the required parameter 'image_file' is set
        if (!isset($params[ 'image_file' ])) {
            throw new \InvalidArgumentException('Missing the required parameter $params[ "image_file" ] when calling createModifierImage');
        }
        $image_file = array_key_exists( 'image_file', $params ) ? $params[ 'image_file' ] : null;


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}/image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['multipart/form-data']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // form params
        if ($image_file !== null) {
        // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
        // See: https://wiki.php.net/rfc/curl-file-upload
        if (function_exists('curl_file_create')) {
            $formParams['image_file'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($image_file));
        } else {
            $formParams['image_file'] = '@' . $this->apiClient->getSerializer()->toFormValue($image_file);
        }
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ImageResponse',
                '/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}/image'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ImageResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ImageResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createModifierValue
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierValuePost $modifier_value A &#x60;ModifierValue&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ModifierValueResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createModifierValue($product_id, $modifier_id, $modifier_value, array $params = [])
    {
        list($response) = $this->createModifierValueWithHttpInfo($product_id, $modifier_id,  $modifier_value, $params);
        return $response;
    }


    /**
     * Operation createModifierValueWithHttpInfo
     *
     * @see self::createModifierValue()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierValuePost $modifier_value A &#x60;ModifierValue&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierValueResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createModifierValueWithHttpInfo($product_id, $modifier_id,  $modifier_value, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createModifierValue');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling createModifierValue');
        }

        // verify the required parameter 'modifier_value' is set
        if (!isset($modifier_value)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_value when calling createModifierValue');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}/values";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($modifier_value)) {
        $_tempBody = $modifier_value;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierValueResponse',
                '/catalog/products/{product_id}/modifiers/{modifier_id}/values'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierValueResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierValueResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createOption
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\OptionPost $option An &#x60;Option&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\OptionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createOption($product_id, $option, array $params = [])
    {
        list($response) = $this->createOptionWithHttpInfo($product_id,  $option, $params);
        return $response;
    }


    /**
     * Operation createOptionWithHttpInfo
     *
     * @see self::createOption()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\OptionPost $option An &#x60;Option&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOptionWithHttpInfo($product_id,  $option, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createOption');
        }

        // verify the required parameter 'option' is set
        if (!isset($option)) {
            throw new \InvalidArgumentException('Missing the required parameter $option when calling createOption');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($option)) {
        $_tempBody = $option;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionResponse',
                '/catalog/products/{product_id}/options'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createOptionValue
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\OptionValuePost $option_value A &#x60;OptionValue&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\OptionValueResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createOptionValue($product_id, $option_id, $option_value, array $params = [])
    {
        list($response) = $this->createOptionValueWithHttpInfo($product_id, $option_id,  $option_value, $params);
        return $response;
    }


    /**
     * Operation createOptionValueWithHttpInfo
     *
     * @see self::createOptionValue()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\OptionValuePost $option_value A &#x60;OptionValue&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionValueResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOptionValueWithHttpInfo($product_id, $option_id,  $option_value, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createOptionValue');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling createOptionValue');
        }

        // verify the required parameter 'option_value' is set
        if (!isset($option_value)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_value when calling createOptionValue');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}/values";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($option_value)) {
        $_tempBody = $option_value;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionValueResponse',
                '/catalog/products/{product_id}/options/{option_id}/values'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionValueResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionValueResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createProduct
     *
     *
     *
     * @param \BigCommerce\Api\v3\Model\ProductPost $product A BigCommerce &#x60;Product&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createProduct($product, array $params = [])
    {
        list($response) = $this->createProductWithHttpInfo( $product, $params);
        return $response;
    }


    /**
     * Operation createProductWithHttpInfo
     *
     * @see self::createProduct()
     * @param \BigCommerce\Api\v3\Model\ProductPost $product A BigCommerce &#x60;Product&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductWithHttpInfo( $product, array $params = [])
    {

        // verify the required parameter 'product' is set
        if (!isset($product)) {
            throw new \InvalidArgumentException('Missing the required parameter $product when calling createProduct');
        }


        // parse inputs
        $resourcePath = "/catalog/products";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product)) {
        $_tempBody = $product;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductResponse',
                '/catalog/products'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createProductImage
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductImagePost $product_image A BigCommerce &#x60;ProductImage&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductImageResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createProductImage($product_id, $product_image, array $params = [])
    {
        list($response) = $this->createProductImageWithHttpInfo($product_id,  $product_image, $params);
        return $response;
    }


    /**
     * Operation createProductImageWithHttpInfo
     *
     * @see self::createProductImage()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductImagePost $product_image A BigCommerce &#x60;ProductImage&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductImageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductImageWithHttpInfo($product_id,  $product_image, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createProductImage');
        }

        // verify the required parameter 'product_image' is set
        if (!isset($product_image)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_image when calling createProductImage');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/images";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product_image)) {
        $_tempBody = $product_image;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductImageResponse',
                '/catalog/products/{product_id}/images'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductImageResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductImageResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createProductMetafield
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createProductMetafield($product_id, $metafield, array $params = [])
    {
        list($response) = $this->createProductMetafieldWithHttpInfo($product_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation createProductMetafieldWithHttpInfo
     *
     * @see self::createProductMetafield()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductMetafieldWithHttpInfo($product_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createProductMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling createProductMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/products/{product_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createProductReview
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductReviewPost $product_review A BigCommerce &#x60;ProductReview&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductReviewResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createProductReview($product_id, $product_review, array $params = [])
    {
        list($response) = $this->createProductReviewWithHttpInfo($product_id,  $product_review, $params);
        return $response;
    }


    /**
     * Operation createProductReviewWithHttpInfo
     *
     * @see self::createProductReview()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductReviewPost $product_review A BigCommerce &#x60;ProductReview&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductReviewResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductReviewWithHttpInfo($product_id,  $product_review, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createProductReview');
        }

        // verify the required parameter 'product_review' is set
        if (!isset($product_review)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_review when calling createProductReview');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/reviews";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product_review)) {
        $_tempBody = $product_review;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductReviewResponse',
                '/catalog/products/{product_id}/reviews'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductReviewResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductReviewResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createProductVideo
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductVideoPost $product_video A BigCommerce &#x60;ProductVideo&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductVideoResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createProductVideo($product_id, $product_video, array $params = [])
    {
        list($response) = $this->createProductVideoWithHttpInfo($product_id,  $product_video, $params);
        return $response;
    }


    /**
     * Operation createProductVideoWithHttpInfo
     *
     * @see self::createProductVideo()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductVideoPost $product_video A BigCommerce &#x60;ProductVideo&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductVideoResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductVideoWithHttpInfo($product_id,  $product_video, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createProductVideo');
        }

        // verify the required parameter 'product_video' is set
        if (!isset($product_video)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_video when calling createProductVideo');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/videos";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product_video)) {
        $_tempBody = $product_video;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductVideoResponse',
                '/catalog/products/{product_id}/videos'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductVideoResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductVideoResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createVariant
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\VariantPost $variant &#x60;Variant&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\VariantResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createVariant($product_id, $variant, array $params = [])
    {
        list($response) = $this->createVariantWithHttpInfo($product_id,  $variant, $params);
        return $response;
    }


    /**
     * Operation createVariantWithHttpInfo
     *
     * @see self::createVariant()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\VariantPost $variant &#x60;Variant&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\VariantResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createVariantWithHttpInfo($product_id,  $variant, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createVariant');
        }

        // verify the required parameter 'variant' is set
        if (!isset($variant)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant when calling createVariant');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($variant)) {
        $_tempBody = $variant;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\VariantResponse',
                '/catalog/products/{product_id}/variants'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\VariantResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\VariantResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createVariantImage
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     *     - image_file \SplFileObject An image file. Supported MIME types include GIF, JPEG, and PNG. (required)
     * @return \BigCommerce\Api\v3\Model\ImageResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createVariantImage($product_id, $variant_id, array $params = [])
    {
        list($response) = $this->createVariantImageWithHttpInfo($product_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation createVariantImageWithHttpInfo
     *
     * @see self::createVariantImage()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ImageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createVariantImageWithHttpInfo($product_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createVariantImage');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling createVariantImage');
        }

        // verify the required parameter 'image_file' is set
        if (!isset($params[ 'image_file' ])) {
            throw new \InvalidArgumentException('Missing the required parameter $params[ "image_file" ] when calling createVariantImage');
        }
        $image_file = array_key_exists( 'image_file', $params ) ? $params[ 'image_file' ] : null;


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}/image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['multipart/form-data']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // form params
        if ($image_file !== null) {
        // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
        // See: https://wiki.php.net/rfc/curl-file-upload
        if (function_exists('curl_file_create')) {
            $formParams['image_file'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($image_file));
        } else {
            $formParams['image_file'] = '@' . $this->apiClient->getSerializer()->toFormValue($image_file);
        }
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ImageResponse',
                '/catalog/products/{product_id}/variants/{variant_id}/image'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ImageResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ImageResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation createVariantMetafield
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createVariantMetafield($product_id, $variant_id, $metafield, array $params = [])
    {
        list($response) = $this->createVariantMetafieldWithHttpInfo($product_id, $variant_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation createVariantMetafieldWithHttpInfo
     *
     * @see self::createVariantMetafield()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPost $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createVariantMetafieldWithHttpInfo($product_id, $variant_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling createVariantMetafield');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling createVariantMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling createVariantMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/products/{product_id}/variants/{variant_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation deleteBrandById
     *
     *
     *
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteBrandById($brand_id, array $params = [])
    {
        list($response) = $this->deleteBrandByIdWithHttpInfo($brand_id, $params);
        return $response;
    }


    /**
     * Operation deleteBrandByIdWithHttpInfo
     *
     * @see self::deleteBrandById()
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandByIdWithHttpInfo($brand_id, array $params = [])
    {

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling deleteBrandById');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/brands/{brand_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteBrandImage
     *
     *
     *
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteBrandImage($brand_id, array $params = [])
    {
        list($response) = $this->deleteBrandImageWithHttpInfo($brand_id, $params);
        return $response;
    }


    /**
     * Operation deleteBrandImageWithHttpInfo
     *
     * @see self::deleteBrandImage()
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandImageWithHttpInfo($brand_id, array $params = [])
    {

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling deleteBrandImage');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}/image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/brands/{brand_id}/image'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteBrandMetafieldById
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteBrandMetafieldById($metafield_id, $brand_id, array $params = [])
    {
        list($response) = $this->deleteBrandMetafieldByIdWithHttpInfo($metafield_id, $brand_id, $params);
        return $response;
    }


    /**
     * Operation deleteBrandMetafieldByIdWithHttpInfo
     *
     * @see self::deleteBrandMetafieldById()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandMetafieldByIdWithHttpInfo($metafield_id, $brand_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling deleteBrandMetafieldById');
        }

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling deleteBrandMetafieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/brands/{brand_id}/metafields/{metafield_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteBrands
     *
     *
     *
     * @param array $params = []
     *     - name string Filter items by name. (optional)
     *     - page_title string Filter items by page_title. (optional)
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteBrands(array $params = [])
    {
        list($response) = $this->deleteBrandsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation deleteBrandsWithHttpInfo
     *
     * @see self::deleteBrands()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandsWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/brands'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteBulkPricingRuleById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $bulk_pricing_rule_id The ID of the &#x60;BulkPricingRule&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteBulkPricingRuleById($product_id, $bulk_pricing_rule_id, array $params = [])
    {
        list($response) = $this->deleteBulkPricingRuleByIdWithHttpInfo($product_id, $bulk_pricing_rule_id, $params);
        return $response;
    }


    /**
     * Operation deleteBulkPricingRuleByIdWithHttpInfo
     *
     * @see self::deleteBulkPricingRuleById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $bulk_pricing_rule_id The ID of the &#x60;BulkPricingRule&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBulkPricingRuleByIdWithHttpInfo($product_id, $bulk_pricing_rule_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteBulkPricingRuleById');
        }

        // verify the required parameter 'bulk_pricing_rule_id' is set
        if (!isset($bulk_pricing_rule_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_pricing_rule_id when calling deleteBulkPricingRuleById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($bulk_pricing_rule_id)) {
            $resourcePath = str_replace(
                "{" . "bulk_pricing_rule_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($bulk_pricing_rule_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation deleteCategories
     *
     *
     *
     * @param array $params = []
     *     - name string Filter items by name. (optional)
     *     - parent_id int Filter items by parent_id. (optional)
     *     - page_title string Filter items by page_title. (optional)
     *     - keyword string Filter items by keywords. (optional)
     *     - is_visible int Filter items by is_visible. (optional)
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteCategories(array $params = [])
    {
        list($response) = $this->deleteCategoriesWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation deleteCategoriesWithHttpInfo
     *
     * @see self::deleteCategories()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCategoriesWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/categories";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/categories'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteCategoryById
     *
     *
     *
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteCategoryById($category_id, array $params = [])
    {
        list($response) = $this->deleteCategoryByIdWithHttpInfo($category_id, $params);
        return $response;
    }


    /**
     * Operation deleteCategoryByIdWithHttpInfo
     *
     * @see self::deleteCategoryById()
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCategoryByIdWithHttpInfo($category_id, array $params = [])
    {

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling deleteCategoryById');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/categories/{category_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteCategoryImage
     *
     *
     *
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteCategoryImage($category_id, array $params = [])
    {
        list($response) = $this->deleteCategoryImageWithHttpInfo($category_id, $params);
        return $response;
    }


    /**
     * Operation deleteCategoryImageWithHttpInfo
     *
     * @see self::deleteCategoryImage()
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCategoryImageWithHttpInfo($category_id, array $params = [])
    {

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling deleteCategoryImage');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}/image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/categories/{category_id}/image'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteCategoryMetafieldById
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteCategoryMetafieldById($metafield_id, $category_id, array $params = [])
    {
        list($response) = $this->deleteCategoryMetafieldByIdWithHttpInfo($metafield_id, $category_id, $params);
        return $response;
    }


    /**
     * Operation deleteCategoryMetafieldByIdWithHttpInfo
     *
     * @see self::deleteCategoryMetafieldById()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCategoryMetafieldByIdWithHttpInfo($metafield_id, $category_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling deleteCategoryMetafieldById');
        }

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling deleteCategoryMetafieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/categories/{category_id}/metafields/{metafield_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteComplexRuleById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $complex_rule_id The ID of the &#x60;ComplexRule&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteComplexRuleById($product_id, $complex_rule_id, array $params = [])
    {
        list($response) = $this->deleteComplexRuleByIdWithHttpInfo($product_id, $complex_rule_id, $params);
        return $response;
    }


    /**
     * Operation deleteComplexRuleByIdWithHttpInfo
     *
     * @see self::deleteComplexRuleById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $complex_rule_id The ID of the &#x60;ComplexRule&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteComplexRuleByIdWithHttpInfo($product_id, $complex_rule_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteComplexRuleById');
        }

        // verify the required parameter 'complex_rule_id' is set
        if (!isset($complex_rule_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $complex_rule_id when calling deleteComplexRuleById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/complex-rules/{complex_rule_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($complex_rule_id)) {
            $resourcePath = str_replace(
                "{" . "complex_rule_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($complex_rule_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/complex-rules/{complex_rule_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteConfigurableFieldById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $configurable_field_id The ID of the &#x60;ConfigurableField&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteConfigurableFieldById($product_id, $configurable_field_id, array $params = [])
    {
        list($response) = $this->deleteConfigurableFieldByIdWithHttpInfo($product_id, $configurable_field_id, $params);
        return $response;
    }


    /**
     * Operation deleteConfigurableFieldByIdWithHttpInfo
     *
     * @see self::deleteConfigurableFieldById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $configurable_field_id The ID of the &#x60;ConfigurableField&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteConfigurableFieldByIdWithHttpInfo($product_id, $configurable_field_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteConfigurableFieldById');
        }

        // verify the required parameter 'configurable_field_id' is set
        if (!isset($configurable_field_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $configurable_field_id when calling deleteConfigurableFieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/configurable-fields/{configurable_field_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($configurable_field_id)) {
            $resourcePath = str_replace(
                "{" . "configurable_field_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($configurable_field_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/configurable-fields/{configurable_field_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation deleteCustomFieldById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteCustomFieldById($product_id, $custom_field_id, array $params = [])
    {
        list($response) = $this->deleteCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, $params);
        return $response;
    }


    /**
     * Operation deleteCustomFieldByIdWithHttpInfo
     *
     * @see self::deleteCustomFieldById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteCustomFieldById');
        }

        // verify the required parameter 'custom_field_id' is set
        if (!isset($custom_field_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field_id when calling deleteCustomFieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/custom-fields/{custom_field_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($custom_field_id)) {
            $resourcePath = str_replace(
                "{" . "custom_field_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/custom-fields/{custom_field_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation deleteModifierById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteModifierById($product_id, $modifier_id, array $params = [])
    {
        list($response) = $this->deleteModifierByIdWithHttpInfo($product_id, $modifier_id, $params);
        return $response;
    }


    /**
     * Operation deleteModifierByIdWithHttpInfo
     *
     * @see self::deleteModifierById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteModifierByIdWithHttpInfo($product_id, $modifier_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteModifierById');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling deleteModifierById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/modifiers/{modifier_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteModifierImage
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteModifierImage($product_id, $modifier_id, $value_id, array $params = [])
    {
        list($response) = $this->deleteModifierImageWithHttpInfo($product_id, $modifier_id, $value_id, $params);
        return $response;
    }


    /**
     * Operation deleteModifierImageWithHttpInfo
     *
     * @see self::deleteModifierImage()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteModifierImageWithHttpInfo($product_id, $modifier_id, $value_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteModifierImage');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling deleteModifierImage');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling deleteModifierImage');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}/image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}/image'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteModifierValueById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteModifierValueById($product_id, $modifier_id, $value_id, array $params = [])
    {
        list($response) = $this->deleteModifierValueByIdWithHttpInfo($product_id, $modifier_id, $value_id, $params);
        return $response;
    }


    /**
     * Operation deleteModifierValueByIdWithHttpInfo
     *
     * @see self::deleteModifierValueById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteModifierValueByIdWithHttpInfo($product_id, $modifier_id, $value_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteModifierValueById');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling deleteModifierValueById');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling deleteModifierValueById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteOptionById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteOptionById($product_id, $option_id, array $params = [])
    {
        list($response) = $this->deleteOptionByIdWithHttpInfo($product_id, $option_id, $params);
        return $response;
    }


    /**
     * Operation deleteOptionByIdWithHttpInfo
     *
     * @see self::deleteOptionById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOptionByIdWithHttpInfo($product_id, $option_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteOptionById');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling deleteOptionById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/options/{option_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteOptionValueById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteOptionValueById($product_id, $option_id, $value_id, array $params = [])
    {
        list($response) = $this->deleteOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, $params);
        return $response;
    }


    /**
     * Operation deleteOptionValueByIdWithHttpInfo
     *
     * @see self::deleteOptionValueById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteOptionValueById');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling deleteOptionValueById');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling deleteOptionValueById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}/values/{value_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/options/{option_id}/values/{value_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteProductById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteProductById($product_id, array $params = [])
    {
        list($response) = $this->deleteProductByIdWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation deleteProductByIdWithHttpInfo
     *
     * @see self::deleteProductById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductByIdWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteProductById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteProductImage
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteProductImage($product_id, $image_id, array $params = [])
    {
        list($response) = $this->deleteProductImageWithHttpInfo($product_id, $image_id, $params);
        return $response;
    }


    /**
     * Operation deleteProductImageWithHttpInfo
     *
     * @see self::deleteProductImage()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductImageWithHttpInfo($product_id, $image_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteProductImage');
        }

        // verify the required parameter 'image_id' is set
        if (!isset($image_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $image_id when calling deleteProductImage');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/images/{image_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($image_id)) {
            $resourcePath = str_replace(
                "{" . "image_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($image_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/images/{image_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteProductMetafieldById
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteProductMetafieldById($metafield_id, $product_id, array $params = [])
    {
        list($response) = $this->deleteProductMetafieldByIdWithHttpInfo($metafield_id, $product_id, $params);
        return $response;
    }


    /**
     * Operation deleteProductMetafieldByIdWithHttpInfo
     *
     * @see self::deleteProductMetafieldById()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductMetafieldByIdWithHttpInfo($metafield_id, $product_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling deleteProductMetafieldById');
        }

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteProductMetafieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/metafields/{metafield_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteProductReview
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $review_id The ID of the &#x60;review&#x60; that is being operated on. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteProductReview($product_id, $review_id, array $params = [])
    {
        list($response) = $this->deleteProductReviewWithHttpInfo($product_id, $review_id, $params);
        return $response;
    }


    /**
     * Operation deleteProductReviewWithHttpInfo
     *
     * @see self::deleteProductReview()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $review_id The ID of the &#x60;review&#x60; that is being operated on. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductReviewWithHttpInfo($product_id, $review_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteProductReview');
        }

        // verify the required parameter 'review_id' is set
        if (!isset($review_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $review_id when calling deleteProductReview');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/reviews/{review_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($review_id)) {
            $resourcePath = str_replace(
                "{" . "review_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($review_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/reviews/{review_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteProductVideo
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param string $video_id The ID of the &#x60;Video&#x60; that is being operated on. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteProductVideo($product_id, $video_id, array $params = [])
    {
        list($response) = $this->deleteProductVideoWithHttpInfo($product_id, $video_id, $params);
        return $response;
    }


    /**
     * Operation deleteProductVideoWithHttpInfo
     *
     * @see self::deleteProductVideo()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param string $video_id The ID of the &#x60;Video&#x60; that is being operated on. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductVideoWithHttpInfo($product_id, $video_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteProductVideo');
        }

        // verify the required parameter 'video_id' is set
        if (!isset($video_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $video_id when calling deleteProductVideo');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/videos/{video_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($video_id)) {
            $resourcePath = str_replace(
                "{" . "video_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($video_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/videos/{video_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteProducts
     *
     *
     *
     * @param array $params = []
     *     - name string Filter items by name. (optional)
     *     - sku string Filter items by sku. (optional)
     *     - price float Filter items by price. (optional)
     *     - weight float Filter items by weight. (optional)
     *     - condition int Filter items by condition. (optional)
     *     - brand_id int Filter items by brand_id. (optional)
     *     - date_modified \DateTime Filter items by date_modified. (optional)
     *     - date_last_imported \DateTime Filter items by date_last_imported. (optional)
     *     - is_visible int Filter items by is_visible. (optional)
     *     - is_featured int Filter items by is_featured. (optional)
     *     - inventory_level int Filter items by inventory_level. (optional)
     *     - total_sold int Filter items by total_sold. (optional)
     *     - type string Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. (optional)
     *     - categories int Filter items by categories. (optional)
     *     - keyword string Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteProducts(array $params = [])
    {
        list($response) = $this->deleteProductsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation deleteProductsWithHttpInfo
     *
     * @see self::deleteProducts()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductsWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/products";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteVariantById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteVariantById($product_id, $variant_id, array $params = [])
    {
        list($response) = $this->deleteVariantByIdWithHttpInfo($product_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation deleteVariantByIdWithHttpInfo
     *
     * @see self::deleteVariantById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariantByIdWithHttpInfo($product_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteVariantById');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling deleteVariantById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/variants/{variant_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deleteVariantMetafieldById
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteVariantMetafieldById($metafield_id, $product_id, $variant_id, array $params = [])
    {
        list($response) = $this->deleteVariantMetafieldByIdWithHttpInfo($metafield_id, $product_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation deleteVariantMetafieldByIdWithHttpInfo
     *
     * @see self::deleteVariantMetafieldById()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariantMetafieldByIdWithHttpInfo($metafield_id, $product_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling deleteVariantMetafieldById');
        }

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling deleteVariantMetafieldById');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling deleteVariantMetafieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation getBrandById
     *
     *
     *
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\BrandResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getBrandById($brand_id, array $params = [])
    {
        list($response) = $this->getBrandByIdWithHttpInfo($brand_id, $params);
        return $response;
    }


    /**
     * Operation getBrandByIdWithHttpInfo
     *
     * @see self::getBrandById()
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BrandResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandByIdWithHttpInfo($brand_id, array $params = [])
    {

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandById');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BrandResponse',
                '/catalog/brands/{brand_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BrandResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BrandResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getBrandMetafieldByBrandId
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getBrandMetafieldByBrandId($metafield_id, $brand_id, array $params = [])
    {
        list($response) = $this->getBrandMetafieldByBrandIdWithHttpInfo($metafield_id, $brand_id, $params);
        return $response;
    }


    /**
     * Operation getBrandMetafieldByBrandIdWithHttpInfo
     *
     * @see self::getBrandMetafieldByBrandId()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandMetafieldByBrandIdWithHttpInfo($metafield_id, $brand_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling getBrandMetafieldByBrandId');
        }

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandMetafieldByBrandId');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/brands/{brand_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getBrandMetafieldsByBrandId
     *
     *
     *
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - key string Filter based on a metafield&#39;s key. (optional)
     *     - namespace string Filter based on a metafield&#39;s key. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getBrandMetafieldsByBrandId($brand_id, array $params = [])
    {
        list($response) = $this->getBrandMetafieldsByBrandIdWithHttpInfo($brand_id, $params);
        return $response;
    }


    /**
     * Operation getBrandMetafieldsByBrandIdWithHttpInfo
     *
     * @see self::getBrandMetafieldsByBrandId()
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandMetafieldsByBrandIdWithHttpInfo($brand_id, array $params = [])
    {

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandMetafieldsByBrandId');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse',
                '/catalog/brands/{brand_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getBrands
     *
     *
     *
     * @param array $params = []
     *     - name string Filter items by name. (optional)
     *     - page_title string Filter items by page_title. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\BrandCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getBrands(array $params = [])
    {
        list($response) = $this->getBrandsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getBrandsWithHttpInfo
     *
     * @see self::getBrands()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BrandCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandsWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BrandCollectionResponse',
                '/catalog/brands'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BrandCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BrandCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getBulkPricingRuleById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $bulk_pricing_rule_id The ID of the &#x60;BulkPricingRule&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\BulkPricingRuleResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getBulkPricingRuleById($product_id, $bulk_pricing_rule_id, array $params = [])
    {
        list($response) = $this->getBulkPricingRuleByIdWithHttpInfo($product_id, $bulk_pricing_rule_id, $params);
        return $response;
    }


    /**
     * Operation getBulkPricingRuleByIdWithHttpInfo
     *
     * @see self::getBulkPricingRuleById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $bulk_pricing_rule_id The ID of the &#x60;BulkPricingRule&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BulkPricingRuleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkPricingRuleByIdWithHttpInfo($product_id, $bulk_pricing_rule_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getBulkPricingRuleById');
        }

        // verify the required parameter 'bulk_pricing_rule_id' is set
        if (!isset($bulk_pricing_rule_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_pricing_rule_id when calling getBulkPricingRuleById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($bulk_pricing_rule_id)) {
            $resourcePath = str_replace(
                "{" . "bulk_pricing_rule_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($bulk_pricing_rule_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse',
                '/catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getBulkPricingRules
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\BulkPricingRuleCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getBulkPricingRules($product_id, array $params = [])
    {
        list($response) = $this->getBulkPricingRulesWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getBulkPricingRulesWithHttpInfo
     *
     * @see self::getBulkPricingRules()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BulkPricingRuleCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkPricingRulesWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getBulkPricingRules');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/bulk-pricing-rules";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BulkPricingRuleCollectionResponse',
                '/catalog/products/{product_id}/bulk-pricing-rules'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BulkPricingRuleCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BulkPricingRuleCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getCategories
     *
     *
     *
     * @param array $params = []
     *     - name string Filter items by name. (optional)
     *     - parent_id int Filter items by parent_id. (optional)
     *     - page_title string Filter items by page_title. (optional)
     *     - keyword string Filter items by keywords. (optional)
     *     - is_visible int Filter items by is_visible. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\CategoryCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCategories(array $params = [])
    {
        list($response) = $this->getCategoriesWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getCategoriesWithHttpInfo
     *
     * @see self::getCategories()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CategoryCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoriesWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/categories";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CategoryCollectionResponse',
                '/catalog/categories'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CategoryCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CategoryCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getCategoryById
     *
     *
     *
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\CategoryResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCategoryById($category_id, array $params = [])
    {
        list($response) = $this->getCategoryByIdWithHttpInfo($category_id, $params);
        return $response;
    }


    /**
     * Operation getCategoryByIdWithHttpInfo
     *
     * @see self::getCategoryById()
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CategoryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoryByIdWithHttpInfo($category_id, array $params = [])
    {

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling getCategoryById');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CategoryResponse',
                '/catalog/categories/{category_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CategoryResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CategoryResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getCategoryMetafieldByCategoryId
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCategoryMetafieldByCategoryId($metafield_id, $category_id, array $params = [])
    {
        list($response) = $this->getCategoryMetafieldByCategoryIdWithHttpInfo($metafield_id, $category_id, $params);
        return $response;
    }


    /**
     * Operation getCategoryMetafieldByCategoryIdWithHttpInfo
     *
     * @see self::getCategoryMetafieldByCategoryId()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoryMetafieldByCategoryIdWithHttpInfo($metafield_id, $category_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling getCategoryMetafieldByCategoryId');
        }

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling getCategoryMetafieldByCategoryId');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/categories/{category_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getCategoryMetafieldsByCategoryId
     *
     *
     *
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - key string Filter based on a metafield&#39;s key. (optional)
     *     - namespace string Filter based on a metafield&#39;s key. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCategoryMetafieldsByCategoryId($category_id, array $params = [])
    {
        list($response) = $this->getCategoryMetafieldsByCategoryIdWithHttpInfo($category_id, $params);
        return $response;
    }


    /**
     * Operation getCategoryMetafieldsByCategoryIdWithHttpInfo
     *
     * @see self::getCategoryMetafieldsByCategoryId()
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoryMetafieldsByCategoryIdWithHttpInfo($category_id, array $params = [])
    {

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling getCategoryMetafieldsByCategoryId');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse',
                '/catalog/categories/{category_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }

    /**
     * Operation getCategoriesBatch
     *
     *
     *
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\CategoryCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCategoriesBatch(array $params = [])
    {
        list($response) = $this->getCategoriesBatchWithHttpInfo($params);

        return $response;
    }

    /**
     * Operation getCategoriesBatchWithHttpInfo
     *
     * @see self::getCategoriesBatch()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CategoryCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoriesBatchWithHttpInfo(array $params = [])
    {
        // parse inputs
        $resourcePath = "/catalog/trees/categories";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CategoryCollectionResponse',
                '/catalog/trees/categories'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CategoryCollectionResponse', $httpHeader), $statusCode, $httpHeader];

        } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CategoryCollectionResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;

            }

            throw $e;
        }
    }

    /**
     * Operation getCategoryTree
     *
     *
     *
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\CategoryTreeCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCategoryTree(array $params = [])
    {
        list($response) = $this->getCategoryTreeWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getCategoryTreeWithHttpInfo
     *
     * @see self::getCategoryTree()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CategoryTreeCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoryTreeWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/trees";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CategoryTreeCollectionResponse',
                '/catalog/trees'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CategoryTreeCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CategoryTreeCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getComplexRuleById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $complex_rule_id The ID of the &#x60;ComplexRule&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ComplexRuleResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getComplexRuleById($product_id, $complex_rule_id, array $params = [])
    {
        list($response) = $this->getComplexRuleByIdWithHttpInfo($product_id, $complex_rule_id, $params);
        return $response;
    }


    /**
     * Operation getComplexRuleByIdWithHttpInfo
     *
     * @see self::getComplexRuleById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $complex_rule_id The ID of the &#x60;ComplexRule&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ComplexRuleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getComplexRuleByIdWithHttpInfo($product_id, $complex_rule_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getComplexRuleById');
        }

        // verify the required parameter 'complex_rule_id' is set
        if (!isset($complex_rule_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $complex_rule_id when calling getComplexRuleById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/complex-rules/{complex_rule_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($complex_rule_id)) {
            $resourcePath = str_replace(
                "{" . "complex_rule_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($complex_rule_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ComplexRuleResponse',
                '/catalog/products/{product_id}/complex-rules/{complex_rule_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ComplexRuleResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ComplexRuleResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getComplexRules
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ComplexRuleCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getComplexRules($product_id, array $params = [])
    {
        list($response) = $this->getComplexRulesWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getComplexRulesWithHttpInfo
     *
     * @see self::getComplexRules()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ComplexRuleCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getComplexRulesWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getComplexRules');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/complex-rules";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ComplexRuleCollectionResponse',
                '/catalog/products/{product_id}/complex-rules'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ComplexRuleCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ComplexRuleCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getConfigurableFieldById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $configurable_field_id The ID of the &#x60;ConfigurableField&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ConfigurableFieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getConfigurableFieldById($product_id, $configurable_field_id, array $params = [])
    {
        list($response) = $this->getConfigurableFieldByIdWithHttpInfo($product_id, $configurable_field_id, $params);
        return $response;
    }


    /**
     * Operation getConfigurableFieldByIdWithHttpInfo
     *
     * @see self::getConfigurableFieldById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $configurable_field_id The ID of the &#x60;ConfigurableField&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ConfigurableFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConfigurableFieldByIdWithHttpInfo($product_id, $configurable_field_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getConfigurableFieldById');
        }

        // verify the required parameter 'configurable_field_id' is set
        if (!isset($configurable_field_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $configurable_field_id when calling getConfigurableFieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/configurable-fields/{configurable_field_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($configurable_field_id)) {
            $resourcePath = str_replace(
                "{" . "configurable_field_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($configurable_field_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse',
                '/catalog/products/{product_id}/configurable-fields/{configurable_field_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getConfigurableFields
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @return \BigCommerce\Api\v3\Model\ConfigurableFieldCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getConfigurableFields($product_id, array $params = [])
    {
        list($response) = $this->getConfigurableFieldsWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getConfigurableFieldsWithHttpInfo
     *
     * @see self::getConfigurableFields()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ConfigurableFieldCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConfigurableFieldsWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getConfigurableFields');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/configurable-fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ConfigurableFieldCollectionResponse',
                '/catalog/products/{product_id}/configurable-fields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ConfigurableFieldCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ConfigurableFieldCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getCustomFieldById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\CustomFieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCustomFieldById($product_id, $custom_field_id, array $params = [])
    {
        list($response) = $this->getCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, $params);
        return $response;
    }


    /**
     * Operation getCustomFieldByIdWithHttpInfo
     *
     * @see self::getCustomFieldById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CustomFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomFieldByIdWithHttpInfo($product_id, $custom_field_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getCustomFieldById');
        }

        // verify the required parameter 'custom_field_id' is set
        if (!isset($custom_field_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field_id when calling getCustomFieldById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/custom-fields/{custom_field_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($custom_field_id)) {
            $resourcePath = str_replace(
                "{" . "custom_field_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CustomFieldResponse',
                '/catalog/products/{product_id}/custom-fields/{custom_field_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CustomFieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CustomFieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getCustomFields
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @return \BigCommerce\Api\v3\Model\CustomFieldCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getCustomFields($product_id, array $params = [])
    {
        list($response) = $this->getCustomFieldsWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getCustomFieldsWithHttpInfo
     *
     * @see self::getCustomFields()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CustomFieldCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomFieldsWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getCustomFields');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/custom-fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CustomFieldCollectionResponse',
                '/catalog/products/{product_id}/custom-fields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CustomFieldCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CustomFieldCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getModifierById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ModifierResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getModifierById($product_id, $modifier_id, array $params = [])
    {
        list($response) = $this->getModifierByIdWithHttpInfo($product_id, $modifier_id, $params);
        return $response;
    }


    /**
     * Operation getModifierByIdWithHttpInfo
     *
     * @see self::getModifierById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getModifierByIdWithHttpInfo($product_id, $modifier_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getModifierById');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling getModifierById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierResponse',
                '/catalog/products/{product_id}/modifiers/{modifier_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getModifierValueById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ModifierValueResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getModifierValueById($product_id, $modifier_id, $value_id, array $params = [])
    {
        list($response) = $this->getModifierValueByIdWithHttpInfo($product_id, $modifier_id, $value_id, $params);
        return $response;
    }


    /**
     * Operation getModifierValueByIdWithHttpInfo
     *
     * @see self::getModifierValueById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierValueResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getModifierValueByIdWithHttpInfo($product_id, $modifier_id, $value_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getModifierValueById');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling getModifierValueById');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling getModifierValueById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierValueResponse',
                '/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierValueResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierValueResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getModifierValues
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ModifierValueCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getModifierValues($product_id, $modifier_id, array $params = [])
    {
        list($response) = $this->getModifierValuesWithHttpInfo($product_id, $modifier_id, $params);
        return $response;
    }


    /**
     * Operation getModifierValuesWithHttpInfo
     *
     * @see self::getModifierValues()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierValueCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getModifierValuesWithHttpInfo($product_id, $modifier_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getModifierValues');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling getModifierValues');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}/values";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierValueCollectionResponse',
                '/catalog/products/{product_id}/modifiers/{modifier_id}/values'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierValueCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierValueCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getModifiers
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ModifierCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getModifiers($product_id, array $params = [])
    {
        list($response) = $this->getModifiersWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getModifiersWithHttpInfo
     *
     * @see self::getModifiers()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getModifiersWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getModifiers');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierCollectionResponse',
                '/catalog/products/{product_id}/modifiers'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getOptionById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\OptionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getOptionById($product_id, $option_id, array $params = [])
    {
        list($response) = $this->getOptionByIdWithHttpInfo($product_id, $option_id, $params);
        return $response;
    }


    /**
     * Operation getOptionByIdWithHttpInfo
     *
     * @see self::getOptionById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOptionByIdWithHttpInfo($product_id, $option_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getOptionById');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling getOptionById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionResponse',
                '/catalog/products/{product_id}/options/{option_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getOptionValueById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\OptionValueResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getOptionValueById($product_id, $option_id, $value_id, array $params = [])
    {
        list($response) = $this->getOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, $params);
        return $response;
    }


    /**
     * Operation getOptionValueByIdWithHttpInfo
     *
     * @see self::getOptionValueById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionValueResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOptionValueByIdWithHttpInfo($product_id, $option_id, $value_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getOptionValueById');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling getOptionValueById');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling getOptionValueById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}/values/{value_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionValueResponse',
                '/catalog/products/{product_id}/options/{option_id}/values/{value_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionValueResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionValueResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getOptionValues
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\OptionValueCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getOptionValues($product_id, $option_id, array $params = [])
    {
        list($response) = $this->getOptionValuesWithHttpInfo($product_id, $option_id, $params);
        return $response;
    }


    /**
     * Operation getOptionValuesWithHttpInfo
     *
     * @see self::getOptionValues()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionValueCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOptionValuesWithHttpInfo($product_id, $option_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getOptionValues');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling getOptionValues');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}/values";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionValueCollectionResponse',
                '/catalog/products/{product_id}/options/{option_id}/values'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionValueCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionValueCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getOptions
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\OptionCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getOptions($product_id, array $params = [])
    {
        list($response) = $this->getOptionsWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getOptionsWithHttpInfo
     *
     * @see self::getOptions()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOptionsWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getOptions');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionCollectionResponse',
                '/catalog/products/{product_id}/options'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include string Sub-resources to include on a product, in a comma-separated list. Valid expansions currently include &#x60;variants&#x60;, &#x60;images&#x60;, &#39;primary_image&#x60;, &#x60;custom_fields&#x60;, and &#x60;bulk_pricing_rules&#x60;. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     *     - price_list_id int The ID of the &#x60;Price List&#x60;. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductById($product_id, array $params = [])
    {
        list($response) = $this->getProductByIdWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getProductByIdWithHttpInfo
     *
     * @see self::getProductById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductByIdWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductResponse',
                '/catalog/products/{product_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductImageById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductImageResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductImageById($product_id, $image_id, array $params = [])
    {
        list($response) = $this->getProductImageByIdWithHttpInfo($product_id, $image_id, $params);
        return $response;
    }


    /**
     * Operation getProductImageByIdWithHttpInfo
     *
     * @see self::getProductImageById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductImageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductImageByIdWithHttpInfo($product_id, $image_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductImageById');
        }

        // verify the required parameter 'image_id' is set
        if (!isset($image_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $image_id when calling getProductImageById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/images/{image_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($image_id)) {
            $resourcePath = str_replace(
                "{" . "image_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($image_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductImageResponse',
                '/catalog/products/{product_id}/images/{image_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductImageResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductImageResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductImages
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductImageCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductImages($product_id, array $params = [])
    {
        list($response) = $this->getProductImagesWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getProductImagesWithHttpInfo
     *
     * @see self::getProductImages()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductImageCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductImagesWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductImages');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/images";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductImageCollectionResponse',
                '/catalog/products/{product_id}/images'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductImageCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductImageCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductMetafieldByProductId
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductMetafieldByProductId($metafield_id, $product_id, array $params = [])
    {
        list($response) = $this->getProductMetafieldByProductIdWithHttpInfo($metafield_id, $product_id, $params);
        return $response;
    }


    /**
     * Operation getProductMetafieldByProductIdWithHttpInfo
     *
     * @see self::getProductMetafieldByProductId()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductMetafieldByProductIdWithHttpInfo($metafield_id, $product_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling getProductMetafieldByProductId');
        }

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductMetafieldByProductId');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/products/{product_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductMetafieldsByProductId
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - key string Filter based on a metafield&#39;s key. (optional)
     *     - namespace string Filter based on a metafield&#39;s key. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductMetafieldsByProductId($product_id, array $params = [])
    {
        list($response) = $this->getProductMetafieldsByProductIdWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getProductMetafieldsByProductIdWithHttpInfo
     *
     * @see self::getProductMetafieldsByProductId()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductMetafieldsByProductIdWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductMetafieldsByProductId');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse',
                '/catalog/products/{product_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductReviewById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $review_id The ID of the &#x60;review&#x60; that is being operated on. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductReviewResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductReviewById($product_id, $review_id, array $params = [])
    {
        list($response) = $this->getProductReviewByIdWithHttpInfo($product_id, $review_id, $params);
        return $response;
    }


    /**
     * Operation getProductReviewByIdWithHttpInfo
     *
     * @see self::getProductReviewById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $review_id The ID of the &#x60;review&#x60; that is being operated on. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductReviewResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductReviewByIdWithHttpInfo($product_id, $review_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductReviewById');
        }

        // verify the required parameter 'review_id' is set
        if (!isset($review_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $review_id when calling getProductReviewById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/reviews/{review_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($review_id)) {
            $resourcePath = str_replace(
                "{" . "review_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($review_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductReviewResponse',
                '/catalog/products/{product_id}/reviews/{review_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductReviewResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductReviewResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductReviews
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductReviewCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductReviews($product_id, array $params = [])
    {
        list($response) = $this->getProductReviewsWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getProductReviewsWithHttpInfo
     *
     * @see self::getProductReviews()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductReviewCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductReviewsWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductReviews');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/reviews";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductReviewCollectionResponse',
                '/catalog/products/{product_id}/reviews'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductReviewCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductReviewCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductVideoById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param string $video_id The ID of the &#x60;Video&#x60; that is being operated on. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductVideoResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductVideoById($product_id, $video_id, array $params = [])
    {
        list($response) = $this->getProductVideoByIdWithHttpInfo($product_id, $video_id, $params);
        return $response;
    }


    /**
     * Operation getProductVideoByIdWithHttpInfo
     *
     * @see self::getProductVideoById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param string $video_id The ID of the &#x60;Video&#x60; that is being operated on. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductVideoResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductVideoByIdWithHttpInfo($product_id, $video_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductVideoById');
        }

        // verify the required parameter 'video_id' is set
        if (!isset($video_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $video_id when calling getProductVideoById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/videos/{video_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($video_id)) {
            $resourcePath = str_replace(
                "{" . "video_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($video_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductVideoResponse',
                '/catalog/products/{product_id}/videos/{video_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductVideoResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductVideoResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProductVideos
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductVideoCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProductVideos($product_id, array $params = [])
    {
        list($response) = $this->getProductVideosWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getProductVideosWithHttpInfo
     *
     * @see self::getProductVideos()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductVideoCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductVideosWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getProductVideos');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/videos";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductVideoCollectionResponse',
                '/catalog/products/{product_id}/videos'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductVideoCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductVideoCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getProducts
     *
     *
     *
     * @param array $params = []
     *     - id int Filter items by id. (optional)
     *     - name string Filter items by name. (optional)
     *     - sku string Filter items by sku. (optional)
     *     - upc string Filter items by upc. (optional)
     *     - price float Filter items by price. (optional)
     *     - weight float Filter items by weight. (optional)
     *     - condition int Filter items by condition. (optional)
     *     - brand_id int Filter items by brand_id. (optional)
     *     - date_modified \DateTime Filter items by date_modified. (optional)
     *     - date_last_imported \DateTime Filter items by date_last_imported. (optional)
     *     - is_visible int Filter items by is_visible. (optional)
     *     - is_featured int Filter items by is_featured. (optional)
     *     - is_free_shipping int Filter items by is_free_shipping. (optional)
     *     - inventory_level int Filter items by inventory_level. (optional)
     *     - inventory_low int Filter items by inventory_low. Values: 1, 0. (optional)
     *     - out_of_stock int Filter items by out_of_stock. To enable the filter, pass &#x60;out_of_stock&#x60;&#x3D;&#x60;1&#x60;. (optional)
     *     - total_sold int Filter items by total_sold. (optional)
     *     - type string Filter items by type: &#x60;physical&#x60; or &#x60;digital&#x60;. (optional)
     *     - categories int Filter items by categories. (optional)
     *     - keyword string Filter items by keywords found in the &#x60;name&#x60;, &#x60;description&#x60;, or &#x60;sku&#x60; fields, or in the brand name. (optional)
     *     - keyword_context string Set context for a product search. (optional)
     *     - status int Filter items by status. (optional)
     *     - include string Sub-resources to include on a product, in a comma-separated list. Valid expansions currently include &#x60;variants&#x60;, &#x60;images&#x60;, &#39;primary_image&#x60;, &#x60;custom_fields&#x60;, and &#x60;bulk_pricing_rules&#x60;. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     *     - availability string Filter items by availability. Values are: available, disabled, preorder. (optional)
     *     - price_list_id int The ID of the &#x60;Price List&#x60;. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - direction string Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. (optional)
     *     - sort string Field name to sort by. (optional)
     * @return \BigCommerce\Api\v3\Model\ProductCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getProducts(array $params = [])
    {
        list($response) = $this->getProductsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getProductsWithHttpInfo
     *
     * @see self::getProducts()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductsWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/products";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductCollectionResponse',
                '/catalog/products'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getVariantById
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\VariantResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getVariantById($product_id, $variant_id, array $params = [])
    {
        list($response) = $this->getVariantByIdWithHttpInfo($product_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation getVariantByIdWithHttpInfo
     *
     * @see self::getVariantById()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\VariantResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariantByIdWithHttpInfo($product_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getVariantById');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling getVariantById');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\VariantResponse',
                '/catalog/products/{product_id}/variants/{variant_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\VariantResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\VariantResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getVariantMetafieldByProductIdAndVariantId
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getVariantMetafieldByProductIdAndVariantId($metafield_id, $product_id, $variant_id, array $params = [])
    {
        list($response) = $this->getVariantMetafieldByProductIdAndVariantIdWithHttpInfo($metafield_id, $product_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation getVariantMetafieldByProductIdAndVariantIdWithHttpInfo
     *
     * @see self::getVariantMetafieldByProductIdAndVariantId()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariantMetafieldByProductIdAndVariantIdWithHttpInfo($metafield_id, $product_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling getVariantMetafieldByProductIdAndVariantId');
        }

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getVariantMetafieldByProductIdAndVariantId');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling getVariantMetafieldByProductIdAndVariantId');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getVariantMetafieldsByProductIdAndVariantId
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - key string Filter based on a metafield&#39;s key. (optional)
     *     - namespace string Filter based on a metafield&#39;s key. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getVariantMetafieldsByProductIdAndVariantId($product_id, $variant_id, array $params = [])
    {
        list($response) = $this->getVariantMetafieldsByProductIdAndVariantIdWithHttpInfo($product_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation getVariantMetafieldsByProductIdAndVariantIdWithHttpInfo
     *
     * @see self::getVariantMetafieldsByProductIdAndVariantId()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetaFieldCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariantMetafieldsByProductIdAndVariantIdWithHttpInfo($product_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getVariantMetafieldsByProductIdAndVariantId');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling getVariantMetafieldsByProductIdAndVariantId');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}/metafields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse',
                '/catalog/products/{product_id}/variants/{variant_id}/metafields'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetaFieldCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getVariants
     *
     *
     *
     * @param array $params = []
     *     - id int Filter items by id. (optional)
     *     - sku string Filter items by sku. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\VariantCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getVariants(array $params = [])
    {
        list($response) = $this->getVariantsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getVariantsWithHttpInfo
     *
     * @see self::getVariants()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\VariantCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariantsWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/catalog/variants";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\VariantCollectionResponse',
                '/catalog/variants'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\VariantCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\VariantCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getVariantsByProductId
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include_fields string Fields to include, in a comma-separated list. The ID and the specified fields will be returned. (optional)
     *     - exclude_fields string Fields to exclude, in a comma-separated list. The specified fields will be excluded from a response. The ID cannot be excluded. (optional)
     * @return \BigCommerce\Api\v3\Model\VariantCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getVariantsByProductId($product_id, array $params = [])
    {
        list($response) = $this->getVariantsByProductIdWithHttpInfo($product_id, $params);
        return $response;
    }


    /**
     * Operation getVariantsByProductIdWithHttpInfo
     *
     * @see self::getVariantsByProductId()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\VariantCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariantsByProductIdWithHttpInfo($product_id, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling getVariantsByProductId');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\VariantCollectionResponse',
                '/catalog/products/{product_id}/variants'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\VariantCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\VariantCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateBrand
     *
     *
     *
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\BrandPut $brand Returns a &#x60;Brand&#x60; from the BigCommerce Catalog. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\BrandResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateBrand($brand_id, $brand, array $params = [])
    {
        list($response) = $this->updateBrandWithHttpInfo($brand_id,  $brand, $params);
        return $response;
    }


    /**
     * Operation updateBrandWithHttpInfo
     *
     * @see self::updateBrand()
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\BrandPut $brand Returns a &#x60;Brand&#x60; from the BigCommerce Catalog. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BrandResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandWithHttpInfo($brand_id,  $brand, array $params = [])
    {

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrand');
        }

        // verify the required parameter 'brand' is set
        if (!isset($brand)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand when calling updateBrand');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($brand)) {
        $_tempBody = $brand;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BrandResponse',
                '/catalog/brands/{brand_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BrandResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BrandResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateBrandMetafield
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateBrandMetafield($metafield_id, $brand_id, $metafield, array $params = [])
    {
        list($response) = $this->updateBrandMetafieldWithHttpInfo($metafield_id, $brand_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation updateBrandMetafieldWithHttpInfo
     *
     * @see self::updateBrandMetafield()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $brand_id The ID of the &#x60;Brand&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandMetafieldWithHttpInfo($metafield_id, $brand_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling updateBrandMetafield');
        }

        // verify the required parameter 'brand_id' is set
        if (!isset($brand_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrandMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling updateBrandMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/brands/{brand_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($brand_id)) {
            $resourcePath = str_replace(
                "{" . "brand_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/brands/{brand_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateBulkPricingRule
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $bulk_pricing_rule_id The ID of the &#x60;BulkPricingRule&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\BulkPricingRulePut $bulk_pricing_rule &#x60;BulkPricingRule&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\BulkPricingRuleResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateBulkPricingRule($product_id, $bulk_pricing_rule_id, $bulk_pricing_rule, array $params = [])
    {
        list($response) = $this->updateBulkPricingRuleWithHttpInfo($product_id, $bulk_pricing_rule_id,  $bulk_pricing_rule, $params);
        return $response;
    }


    /**
     * Operation updateBulkPricingRuleWithHttpInfo
     *
     * @see self::updateBulkPricingRule()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $bulk_pricing_rule_id The ID of the &#x60;BulkPricingRule&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\BulkPricingRulePut $bulk_pricing_rule &#x60;BulkPricingRule&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\BulkPricingRuleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBulkPricingRuleWithHttpInfo($product_id, $bulk_pricing_rule_id,  $bulk_pricing_rule, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateBulkPricingRule');
        }

        // verify the required parameter 'bulk_pricing_rule_id' is set
        if (!isset($bulk_pricing_rule_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_pricing_rule_id when calling updateBulkPricingRule');
        }

        // verify the required parameter 'bulk_pricing_rule' is set
        if (!isset($bulk_pricing_rule)) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_pricing_rule when calling updateBulkPricingRule');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($bulk_pricing_rule_id)) {
            $resourcePath = str_replace(
                "{" . "bulk_pricing_rule_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($bulk_pricing_rule_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($bulk_pricing_rule)) {
        $_tempBody = $bulk_pricing_rule;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse',
                '/catalog/products/{product_id}/bulk-pricing-rules/{bulk_pricing_rule_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\BulkPricingRuleResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateCategory
     *
     *
     *
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\CategoryPut $category A BigCommerce &#x60;Category&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\CategoryResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateCategory($category_id, $category, array $params = [])
    {
        list($response) = $this->updateCategoryWithHttpInfo($category_id,  $category, $params);
        return $response;
    }


    /**
     * Operation updateCategoryWithHttpInfo
     *
     * @see self::updateCategory()
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\CategoryPut $category A BigCommerce &#x60;Category&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CategoryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCategoryWithHttpInfo($category_id,  $category, array $params = [])
    {

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling updateCategory');
        }

        // verify the required parameter 'category' is set
        if (!isset($category)) {
            throw new \InvalidArgumentException('Missing the required parameter $category when calling updateCategory');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($category)) {
        $_tempBody = $category;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CategoryResponse',
                '/catalog/categories/{category_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CategoryResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CategoryResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateCategoryMetafield
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateCategoryMetafield($metafield_id, $category_id, $metafield, array $params = [])
    {
        list($response) = $this->updateCategoryMetafieldWithHttpInfo($metafield_id, $category_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation updateCategoryMetafieldWithHttpInfo
     *
     * @see self::updateCategoryMetafield()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $category_id The ID of the &#x60;Category&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCategoryMetafieldWithHttpInfo($metafield_id, $category_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling updateCategoryMetafield');
        }

        // verify the required parameter 'category_id' is set
        if (!isset($category_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $category_id when calling updateCategoryMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling updateCategoryMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/categories/{category_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($category_id)) {
            $resourcePath = str_replace(
                "{" . "category_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($category_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/categories/{category_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateComplexRule
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $complex_rule_id The ID of the &#x60;ComplexRule&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ComplexRulePut $complex_rule &#x60;ComplexRule&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ComplexRuleResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateComplexRule($product_id, $complex_rule_id, $complex_rule, array $params = [])
    {
        list($response) = $this->updateComplexRuleWithHttpInfo($product_id, $complex_rule_id,  $complex_rule, $params);
        return $response;
    }


    /**
     * Operation updateComplexRuleWithHttpInfo
     *
     * @see self::updateComplexRule()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $complex_rule_id The ID of the &#x60;ComplexRule&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ComplexRulePut $complex_rule &#x60;ComplexRule&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ComplexRuleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateComplexRuleWithHttpInfo($product_id, $complex_rule_id,  $complex_rule, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateComplexRule');
        }

        // verify the required parameter 'complex_rule_id' is set
        if (!isset($complex_rule_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $complex_rule_id when calling updateComplexRule');
        }

        // verify the required parameter 'complex_rule' is set
        if (!isset($complex_rule)) {
            throw new \InvalidArgumentException('Missing the required parameter $complex_rule when calling updateComplexRule');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/complex-rules/{complex_rule_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($complex_rule_id)) {
            $resourcePath = str_replace(
                "{" . "complex_rule_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($complex_rule_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($complex_rule)) {
        $_tempBody = $complex_rule;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ComplexRuleResponse',
                '/catalog/products/{product_id}/complex-rules/{complex_rule_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ComplexRuleResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ComplexRuleResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateConfigurableField
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $configurable_field_id The ID of the &#x60;ConfigurableField&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ConfigurableFieldPut $configurable_field &#x60;ConfigurableField&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ConfigurableFieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateConfigurableField($product_id, $configurable_field_id, $configurable_field, array $params = [])
    {
        list($response) = $this->updateConfigurableFieldWithHttpInfo($product_id, $configurable_field_id,  $configurable_field, $params);
        return $response;
    }


    /**
     * Operation updateConfigurableFieldWithHttpInfo
     *
     * @see self::updateConfigurableField()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $configurable_field_id The ID of the &#x60;ConfigurableField&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ConfigurableFieldPut $configurable_field &#x60;ConfigurableField&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ConfigurableFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateConfigurableFieldWithHttpInfo($product_id, $configurable_field_id,  $configurable_field, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateConfigurableField');
        }

        // verify the required parameter 'configurable_field_id' is set
        if (!isset($configurable_field_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $configurable_field_id when calling updateConfigurableField');
        }

        // verify the required parameter 'configurable_field' is set
        if (!isset($configurable_field)) {
            throw new \InvalidArgumentException('Missing the required parameter $configurable_field when calling updateConfigurableField');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/configurable-fields/{configurable_field_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($configurable_field_id)) {
            $resourcePath = str_replace(
                "{" . "configurable_field_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($configurable_field_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($configurable_field)) {
        $_tempBody = $configurable_field;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse',
                '/catalog/products/{product_id}/configurable-fields/{configurable_field_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ConfigurableFieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateCustomField
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\CustomFieldPut $custom_field &#x60;CustomField&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\CustomFieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateCustomField($product_id, $custom_field_id, $custom_field, array $params = [])
    {
        list($response) = $this->updateCustomFieldWithHttpInfo($product_id, $custom_field_id,  $custom_field, $params);
        return $response;
    }


    /**
     * Operation updateCustomFieldWithHttpInfo
     *
     * @see self::updateCustomField()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $custom_field_id The ID of the &#x60;CustomField&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\CustomFieldPut $custom_field &#x60;CustomField&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\CustomFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomFieldWithHttpInfo($product_id, $custom_field_id,  $custom_field, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateCustomField');
        }

        // verify the required parameter 'custom_field_id' is set
        if (!isset($custom_field_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field_id when calling updateCustomField');
        }

        // verify the required parameter 'custom_field' is set
        if (!isset($custom_field)) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field when calling updateCustomField');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/custom-fields/{custom_field_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($custom_field_id)) {
            $resourcePath = str_replace(
                "{" . "custom_field_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($custom_field)) {
        $_tempBody = $custom_field;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\CustomFieldResponse',
                '/catalog/products/{product_id}/custom-fields/{custom_field_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\CustomFieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\CustomFieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateModifier
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierPut $modifier A BigCommerce &#x60;Modifier&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ModifierResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateModifier($product_id, $modifier_id, $modifier, array $params = [])
    {
        list($response) = $this->updateModifierWithHttpInfo($product_id, $modifier_id,  $modifier, $params);
        return $response;
    }


    /**
     * Operation updateModifierWithHttpInfo
     *
     * @see self::updateModifier()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierPut $modifier A BigCommerce &#x60;Modifier&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateModifierWithHttpInfo($product_id, $modifier_id,  $modifier, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateModifier');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling updateModifier');
        }

        // verify the required parameter 'modifier' is set
        if (!isset($modifier)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier when calling updateModifier');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($modifier)) {
        $_tempBody = $modifier;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierResponse',
                '/catalog/products/{product_id}/modifiers/{modifier_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateModifierValue
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierValuePut $modifier_value A BigCommerce &#x60;ModifierValue&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ModifierValueResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateModifierValue($product_id, $modifier_id, $value_id, $modifier_value, array $params = [])
    {
        list($response) = $this->updateModifierValueWithHttpInfo($product_id, $modifier_id, $value_id,  $modifier_value, $params);
        return $response;
    }


    /**
     * Operation updateModifierValueWithHttpInfo
     *
     * @see self::updateModifierValue()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $modifier_id The ID of the &#x60;Modifier&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\ModifierValuePut $modifier_value A BigCommerce &#x60;ModifierValue&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ModifierValueResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateModifierValueWithHttpInfo($product_id, $modifier_id, $value_id,  $modifier_value, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateModifierValue');
        }

        // verify the required parameter 'modifier_id' is set
        if (!isset($modifier_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_id when calling updateModifierValue');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling updateModifierValue');
        }

        // verify the required parameter 'modifier_value' is set
        if (!isset($modifier_value)) {
            throw new \InvalidArgumentException('Missing the required parameter $modifier_value when calling updateModifierValue');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($modifier_id)) {
            $resourcePath = str_replace(
                "{" . "modifier_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($modifier_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($modifier_value)) {
        $_tempBody = $modifier_value;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ModifierValueResponse',
                '/catalog/products/{product_id}/modifiers/{modifier_id}/values/{value_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ModifierValueResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ModifierValueResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateOption
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\OptionPut $option A BigCommerce &#x60;Option&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\OptionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateOption($product_id, $option_id, $option, array $params = [])
    {
        list($response) = $this->updateOptionWithHttpInfo($product_id, $option_id,  $option, $params);
        return $response;
    }


    /**
     * Operation updateOptionWithHttpInfo
     *
     * @see self::updateOption()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\OptionPut $option A BigCommerce &#x60;Option&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateOptionWithHttpInfo($product_id, $option_id,  $option, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateOption');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling updateOption');
        }

        // verify the required parameter 'option' is set
        if (!isset($option)) {
            throw new \InvalidArgumentException('Missing the required parameter $option when calling updateOption');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($option)) {
        $_tempBody = $option;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionResponse',
                '/catalog/products/{product_id}/options/{option_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateOptionValue
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\OptionValuePut $option_value A BigCommerce &#x60;OptionValue&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\OptionValueResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateOptionValue($product_id, $option_id, $value_id, $option_value, array $params = [])
    {
        list($response) = $this->updateOptionValueWithHttpInfo($product_id, $option_id, $value_id,  $option_value, $params);
        return $response;
    }


    /**
     * Operation updateOptionValueWithHttpInfo
     *
     * @see self::updateOptionValue()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $option_id The ID of the &#x60;Option&#x60;. (required)
     * @param int $value_id The ID of the &#x60;Modifier/Option Value&#x60;. (required)
     * @param \BigCommerce\Api\v3\Model\OptionValuePut $option_value A BigCommerce &#x60;OptionValue&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\OptionValueResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateOptionValueWithHttpInfo($product_id, $option_id, $value_id,  $option_value, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateOptionValue');
        }

        // verify the required parameter 'option_id' is set
        if (!isset($option_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_id when calling updateOptionValue');
        }

        // verify the required parameter 'value_id' is set
        if (!isset($value_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $value_id when calling updateOptionValue');
        }

        // verify the required parameter 'option_value' is set
        if (!isset($option_value)) {
            throw new \InvalidArgumentException('Missing the required parameter $option_value when calling updateOptionValue');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/options/{option_id}/values/{value_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($option_id)) {
            $resourcePath = str_replace(
                "{" . "option_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($option_id),
                $resourcePath
            );
        }
        // path params


        if (isset($value_id)) {
            $resourcePath = str_replace(
                "{" . "value_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($value_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($option_value)) {
        $_tempBody = $option_value;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\OptionValueResponse',
                '/catalog/products/{product_id}/options/{option_id}/values/{value_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\OptionValueResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\OptionValueResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateProduct
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductPut $product A BigCommerce &#x60;Product&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateProduct($product_id, $product, array $params = [])
    {
        list($response) = $this->updateProductWithHttpInfo($product_id,  $product, $params);
        return $response;
    }


    /**
     * Operation updateProductWithHttpInfo
     *
     * @see self::updateProduct()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\ProductPut $product A BigCommerce &#x60;Product&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductWithHttpInfo($product_id,  $product, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateProduct');
        }

        // verify the required parameter 'product' is set
        if (!isset($product)) {
            throw new \InvalidArgumentException('Missing the required parameter $product when calling updateProduct');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product)) {
        $_tempBody = $product;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductResponse',
                '/catalog/products/{product_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateProductImage
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param \BigCommerce\Api\v3\Model\ProductImagePut $product_image A BigCommerce &#x60;ProductImage&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductImageResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateProductImage($product_id, $image_id, $product_image, array $params = [])
    {
        list($response) = $this->updateProductImageWithHttpInfo($product_id, $image_id,  $product_image, $params);
        return $response;
    }


    /**
     * Operation updateProductImageWithHttpInfo
     *
     * @see self::updateProductImage()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $image_id The ID of the &#x60;Image&#x60; that is being operated on. (required)
     * @param \BigCommerce\Api\v3\Model\ProductImagePut $product_image A BigCommerce &#x60;ProductImage&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductImageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductImageWithHttpInfo($product_id, $image_id,  $product_image, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateProductImage');
        }

        // verify the required parameter 'image_id' is set
        if (!isset($image_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $image_id when calling updateProductImage');
        }

        // verify the required parameter 'product_image' is set
        if (!isset($product_image)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_image when calling updateProductImage');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/images/{image_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($image_id)) {
            $resourcePath = str_replace(
                "{" . "image_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($image_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product_image)) {
        $_tempBody = $product_image;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductImageResponse',
                '/catalog/products/{product_id}/images/{image_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductImageResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductImageResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateProductMetafield
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateProductMetafield($metafield_id, $product_id, $metafield, array $params = [])
    {
        list($response) = $this->updateProductMetafieldWithHttpInfo($metafield_id, $product_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation updateProductMetafieldWithHttpInfo
     *
     * @see self::updateProductMetafield()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductMetafieldWithHttpInfo($metafield_id, $product_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling updateProductMetafield');
        }

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateProductMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling updateProductMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/products/{product_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateProductReview
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $review_id The ID of the &#x60;review&#x60; that is being operated on. (required)
     * @param \BigCommerce\Api\v3\Model\ProductReviewPut $product_review A BigCommerce &#x60;ProductReview&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductReviewResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateProductReview($product_id, $review_id, $product_review, array $params = [])
    {
        list($response) = $this->updateProductReviewWithHttpInfo($product_id, $review_id,  $product_review, $params);
        return $response;
    }


    /**
     * Operation updateProductReviewWithHttpInfo
     *
     * @see self::updateProductReview()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $review_id The ID of the &#x60;review&#x60; that is being operated on. (required)
     * @param \BigCommerce\Api\v3\Model\ProductReviewPut $product_review A BigCommerce &#x60;ProductReview&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductReviewResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductReviewWithHttpInfo($product_id, $review_id,  $product_review, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateProductReview');
        }

        // verify the required parameter 'review_id' is set
        if (!isset($review_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $review_id when calling updateProductReview');
        }

        // verify the required parameter 'product_review' is set
        if (!isset($product_review)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_review when calling updateProductReview');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/reviews/{review_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($review_id)) {
            $resourcePath = str_replace(
                "{" . "review_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($review_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product_review)) {
        $_tempBody = $product_review;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductReviewResponse',
                '/catalog/products/{product_id}/reviews/{review_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductReviewResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductReviewResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateProductVideo
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param string $video_id The ID of the &#x60;Video&#x60; that is being operated on. (required)
     * @param \BigCommerce\Api\v3\Model\ProductVideoPut $product_video A BigCommerce &#x60;ProductVideo&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\ProductVideoResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateProductVideo($product_id, $video_id, $product_video, array $params = [])
    {
        list($response) = $this->updateProductVideoWithHttpInfo($product_id, $video_id,  $product_video, $params);
        return $response;
    }


    /**
     * Operation updateProductVideoWithHttpInfo
     *
     * @see self::updateProductVideo()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param string $video_id The ID of the &#x60;Video&#x60; that is being operated on. (required)
     * @param \BigCommerce\Api\v3\Model\ProductVideoPut $product_video A BigCommerce &#x60;ProductVideo&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ProductVideoResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProductVideoWithHttpInfo($product_id, $video_id,  $product_video, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateProductVideo');
        }

        // verify the required parameter 'video_id' is set
        if (!isset($video_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $video_id when calling updateProductVideo');
        }

        // verify the required parameter 'product_video' is set
        if (!isset($product_video)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_video when calling updateProductVideo');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/videos/{video_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($video_id)) {
            $resourcePath = str_replace(
                "{" . "video_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($video_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($product_video)) {
        $_tempBody = $product_video;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ProductVideoResponse',
                '/catalog/products/{product_id}/videos/{video_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ProductVideoResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ProductVideoResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateVariant
     *
     *
     *
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param \BigCommerce\Api\v3\Model\VariantPut $variant A &#x60;Variant&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\VariantResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateVariant($product_id, $variant_id, $variant, array $params = [])
    {
        list($response) = $this->updateVariantWithHttpInfo($product_id, $variant_id,  $variant, $params);
        return $response;
    }


    /**
     * Operation updateVariantWithHttpInfo
     *
     * @see self::updateVariant()
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param \BigCommerce\Api\v3\Model\VariantPut $variant A &#x60;Variant&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\VariantResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateVariantWithHttpInfo($product_id, $variant_id,  $variant, array $params = [])
    {

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateVariant');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling updateVariant');
        }

        // verify the required parameter 'variant' is set
        if (!isset($variant)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant when calling updateVariant');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($variant)) {
        $_tempBody = $variant;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\VariantResponse',
                '/catalog/products/{product_id}/variants/{variant_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\VariantResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\VariantResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updateVariantMetafield
     *
     *
     *
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\MetafieldResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateVariantMetafield($metafield_id, $product_id, $variant_id, $metafield, array $params = [])
    {
        list($response) = $this->updateVariantMetafieldWithHttpInfo($metafield_id, $product_id, $variant_id,  $metafield, $params);
        return $response;
    }


    /**
     * Operation updateVariantMetafieldWithHttpInfo
     *
     * @see self::updateVariantMetafield()
     * @param int $metafield_id The ID of the &#x60;Metafield&#x60;. (required)
     * @param int $product_id The ID of the &#x60;Product&#x60; to which the resource belongs. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param \BigCommerce\Api\v3\Model\MetafieldPut $metafield A &#x60;Metafield&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\MetafieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateVariantMetafieldWithHttpInfo($metafield_id, $product_id, $variant_id,  $metafield, array $params = [])
    {

        // verify the required parameter 'metafield_id' is set
        if (!isset($metafield_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield_id when calling updateVariantMetafield');
        }

        // verify the required parameter 'product_id' is set
        if (!isset($product_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $product_id when calling updateVariantMetafield');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling updateVariantMetafield');
        }

        // verify the required parameter 'metafield' is set
        if (!isset($metafield)) {
            throw new \InvalidArgumentException('Missing the required parameter $metafield when calling updateVariantMetafield');
        }


        // parse inputs
        $resourcePath = "/catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($metafield_id)) {
            $resourcePath = str_replace(
                "{" . "metafield_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($metafield_id),
                $resourcePath
            );
        }
        // path params


        if (isset($product_id)) {
            $resourcePath = str_replace(
                "{" . "product_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($product_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($metafield)) {
        $_tempBody = $metafield;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\MetafieldResponse',
                '/catalog/products/{product_id}/variants/{variant_id}/metafields/{metafield_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\MetafieldResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\MetafieldResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
}
