<?php
/**
 * List of currencies by ISO-4217.
 *
 * @see https://github.com/Payum/iso4217
 * @see https://en.wikipedia.org/wiki/ISO_4217
 */
return [
	[
		'name' => esc_html__( 'UAE Dirham', 'awebooking' ),
		'alpha3' => 'AED',
		'numeric' => '784',
		'exp' => 2,
		'country' => 'AE',
	],
	[
		'name' => esc_html__( 'Afghan Afghani', 'awebooking' ),
		'alpha3' => 'AFN',
		'numeric' => '971',
		'exp' => 2,
		'country' => 'AF',
	],
	[
		'name' => esc_html__( 'Albanian Lek', 'awebooking' ),
		'alpha3' => 'ALL',
		'numeric' => '008',
		'exp' => 2,
		'country' => 'AL',
	],
	[
		'name' => esc_html__( 'Armenian Dram', 'awebooking' ),
		'alpha3' => 'AMD',
		'numeric' => '051',
		'exp' => 2,
		'country' => 'AM',
	],
	[
		'name' => esc_html__( 'Netherlands Antillean Guilder', 'awebooking' ),
		'alpha3' => 'ANG',
		'numeric' => '532',
		'exp' => 2,
		'country' => [ 'CW', 'SX' ],
	],
	[
		'name' => esc_html__( 'Angolan Kwanza', 'awebooking' ),
		'alpha3' => 'AOA',
		'numeric' => '973',
		'exp' => 2,
		'country' => 'AO',
	],
	[
		'name' => esc_html__( 'Argentine Peso', 'awebooking' ),
		'alpha3' => 'ARS',
		'numeric' => '032',
		'exp' => 2,
		'country' => 'AR',
	],
	[
		'name' => esc_html__( 'Australian Dollar', 'awebooking' ),
		'alpha3' => 'AUD',
		'numeric' => '036',
		'exp' => 2,
		'country' => [ 'AU', 'CC', 'CX', 'HM', 'KI', 'NF', 'NR', 'TV' ],
	],
	[
		'name' => esc_html__( 'Aruban Florin', 'awebooking' ),
		'alpha3' => 'AWG',
		'numeric' => '533',
		'exp' => 2,
		'country' => 'AW',
	],
	[
		'name' => esc_html__( 'Azerbaijani Manat', 'awebooking' ),
		'alpha3' => 'AZN',
		'numeric' => '944',
		'exp' => 2,
		'country' => 'AZ',
	],
	[
		'name' => esc_html__( 'Bosnia and Herzegovina Convertible Mark', 'awebooking' ),
		'alpha3' => 'BAM',
		'numeric' => '977',
		'exp' => 2,
		'country' => 'BA',
	],
	[
		'name' => esc_html__( 'Barbados Dollar', 'awebooking' ),
		'alpha3' => 'BBD',
		'numeric' => '052',
		'exp' => 2,
		'country' => 'BB',
	],
	[
		'name' => esc_html__( 'Bangladeshi Taka', 'awebooking' ),
		'alpha3' => 'BDT',
		'numeric' => '050',
		'exp' => 2,
		'country' => 'BD',
	],
	[
		'name' => esc_html__( 'Bulgarian Lev', 'awebooking' ),
		'alpha3' => 'BGN',
		'numeric' => '975',
		'exp' => 2,
		'country' => 'BG',
	],
	[
		'name' => esc_html__( 'Bahraini Dinar', 'awebooking' ),
		'alpha3' => 'BHD',
		'numeric' => '048',
		'exp' => 3,
		'country' => 'BH',
	],
	[
		'name' => esc_html__( 'Burundian Franc', 'awebooking' ),
		'alpha3' => 'BIF',
		'numeric' => '108',
		'exp' => 0,
		'country' => 'BI',
	],
	[
		'name' => esc_html__( 'Bermudian Dollar', 'awebooking' ),
		'alpha3' => 'BMD',
		'numeric' => '060',
		'exp' => 2,
		'country' => 'BM',
	],
	[
		'name' => esc_html__( 'Brunei Dollar', 'awebooking' ),
		'alpha3' => 'BND',
		'numeric' => '096',
		'exp' => 2,
		'country' => 'BN',
	],
	[
		'name' => esc_html__( 'Boliviano', 'awebooking' ),
		'alpha3' => 'BOB',
		'numeric' => '068',
		'exp' => 2,
		'country' => 'BO',
	],
	[
		'name' => esc_html__( 'Brazilian Real', 'awebooking' ),
		'alpha3' => 'BRL',
		'numeric' => '986',
		'exp' => 2,
		'country' => 'BR',
	],
	[
		'name' => esc_html__( 'Bahamian Dollar', 'awebooking' ),
		'alpha3' => 'BSD',
		'numeric' => '044',
		'exp' => 2,
		'country' => 'BS',
	],
	[
		'name' => esc_html__( 'Bhutanese Ngultrum', 'awebooking' ),
		'alpha3' => 'BTN',
		'numeric' => '064',
		'exp' => 2,
		'country' => 'BT',
	],
	[
		'name' => esc_html__( 'Botswana Pula', 'awebooking' ),
		'alpha3' => 'BWP',
		'numeric' => '072',
		'exp' => 2,
		'country' => [ 'BW', 'ZW' ],
	],
	[
		'name' => esc_html__( 'Belarussian Ruble', 'awebooking' ),
		'alpha3' => 'BYR',
		'numeric' => '974',
		'exp' => 0,
		'country' => 'BY',
	],
	[
		'name' => esc_html__( 'Belize Dollar', 'awebooking' ),
		'alpha3' => 'BZD',
		'numeric' => '084',
		'exp' => 2,
		'country' => 'BZ',
	],
	[
		'name' => esc_html__( 'Canadian Dollar', 'awebooking' ),
		'alpha3' => 'CAD',
		'numeric' => '124',
		'exp' => 2,
		'country' => 'CA',
	],
	[
		'name' => esc_html__( 'Congolese Franc', 'awebooking' ),
		'alpha3' => 'CDF',
		'numeric' => '976',
		'exp' => 2,
		'country' => 'CD',
	],
	[
		'name' => esc_html__( 'Swiss Franc', 'awebooking' ),
		'alpha3' => 'CHF',
		'numeric' => '756',
		'exp' => 2,
		'country' => [ 'CH', 'LI' ],
	],
	[
		'name' => esc_html__( 'Chilean Peso', 'awebooking' ),
		'alpha3' => 'CLP',
		'numeric' => '152',
		'exp' => 0,
		'country' => 'CL',
	],
	[
		'name' => esc_html__( 'Chinese Yuan', 'awebooking' ),
		'alpha3' => 'CNY',
		'numeric' => '156',
		'exp' => 2,
		'country' => 'CN',
	],
	[
		'name' => esc_html__( 'Colombian Peso', 'awebooking' ),
		'alpha3' => 'COP',
		'numeric' => '170',
		'exp' => 2,
		'country' => 'CO',
	],
	[
		'name' => esc_html__( 'Costa Rican Colon', 'awebooking' ),
		'alpha3' => 'CRC',
		'numeric' => '188',
		'exp' => 2,
		'country' => 'CR',
	],
	[
		'name' => esc_html__( 'Cuban Convertible Peso', 'awebooking' ),
		'alpha3' => 'CUC',
		'numeric' => '931',
		'exp' => 2,
		'country' => 'CU',
	],
	[
		'name' => esc_html__( 'Cuban Peso', 'awebooking' ),
		'alpha3' => 'CUP',
		'numeric' => '192',
		'exp' => 2,
		'country' => 'CU',
	],
	[
		'name' => esc_html__( 'Cape Verde Escudo', 'awebooking' ),
		'alpha3' => 'CVE',
		'numeric' => '132',
		'exp' => 2,
		'country' => 'CV',
	],
	[
		'name' => esc_html__( 'Czech Koruna', 'awebooking' ),
		'alpha3' => 'CZK',
		'numeric' => '203',
		'exp' => 2,
		'country' => 'CZ',
	],
	[
		'name' => esc_html__( 'Djiboutian Franc', 'awebooking' ),
		'alpha3' => 'DJF',
		'numeric' => '262',
		'exp' => 0,
		'country' => 'DJ',
	],
	[
		'name' => esc_html__( 'Danish Krone', 'awebooking' ),
		'alpha3' => 'DKK',
		'numeric' => '208',
		'exp' => 2,
		'country' => [ 'DK', 'FO', 'GL' ],
	],
	[
		'name' => esc_html__( 'Dominican Peso', 'awebooking' ),
		'alpha3' => 'DOP',
		'numeric' => '214',
		'exp' => 2,
		'country' => 'DO',
	],
	[
		'name' => esc_html__( 'Algerian Dinar', 'awebooking' ),
		'alpha3' => 'DZD',
		'numeric' => '012',
		'exp' => 2,
		'country' => 'DZ',
	],
	[
		'name' => esc_html__( 'Egyptian Pound', 'awebooking' ),
		'alpha3' => 'EGP',
		'numeric' => '818',
		'exp' => 2,
		'country' => 'EG',
	],
	[
		'name' => esc_html__( 'Eritrean Nakfa', 'awebooking' ),
		'alpha3' => 'ERN',
		'numeric' => '232',
		'exp' => 2,
		'country' => 'ER',
	],
	[
		'name' => esc_html__( 'Ethiopian Birr', 'awebooking' ),
		'alpha3' => 'ETB',
		'numeric' => '230',
		'exp' => 2,
		'country' => 'ET',
	],
	[
		'name' => esc_html__( 'Euro', 'awebooking' ),
		'alpha3' => 'EUR',
		'numeric' => '978',
		'exp' => 2,
		'country' => [ 'AD', 'AT', 'AX', 'BE', 'BL', 'CY', 'DE', 'EE', 'ES', 'FI', 'FR', 'GF', 'GP', 'GR', 'IE', 'IT', 'LT', 'LU', 'LV', 'MC', 'ME', 'MF', 'MQ', 'MT', 'NL', 'PM', 'PT', 'RE', 'SI', 'SK', 'SM', 'TF', 'VA', 'YT', 'ZW' ],
	],
	[
		'name' => esc_html__( 'Fiji Dollar', 'awebooking' ),
		'alpha3' => 'FJD',
		'numeric' => '242',
		'exp' => 2,
		'country' => 'FJ',
	],
	[
		'name' => esc_html__( 'Falkland Islands Pound', 'awebooking' ),
		'alpha3' => 'FKP',
		'numeric' => '238',
		'exp' => 2,
		'country' => 'FK',
	],
	[
		'name' => esc_html__( 'Pound Sterling', 'awebooking' ),
		'alpha3' => 'GBP',
		'numeric' => '826',
		'exp' => 2,
		'country' => [ 'GB', 'GG', 'GS', 'IM', 'IO', 'JE', 'ZW' ],
	],
	[
		'name' => esc_html__( 'Georgian Lari', 'awebooking' ),
		'alpha3' => 'GEL',
		'numeric' => '981',
		'exp' => 2,
		'country' => 'GE',
	],
	[
		'name' => esc_html__( 'Ghanaian Cedi', 'awebooking' ),
		'alpha3' => 'GHS',
		'numeric' => '936',
		'exp' => 2,
		'country' => 'GH',
	],
	[
		'name' => esc_html__( 'Gibraltar Pound', 'awebooking' ),
		'alpha3' => 'GIP',
		'numeric' => '292',
		'exp' => 2,
		'country' => 'GI',
	],
	[
		'name' => esc_html__( 'Gambian Dalasi', 'awebooking' ),
		'alpha3' => 'GMD',
		'numeric' => '270',
		'exp' => 2,
		'country' => 'GM',
	],
	[
		'name' => esc_html__( 'Guinean Franc', 'awebooking' ),
		'alpha3' => 'GNF',
		'numeric' => '324',
		'exp' => 0,
		'country' => 'GN',
	],
	[
		'name' => esc_html__( 'Guatemalan Quetzal', 'awebooking' ),
		'alpha3' => 'GTQ',
		'numeric' => '320',
		'exp' => 2,
		'country' => 'GT',
	],
	[
		'name' => esc_html__( 'Guyanese Dollar', 'awebooking' ),
		'alpha3' => 'GYD',
		'numeric' => '328',
		'exp' => 2,
		'country' => 'GY',
	],
	[
		'name' => esc_html__( 'Hong Kong Dollar', 'awebooking' ),
		'alpha3' => 'HKD',
		'numeric' => '344',
		'exp' => 2,
		'country' => 'HK',
	],
	[
		'name' => esc_html__( 'Honduran Lempira', 'awebooking' ),
		'alpha3' => 'HNL',
		'numeric' => '340',
		'exp' => 2,
		'country' => 'HN',
	],
	[
		'name' => esc_html__( 'Croatian Kuna', 'awebooking' ),
		'alpha3' => 'HRK',
		'numeric' => '191',
		'exp' => 2,
		'country' => 'HR',
	],
	[
		'name' => esc_html__( 'Haitian Gourde', 'awebooking' ),
		'alpha3' => 'HTG',
		'numeric' => '332',
		'exp' => 2,
		'country' => 'HT',
	],
	[
		'name' => esc_html__( 'Hungarian Forint', 'awebooking' ),
		'alpha3' => 'HUF',
		'numeric' => '348',
		'exp' => 2,
		'country' => 'HU',
	],
	[
		'name' => esc_html__( 'Indonesian Rupiah', 'awebooking' ),
		'alpha3' => 'IDR',
		'numeric' => '360',
		'exp' => 2,
		'country' => 'ID',
	],
	[
		'name' => esc_html__( 'Israeli New Sheqel', 'awebooking' ),
		'alpha3' => 'ILS',
		'numeric' => '376',
		'exp' => 2,
		'country' => [ 'IL', 'PS' ],
	],
	[
		'name' => esc_html__( 'Indian Rupee', 'awebooking' ),
		'alpha3' => 'INR',
		'numeric' => '356',
		'exp' => 2,
		'country' => 'IN',
	],
	[
		'name' => esc_html__( 'Iraqi Dinar', 'awebooking' ),
		'alpha3' => 'IQD',
		'numeric' => '368',
		'exp' => 3,
		'country' => 'IQ',
	],
	[
		'name' => esc_html__( 'Iranian Rial', 'awebooking' ),
		'alpha3' => 'IRR',
		'numeric' => '364',
		'exp' => 2,
		'country' => 'IR',
	],
	[
		'name' => esc_html__( 'Icelandic Króna', 'awebooking' ),
		'alpha3' => 'ISK',
		'numeric' => '352',
		'exp' => 0,
		'country' => 'IS',
	],
	[
		'name' => esc_html__( 'Jamaican Dollar', 'awebooking' ),
		'alpha3' => 'JMD',
		'numeric' => '388',
		'exp' => 2,
		'country' => 'JM',
	],
	[
		'name' => esc_html__( 'Jordanian Dinar', 'awebooking' ),
		'alpha3' => 'JOD',
		'numeric' => '400',
		'exp' => 3,
		'country' => 'JO',
	],
	[
		'name' => esc_html__( 'Japanese Yen', 'awebooking' ),
		'alpha3' => 'JPY',
		'numeric' => '392',
		'exp' => 0,
		'country' => 'JP',
	],
	[
		'name' => esc_html__( 'Kenyan Shilling', 'awebooking' ),
		'alpha3' => 'KES',
		'numeric' => '404',
		'exp' => 2,
		'country' => 'KE',
	],
	[
		'name' => esc_html__( 'Kyrgyzstani Som', 'awebooking' ),
		'alpha3' => 'KGS',
		'numeric' => '417',
		'exp' => 2,
		'country' => 'KG',
	],
	[
		'name' => esc_html__( 'Cambodian Riel', 'awebooking' ),
		'alpha3' => 'KHR',
		'numeric' => '116',
		'exp' => 2,
		'country' => 'KH',
	],
	[
		'name' => esc_html__( 'Comoro Franc', 'awebooking' ),
		'alpha3' => 'KMF',
		'numeric' => '174',
		'exp' => 0,
		'country' => 'KM',
	],
	[
		'name' => esc_html__( 'North Korean Won', 'awebooking' ),
		'alpha3' => 'KPW',
		'numeric' => '408',
		'exp' => 2,
		'country' => 'KP',
	],
	[
		'name' => esc_html__( 'South Korean Won', 'awebooking' ),
		'alpha3' => 'KRW',
		'numeric' => '410',
		'exp' => 0,
		'country' => 'KR',
	],
	[
		'name' => esc_html__( 'Kuwaiti Dinar', 'awebooking' ),
		'alpha3' => 'KWD',
		'numeric' => '414',
		'exp' => 3,
		'country' => 'KW',
	],
	[
		'name' => esc_html__( 'Cayman Islands Dollar', 'awebooking' ),
		'alpha3' => 'KYD',
		'numeric' => '136',
		'exp' => 2,
		'country' => 'KY',
	],
	[
		'name' => esc_html__( 'Kazakhstani Tenge', 'awebooking' ),
		'alpha3' => 'KZT',
		'numeric' => '398',
		'exp' => 2,
		'country' => 'KZ',
	],
	[
		'name' => esc_html__( 'Lao Kip', 'awebooking' ),
		'alpha3' => 'LAK',
		'numeric' => '418',
		'exp' => 2,
		'country' => 'LA',
	],
	[
		'name' => esc_html__( 'Lebanese Pound', 'awebooking' ),
		'alpha3' => 'LBP',
		'numeric' => '422',
		'exp' => 2,
		'country' => 'LB',
	],
	[
		'name' => esc_html__( 'Sri Lankan Rupee', 'awebooking' ),
		'alpha3' => 'LKR',
		'numeric' => '144',
		'exp' => 2,
		'country' => 'LK',
	],
	[
		'name' => esc_html__( 'Liberian Dollar', 'awebooking' ),
		'alpha3' => 'LRD',
		'numeric' => '430',
		'exp' => 2,
		'country' => 'LR',
	],
	[
		'name' => esc_html__( 'Lesotho Loti', 'awebooking' ),
		'alpha3' => 'LSL',
		'numeric' => '426',
		'exp' => 2,
		'country' => 'LS',
	],
	[
		'name' => esc_html__( 'Libyan Dinar', 'awebooking' ),
		'alpha3' => 'LYD',
		'numeric' => '434',
		'exp' => 3,
		'country' => 'LY',
	],
	[
		'name' => esc_html__( 'Moroccan Dirham', 'awebooking' ),
		'alpha3' => 'MAD',
		'numeric' => '504',
		'exp' => 2,
		'country' => [ 'EH', 'MA' ],
	],
	[
		'name' => esc_html__( 'Moldovan Leu', 'awebooking' ),
		'alpha3' => 'MDL',
		'numeric' => '498',
		'exp' => 2,
		'country' => 'MD',
	],
	[
		'name' => esc_html__( 'Malagasy Ariary', 'awebooking' ),
		'alpha3' => 'MGA',
		'numeric' => '969',
		'exp' => 0,
		'country' => 'MG',
	],
	[
		'name' => esc_html__( 'Macedonian Denar', 'awebooking' ),
		'alpha3' => 'MKD',
		'numeric' => '807',
		'exp' => 2,
		'country' => 'MK',
	],
	[
		'name' => esc_html__( 'Myanmar Kyat', 'awebooking' ),
		'alpha3' => 'MMK',
		'numeric' => '104',
		'exp' => 2,
		'country' => 'MM',
	],
	[
		'name' => esc_html__( 'Mongolian Tugrik', 'awebooking' ),
		'alpha3' => 'MNT',
		'numeric' => '496',
		'exp' => 2,
		'country' => 'MN',
	],
	[
		'name' => esc_html__( 'Macanese Pataca', 'awebooking' ),
		'alpha3' => 'MOP',
		'numeric' => '446',
		'exp' => 2,
		'country' => 'MO',
	],
	[
		'name' => esc_html__( 'Mauritanian Ouguiya', 'awebooking' ),
		'alpha3' => 'MRO',
		'numeric' => '478',
		'exp' => 0,
		'country' => 'MR',
	],
	[
		'name' => esc_html__( 'Mauritian Rupee', 'awebooking' ),
		'alpha3' => 'MUR',
		'numeric' => '480',
		'exp' => 2,
		'country' => 'MU',
	],
	[
		'name' => esc_html__( 'Maldivian Rufiyaa', 'awebooking' ),
		'alpha3' => 'MVR',
		'numeric' => '462',
		'exp' => 2,
		'country' => 'MV',
	],
	[
		'name' => esc_html__( 'Malawian Kwacha', 'awebooking' ),
		'alpha3' => 'MWK',
		'numeric' => '454',
		'exp' => 2,
		'country' => 'MW',
	],
	[
		'name' => esc_html__( 'Mexican Peso', 'awebooking' ),
		'alpha3' => 'MXN',
		'numeric' => '484',
		'exp' => 2,
		'country' => 'MX',
	],
	[
		'name' => esc_html__( 'Malaysian Ringgit', 'awebooking' ),
		'alpha3' => 'MYR',
		'numeric' => '458',
		'exp' => 2,
		'country' => 'MY',
	],
	[
		'name' => esc_html__( 'Mozambican Metical', 'awebooking' ),
		'alpha3' => 'MZN',
		'numeric' => '943',
		'exp' => 2,
		'country' => 'MZ',
	],
	[
		'name' => esc_html__( 'Namibian Dollar', 'awebooking' ),
		'alpha3' => 'NAD',
		'numeric' => '516',
		'exp' => 2,
		'country' => 'NA',
	],
	[
		'name' => esc_html__( 'Nigerian Naira', 'awebooking' ),
		'alpha3' => 'NGN',
		'numeric' => '566',
		'exp' => 2,
		'country' => 'NG',
	],
	[
		'name' => esc_html__( 'Nicaraguan Córdoba', 'awebooking' ),
		'alpha3' => 'NIO',
		'numeric' => '558',
		'exp' => 2,
		'country' => 'NI',
	],
	[
		'name' => esc_html__( 'Norwegian Krone', 'awebooking' ),
		'alpha3' => 'NOK',
		'numeric' => '578',
		'exp' => 2,
		'country' => [ 'AQ', 'BV', 'NO', 'SJ' ],
	],
	[
		'name' => esc_html__( 'Nepalese Rupee', 'awebooking' ),
		'alpha3' => 'NPR',
		'numeric' => '524',
		'exp' => 2,
		'country' => 'NP',
	],
	[
		'name' => esc_html__( 'New Zealand Dollar', 'awebooking' ),
		'alpha3' => 'NZD',
		'numeric' => '554',
		'exp' => 2,
		'country' => [ 'CK', 'NU', 'NZ', 'PN', 'TK' ],
	],
	[
		'name' => esc_html__( 'Omani Rial', 'awebooking' ),
		'alpha3' => 'OMR',
		'numeric' => '512',
		'exp' => 3,
		'country' => 'OM',
	],
	[
		'name' => esc_html__( 'Panamanian Balboa', 'awebooking' ),
		'alpha3' => 'PAB',
		'numeric' => '590',
		'exp' => 2,
		'country' => 'PA',
	],
	[
		'name' => esc_html__( 'Peruvian Nuevo Sol', 'awebooking' ),
		'alpha3' => 'PEN',
		'numeric' => '604',
		'exp' => 2,
		'country' => 'PE',
	],
	[
		'name' => esc_html__( 'Papua New Guinean Kina', 'awebooking' ),
		'alpha3' => 'PGK',
		'numeric' => '598',
		'exp' => 2,
		'country' => 'PG',
	],
	[
		'name' => esc_html__( 'Philippine Peso', 'awebooking' ),
		'alpha3' => 'PHP',
		'numeric' => '608',
		'exp' => 2,
		'country' => 'PH',
	],
	[
		'name' => esc_html__( 'Pakistani Rupee', 'awebooking' ),
		'alpha3' => 'PKR',
		'numeric' => '586',
		'exp' => 2,
		'country' => 'PK',
	],
	[
		'name' => esc_html__( 'Polish Zloty', 'awebooking' ),
		'alpha3' => 'PLN',
		'numeric' => '985',
		'exp' => 2,
		'country' => 'PL',
	],
	[
		'name' => esc_html__( 'Paraguayan Guarani', 'awebooking' ),
		'alpha3' => 'PYG',
		'numeric' => '600',
		'exp' => 0,
		'country' => 'PY',
	],
	[
		'name' => esc_html__( 'Qatari Rial', 'awebooking' ),
		'alpha3' => 'QAR',
		'numeric' => '634',
		'exp' => 2,
		'country' => 'QA',
	],
	[
		'name' => esc_html__( 'Romanian New Leu', 'awebooking' ),
		'alpha3' => 'RON',
		'numeric' => '946',
		'exp' => 2,
		'country' => 'RO',
	],
	[
		'name' => esc_html__( 'Serbian Dinar', 'awebooking' ),
		'alpha3' => 'RSD',
		'numeric' => '941',
		'exp' => 0,
		'country' => 'RS',
	],
	[
		'name' => esc_html__( 'Russian Ruble', 'awebooking' ),
		'alpha3' => 'RUB',
		'numeric' => '643',
		'exp' => 2,
		'country' => 'RU',
	],
	[
		'name' => esc_html__( 'Rwandan Franc', 'awebooking' ),
		'alpha3' => 'RWF',
		'numeric' => '646',
		'exp' => 0,
		'country' => 'RW',
	],
	[
		'name' => esc_html__( 'Saudi Riyal', 'awebooking' ),
		'alpha3' => 'SAR',
		'numeric' => '682',
		'exp' => 2,
		'country' => 'SA',
	],
	[
		'name' => esc_html__( 'Solomon Islands Dollar', 'awebooking' ),
		'alpha3' => 'SBD',
		'numeric' => '090',
		'exp' => 2,
		'country' => 'SB',
	],
	[
		'name' => esc_html__( 'Seychelles Rupee', 'awebooking' ),
		'alpha3' => 'SCR',
		'numeric' => '690',
		'exp' => 2,
		'country' => 'SC',
	],
	[
		'name' => esc_html__( 'Sudanese Pound', 'awebooking' ),
		'alpha3' => 'SDG',
		'numeric' => '938',
		'exp' => 2,
		'country' => 'SD',
	],
	[
		'name' => esc_html__( 'Swedish Krona', 'awebooking' ),
		'alpha3' => 'SEK',
		'numeric' => '752',
		'exp' => 2,
		'country' => 'SE',
	],
	[
		'name' => esc_html__( 'Singapore Dollar', 'awebooking' ),
		'alpha3' => 'SGD',
		'numeric' => '702',
		'exp' => 2,
		'country' => [ 'BN', 'SG' ],
	],
	[
		'name' => esc_html__( 'Saint Helena Pound', 'awebooking' ),
		'alpha3' => 'SHP',
		'numeric' => '654',
		'exp' => 2,
		'country' => 'SH',
	],
	[
		'name' => esc_html__( 'Sierra Leonean Leone', 'awebooking' ),
		'alpha3' => 'SLL',
		'numeric' => '694',
		'exp' => 2,
		'country' => 'SL',
	],
	[
		'name' => esc_html__( 'Somali Shilling', 'awebooking' ),
		'alpha3' => 'SOS',
		'numeric' => '706',
		'exp' => 2,
		'country' => 'SO',
	],
	[
		'name' => esc_html__( 'Surinamese Dollar', 'awebooking' ),
		'alpha3' => 'SRD',
		'numeric' => '968',
		'exp' => 2,
		'country' => 'SR',
	],
	[
		'name' => esc_html__( 'South Sudanese Pound', 'awebooking' ),
		'alpha3' => 'SSP',
		'numeric' => '728',
		'exp' => 2,
		'country' => 'SS',
	],
	[
		'name' => esc_html__( 'São Tomé and Principe Dobra', 'awebooking' ),
		'alpha3' => 'STD',
		'numeric' => '678',
		'exp' => 2,
		'country' => 'ST',
	],
	[
		'name' => esc_html__( 'Syrian Pound', 'awebooking' ),
		'alpha3' => 'SYP',
		'numeric' => '760',
		'exp' => 2,
		'country' => 'SY',
	],
	[
		'name' => esc_html__( 'Swazi Lilangeni', 'awebooking' ),
		'alpha3' => 'SZL',
		'numeric' => '748',
		'exp' => 2,
		'country' => 'SZ',
	],
	[
		'name' => esc_html__( 'Thai Baht', 'awebooking' ),
		'alpha3' => 'THB',
		'numeric' => '764',
		'exp' => 2,
		'country' => 'TH',
	],
	[
		'name' => esc_html__( 'Tajikistani Somoni', 'awebooking' ),
		'alpha3' => 'TJS',
		'numeric' => '972',
		'exp' => 2,
		'country' => 'TJ',
	],
	[
		'name' => esc_html__( 'Turkmenistani Manat', 'awebooking' ),
		'alpha3' => 'TMT',
		'numeric' => '934',
		'exp' => 2,
		'country' => 'TM',
	],
	[
		'name' => esc_html__( 'Tunisian Dinar', 'awebooking' ),
		'alpha3' => 'TND',
		'numeric' => '788',
		'exp' => 3,
		'country' => 'TN',
	],
	[
		'name' => esc_html__( 'Tongan Paʻanga', 'awebooking' ),
		'alpha3' => 'TOP',
		'numeric' => '776',
		'exp' => 2,
		'country' => 'TO',
	],
	[
		'name' => esc_html__( 'Turkish Lira', 'awebooking' ),
		'alpha3' => 'TRY',
		'numeric' => '949',
		'exp' => 2,
		'country' => 'TR',
	],
	[
		'name' => esc_html__( 'Trinidad and Tobago Dollar', 'awebooking' ),
		'alpha3' => 'TTD',
		'numeric' => '780',
		'exp' => 2,
		'country' => 'TT',
	],
	[
		'name' => esc_html__( 'New Taiwan Dollar', 'awebooking' ),
		'alpha3' => 'TWD',
		'numeric' => '901',
		'exp' => 2,
		'country' => 'TW',
	],
	[
		'name' => esc_html__( 'Tanzanian Shilling', 'awebooking' ),
		'alpha3' => 'TZS',
		'numeric' => '834',
		'exp' => 2,
		'country' => 'TZ',
	],
	[
		'name' => esc_html__( 'Ukrainian Hryvnia', 'awebooking' ),
		'alpha3' => 'UAH',
		'numeric' => '980',
		'exp' => 2,
		'country' => 'UA',
	],
	[
		'name' => esc_html__( 'Ugandan Shilling', 'awebooking' ),
		'alpha3' => 'UGX',
		'numeric' => '800',
		'exp' => 0,
		'country' => 'UG',
	],
	[
		'name' => esc_html__( 'US Dollar', 'awebooking' ),
		'alpha3' => 'USD',
		'numeric' => '840',
		'exp' => 2,
		'country' => [ 'AS', 'BQ', 'EC', 'FM', 'GU', 'MF', 'MH', 'MP', 'PR', 'PW', 'SV', 'TC', 'TL', 'UM', 'US', 'VG', 'VI', 'ZW' ],
	],
	[
		'name' => esc_html__( 'Uruguayan Peso', 'awebooking' ),
		'alpha3' => 'UYU',
		'numeric' => '858',
		'exp' => 2,
		'country' => 'UY',
	],
	[
		'name' => esc_html__( 'Uzbekistan Som', 'awebooking' ),
		'alpha3' => 'UZS',
		'numeric' => '860',
		'exp' => 2,
		'country' => 'UZ',
	],
	[
		'name' => esc_html__( 'Venezuelan Bolivar', 'awebooking' ),
		'alpha3' => 'VEF',
		'numeric' => '937',
		'exp' => 2,
		'country' => 'VE',
	],
	[
		'name' => esc_html__( 'Vietnamese Dong', 'awebooking' ),
		'alpha3' => 'VND',
		'numeric' => '704',
		'exp' => 0,
		'country' => 'VN',
	],
	[
		'name' => esc_html__( 'Vanuatu Vatu', 'awebooking' ),
		'alpha3' => 'VUV',
		'numeric' => '548',
		'exp' => 0,
		'country' => 'VU',
	],
	[
		'name' => esc_html__( 'Samoan Tala', 'awebooking' ),
		'alpha3' => 'WST',
		'numeric' => '882',
		'exp' => 2,
		'country' => 'WS',
	],
	[
		'name' => esc_html__( 'CFA Franc BEAC', 'awebooking' ),
		'alpha3' => 'XAF',
		'numeric' => '950',
		'exp' => 0,
		'country' => [ 'CF', 'CG', 'CM', 'GA', 'GQ', 'TD' ],
	],
	[
		'name' => esc_html__( 'East Caribbean Dollar', 'awebooking' ),
		'alpha3' => 'XCD',
		'numeric' => '951',
		'exp' => 2,
		'country' => [ 'AG', 'AI', 'DM', 'GD', 'KN', 'LC', 'MS', 'VC' ],
	],
	[
		'name' => esc_html__( 'CFA Franc BCEAO', 'awebooking' ),
		'alpha3' => 'XOF',
		'numeric' => '952',
		'exp' => 0,
		'country' => [ 'BJ', 'BF', 'CI', 'GW', 'ML', 'NE', 'SN', 'TG' ],
	],
	[
		'name' => esc_html__( 'CFP Franc', 'awebooking' ),
		'alpha3' => 'XPF',
		'numeric' => '953',
		'exp' => 0,
		'country' => [ 'NC', 'PF', 'WF' ],
	],
	[
		'name' => esc_html__( 'Yemeni Rial', 'awebooking' ),
		'alpha3' => 'YER',
		'numeric' => '886',
		'exp' => 2,
		'country' => 'YE',
	],
	[
		'name' => esc_html__( 'South African Rand', 'awebooking' ),
		'alpha3' => 'ZAR',
		'numeric' => '710',
		'exp' => 2,
		'country' => [ 'NA', 'LS', 'SZ', 'ZA', 'ZW' ],
	],
	[
		'name' => esc_html__( 'Zambian Kwacha', 'awebooking' ),
		'alpha3' => 'ZMW',
		'numeric' => '967',
		'exp' => 2,
		'country' => 'ZM',
	],
];
