<?php
/**
 * The countries dataset ISO-3166.
 *
 * @see https://en.wikipedia.org/wiki/ISO_3166
 */
return [
	[
		'name' => esc_html__( 'Afghanistan', 'awebooking' ),
		'alpha2' => 'AF',
		'alpha3' => 'AFG',
		'numeric' => '004',
		'currency' => [
			'AFN',
		],
	],
	[
		'name' => esc_html__( 'Åland Islands', 'awebooking' ),
		'alpha2' => 'AX',
		'alpha3' => 'ALA',
		'numeric' => '248',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Albania', 'awebooking' ),
		'alpha2' => 'AL',
		'alpha3' => 'ALB',
		'numeric' => '008',
		'currency' => [
			'ALL',
		],
	],
	[
		'name' => esc_html__( 'Algeria', 'awebooking' ),
		'alpha2' => 'DZ',
		'alpha3' => 'DZA',
		'numeric' => '012',
		'currency' => [
			'DZD',
		],
	],
	[
		'name' => esc_html__( 'American Samoa', 'awebooking' ),
		'alpha2' => 'AS',
		'alpha3' => 'ASM',
		'numeric' => '016',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Andorra', 'awebooking' ),
		'alpha2' => 'AD',
		'alpha3' => 'AND',
		'numeric' => '020',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Angola', 'awebooking' ),
		'alpha2' => 'AO',
		'alpha3' => 'AGO',
		'numeric' => '024',
		'currency' => [
			'AOA',
		],
	],
	[
		'name' => esc_html__( 'Anguilla', 'awebooking' ),
		'alpha2' => 'AI',
		'alpha3' => 'AIA',
		'numeric' => '660',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Antarctica', 'awebooking' ),
		'alpha2' => 'AQ',
		'alpha3' => 'ATA',
		'numeric' => '010',
		'currency' => [
			'ARS',
			'AUD',
			'BGN',
			'BRL',
			'BYR',
			'CLP',
			'CNY',
			'CZK',
			'EUR',
			'GBP',
			'INR',
			'JPY',
			'KRW',
			'NOK',
			'NZD',
			'PEN',
			'PKR',
			'PLN',
			'RON',
			'RUB',
			'SEK',
			'UAH',
			'USD',
			'UYU',
			'ZAR',
		],
	],
	[
		'name' => esc_html__( 'Antigua and Barbuda', 'awebooking' ),
		'alpha2' => 'AG',
		'alpha3' => 'ATG',
		'numeric' => '028',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Argentina', 'awebooking' ),
		'alpha2' => 'AR',
		'alpha3' => 'ARG',
		'numeric' => '032',
		'currency' => [
			'ARS',
		],
	],
	[
		'name' => esc_html__( 'Armenia', 'awebooking' ),
		'alpha2' => 'AM',
		'alpha3' => 'ARM',
		'numeric' => '051',
		'currency' => [
			'AMD',
		],
	],
	[
		'name' => esc_html__( 'Aruba', 'awebooking' ),
		'alpha2' => 'AW',
		'alpha3' => 'ABW',
		'numeric' => '533',
		'currency' => [
			'AWG',
		],
	],
	[
		'name' => esc_html__( 'Australia', 'awebooking' ),
		'alpha2' => 'AU',
		'alpha3' => 'AUS',
		'numeric' => '036',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Austria', 'awebooking' ),
		'alpha2' => 'AT',
		'alpha3' => 'AUT',
		'numeric' => '040',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Azerbaijan', 'awebooking' ),
		'alpha2' => 'AZ',
		'alpha3' => 'AZE',
		'numeric' => '031',
		'currency' => [
			'AZN',
		],
	],
	[
		'name' => esc_html__( 'Bahamas', 'awebooking' ),
		'alpha2' => 'BS',
		'alpha3' => 'BHS',
		'numeric' => '044',
		'currency' => [
			'BSD',
		],
	],
	[
		'name' => esc_html__( 'Bahrain', 'awebooking' ),
		'alpha2' => 'BH',
		'alpha3' => 'BHR',
		'numeric' => '048',
		'currency' => [
			'BHD',
		],
	],
	[
		'name' => esc_html__( 'Bangladesh', 'awebooking' ),
		'alpha2' => 'BD',
		'alpha3' => 'BGD',
		'numeric' => '050',
		'currency' => [
			'BDT',
		],
	],
	[
		'name' => esc_html__( 'Barbados', 'awebooking' ),
		'alpha2' => 'BB',
		'alpha3' => 'BRB',
		'numeric' => '052',
		'currency' => [
			'BBD',
		],
	],
	[
		'name' => esc_html__( 'Belarus', 'awebooking' ),
		'alpha2' => 'BY',
		'alpha3' => 'BLR',
		'numeric' => '112',
		'currency' => [
			'BYN',
		],
	],
	[
		'name' => esc_html__( 'Belgium', 'awebooking' ),
		'alpha2' => 'BE',
		'alpha3' => 'BEL',
		'numeric' => '056',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Belize', 'awebooking' ),
		'alpha2' => 'BZ',
		'alpha3' => 'BLZ',
		'numeric' => '084',
		'currency' => [
			'BZD',
		],
	],
	[
		'name' => esc_html__( 'Benin', 'awebooking' ),
		'alpha2' => 'BJ',
		'alpha3' => 'BEN',
		'numeric' => '204',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Bermuda', 'awebooking' ),
		'alpha2' => 'BM',
		'alpha3' => 'BMU',
		'numeric' => '060',
		'currency' => [
			'BMD',
		],
	],
	[
		'name' => esc_html__( 'Bhutan', 'awebooking' ),
		'alpha2' => 'BT',
		'alpha3' => 'BTN',
		'numeric' => '064',
		'currency' => [
			'BTN',
		],
	],
	[
		'name' => esc_html__( 'Bolivia (Plurinational State of)', 'awebooking' ),
		'alpha2' => 'BO',
		'alpha3' => 'BOL',
		'numeric' => '068',
		'currency' => [
			'BOB',
		],
	],
	[
		'name' => esc_html__( 'Bonaire, Sint Eustatius and Saba', 'awebooking' ),
		'alpha2' => 'BQ',
		'alpha3' => 'BES',
		'numeric' => '535',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Bosnia and Herzegovina', 'awebooking' ),
		'alpha2' => 'BA',
		'alpha3' => 'BIH',
		'numeric' => '070',
		'currency' => [
			'BAM',
		],
	],
	[
		'name' => esc_html__( 'Botswana', 'awebooking' ),
		'alpha2' => 'BW',
		'alpha3' => 'BWA',
		'numeric' => '072',
		'currency' => [
			'BWP',
		],
	],
	[
		'name' => esc_html__( 'Bouvet Island', 'awebooking' ),
		'alpha2' => 'BV',
		'alpha3' => 'BVT',
		'numeric' => '074',
		'currency' => [
			'NOK',
		],
	],
	[
		'name' => esc_html__( 'Brazil', 'awebooking' ),
		'alpha2' => 'BR',
		'alpha3' => 'BRA',
		'numeric' => '076',
		'currency' => [
			'BRL',
		],
	],
	[
		'name' => esc_html__( 'British Indian Ocean Territory', 'awebooking' ),
		'alpha2' => 'IO',
		'alpha3' => 'IOT',
		'numeric' => '086',
		'currency' => [
			'GBP',
		],
	],
	[
		'name' => esc_html__( 'Brunei Darussalam', 'awebooking' ),
		'alpha2' => 'BN',
		'alpha3' => 'BRN',
		'numeric' => '096',
		'currency' => [
			'BND',
			'SGD',
		],
	],
	[
		'name' => esc_html__( 'Bulgaria', 'awebooking' ),
		'alpha2' => 'BG',
		'alpha3' => 'BGR',
		'numeric' => '100',
		'currency' => [
			'BGN',
		],
	],
	[
		'name' => esc_html__( 'Burkina Faso', 'awebooking' ),
		'alpha2' => 'BF',
		'alpha3' => 'BFA',
		'numeric' => '854',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Burundi', 'awebooking' ),
		'alpha2' => 'BI',
		'alpha3' => 'BDI',
		'numeric' => '108',
		'currency' => [
			'BIF',
		],
	],
	[
		'name' => esc_html__( 'Cabo Verde', 'awebooking' ),
		'alpha2' => 'CV',
		'alpha3' => 'CPV',
		'numeric' => '132',
		'currency' => [
			'CVE',
		],
	],
	[
		'name' => esc_html__( 'Cambodia', 'awebooking' ),
		'alpha2' => 'KH',
		'alpha3' => 'KHM',
		'numeric' => '116',
		'currency' => [
			'KHR',
		],
	],
	[
		'name' => esc_html__( 'Cameroon', 'awebooking' ),
		'alpha2' => 'CM',
		'alpha3' => 'CMR',
		'numeric' => '120',
		'currency' => [
			'XAF',
		],
	],
	[
		'name' => esc_html__( 'Canada', 'awebooking' ),
		'alpha2' => 'CA',
		'alpha3' => 'CAN',
		'numeric' => '124',
		'currency' => [
			'CAD',
		],
	],
	[
		'name' => esc_html__( 'Cayman Islands', 'awebooking' ),
		'alpha2' => 'KY',
		'alpha3' => 'CYM',
		'numeric' => '136',
		'currency' => [
			'KYD',
		],
	],
	[
		'name' => esc_html__( 'Central African Republic', 'awebooking' ),
		'alpha2' => 'CF',
		'alpha3' => 'CAF',
		'numeric' => '140',
		'currency' => [
			'XAF',
		],
	],
	[
		'name' => esc_html__( 'Chad', 'awebooking' ),
		'alpha2' => 'TD',
		'alpha3' => 'TCD',
		'numeric' => '148',
		'currency' => [
			'XAF',
		],
	],
	[
		'name' => esc_html__( 'Chile', 'awebooking' ),
		'alpha2' => 'CL',
		'alpha3' => 'CHL',
		'numeric' => '152',
		'currency' => [
			'CLP',
		],
	],
	[
		'name' => esc_html__( 'China', 'awebooking' ),
		'alpha2' => 'CN',
		'alpha3' => 'CHN',
		'numeric' => '156',
		'currency' => [
			'CNY',
		],
	],
	[
		'name' => esc_html__( 'Christmas Island', 'awebooking' ),
		'alpha2' => 'CX',
		'alpha3' => 'CXR',
		'numeric' => '162',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Cocos (Keeling) Islands', 'awebooking' ),
		'alpha2' => 'CC',
		'alpha3' => 'CCK',
		'numeric' => '166',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Colombia', 'awebooking' ),
		'alpha2' => 'CO',
		'alpha3' => 'COL',
		'numeric' => '170',
		'currency' => [
			'COP',
		],
	],
	[
		'name' => esc_html__( 'Comoros', 'awebooking' ),
		'alpha2' => 'KM',
		'alpha3' => 'COM',
		'numeric' => '174',
		'currency' => [
			'KMF',
		],
	],
	[
		'name' => esc_html__( 'Congo', 'awebooking' ),
		'alpha2' => 'CG',
		'alpha3' => 'COG',
		'numeric' => '178',
		'currency' => [
			'XAF',
		],
	],
	[
		'name' => esc_html__( 'Congo (Democratic Republic of the)', 'awebooking' ),
		'alpha2' => 'CD',
		'alpha3' => 'COD',
		'numeric' => '180',
		'currency' => [
			'CDF',
		],
	],
	[
		'name' => esc_html__( 'Cook Islands', 'awebooking' ),
		'alpha2' => 'CK',
		'alpha3' => 'COK',
		'numeric' => '184',
		'currency' => [
			'NZD',
		],
	],
	[
		'name' => esc_html__( 'Costa Rica', 'awebooking' ),
		'alpha2' => 'CR',
		'alpha3' => 'CRI',
		'numeric' => '188',
		'currency' => [
			'CRC',
		],
	],
	[
		'name' => esc_html__( 'Côte d\'Ivoire', 'awebooking' ),
		'alpha2' => 'CI',
		'alpha3' => 'CIV',
		'numeric' => '384',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Croatia', 'awebooking' ),
		'alpha2' => 'HR',
		'alpha3' => 'HRV',
		'numeric' => '191',
		'currency' => [
			'HRK',
		],
	],
	[
		'name' => esc_html__( 'Cuba', 'awebooking' ),
		'alpha2' => 'CU',
		'alpha3' => 'CUB',
		'numeric' => '192',
		'currency' => [
			'CUC',
			'CUP',
		],
	],
	[
		'name' => esc_html__( 'Curaçao', 'awebooking' ),
		'alpha2' => 'CW',
		'alpha3' => 'CUW',
		'numeric' => '531',
		'currency' => [
			'ANG',
		],
	],
	[
		'name' => esc_html__( 'Cyprus', 'awebooking' ),
		'alpha2' => 'CY',
		'alpha3' => 'CYP',
		'numeric' => '196',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Czechia', 'awebooking' ),
		'alpha2' => 'CZ',
		'alpha3' => 'CZE',
		'numeric' => '203',
		'currency' => [
			'CZK',
		],
	],
	[
		'name' => esc_html__( 'Denmark', 'awebooking' ),
		'alpha2' => 'DK',
		'alpha3' => 'DNK',
		'numeric' => '208',
		'currency' => [
			'DKK',
		],
	],
	[
		'name' => esc_html__( 'Djibouti', 'awebooking' ),
		'alpha2' => 'DJ',
		'alpha3' => 'DJI',
		'numeric' => '262',
		'currency' => [
			'DJF',
		],
	],
	[
		'name' => esc_html__( 'Dominica', 'awebooking' ),
		'alpha2' => 'DM',
		'alpha3' => 'DMA',
		'numeric' => '212',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Dominican Republic', 'awebooking' ),
		'alpha2' => 'DO',
		'alpha3' => 'DOM',
		'numeric' => '214',
		'currency' => [
			'DOP',
		],
	],
	[
		'name' => esc_html__( 'Ecuador', 'awebooking' ),
		'alpha2' => 'EC',
		'alpha3' => 'ECU',
		'numeric' => '218',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Egypt', 'awebooking' ),
		'alpha2' => 'EG',
		'alpha3' => 'EGY',
		'numeric' => '818',
		'currency' => [
			'EGP',
		],
	],
	[
		'name' => esc_html__( 'El Salvador', 'awebooking' ),
		'alpha2' => 'SV',
		'alpha3' => 'SLV',
		'numeric' => '222',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Equatorial Guinea', 'awebooking' ),
		'alpha2' => 'GQ',
		'alpha3' => 'GNQ',
		'numeric' => '226',
		'currency' => [
			'XAF',
		],
	],
	[
		'name' => esc_html__( 'Eritrea', 'awebooking' ),
		'alpha2' => 'ER',
		'alpha3' => 'ERI',
		'numeric' => '232',
		'currency' => [
			'ERN',
		],
	],
	[
		'name' => esc_html__( 'Estonia', 'awebooking' ),
		'alpha2' => 'EE',
		'alpha3' => 'EST',
		'numeric' => '233',
		'currency' => [
			'EEK',
		],
	],
	[
		'name' => esc_html__( 'Ethiopia', 'awebooking' ),
		'alpha2' => 'ET',
		'alpha3' => 'ETH',
		'numeric' => '231',
		'currency' => [
			'ETB',
		],
	],
	[
		'name' => esc_html__( 'Falkland Islands (Malvinas)', 'awebooking' ),
		'alpha2' => 'FK',
		'alpha3' => 'FLK',
		'numeric' => '238',
		'currency' => [
			'FKP',
		],
	],
	[
		'name' => esc_html__( 'Faroe Islands', 'awebooking' ),
		'alpha2' => 'FO',
		'alpha3' => 'FRO',
		'numeric' => '234',
		'currency' => [
			'DKK',
		],
	],
	[
		'name' => esc_html__( 'Fiji', 'awebooking' ),
		'alpha2' => 'FJ',
		'alpha3' => 'FJI',
		'numeric' => '242',
		'currency' => [
			'FJD',
		],
	],
	[
		'name' => esc_html__( 'Finland', 'awebooking' ),
		'alpha2' => 'FI',
		'alpha3' => 'FIN',
		'numeric' => '246',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'France', 'awebooking' ),
		'alpha2' => 'FR',
		'alpha3' => 'FRA',
		'numeric' => '250',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'French Guiana', 'awebooking' ),
		'alpha2' => 'GF',
		'alpha3' => 'GUF',
		'numeric' => '254',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'French Polynesia', 'awebooking' ),
		'alpha2' => 'PF',
		'alpha3' => 'PYF',
		'numeric' => '258',
		'currency' => [
			'XPF',
		],
	],
	[
		'name' => esc_html__( 'French Southern Territories', 'awebooking' ),
		'alpha2' => 'TF',
		'alpha3' => 'ATF',
		'numeric' => '260',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Gabon', 'awebooking' ),
		'alpha2' => 'GA',
		'alpha3' => 'GAB',
		'numeric' => '266',
		'currency' => [
			'XAF',
		],
	],
	[
		'name' => esc_html__( 'Gambia', 'awebooking' ),
		'alpha2' => 'GM',
		'alpha3' => 'GMB',
		'numeric' => '270',
		'currency' => [
			'GMD',
		],
	],
	[
		'name' => esc_html__( 'Georgia', 'awebooking' ),
		'alpha2' => 'GE',
		'alpha3' => 'GEO',
		'numeric' => '268',
		'currency' => [
			'GEL',
		],
	],
	[
		'name' => esc_html__( 'Germany', 'awebooking' ),
		'alpha2' => 'DE',
		'alpha3' => 'DEU',
		'numeric' => '276',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Ghana', 'awebooking' ),
		'alpha2' => 'GH',
		'alpha3' => 'GHA',
		'numeric' => '288',
		'currency' => [
			'GHS',
		],
	],
	[
		'name' => esc_html__( 'Gibraltar', 'awebooking' ),
		'alpha2' => 'GI',
		'alpha3' => 'GIB',
		'numeric' => '292',
		'currency' => [
			'GIP',
		],
	],
	[
		'name' => esc_html__( 'Greece', 'awebooking' ),
		'alpha2' => 'GR',
		'alpha3' => 'GRC',
		'numeric' => '300',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Greenland', 'awebooking' ),
		'alpha2' => 'GL',
		'alpha3' => 'GRL',
		'numeric' => '304',
		'currency' => [
			'DKK',
		],
	],
	[
		'name' => esc_html__( 'Grenada', 'awebooking' ),
		'alpha2' => 'GD',
		'alpha3' => 'GRD',
		'numeric' => '308',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Guadeloupe', 'awebooking' ),
		'alpha2' => 'GP',
		'alpha3' => 'GLP',
		'numeric' => '312',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Guam', 'awebooking' ),
		'alpha2' => 'GU',
		'alpha3' => 'GUM',
		'numeric' => '316',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Guatemala', 'awebooking' ),
		'alpha2' => 'GT',
		'alpha3' => 'GTM',
		'numeric' => '320',
		'currency' => [
			'GTQ',
		],
	],
	[
		'name' => esc_html__( 'Guernsey', 'awebooking' ),
		'alpha2' => 'GG',
		'alpha3' => 'GGY',
		'numeric' => '831',
		'currency' => [
			'GBP',
		],
	],
	[
		'name' => esc_html__( 'Guinea', 'awebooking' ),
		'alpha2' => 'GN',
		'alpha3' => 'GIN',
		'numeric' => '324',
		'currency' => [
			'GNF',
		],
	],
	[
		'name' => esc_html__( 'Guinea-Bissau', 'awebooking' ),
		'alpha2' => 'GW',
		'alpha3' => 'GNB',
		'numeric' => '624',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Guyana', 'awebooking' ),
		'alpha2' => 'GY',
		'alpha3' => 'GUY',
		'numeric' => '328',
		'currency' => [
			'GYD',
		],
	],
	[
		'name' => esc_html__( 'Haiti', 'awebooking' ),
		'alpha2' => 'HT',
		'alpha3' => 'HTI',
		'numeric' => '332',
		'currency' => [
			'HTG',
		],
	],
	[
		'name' => esc_html__( 'Heard Island and McDonald Islands', 'awebooking' ),
		'alpha2' => 'HM',
		'alpha3' => 'HMD',
		'numeric' => '334',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Holy See', 'awebooking' ),
		'alpha2' => 'VA',
		'alpha3' => 'VAT',
		'numeric' => '336',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Honduras', 'awebooking' ),
		'alpha2' => 'HN',
		'alpha3' => 'HND',
		'numeric' => '340',
		'currency' => [
			'HNL',
		],
	],
	[
		'name' => esc_html__( 'Hong Kong', 'awebooking' ),
		'alpha2' => 'HK',
		'alpha3' => 'HKG',
		'numeric' => '344',
		'currency' => [
			'HKD',
		],
	],
	[
		'name' => esc_html__( 'Hungary', 'awebooking' ),
		'alpha2' => 'HU',
		'alpha3' => 'HUN',
		'numeric' => '348',
		'currency' => [
			'HUF',
		],
	],
	[
		'name' => esc_html__( 'Iceland', 'awebooking' ),
		'alpha2' => 'IS',
		'alpha3' => 'ISL',
		'numeric' => '352',
		'currency' => [
			'ISK',
		],
	],
	[
		'name' => esc_html__( 'India', 'awebooking' ),
		'alpha2' => 'IN',
		'alpha3' => 'IND',
		'numeric' => '356',
		'currency' => [
			'INR',
		],
	],
	[
		'name' => esc_html__( 'Indonesia', 'awebooking' ),
		'alpha2' => 'ID',
		'alpha3' => 'IDN',
		'numeric' => '360',
		'currency' => [
			'IDR',
		],
	],
	[
		'name' => esc_html__( 'Iran (Islamic Republic of)', 'awebooking' ),
		'alpha2' => 'IR',
		'alpha3' => 'IRN',
		'numeric' => '364',
		'currency' => [
			'IRR',
		],
	],
	[
		'name' => esc_html__( 'Iraq', 'awebooking' ),
		'alpha2' => 'IQ',
		'alpha3' => 'IRQ',
		'numeric' => '368',
		'currency' => [
			'IQD',
		],
	],
	[
		'name' => esc_html__( 'Ireland', 'awebooking' ),
		'alpha2' => 'IE',
		'alpha3' => 'IRL',
		'numeric' => '372',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Isle of Man', 'awebooking' ),
		'alpha2' => 'IM',
		'alpha3' => 'IMN',
		'numeric' => '833',
		'currency' => [
			'GBP',
		],
	],
	[
		'name' => esc_html__( 'Israel', 'awebooking' ),
		'alpha2' => 'IL',
		'alpha3' => 'ISR',
		'numeric' => '376',
		'currency' => [
			'ILS',
		],
	],
	[
		'name' => esc_html__( 'Italy', 'awebooking' ),
		'alpha2' => 'IT',
		'alpha3' => 'ITA',
		'numeric' => '380',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Jamaica', 'awebooking' ),
		'alpha2' => 'JM',
		'alpha3' => 'JAM',
		'numeric' => '388',
		'currency' => [
			'JMD',
		],
	],
	[
		'name' => esc_html__( 'Japan', 'awebooking' ),
		'alpha2' => 'JP',
		'alpha3' => 'JPN',
		'numeric' => '392',
		'currency' => [
			'JPY',
		],
	],
	[
		'name' => esc_html__( 'Jersey', 'awebooking' ),
		'alpha2' => 'JE',
		'alpha3' => 'JEY',
		'numeric' => '832',
		'currency' => [
			'GBP',
		],
	],
	[
		'name' => esc_html__( 'Jordan', 'awebooking' ),
		'alpha2' => 'JO',
		'alpha3' => 'JOR',
		'numeric' => '400',
		'currency' => [
			'JOD',
		],
	],
	[
		'name' => esc_html__( 'Kazakhstan', 'awebooking' ),
		'alpha2' => 'KZ',
		'alpha3' => 'KAZ',
		'numeric' => '398',
		'currency' => [
			'KZT',
		],
	],
	[
		'name' => esc_html__( 'Kenya', 'awebooking' ),
		'alpha2' => 'KE',
		'alpha3' => 'KEN',
		'numeric' => '404',
		'currency' => [
			'KES',
		],
	],
	[
		'name' => esc_html__( 'Kiribati', 'awebooking' ),
		'alpha2' => 'KI',
		'alpha3' => 'KIR',
		'numeric' => '296',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Korea (Democratic People\'s Republic of)', 'awebooking' ),
		'alpha2' => 'KP',
		'alpha3' => 'PRK',
		'numeric' => '408',
		'currency' => [
			'KPW',
		],
	],
	[
		'name' => esc_html__( 'Korea (Republic of)', 'awebooking' ),
		'alpha2' => 'KR',
		'alpha3' => 'KOR',
		'numeric' => '410',
		'currency' => [
			'KRW',
		],
	],
	[
		'name' => esc_html__( 'Kuwait', 'awebooking' ),
		'alpha2' => 'KW',
		'alpha3' => 'KWT',
		'numeric' => '414',
		'currency' => [
			'KWD',
		],
	],
	[
		'name' => esc_html__( 'Kyrgyzstan', 'awebooking' ),
		'alpha2' => 'KG',
		'alpha3' => 'KGZ',
		'numeric' => '417',
		'currency' => [
			'KGS',
		],
	],
	[
		'name' => esc_html__( 'Lao People\'s Democratic Republic', 'awebooking' ),
		'alpha2' => 'LA',
		'alpha3' => 'LAO',
		'numeric' => '418',
		'currency' => [
			'LAK',
		],
	],
	[
		'name' => esc_html__( 'Latvia', 'awebooking' ),
		'alpha2' => 'LV',
		'alpha3' => 'LVA',
		'numeric' => '428',
		'currency' => [
			'LVL',
		],
	],
	[
		'name' => esc_html__( 'Lebanon', 'awebooking' ),
		'alpha2' => 'LB',
		'alpha3' => 'LBN',
		'numeric' => '422',
		'currency' => [
			'LBP',
		],
	],
	[
		'name' => esc_html__( 'Lesotho', 'awebooking' ),
		'alpha2' => 'LS',
		'alpha3' => 'LSO',
		'numeric' => '426',
		'currency' => [
			'LSL',
			'ZAR',
		],
	],
	[
		'name' => esc_html__( 'Liberia', 'awebooking' ),
		'alpha2' => 'LR',
		'alpha3' => 'LBR',
		'numeric' => '430',
		'currency' => [
			'LRD',
		],
	],
	[
		'name' => esc_html__( 'Libya', 'awebooking' ),
		'alpha2' => 'LY',
		'alpha3' => 'LBY',
		'numeric' => '434',
		'currency' => [
			'LYD',
		],
	],
	[
		'name' => esc_html__( 'Liechtenstein', 'awebooking' ),
		'alpha2' => 'LI',
		'alpha3' => 'LIE',
		'numeric' => '438',
		'currency' => [
			'CHF',
		],
	],
	[
		'name' => esc_html__( 'Lithuania', 'awebooking' ),
		'alpha2' => 'LT',
		'alpha3' => 'LTU',
		'numeric' => '440',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Luxembourg', 'awebooking' ),
		'alpha2' => 'LU',
		'alpha3' => 'LUX',
		'numeric' => '442',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Macao', 'awebooking' ),
		'alpha2' => 'MO',
		'alpha3' => 'MAC',
		'numeric' => '446',
		'currency' => [
			'MOP',
		],
	],
	[
		'name' => esc_html__( 'Macedonia (the former Yugoslav Republic of)', 'awebooking' ),
		'alpha2' => 'MK',
		'alpha3' => 'MKD',
		'numeric' => '807',
		'currency' => [
			'MKD',
		],
	],
	[
		'name' => esc_html__( 'Madagascar', 'awebooking' ),
		'alpha2' => 'MG',
		'alpha3' => 'MDG',
		'numeric' => '450',
		'currency' => [
			'MGA',
		],
	],
	[
		'name' => esc_html__( 'Malawi', 'awebooking' ),
		'alpha2' => 'MW',
		'alpha3' => 'MWI',
		'numeric' => '454',
		'currency' => [
			'MWK',
		],
	],
	[
		'name' => esc_html__( 'Malaysia', 'awebooking' ),
		'alpha2' => 'MY',
		'alpha3' => 'MYS',
		'numeric' => '458',
		'currency' => [
			'MYR',
		],
	],
	[
		'name' => esc_html__( 'Maldives', 'awebooking' ),
		'alpha2' => 'MV',
		'alpha3' => 'MDV',
		'numeric' => '462',
		'currency' => [
			'MVR',
		],
	],
	[
		'name' => esc_html__( 'Mali', 'awebooking' ),
		'alpha2' => 'ML',
		'alpha3' => 'MLI',
		'numeric' => '466',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Malta', 'awebooking' ),
		'alpha2' => 'MT',
		'alpha3' => 'MLT',
		'numeric' => '470',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Marshall Islands', 'awebooking' ),
		'alpha2' => 'MH',
		'alpha3' => 'MHL',
		'numeric' => '584',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Martinique', 'awebooking' ),
		'alpha2' => 'MQ',
		'alpha3' => 'MTQ',
		'numeric' => '474',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Mauritania', 'awebooking' ),
		'alpha2' => 'MR',
		'alpha3' => 'MRT',
		'numeric' => '478',
		'currency' => [
			'MRO',
		],
	],
	[
		'name' => esc_html__( 'Mauritius', 'awebooking' ),
		'alpha2' => 'MU',
		'alpha3' => 'MUS',
		'numeric' => '480',
		'currency' => [
			'MUR',
		],
	],
	[
		'name' => esc_html__( 'Mayotte', 'awebooking' ),
		'alpha2' => 'YT',
		'alpha3' => 'MYT',
		'numeric' => '175',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Mexico', 'awebooking' ),
		'alpha2' => 'MX',
		'alpha3' => 'MEX',
		'numeric' => '484',
		'currency' => [
			'MXN',
		],
	],
	[
		'name' => esc_html__( 'Micronesia (Federated States of)', 'awebooking' ),
		'alpha2' => 'FM',
		'alpha3' => 'FSM',
		'numeric' => '583',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Moldova (Republic of)', 'awebooking' ),
		'alpha2' => 'MD',
		'alpha3' => 'MDA',
		'numeric' => '498',
		'currency' => [
			'MDL',
		],
	],
	[
		'name' => esc_html__( 'Monaco', 'awebooking' ),
		'alpha2' => 'MC',
		'alpha3' => 'MCO',
		'numeric' => '492',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Mongolia', 'awebooking' ),
		'alpha2' => 'MN',
		'alpha3' => 'MNG',
		'numeric' => '496',
		'currency' => [
			'MNT',
		],
	],
	[
		'name' => esc_html__( 'Montenegro', 'awebooking' ),
		'alpha2' => 'ME',
		'alpha3' => 'MNE',
		'numeric' => '499',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Montserrat', 'awebooking' ),
		'alpha2' => 'MS',
		'alpha3' => 'MSR',
		'numeric' => '500',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Morocco', 'awebooking' ),
		'alpha2' => 'MA',
		'alpha3' => 'MAR',
		'numeric' => '504',
		'currency' => [
			'MAD',
		],
	],
	[
		'name' => esc_html__( 'Mozambique', 'awebooking' ),
		'alpha2' => 'MZ',
		'alpha3' => 'MOZ',
		'numeric' => '508',
		'currency' => [
			'MZN',
		],
	],
	[
		'name' => esc_html__( 'Myanmar', 'awebooking' ),
		'alpha2' => 'MM',
		'alpha3' => 'MMR',
		'numeric' => '104',
		'currency' => [
			'MMK',
		],
	],
	[
		'name' => esc_html__( 'Namibia', 'awebooking' ),
		'alpha2' => 'NA',
		'alpha3' => 'NAM',
		'numeric' => '516',
		'currency' => [
			'NAD',
			'ZAR',
		],
	],
	[
		'name' => esc_html__( 'Nauru', 'awebooking' ),
		'alpha2' => 'NR',
		'alpha3' => 'NRU',
		'numeric' => '520',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Nepal', 'awebooking' ),
		'alpha2' => 'NP',
		'alpha3' => 'NPL',
		'numeric' => '524',
		'currency' => [
			'NPR',
		],
	],
	[
		'name' => esc_html__( 'Netherlands', 'awebooking' ),
		'alpha2' => 'NL',
		'alpha3' => 'NLD',
		'numeric' => '528',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'New Caledonia', 'awebooking' ),
		'alpha2' => 'NC',
		'alpha3' => 'NCL',
		'numeric' => '540',
		'currency' => [
			'XPF',
		],
	],
	[
		'name' => esc_html__( 'New Zealand', 'awebooking' ),
		'alpha2' => 'NZ',
		'alpha3' => 'NZL',
		'numeric' => '554',
		'currency' => [
			'NZD',
		],
	],
	[
		'name' => esc_html__( 'Nicaragua', 'awebooking' ),
		'alpha2' => 'NI',
		'alpha3' => 'NIC',
		'numeric' => '558',
		'currency' => [
			'NIO',
		],
	],
	[
		'name' => esc_html__( 'Niger', 'awebooking' ),
		'alpha2' => 'NE',
		'alpha3' => 'NER',
		'numeric' => '562',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Nigeria', 'awebooking' ),
		'alpha2' => 'NG',
		'alpha3' => 'NGA',
		'numeric' => '566',
		'currency' => [
			'NGN',
		],
	],
	[
		'name' => esc_html__( 'Niue', 'awebooking' ),
		'alpha2' => 'NU',
		'alpha3' => 'NIU',
		'numeric' => '570',
		'currency' => [
			'NZD',
		],
	],
	[
		'name' => esc_html__( 'Norfolk Island', 'awebooking' ),
		'alpha2' => 'NF',
		'alpha3' => 'NFK',
		'numeric' => '574',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Northern Mariana Islands', 'awebooking' ),
		'alpha2' => 'MP',
		'alpha3' => 'MNP',
		'numeric' => '580',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Norway', 'awebooking' ),
		'alpha2' => 'NO',
		'alpha3' => 'NOR',
		'numeric' => '578',
		'currency' => [
			'NOK',
		],
	],
	[
		'name' => esc_html__( 'Oman', 'awebooking' ),
		'alpha2' => 'OM',
		'alpha3' => 'OMN',
		'numeric' => '512',
		'currency' => [
			'OMR',
		],
	],
	[
		'name' => esc_html__( 'Pakistan', 'awebooking' ),
		'alpha2' => 'PK',
		'alpha3' => 'PAK',
		'numeric' => '586',
		'currency' => [
			'PKR',
		],
	],
	[
		'name' => esc_html__( 'Palau', 'awebooking' ),
		'alpha2' => 'PW',
		'alpha3' => 'PLW',
		'numeric' => '585',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Palestine, State of', 'awebooking' ),
		'alpha2' => 'PS',
		'alpha3' => 'PSE',
		'numeric' => '275',
		'currency' => [
			'ILS',
		],
	],
	[
		'name' => esc_html__( 'Panama', 'awebooking' ),
		'alpha2' => 'PA',
		'alpha3' => 'PAN',
		'numeric' => '591',
		'currency' => [
			'PAB',
		],
	],
	[
		'name' => esc_html__( 'Papua New Guinea', 'awebooking' ),
		'alpha2' => 'PG',
		'alpha3' => 'PNG',
		'numeric' => '598',
		'currency' => [
			'PGK',
		],
	],
	[
		'name' => esc_html__( 'Paraguay', 'awebooking' ),
		'alpha2' => 'PY',
		'alpha3' => 'PRY',
		'numeric' => '600',
		'currency' => [
			'PYG',
		],
	],
	[
		'name' => esc_html__( 'Peru', 'awebooking' ),
		'alpha2' => 'PE',
		'alpha3' => 'PER',
		'numeric' => '604',
		'currency' => [
			'PEN',
		],
	],
	[
		'name' => esc_html__( 'Philippines', 'awebooking' ),
		'alpha2' => 'PH',
		'alpha3' => 'PHL',
		'numeric' => '608',
		'currency' => [
			'PHP',
		],
	],
	[
		'name' => esc_html__( 'Pitcairn', 'awebooking' ),
		'alpha2' => 'PN',
		'alpha3' => 'PCN',
		'numeric' => '612',
		'currency' => [
			'NZD',
		],
	],
	[
		'name' => esc_html__( 'Poland', 'awebooking' ),
		'alpha2' => 'PL',
		'alpha3' => 'POL',
		'numeric' => '616',
		'currency' => [
			'PLN',
		],
	],
	[
		'name' => esc_html__( 'Portugal', 'awebooking' ),
		'alpha2' => 'PT',
		'alpha3' => 'PRT',
		'numeric' => '620',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Puerto Rico', 'awebooking' ),
		'alpha2' => 'PR',
		'alpha3' => 'PRI',
		'numeric' => '630',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Qatar', 'awebooking' ),
		'alpha2' => 'QA',
		'alpha3' => 'QAT',
		'numeric' => '634',
		'currency' => [
			'QAR',
		],
	],
	[
		'name' => esc_html__( 'Réunion', 'awebooking' ),
		'alpha2' => 'RE',
		'alpha3' => 'REU',
		'numeric' => '638',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Romania', 'awebooking' ),
		'alpha2' => 'RO',
		'alpha3' => 'ROU',
		'numeric' => '642',
		'currency' => [
			'RON',
		],
	],
	[
		'name' => esc_html__( 'Russian Federation', 'awebooking' ),
		'alpha2' => 'RU',
		'alpha3' => 'RUS',
		'numeric' => '643',
		'currency' => [
			'RUB',
		],
	],
	[
		'name' => esc_html__( 'Rwanda', 'awebooking' ),
		'alpha2' => 'RW',
		'alpha3' => 'RWA',
		'numeric' => '646',
		'currency' => [
			'RWF',
		],
	],
	[
		'name' => esc_html__( 'Saint Barthélemy', 'awebooking' ),
		'alpha2' => 'BL',
		'alpha3' => 'BLM',
		'numeric' => '652',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Saint Helena, Ascension and Tristan da Cunha', 'awebooking' ),
		'alpha2' => 'SH',
		'alpha3' => 'SHN',
		'numeric' => '654',
		'currency' => [
			'SHP',
		],
	],
	[
		'name' => esc_html__( 'Saint Kitts and Nevis', 'awebooking' ),
		'alpha2' => 'KN',
		'alpha3' => 'KNA',
		'numeric' => '659',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Saint Lucia', 'awebooking' ),
		'alpha2' => 'LC',
		'alpha3' => 'LCA',
		'numeric' => '662',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Saint Martin (French part)', 'awebooking' ),
		'alpha2' => 'MF',
		'alpha3' => 'MAF',
		'numeric' => '663',
		'currency' => [
			'EUR',
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Saint Pierre and Miquelon', 'awebooking' ),
		'alpha2' => 'PM',
		'alpha3' => 'SPM',
		'numeric' => '666',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Saint Vincent and the Grenadines', 'awebooking' ),
		'alpha2' => 'VC',
		'alpha3' => 'VCT',
		'numeric' => '670',
		'currency' => [
			'XCD',
		],
	],
	[
		'name' => esc_html__( 'Samoa', 'awebooking' ),
		'alpha2' => 'WS',
		'alpha3' => 'WSM',
		'numeric' => '882',
		'currency' => [
			'WST',
		],
	],
	[
		'name' => esc_html__( 'San Marino', 'awebooking' ),
		'alpha2' => 'SM',
		'alpha3' => 'SMR',
		'numeric' => '674',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Sao Tome and Principe', 'awebooking' ),
		'alpha2' => 'ST',
		'alpha3' => 'STP',
		'numeric' => '678',
		'currency' => [
			'STD',
		],
	],
	[
		'name' => esc_html__( 'Saudi Arabia', 'awebooking' ),
		'alpha2' => 'SA',
		'alpha3' => 'SAU',
		'numeric' => '682',
		'currency' => [
			'SAR',
		],
	],
	[
		'name' => esc_html__( 'Senegal', 'awebooking' ),
		'alpha2' => 'SN',
		'alpha3' => 'SEN',
		'numeric' => '686',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Serbia', 'awebooking' ),
		'alpha2' => 'RS',
		'alpha3' => 'SRB',
		'numeric' => '688',
		'currency' => [
			'RSD',
		],
	],
	[
		'name' => esc_html__( 'Seychelles', 'awebooking' ),
		'alpha2' => 'SC',
		'alpha3' => 'SYC',
		'numeric' => '690',
		'currency' => [
			'SCR',
		],
	],
	[
		'name' => esc_html__( 'Sierra Leone', 'awebooking' ),
		'alpha2' => 'SL',
		'alpha3' => 'SLE',
		'numeric' => '694',
		'currency' => [
			'SLL',
		],
	],
	[
		'name' => esc_html__( 'Singapore', 'awebooking' ),
		'alpha2' => 'SG',
		'alpha3' => 'SGP',
		'numeric' => '702',
		'currency' => [
			'SGD',
		],
	],
	[
		'name' => esc_html__( 'Sint Maarten (Dutch part)', 'awebooking' ),
		'alpha2' => 'SX',
		'alpha3' => 'SXM',
		'numeric' => '534',
		'currency' => [
			'ANG',
		],
	],
	[
		'name' => esc_html__( 'Slovakia', 'awebooking' ),
		'alpha2' => 'SK',
		'alpha3' => 'SVK',
		'numeric' => '703',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Slovenia', 'awebooking' ),
		'alpha2' => 'SI',
		'alpha3' => 'SVN',
		'numeric' => '705',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Solomon Islands', 'awebooking' ),
		'alpha2' => 'SB',
		'alpha3' => 'SLB',
		'numeric' => '090',
		'currency' => [
			'SBD',
		],
	],
	[
		'name' => esc_html__( 'Somalia', 'awebooking' ),
		'alpha2' => 'SO',
		'alpha3' => 'SOM',
		'numeric' => '706',
		'currency' => [
			'SOS',
		],
	],
	[
		'name' => esc_html__( 'South Africa', 'awebooking' ),
		'alpha2' => 'ZA',
		'alpha3' => 'ZAF',
		'numeric' => '710',
		'currency' => [
			'ZAR',
		],
	],
	[
		'name' => esc_html__( 'South Georgia and the South Sandwich Islands', 'awebooking' ),
		'alpha2' => 'GS',
		'alpha3' => 'SGS',
		'numeric' => '239',
		'currency' => [
			'GBP',
		],
	],
	[
		'name' => esc_html__( 'South Sudan', 'awebooking' ),
		'alpha2' => 'SS',
		'alpha3' => 'SSD',
		'numeric' => '728',
		'currency' => [
			'SSP',
		],
	],
	[
		'name' => esc_html__( 'Spain', 'awebooking' ),
		'alpha2' => 'ES',
		'alpha3' => 'ESP',
		'numeric' => '724',
		'currency' => [
			'EUR',
		],
	],
	[
		'name' => esc_html__( 'Sri Lanka', 'awebooking' ),
		'alpha2' => 'LK',
		'alpha3' => 'LKA',
		'numeric' => '144',
		'currency' => [
			'LKR',
		],
	],
	[
		'name' => esc_html__( 'Sudan', 'awebooking' ),
		'alpha2' => 'SD',
		'alpha3' => 'SDN',
		'numeric' => '729',
		'currency' => [
			'SDG',
		],
	],
	[
		'name' => esc_html__( 'Suriname', 'awebooking' ),
		'alpha2' => 'SR',
		'alpha3' => 'SUR',
		'numeric' => '740',
		'currency' => [
			'SRD',
		],
	],
	[
		'name' => esc_html__( 'Svalbard and Jan Mayen', 'awebooking' ),
		'alpha2' => 'SJ',
		'alpha3' => 'SJM',
		'numeric' => '744',
		'currency' => [
			'NOK',
		],
	],
	[
		'name' => esc_html__( 'Swaziland', 'awebooking' ),
		'alpha2' => 'SZ',
		'alpha3' => 'SWZ',
		'numeric' => '748',
		'currency' => [
			'SZL',
			'ZAR',
		],
	],
	[
		'name' => esc_html__( 'Sweden', 'awebooking' ),
		'alpha2' => 'SE',
		'alpha3' => 'SWE',
		'numeric' => '752',
		'currency' => [
			'SEK',
		],
	],
	[
		'name' => esc_html__( 'Switzerland', 'awebooking' ),
		'alpha2' => 'CH',
		'alpha3' => 'CHE',
		'numeric' => '756',
		'currency' => [
			'CHF',
		],
	],
	[
		'name' => esc_html__( 'Syrian Arab Republic', 'awebooking' ),
		'alpha2' => 'SY',
		'alpha3' => 'SYR',
		'numeric' => '760',
		'currency' => [
			'SYP',
		],
	],
	[
		'name' => esc_html__( 'Taiwan (Province of China)', 'awebooking' ),
		'alpha2' => 'TW',
		'alpha3' => 'TWN',
		'numeric' => '158',
		'currency' => [
			'TWD',
		],
	],
	[
		'name' => esc_html__( 'Tajikistan', 'awebooking' ),
		'alpha2' => 'TJ',
		'alpha3' => 'TJK',
		'numeric' => '762',
		'currency' => [
			'TJS',
		],
	],
	[
		'name' => esc_html__( 'Tanzania, United Republic of', 'awebooking' ),
		'alpha2' => 'TZ',
		'alpha3' => 'TZA',
		'numeric' => '834',
		'currency' => [
			'TZS',
		],
	],
	[
		'name' => esc_html__( 'Thailand', 'awebooking' ),
		'alpha2' => 'TH',
		'alpha3' => 'THA',
		'numeric' => '764',
		'currency' => [
			'THB',
		],
	],
	[
		'name' => esc_html__( 'Timor-Leste', 'awebooking' ),
		'alpha2' => 'TL',
		'alpha3' => 'TLS',
		'numeric' => '626',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Togo', 'awebooking' ),
		'alpha2' => 'TG',
		'alpha3' => 'TGO',
		'numeric' => '768',
		'currency' => [
			'XOF',
		],
	],
	[
		'name' => esc_html__( 'Tokelau', 'awebooking' ),
		'alpha2' => 'TK',
		'alpha3' => 'TKL',
		'numeric' => '772',
		'currency' => [
			'NZD',
		],
	],
	[
		'name' => esc_html__( 'Tonga', 'awebooking' ),
		'alpha2' => 'TO',
		'alpha3' => 'TON',
		'numeric' => '776',
		'currency' => [
			'TOP',
		],
	],
	[
		'name' => esc_html__( 'Trinidad and Tobago', 'awebooking' ),
		'alpha2' => 'TT',
		'alpha3' => 'TTO',
		'numeric' => '780',
		'currency' => [
			'TTD',
		],
	],
	[
		'name' => esc_html__( 'Tunisia', 'awebooking' ),
		'alpha2' => 'TN',
		'alpha3' => 'TUN',
		'numeric' => '788',
		'currency' => [
			'TND',
		],
	],
	[
		'name' => esc_html__( 'Turkey', 'awebooking' ),
		'alpha2' => 'TR',
		'alpha3' => 'TUR',
		'numeric' => '792',
		'currency' => [
			'TRY',
		],
	],
	[
		'name' => esc_html__( 'Turkmenistan', 'awebooking' ),
		'alpha2' => 'TM',
		'alpha3' => 'TKM',
		'numeric' => '795',
		'currency' => [
			'TMT',
		],
	],
	[
		'name' => esc_html__( 'Turks and Caicos Islands', 'awebooking' ),
		'alpha2' => 'TC',
		'alpha3' => 'TCA',
		'numeric' => '796',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Tuvalu', 'awebooking' ),
		'alpha2' => 'TV',
		'alpha3' => 'TUV',
		'numeric' => '798',
		'currency' => [
			'AUD',
		],
	],
	[
		'name' => esc_html__( 'Uganda', 'awebooking' ),
		'alpha2' => 'UG',
		'alpha3' => 'UGA',
		'numeric' => '800',
		'currency' => [
			'UGX',
		],
	],
	[
		'name' => esc_html__( 'Ukraine', 'awebooking' ),
		'alpha2' => 'UA',
		'alpha3' => 'UKR',
		'numeric' => '804',
		'currency' => [
			'UAH',
		],
	],
	[
		'name' => esc_html__( 'United Arab Emirates', 'awebooking' ),
		'alpha2' => 'AE',
		'alpha3' => 'ARE',
		'numeric' => '784',
		'currency' => [
			'AED',
		],
	],
	[
		'name' => esc_html__( 'United Kingdom of Great Britain and Northern Ireland', 'awebooking' ),
		'alpha2' => 'GB',
		'alpha3' => 'GBR',
		'numeric' => '826',
		'currency' => [
			'GBP',
		],
	],
	[
		'name' => esc_html__( 'United States of America', 'awebooking' ),
		'alpha2' => 'US',
		'alpha3' => 'USA',
		'numeric' => '840',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'United States Minor Outlying Islands', 'awebooking' ),
		'alpha2' => 'UM',
		'alpha3' => 'UMI',
		'numeric' => '581',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Uruguay', 'awebooking' ),
		'alpha2' => 'UY',
		'alpha3' => 'URY',
		'numeric' => '858',
		'currency' => [
			'UYU',
		],
	],
	[
		'name' => esc_html__( 'Uzbekistan', 'awebooking' ),
		'alpha2' => 'UZ',
		'alpha3' => 'UZB',
		'numeric' => '860',
		'currency' => [
			'UZS',
		],
	],
	[
		'name' => esc_html__( 'Vanuatu', 'awebooking' ),
		'alpha2' => 'VU',
		'alpha3' => 'VUT',
		'numeric' => '548',
		'currency' => [
			'VUV',
		],
	],
	[
		'name' => esc_html__( 'Venezuela (Bolivarian Republic of)', 'awebooking' ),
		'alpha2' => 'VE',
		'alpha3' => 'VEN',
		'numeric' => '862',
		'currency' => [
			'VEF',
		],
	],
	[
		'name' => esc_html__( 'Viet Nam', 'awebooking' ),
		'alpha2' => 'VN',
		'alpha3' => 'VNM',
		'numeric' => '704',
		'currency' => [
			'VND',
		],
	],
	[
		'name' => esc_html__( 'Virgin Islands (British)', 'awebooking' ),
		'alpha2' => 'VG',
		'alpha3' => 'VGB',
		'numeric' => '092',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Virgin Islands (U.S.)', 'awebooking' ),
		'alpha2' => 'VI',
		'alpha3' => 'VIR',
		'numeric' => '850',
		'currency' => [
			'USD',
		],
	],
	[
		'name' => esc_html__( 'Wallis and Futuna', 'awebooking' ),
		'alpha2' => 'WF',
		'alpha3' => 'WLF',
		'numeric' => '876',
		'currency' => [
			'XPF',
		],
	],
	[
		'name' => esc_html__( 'Western Sahara', 'awebooking' ),
		'alpha2' => 'EH',
		'alpha3' => 'ESH',
		'numeric' => '732',
		'currency' => [
			'MAD',
		],
	],
	[
		'name' => esc_html__( 'Yemen', 'awebooking' ),
		'alpha2' => 'YE',
		'alpha3' => 'YEM',
		'numeric' => '887',
		'currency' => [
			'YER',
		],
	],
	[
		'name' => esc_html__( 'Zambia', 'awebooking' ),
		'alpha2' => 'ZM',
		'alpha3' => 'ZMB',
		'numeric' => '894',
		'currency' => [
			'ZMW',
		],
	],
	[
		'name' => esc_html__( 'Zimbabwe', 'awebooking' ),
		'alpha2' => 'ZW',
		'alpha3' => 'ZWE',
		'numeric' => '716',
		'currency' => [
			'BWP',
			'EUR',
			'GBP',
			'USD',
			'ZAR',
		],
	],
];
